 /*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_accfrmobjslist.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:11:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _PAGEFRM_HXX
#include <pagefrm.hxx>
#endif
#ifndef _ACCFRMOBJSLIST_HXX
#include <accfrmobjslist.hxx>
#endif
namespace binfilter {


SwFrmOrObjSList_const_iterator::SwFrmOrObjSList_const_iterator(
	const SwFrmOrObjSList& rLst, sal_Bool ) :
	rList( rLst ), aCurr( rList.pFrm->GetLower() ), nNextObj( 0 )
{
	if( !aCurr.GetSwFrm() )
	{
		if( rList.pFrm->IsPageFrm() )
		{
			const SwPageFrm *pPgFrm = 
				static_cast< const SwPageFrm * >( rList.pFrm );
			const SwSortDrawObjs *pObjs = pPgFrm->GetSortedObjs();
			if( pObjs && pObjs->Count() )
				aCurr = (*pObjs)[nNextObj++];
		}
		else if( rList.pFrm->IsTxtFrm() )
		{
			const SwDrawObjs *pObjs = rList.pFrm->GetDrawObjs();
			if( pObjs && pObjs->Count() )
			{
				aCurr = (*pObjs)[nNextObj++];
				while( aCurr.IsValid() && !aCurr.IsBoundAsChar() )
					aCurr = (nNextObj < pObjs->Count())
								? (*pObjs)[nNextObj++]
								: static_cast< const SdrObject *>( 0 );

			}
		}
	}
	if( rList.bVisibleOnly )
	{
		// Find the first visible
		while( aCurr.IsValid() &&
			   !aCurr.GetBox().IsOver( rList.aVisArea ) )
			next();
	}
}

SwFrmOrObjSList_const_iterator& SwFrmOrObjSList_const_iterator::next()
{
	sal_Bool bGetSdrObject = sal_False;
	if( aCurr.GetSdrObject() )
	{
		bGetSdrObject = sal_True;
	}
	else if( aCurr.GetSwFrm() )
	{
		aCurr = aCurr.GetSwFrm()->GetNext();
		if( !aCurr.GetSwFrm() )
			bGetSdrObject = sal_True;
	}

	if( bGetSdrObject )
	{
		if( rList.pFrm->IsPageFrm() )
		{
			const SwPageFrm *pPgFrm = 
				static_cast< const SwPageFrm * >( rList.pFrm );
			const SwSortDrawObjs *pObjs = pPgFrm->GetSortedObjs();
			aCurr = (pObjs && nNextObj < pObjs->Count())
							? (*pObjs)[nNextObj++]
							: static_cast< const SdrObject *>( 0 );
		}
		else if( rList.pFrm->IsTxtFrm() )
		{
			const SwDrawObjs *pObjs = rList.pFrm->GetDrawObjs();
			aCurr = (pObjs && nNextObj < pObjs->Count())
							? (*pObjs)[nNextObj++]
							: static_cast< const SdrObject *>( 0 );
			while( aCurr.IsValid() && !aCurr.IsBoundAsChar() )
				aCurr = (nNextObj < pObjs->Count())
							? (*pObjs)[nNextObj++]
							: static_cast< const SdrObject *>( 0 );
		}
	}

	return *this;
}

SwFrmOrObjSList_const_iterator& SwFrmOrObjSList_const_iterator::next_visible()
{
	next();
	while( aCurr.IsValid() &&
		   !aCurr.GetBox().IsOver( rList.aVisArea ) )
		next();

	return *this;
}
}
