/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_zoom.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:13:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
#ifndef _SFX_OBJSH_HXX
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen wg. RET_OK, RET_CANCEL
#include <vcl/msgbox.hxx>
#endif
#pragma hdrstop

#define _SVX_ZOOM_CXX

#include "dialogs.hrc"
#include "zoom.hrc"

#include "zoom.hxx"
#include "zoomitem.hxx"
#include "dialmgr.hxx"
namespace binfilter {

// static ----------------------------------------------------------------

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_ZOOM,
//STRIP001 	SID_ATTR_ZOOM,
//STRIP001 	0
//STRIP001 };

//STRIP001 #define SPECIAL_FACTOR	((USHORT)0xFFFF)

// class SvxZoomDialog ---------------------------------------------------

//STRIP001 USHORT SvxZoomDialog::GetFactor() const
//STRIP001 {
//STRIP001 	if ( a200Btn.IsChecked() )
//STRIP001 		return 200;
//STRIP001 	if ( a150Btn.IsChecked() )
//STRIP001 		return 150;
//STRIP001 	if ( a100Btn.IsChecked() )
//STRIP001 		return 100;
//STRIP001 	if ( a75Btn.IsChecked() )
//STRIP001 		return 75;
//STRIP001 	if ( a50Btn.IsChecked() )
//STRIP001 		return 50;
//STRIP001 	if ( aUserBtn.IsChecked() )
//STRIP001 		return (USHORT)aUserEdit.GetValue();
//STRIP001 	else
//STRIP001 		return SPECIAL_FACTOR;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxZoomDialog::SetFactor( USHORT nNewFactor, USHORT nBtnId )
//STRIP001 {
//STRIP001 	aUserEdit.Disable();
//STRIP001 
//STRIP001 	if ( !nBtnId )
//STRIP001 	{
//STRIP001 		if ( nNewFactor == 200 )
//STRIP001 		{
//STRIP001 			a200Btn.Check();
//STRIP001 			a200Btn.GrabFocus();
//STRIP001 		}
//STRIP001 		else if ( nNewFactor == 150 )
//STRIP001 		{
//STRIP001 			a150Btn.Check();
//STRIP001 			a150Btn.GrabFocus();
//STRIP001 		}
//STRIP001 		else if ( nNewFactor == 100 )
//STRIP001 		{
//STRIP001 			a100Btn.Check();
//STRIP001 			a100Btn.GrabFocus();
//STRIP001 		}
//STRIP001 		else if ( nNewFactor == 75 )
//STRIP001 		{
//STRIP001 			a75Btn.Check();
//STRIP001 			a75Btn.GrabFocus();
//STRIP001 		}
//STRIP001 		else if ( nNewFactor == 50 )
//STRIP001 		{
//STRIP001 			a50Btn.Check();
//STRIP001 			a50Btn.GrabFocus();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aUserBtn.Check();
//STRIP001 			aUserEdit.Enable();
//STRIP001 			aUserEdit.SetValue( (long)nNewFactor );
//STRIP001 			aUserEdit.GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aUserEdit.SetValue( (long)nNewFactor );
//STRIP001 
//STRIP001 		if ( ZOOMBTN_OPTIMAL == nBtnId )
//STRIP001 		{
//STRIP001 			aOptimalBtn.Check();
//STRIP001 			aOptimalBtn.GrabFocus();
//STRIP001 		}
//STRIP001 		else if ( ZOOMBTN_PAGEWIDTH == nBtnId )
//STRIP001 		{
//STRIP001 			aPageWidthBtn.Check();
//STRIP001 			aPageWidthBtn.GrabFocus();
//STRIP001 		}
//STRIP001 		else if ( ZOOMBTN_WHOLEPAGE == nBtnId )
//STRIP001 		{
//STRIP001 			aWholePageBtn.Check();
//STRIP001 			aWholePageBtn.GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxZoomDialog::SetButtonText( USHORT nBtnId, const String& rNewTxt )
//STRIP001 {
//STRIP001 	switch ( nBtnId )
//STRIP001 	{
//STRIP001 		case ZOOMBTN_OPTIMAL: // Optimal-Button
//STRIP001 			aOptimalBtn.SetText( rNewTxt );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ZOOMBTN_PAGEWIDTH: // Seitenbreite-Button
//STRIP001 			aPageWidthBtn.SetText( rNewTxt );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ZOOMBTN_WHOLEPAGE: // Ganze Seite-Button
//STRIP001 			aWholePageBtn.SetText( rNewTxt );
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR( "wrong button number" );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxZoomDialog::HideButton( USHORT nBtnId )
//STRIP001 {
//STRIP001 	switch ( nBtnId )
//STRIP001 	{
//STRIP001 		case ZOOMBTN_OPTIMAL: // Optimal-Button
//STRIP001 			aOptimalBtn.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ZOOMBTN_PAGEWIDTH: // Seitenbreite-Button
//STRIP001 			aPageWidthBtn.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ZOOMBTN_WHOLEPAGE: // Ganze Seite-Button
//STRIP001 			aWholePageBtn.Hide();
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR( "Falsche Button-Nummer!!!" );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxZoomDialog::SetLimits( USHORT nMin, USHORT nMax )
//STRIP001 {
//STRIP001 	DBG_ASSERT( nMin < nMax, "invalid limits" );
//STRIP001 	aUserEdit.SetMin( nMin );
//STRIP001 	aUserEdit.SetFirst( nMin );
//STRIP001 	aUserEdit.SetMax( nMax );
//STRIP001 	aUserEdit.SetLast( nMax );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxZoomDialog::SetSpinSize( USHORT nNewSpin )
//STRIP001 {
//STRIP001 	aUserEdit.SetSpinSize( nNewSpin );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxZoomDialog::SvxZoomDialog( Window* pParent, const SfxItemSet& rCoreSet ) :
//STRIP001 
//STRIP001 	SfxModalDialog( pParent, SVX_RES( RID_SVXDLG_ZOOM ) ),
//STRIP001 
//STRIP001 	a200Btn         ( this, ResId( BTN_200 ) ),
//STRIP001 	a150Btn         ( this, ResId( BTN_150 ) ),
//STRIP001 	a100Btn         ( this, ResId( BTN_100 ) ),
//STRIP001 	a75Btn          ( this, ResId( BTN_75 ) ),
//STRIP001 	a50Btn          ( this, ResId( BTN_50 ) ),
//STRIP001 	aOptimalBtn		( this, ResId( BTN_OPTIMAL ) ),
//STRIP001 	aPageWidthBtn	( this, ResId( BTN_PAGE_WIDTH ) ),
//STRIP001 	aWholePageBtn	( this, ResId( BTN_WHOLE_PAGE ) ),
//STRIP001 	aUserBtn        ( this, ResId( BTN_USER ) ),
//STRIP001 	aUserEdit       ( this, ResId( ED_USER ) ),
//STRIP001     aZoomFl         ( this, ResId( FL_ZOOM ) ),
//STRIP001 	aOKBtn          ( this, ResId( BTN_ZOOM_OK ) ),
//STRIP001 	aCancelBtn      ( this, ResId( BTN_ZOOM_CANCEL ) ),
//STRIP001 	aHelpBtn	    ( this, ResId( BTN_ZOOM_HELP ) ),
//STRIP001 
//STRIP001 	rSet		( rCoreSet ),
//STRIP001 	pOutSet     ( NULL ),
//STRIP001 	bModified	( FALSE )
//STRIP001 
//STRIP001 {
//STRIP001 	Link aLink = LINK( this, SvxZoomDialog, UserHdl );
//STRIP001 	a200Btn.SetClickHdl( aLink );
//STRIP001 	a150Btn.SetClickHdl( aLink );
//STRIP001 	a100Btn.SetClickHdl( aLink );
//STRIP001 	a75Btn.SetClickHdl( aLink );
//STRIP001 	a50Btn.SetClickHdl( aLink );
//STRIP001 	aOptimalBtn.SetClickHdl( aLink );
//STRIP001 	aPageWidthBtn.SetClickHdl( aLink );
//STRIP001 	aWholePageBtn.SetClickHdl( aLink );
//STRIP001 	aUserBtn.SetClickHdl( aLink );
//STRIP001 	aOKBtn.SetClickHdl( LINK( this, SvxZoomDialog, OKHdl ) );
//STRIP001 	aUserEdit.SetModifyHdl( LINK( this, SvxZoomDialog, SpinHdl ) );
//STRIP001 
//STRIP001 	// Default-Werte
//STRIP001 	USHORT nValue = 100;
//STRIP001 	USHORT nMin = 10;
//STRIP001 	USHORT nMax = 1000;
//STRIP001 
//STRIP001 	// ggf. erst den alten Wert besorgen
//STRIP001 	const SfxUInt16Item* pOldUserItem = 0;
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 	if ( pSh )
//STRIP001 		pOldUserItem = (const SfxUInt16Item*)pSh->GetItem( SID_ATTR_ZOOM_USER );
//STRIP001 
//STRIP001 	if ( pOldUserItem )
//STRIP001 		nValue = pOldUserItem->GetValue();
//STRIP001 
//STRIP001 	// UserEdit initialisieren
//STRIP001 	if ( nMin > nValue )
//STRIP001 		nMin = nValue;
//STRIP001 	if ( nMax < nValue )
//STRIP001 		nMax = nValue;
//STRIP001 	aUserEdit.SetMin( nMin );
//STRIP001 	aUserEdit.SetFirst( nMin );
//STRIP001 	aUserEdit.SetMax( nMax );
//STRIP001 	aUserEdit.SetLast( nMax );
//STRIP001 	aUserEdit.SetValue( nValue );
//STRIP001 
//STRIP001 	const SfxPoolItem& rItem = rSet.Get( rSet.GetPool()->GetWhich( SID_ATTR_ZOOM ) );
//STRIP001 
//STRIP001 	if ( rItem.ISA(SvxZoomItem) )
//STRIP001 	{
//STRIP001 		const SvxZoomItem& rZoomItem = (const SvxZoomItem&)rItem;
//STRIP001 		USHORT nValue = rZoomItem.GetValue();
//STRIP001 		SvxZoomType eType = rZoomItem.GetType();
//STRIP001 		USHORT nValSet = rZoomItem.GetValueSet();
//STRIP001 		USHORT nBtnId = 0;
//STRIP001 
//STRIP001 		switch ( eType )
//STRIP001 		{
//STRIP001 			case SVX_ZOOM_OPTIMAL:
//STRIP001 				nBtnId = ZOOMBTN_OPTIMAL;
//STRIP001 				break;
//STRIP001 			case SVX_ZOOM_PAGEWIDTH:
//STRIP001 				nBtnId = ZOOMBTN_PAGEWIDTH;
//STRIP001 				break;
//STRIP001 			case SVX_ZOOM_WHOLEPAGE:
//STRIP001 				nBtnId = ZOOMBTN_WHOLEPAGE;
//STRIP001 				break;
//STRIP001 			case SVX_ZOOM_PERCENT:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// ggf. Buttons disablen
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_50 & nValSet) )
//STRIP001 			a50Btn.Disable();
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_75 & nValSet) )
//STRIP001 			a75Btn.Disable();
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_100 & nValSet) )
//STRIP001 			a100Btn.Disable();
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_150 & nValSet) )
//STRIP001 			a150Btn.Disable();
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_200 & nValSet) )
//STRIP001 			a200Btn.Disable();
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_OPTIMAL & nValSet) )
//STRIP001 			aOptimalBtn.Disable();
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_PAGEWIDTH & nValSet) )
//STRIP001 			aPageWidthBtn.Disable();
//STRIP001 		if ( !(SVX_ZOOM_ENABLE_WHOLEPAGE & nValSet) )
//STRIP001 			aWholePageBtn.Disable();
//STRIP001 		SetFactor( nValue, nBtnId );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nValue = ( (const SfxUInt16Item&)rItem ).GetValue();
//STRIP001 		SetFactor( nValue );
//STRIP001 	}
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxZoomDialog::~SvxZoomDialog()
//STRIP001 {
//STRIP001 	delete pOutSet;
//STRIP001 	pOutSet = 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 USHORT* SvxZoomDialog::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxZoomDialog, UserHdl, RadioButton *, pBtn )
//STRIP001 {
//STRIP001 	bModified |= TRUE;
//STRIP001 	USHORT nFactor = GetFactor();
//STRIP001 
//STRIP001 	if ( pBtn == &aUserBtn )
//STRIP001 	{
//STRIP001 		aUserEdit.Enable();
//STRIP001 		aUserEdit.GrabFocus();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aUserEdit.Disable();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxZoomDialog, SpinHdl, MetricField *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( !aUserBtn.IsChecked() )
//STRIP001 		return 0;
//STRIP001 	bModified |= TRUE;
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxZoomDialog, OKHdl, Button *, pBtn )
//STRIP001 {
//STRIP001 	if ( bModified || &aOKBtn != pBtn )
//STRIP001 	{
//STRIP001 		SvxZoomItem aItem( SVX_ZOOM_PERCENT, 0,
//STRIP001 						   rSet.GetPool()->GetWhich( SID_ATTR_ZOOM ) );
//STRIP001 
//STRIP001 		if ( &aOKBtn == pBtn )
//STRIP001 		{
//STRIP001 			USHORT nFactor = GetFactor();
//STRIP001 
//STRIP001 			if ( SPECIAL_FACTOR == nFactor )
//STRIP001 			{
//STRIP001 				if ( aOptimalBtn.IsChecked() )
//STRIP001 					aItem.SetType( SVX_ZOOM_OPTIMAL );
//STRIP001 				else if ( aPageWidthBtn.IsChecked() )
//STRIP001 					aItem.SetType( SVX_ZOOM_PAGEWIDTH );
//STRIP001 				else if ( aWholePageBtn.IsChecked() )
//STRIP001 					aItem.SetType( SVX_ZOOM_WHOLEPAGE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aItem.SetValue( nFactor );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERROR( "Wrong Button" );
//STRIP001 			return 0;
//STRIP001 		}
//STRIP001 		pOutSet = new SfxItemSet( rSet );
//STRIP001 		pOutSet->Put( aItem );
//STRIP001 
//STRIP001 		// Wert aus dem UserEdit "uber den Dialog hinaus merken
//STRIP001 		SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 		if ( pSh )
//STRIP001 			pSh->PutItem( SfxUInt16Item( SID_ATTR_ZOOM_USER,
//STRIP001 										 (UINT16)aUserEdit.GetValue() ) );
//STRIP001 		EndDialog( RET_OK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		EndDialog( RET_CANCEL );
//STRIP001 	return 0;
//STRIP001 }


}
