/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svxruler.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:05:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#include <string.h>
#include <limits.h>

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #ifndef _SV_IMAGE_HXX
// auto strip #include <vcl/image.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXRECTITEM_HXX
#include <svtools/rectitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
#pragma hdrstop

#define ITEMID_TABSTOP	0
#define ITEMID_LRSPACE 	0
#define ITEMID_PROTECT  0

#include "dialogs.hrc"
// auto strip #include "dialmgr.hxx"
#include "ruler.hxx"
#include "rlrcitem.hxx"
#include "rulritem.hxx"
#include "tstpitem.hxx"
#include "lrspitem.hxx"
#include "protitem.hxx"
namespace binfilter {

#ifndef RULER_TAB_RTL
#define RULER_TAB_RTL           ((USHORT)0x0010)
#endif

// STATIC DATA -----------------------------------------------------------

#define CTRL_ITEM_COUNT 12
#define GAP 10
#define OBJECT_BORDER_COUNT 4
#define TAB_GAP 1
#define INDENT_GAP 2
#define INDENT_FIRST_LINE   4
#define INDENT_LEFT_MARGIN  5
#define INDENT_RIGHT_MARGIN 6
#define INDENT_LEFT_BORDER  2
#define INDENT_RIGHT_BORDER 3
#define INDENT_COUNT        5 //without the first two old values

#define PIXEL_H_ADJUST( l1, l2 ) (USHORT)PixelHAdjust(l1,l2)

#ifdef DEBUGLIN

//STRIP001 inline long ToMM(Window *pWin, long lVal)
//STRIP001 {
//STRIP001 	return pWin->PixelToLogic(Size(lVal, 0), MapMode(MAP_MM)).Width();
//STRIP001 }

//STRIP001 void Debug_Impl(Window *pWin, SvxColumnItem& rColItem)
//STRIP001 {
//STRIP001 	String aTmp("Aktuell: ");
//STRIP001 	aTmp += rColItem.GetActColumn();
//STRIP001 	aTmp += " ColLeft: ";
//STRIP001 	aTmp +=  String(ToMM(pWin, rColItem.GetLeft()));
//STRIP001 	aTmp += "   ColRight: ";
//STRIP001 	aTmp +=  String(ToMM(pWin, rColItem.GetRight()));
//STRIP001 	for(USHORT i = 0; i < rColItem.Count(); ++i) {
//STRIP001 		aTmp += " Start: ";
//STRIP001 		aTmp += String(ToMM(pWin, rColItem[i].nStart));
//STRIP001 		aTmp += " End: ";
//STRIP001 		aTmp += String(ToMM(pWin, rColItem[i].nEnd));
//STRIP001 	}
//STRIP001 
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }

//STRIP001 void Debug_Impl(Window *pWin, const SvxLongLRSpaceItem& rLRSpace)
//STRIP001 {
//STRIP001 	String aTmp("Left: ");
//STRIP001 	aTmp += pWin->PixelToLogic(Size(rLRSpace.GetLeft(), 0), MapMode(MAP_MM)).Width();
//STRIP001 	aTmp += "   Right: ";
//STRIP001 	aTmp +=pWin->PixelToLogic(Size(rLRSpace.GetRight(), 0), MapMode(MAP_MM)).Width();
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }

//STRIP001 void Debug_Impl(Window *pWin, const SvxLongULSpaceItem& rULSpace)
//STRIP001 {
//STRIP001 	String aTmp("Upper: ");
//STRIP001 	aTmp += pWin->PixelToLogic(Size(rULSpace.GetUpper(), 0), MapMode(MAP_MM)).Width();
//STRIP001 	aTmp += "   Lower: ";
//STRIP001 	aTmp += pWin->PixelToLogic(Size(rULSpace.GetLower(), 0), MapMode(MAP_MM)).Width();
//STRIP001 
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }

//STRIP001 void DebugTabStops_Impl(const SvxTabStopItem& rTabs)
//STRIP001 {
//STRIP001 	String aTmp("Tabs: ");
//STRIP001 
//STRIP001 	// Def Tabs loeschen
//STRIP001 	for(USHORT i = 0; i < rTabs.Count(); ++i)
//STRIP001 	{
//STRIP001 		aTmp += String(rTabs[i].GetTabPos() / 56);
//STRIP001 		aTmp += " : ";
//STRIP001 	}
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }

//STRIP001 void DebugParaMargin_Impl(const SvxLRSpaceItem& rLRSpace)
//STRIP001 {
//STRIP001 	String aTmp("ParaLeft: ");
//STRIP001 	aTmp += rLRSpace.GetTxtLeft() / 56;
//STRIP001 	aTmp += "   ParaRight: ";
//STRIP001 	aTmp += rLRSpace.GetRight() / 56;
//STRIP001 	aTmp += "   FLI: ";
//STRIP001 	aTmp += rLRSpace.GetTxtFirstLineOfst() / 56;
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }

#endif // DEBUGLIN
#ifdef DEBUG_RULER
// auto strip #include <vcl/svapp.hxx>
// auto strip #include <vcl/lstbox.hxx>
//STRIP001 class RulerDebugWindow : public Window
//STRIP001 {
//STRIP001     ListBox aBox;
//STRIP001 public:
//STRIP001         RulerDebugWindow(Window* pParent) :
//STRIP001             Window(pParent, WB_BORDER|WB_SIZEMOVE|WB_DIALOGCONTROL|WB_CLIPCHILDREN|WB_SYSTEMWINDOW),
//STRIP001             aBox(this, WB_BORDER)
//STRIP001             {
//STRIP001                 Size aOutput(200, 400);
//STRIP001                 SetOutputSizePixel(aOutput);
//STRIP001                 aBox.SetSizePixel(aOutput);
//STRIP001                 aBox.Show();
//STRIP001                 Show();
//STRIP001                 Size aParentSize(pParent->GetOutputSizePixel());
//STRIP001                 Size aOwnSize(GetSizePixel());
//STRIP001                 aParentSize.Width() -= aOwnSize.Width();
//STRIP001                 aParentSize.Height() -= aOwnSize.Height();
//STRIP001                 SetPosPixel(Point(aParentSize.Width(), aParentSize.Height()));
//STRIP001             }
//STRIP001         ~RulerDebugWindow();
//STRIP001 
//STRIP001         ListBox& GetLBox() {return aBox;}
//STRIP001         static void     AddDebugText(const sal_Char* pDescription, const String& rText );
//STRIP001 };
//STRIP001 static RulerDebugWindow* pDebugWindow = 0;

//STRIP001 RulerDebugWindow::~RulerDebugWindow()
//STRIP001 {
//STRIP001     pDebugWindow = 0;
//STRIP001 }
//STRIP001 void     RulerDebugWindow::AddDebugText(const sal_Char* pDescription, const String& rText )
//STRIP001 {
//STRIP001     if(!pDebugWindow)
//STRIP001     {
//STRIP001         Window* pParent = Application::GetFocusWindow();
//STRIP001         while(pParent->GetParent())
//STRIP001             pParent = pParent->GetParent();
//STRIP001         pDebugWindow = new RulerDebugWindow(pParent);
//STRIP001     }
//STRIP001     String sContent(String::CreateFromAscii(pDescription));
//STRIP001     sContent += rText;
//STRIP001     USHORT nPos = pDebugWindow->GetLBox().InsertEntry(sContent);
//STRIP001     pDebugWindow->GetLBox().SelectEntryPos(nPos);
//STRIP001     pDebugWindow->GrabFocus();
//STRIP001 }

/*N*/ #define ADD_DEBUG_TEXT(cDescription, sValue) \
/*N*/     RulerDebugWindow::AddDebugText(cDescription, sValue);
/*N*/ 
/*N*/ #define REMOVE_DEBUG_WINDOW \
/*N*/     delete pDebugWindow;    \
/*N*/     pDebugWindow = 0;
/*N*/ 
/*N*/ #else
/*N*/ #define ADD_DEBUG_TEXT(cDescription, sValue)
/*N*/ #define REMOVE_DEBUG_WINDOW
/*N*/ #endif

/*N*/ struct SvxRuler_Impl  {
/*N*/ 	USHORT *pPercBuf;
/*N*/ 	USHORT *pBlockBuf;
/*N*/ 	USHORT nPercSize;
/*N*/ 	long   nTotalDist;
/*N*/ 	long   lOldWinPos;
/*N*/ 	long   lMaxLeftLogic;
/*N*/ 	long   lMaxRightLogic;
/*N*/ 	long   lLastLMargin;
/*N*/ 	SvxProtectItem aProtectItem;
/*N*/     SfxBoolItem* pTextRTLItem;
/*N*/ 	USHORT nControlerItems;
/*N*/ 	USHORT nIdx;
/*N*/ 	USHORT nColLeftPix, nColRightPix; // Pixelwerte fuer linken / rechten Rand
/*N*/ 									  // bei Spalten; gepuffert, um Umrechenfehler
/*N*/ 									  // zu vermeiden.
/*N*/ 									  // Muesste vielleicht fuer weitere Werte
/*N*/ 									  // aufgebohrt werden
/*N*/ 	SvxRuler_Impl() :
/*N*/ 	pPercBuf(0), pBlockBuf(0), nPercSize(0), nTotalDist(0), nIdx(0),
/*N*/     nColLeftPix(0), nColRightPix(0), lOldWinPos(0), pTextRTLItem(0)
/*N*/ 	{
/*N*/ 	}
/*N*/ 	~SvxRuler_Impl()
/*N*/ 	{
/*N*/ 		nPercSize = 0; nTotalDist = 0;
/*N*/ 		delete[] pPercBuf; delete[] pBlockBuf; pPercBuf = 0;
/*N*/         delete pTextRTLItem;
/*N*/ 	}
//STRIP001 	void SetPercSize(USHORT nSize);
/*N*/ 
/*N*/ };



//STRIP001 void SvxRuler_Impl::SetPercSize(USHORT nSize)
//STRIP001 {
//STRIP001 	if(nSize > nPercSize)
//STRIP001 	{
//STRIP001 		delete[] pPercBuf;
//STRIP001 		delete[] pBlockBuf;
//STRIP001 		pPercBuf = new USHORT[nPercSize = nSize];
//STRIP001 		pBlockBuf = new USHORT[nPercSize = nSize];
//STRIP001 	}
//STRIP001 	size_t nSize2 = sizeof(USHORT) * nPercSize;
//STRIP001 	memset(pPercBuf, 0, nSize2);
//STRIP001 	memset(pBlockBuf, 0, nSize2);
//STRIP001 }


// Konstruktor des Lineals

// SID_ATTR_ULSPACE, SID_ATTR_LRSPACE
// erwartet als Parameter SvxULSpaceItem f"ur Seitenr"ander
// (entweder links/rechts oder oben/unten)
// Lineal: SetMargin1, SetMargin2

// SID_RULER_PAGE_POS
// erwartet als Parameter Anfangswert der Seite sowie Seitenbreite
// Lineal: SetPagePos

// SID_ATTR_TABSTOP
// erwartet: SvxTabStopItem
// Lineal: SetTabs

// SID_ATTR_PARA_LRSPACE
// linker, rechter Absatzrand bei H-Lineal
// Lineal: SetIndents

// SID_RULER_BORDERS
// Tabellenraender, Spalten
// erwartet: so etwas wie SwTabCols
// Lineal: SetBorders


/*N*/ SvxRuler::SvxRuler
/*N*/ (
/*N*/  Window* pParent,                               // StarView Parent
/*N*/  Window* pWin,                                  // Ausgabefenster; wird fuer Umrechnung logische
/*N*/ 				// Einheiten <-> Pixel verwendet
/*N*/  USHORT  flags,                                 // Anzeige Flags, siehe ruler.hxx
/*N*/  SfxBindings &rBindings,                // zugeordnete Bindings
/*N*/  WinBits nWinStyle                              // StarView WinBits
/*N*/ )
/*N*/ : Ruler(pParent, nWinStyle),
/*N*/   pLRSpaceItem(0),
/*N*/   pMinMaxItem(0),
/*N*/   pULSpaceItem(0),
/*N*/   pTabStopItem(0),
/*N*/   pParaItem(0),
/*N*/   pParaBorderItem(0),
/*N*/   pPagePosItem(0),
/*N*/   pColumnItem(0),
/*N*/   pObjectItem(0),
/*N*/   pEditWin(pWin),
/*N*/   pIndents(0),
/*N*/   pBorders(new RulerBorder[1]), //wg 1 Spaltiger Tabellen
/*N*/   pObjectBorders(0),
/*N*/   nBorderCount(0),
/*N*/   nDefTabType(RULER_TAB_LEFT),
/*N*/   nTabCount(0),
/*N*/   lDefTabDist(50),
/*N*/   lTabPos(-1),
/*N*/   nTabBufSize(0),
/*N*/   pTabs(0),
/*N*/   nFlags(flags),
/*N*/   nDragOffset(0),
/*N*/   nDragType(NONE),
/*N*/   nMaxLeft(0),
/*N*/   nMaxRight(0),
/*N*/   bListening(FALSE),
/*N*/   bValid(FALSE),
/*N*/   bActive(TRUE),
/*N*/   bAppSetNullOffset(FALSE),  //Wird der 0-Offset des Lineals
/*N*/ 							 //durch die appl. gesetzt?
/*N*/   pBindings(&rBindings),
/*N*/   lLogicNullOffset(0),
/*N*/   lAppNullOffset(LONG_MAX),
/*N*/   lMinFrame(10),
/*N*/   lInitialDragPos(0),
/*N*/   pCtrlItem(new SvxRulerItem *[CTRL_ITEM_COUNT]),
/*N*/   pRuler_Imp(new SvxRuler_Impl)
/*
   [Beschreibung]

   ctor;
   Datenpuffer initialisieren; ControllerItems werden erzeugt

*/
/*N*/ {
/*N*/ 	memset(pCtrlItem, 0, sizeof(SvxRulerItem *) * CTRL_ITEM_COUNT);
/*N*/ 
/*N*/ 	rBindings.EnterRegistrations();
/*N*/ 
/*N*/ 	// Unterstuetzte Items anlegen
/*N*/ 	USHORT i = 0;
/*N*/ 	// Seitenraender
/*N*/ 
/*N*/ 	pCtrlItem[i++] = new SvxRulerItem(SID_RULER_LR_MIN_MAX, *this, rBindings);
/*N*/ 	if((nWinStyle & WB_VSCROLL) == WB_VSCROLL)
/*N*/ 	{
/*N*/ 		bHorz = FALSE;
/*N*/ 		pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_LONG_ULSPACE, *this, rBindings);
/*N*/     }
/*N*/ 	else
/*N*/ 	{
/*N*/ 		bHorz = TRUE;
/*N*/ 		pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_LONG_LRSPACE, *this, rBindings);
/*N*/ 	}
/*N*/ 
/*N*/ 	// Seitenposition
/*N*/ 	pCtrlItem[i++] = new SvxRulerItem(SID_RULER_PAGE_POS, *this, rBindings);
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_TABS) == SVXRULER_SUPPORT_TABS)
/*N*/ 	{
/*N*/         USHORT nTabStopId = bHorz ? SID_ATTR_TABSTOP : SID_ATTR_TABSTOP_VERTICAL;
/*N*/         pCtrlItem[i++] = new SvxRulerItem(nTabStopId, *this, rBindings);
/*N*/ 		SetExtraType(RULER_EXTRA_TAB, nDefTabType);
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/     if(0 != (nFlags & (SVXRULER_SUPPORT_PARAGRAPH_MARGINS |SVXRULER_SUPPORT_PARAGRAPH_MARGINS_VERTICAL)))
/*N*/ 	{
/*N*/ 		if(bHorz)
/*N*/ 			pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_PARA_LRSPACE, *this, rBindings);
/*N*/ 		else
/*N*/ 			pCtrlItem[i++] = new SvxRulerItem(SID_ATTR_PARA_LRSPACE_VERTICAL, *this, rBindings);
/*N*/         pIndents = new RulerIndent[5+INDENT_GAP];
/*N*/ 		memset(pIndents, 0, sizeof(RulerIndent)*(3+INDENT_GAP));
/*N*/ 		pIndents[0].nStyle = RULER_STYLE_DONTKNOW;
/*N*/ 		pIndents[1].nStyle = RULER_STYLE_DONTKNOW;
/*N*/         pIndents[INDENT_FIRST_LINE].nStyle = RULER_INDENT_TOP;
/*N*/         pIndents[INDENT_LEFT_MARGIN].nStyle = RULER_INDENT_BOTTOM;
/*N*/         pIndents[INDENT_RIGHT_MARGIN].nStyle = RULER_INDENT_BOTTOM;
/*N*/         pIndents[INDENT_LEFT_BORDER].nStyle = RULER_INDENT_BORDER;
/*N*/         pIndents[INDENT_RIGHT_BORDER].nStyle = RULER_INDENT_BORDER;
/*N*/         for(USHORT nIn = 0; nIn < 7; nIn++)
/*N*/             pIndents[nIn].nPos = 0;
/*N*/     }
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_BORDERS) ==  SVXRULER_SUPPORT_BORDERS)
/*N*/     {
/*N*/         pCtrlItem[i++] = new SvxRulerItem(bHorz ? SID_RULER_BORDERS : SID_RULER_BORDERS_VERTICAL, *this, rBindings);
/*N*/     }
/*N*/ 
/*N*/     pCtrlItem[i++] = new SvxRulerItem(SID_RULER_TEXT_RIGHT_TO_LEFT, *this, rBindings);
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_OBJECT) == SVXRULER_SUPPORT_OBJECT)
/*N*/ 	{
/*?*/ 		pCtrlItem[i++] = new SvxRulerItem(SID_RULER_OBJECT, *this, rBindings );
/*?*/ 		pObjectBorders = new RulerBorder[OBJECT_BORDER_COUNT];
/*?*/ 		size_t nSize = sizeof( RulerBorder ) * OBJECT_BORDER_COUNT;
/*?*/ 		memset(pObjectBorders, 0, nSize);
/*?*/ 		for(USHORT i = 0; i < OBJECT_BORDER_COUNT; ++i)
/*?*/ 		{
/*?*/ 			pObjectBorders[i].nPos   = 0;
/*?*/ 			pObjectBorders[i].nWidth = 0;
/*?*/ 			pObjectBorders[i].nStyle = RULER_BORDER_MOVEABLE;
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pCtrlItem[i++] = new SvxRulerItem( SID_RULER_PROTECT, *this, rBindings );
/*N*/     pCtrlItem[i++] = new SvxRulerItem(SID_RULER_BORDER_DISTANCE, *this, rBindings);
/*N*/     pRuler_Imp->nControlerItems=i;
/*N*/ 
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_SET_NULLOFFSET) ==
/*N*/ 	   SVXRULER_SUPPORT_SET_NULLOFFSET)
/*?*/ 		SetExtraType(RULER_EXTRA_NULLOFFSET, 0);
/*N*/ 
/*N*/ 	rBindings.LeaveRegistrations();
/*N*/ }


/*N*/ __EXPORT SvxRuler::~SvxRuler()
/*
   [Beschreibung]

   Destruktor Lineal
   Freigabe interner Puffer


*/
/*N*/ {
/*N*/     REMOVE_DEBUG_WINDOW
/*N*/     if(bListening)
/*N*/ 		EndListening(*pBindings);
/*N*/ 
/*N*/ 	pBindings->EnterRegistrations();
/*N*/ 
/*N*/ 	for(USHORT i = 0; i < CTRL_ITEM_COUNT  && pCtrlItem[i]; ++i)
/*N*/ 		delete pCtrlItem[i];
/*N*/ 	delete[] pCtrlItem;
/*N*/ 
/*N*/ 	delete pLRSpaceItem;
/*N*/ 	delete pMinMaxItem;
/*N*/ 	delete pULSpaceItem;
/*N*/ 	delete pTabStopItem;
/*N*/ 	delete pParaItem;
/*N*/     delete pParaBorderItem;
/*N*/     delete pPagePosItem;
/*N*/ 	delete pColumnItem;
/*N*/ 	delete pObjectItem;
/*N*/ 	delete[] pIndents;
/*N*/ 	delete[] pBorders;
/*N*/ 	delete[] pObjectBorders;
/*N*/ 	delete[] pTabs;
/*N*/ 	delete pRuler_Imp;
/*N*/ 
/*N*/ 	pBindings->LeaveRegistrations();
/*N*/ }

/*

   [Beschreibung]

   Interne Umrechenroutinen

*/

/*N*/ long SvxRuler::ConvertHPosPixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(nVal, 0)).Width();
/*N*/ }

/*N*/ long SvxRuler::ConvertVPosPixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(0, nVal)).Height();
/*N*/ }

/*N*/ long SvxRuler::ConvertHSizePixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(nVal, 0)).Width();
/*N*/ }

/*N*/ long SvxRuler::ConvertVSizePixel(long nVal) const
/*N*/ {
/*N*/ 	return pEditWin->LogicToPixel(Size(0, nVal)).Height();
/*N*/ }

/*N*/ long SvxRuler::ConvertPosPixel(long nVal) const
/*N*/ {
/*N*/ 	return bHorz ? ConvertHPosPixel(nVal): ConvertVPosPixel(nVal);
/*N*/ }

/*N*/ long SvxRuler::ConvertSizePixel(long nVal) const
/*N*/ {
/*N*/ 	return bHorz? ConvertHSizePixel(nVal): ConvertVSizePixel(nVal);
/*N*/ }


//STRIP001 inline long SvxRuler::ConvertHPosLogic(long nVal) const
//STRIP001 {
//STRIP001 	return pEditWin->PixelToLogic(Size(nVal, 0)).Width();
//STRIP001 }

//STRIP001 inline long SvxRuler::ConvertVPosLogic(long nVal) const
//STRIP001 {
//STRIP001 	return pEditWin->PixelToLogic(Size(0, nVal)).Height();
//STRIP001 }

//STRIP001 inline long SvxRuler::ConvertHSizeLogic(long nVal) const
//STRIP001 {
//STRIP001 	return pEditWin->PixelToLogic(Size(nVal, 0)).Width();
//STRIP001 }

//STRIP001 inline long SvxRuler::ConvertVSizeLogic(long nVal) const
//STRIP001 {
//STRIP001 	return pEditWin->PixelToLogic(Size(0, nVal)).Height();
//STRIP001 }

//STRIP001 inline long SvxRuler::ConvertPosLogic(long nVal) const
//STRIP001 {
//STRIP001 	return bHorz? ConvertHPosLogic(nVal): ConvertVPosLogic(nVal);
//STRIP001 }

//STRIP001 inline long SvxRuler::ConvertSizeLogic(long nVal) const
//STRIP001 {
//STRIP001 	return bHorz? ConvertHSizeLogic(nVal): ConvertVSizeLogic(nVal);
//STRIP001 }

//STRIP001 long SvxRuler::PixelHAdjust(long nVal, long nValOld) const
//STRIP001 {
//STRIP001 		if(ConvertHSizePixel(nVal)!=ConvertHSizePixel(nValOld))
//STRIP001 				return  nVal;
//STRIP001 		else
//STRIP001 				return  nValOld;
//STRIP001 }

//STRIP001 long SvxRuler::PixelVAdjust(long nVal, long nValOld) const
//STRIP001 {
//STRIP001 		if(ConvertVSizePixel(nVal)!=ConvertVSizePixel(nValOld))
//STRIP001 				return  nVal;
//STRIP001 		else
//STRIP001 				return  nValOld;
//STRIP001 }

//STRIP001 long SvxRuler::PixelAdjust(long nVal, long nValOld) const
//STRIP001 {
//STRIP001 		if(ConvertSizePixel(nVal)!=ConvertSizePixel(nValOld))
//STRIP001 				return  nVal;
//STRIP001 		else
//STRIP001 				return  nValOld;
//STRIP001 }


//STRIP001 inline USHORT SvxRuler::GetObjectBordersOff(USHORT nIdx) const
//STRIP001 {
//STRIP001 	return bHorz? nIdx: nIdx + 2;
//STRIP001 }



/*N*/ void SvxRuler::UpdateFrame()

/*
   [Beschreibung]

   Linken, oberen Rand aktualisieren
   Items werden in die Darstellung des Lineals uebersetzt.

*/

/*N*/ {
/*N*/ 	const USHORT nMarginStyle =
/*N*/ 		( pRuler_Imp->aProtectItem.IsSizeProtected() ||
/*N*/ 		  pRuler_Imp->aProtectItem.IsPosProtected() ) ?
/*N*/ 		0 : RULER_MARGIN_SIZEABLE;
/*N*/ 
/*N*/ 	if(pLRSpaceItem && pPagePosItem)
/*N*/ 	{
/*N*/ 		// wenn keine Initialisierung durch App Defaultverhalten
/*N*/ 		const long nOld = lLogicNullOffset;
/*N*/ 		lLogicNullOffset = pColumnItem?
/*N*/ 			pColumnItem->GetLeft(): pLRSpaceItem->GetLeft();
/*N*/ 		if(bAppSetNullOffset)
/*?*/ 			lAppNullOffset += lLogicNullOffset - nOld;
/*N*/ 		if(!bAppSetNullOffset || lAppNullOffset == LONG_MAX)
/*N*/ 		{
/*N*/ 			Ruler::SetNullOffset(ConvertHPosPixel(lLogicNullOffset));
/*N*/ 			SetMargin1( 0, nMarginStyle );
/*N*/ 			lAppNullOffset = 0;
/*N*/ 		}
/*N*/ 		else
/*?*/ 			SetMargin1( ConvertHPosPixel( lAppNullOffset ), nMarginStyle );
/*N*/ 		long lRight = 0;
/*N*/ 			// bei Tabelle rechten Rand der Tabelle auswerten
/*N*/ 		if(pColumnItem && pColumnItem->IsTable())
/*?*/ 			lRight = pColumnItem->GetRight();
/*N*/ 		else
/*N*/ 			lRight = pLRSpaceItem->GetRight();
/*N*/ 
/*N*/ 		ULONG aWidth=
/*N*/ 			ConvertHPosPixel(pPagePosItem->GetWidth() - lRight -
/*N*/ 									lLogicNullOffset + lAppNullOffset);
/*N*/ 		SetMargin2( aWidth, nMarginStyle );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		if(pULSpaceItem && pPagePosItem)
/*N*/ 		{
/*N*/ 			// Nullpunkt aus oberem Rand des umgebenden Rahmens
/*N*/ 			const long nOld = lLogicNullOffset;
/*N*/ 			lLogicNullOffset = pColumnItem?
/*N*/ 				pColumnItem->GetLeft(): pULSpaceItem->GetUpper();
/*N*/ 			if(bAppSetNullOffset)
/*?*/ 				lAppNullOffset += lLogicNullOffset - nOld;
/*N*/ 			if(!bAppSetNullOffset || lAppNullOffset == LONG_MAX) {
/*N*/ 				Ruler::SetNullOffset(ConvertVPosPixel(lLogicNullOffset));
/*N*/ 				lAppNullOffset = 0;
/*N*/ 				SetMargin1( 0, nMarginStyle );
/*N*/ 			}
/*N*/ 			else
/*?*/ 				SetMargin1( ConvertVPosPixel( lAppNullOffset ),nMarginStyle );
/*N*/ 
/*N*/ 			long lLower = pColumnItem ?
/*N*/ 				pColumnItem->GetRight() : pULSpaceItem->GetLower();
/*N*/ 
/*N*/ 			SetMargin2(ConvertVPosPixel(pPagePosItem->GetHeight() - lLower -
/*N*/ 										lLogicNullOffset + lAppNullOffset),
/*N*/ 										nMarginStyle );
/*N*/ 		}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// schaltet die Anzeige aus
/*N*/ 		SetMargin1();
/*N*/ 		SetMargin2();
/*N*/ 	}
/*N*/ 	if(pColumnItem)
/*N*/ 	{
/*?*/ 		pRuler_Imp->nColLeftPix = (USHORT) ConvertSizePixel(pColumnItem->GetLeft());
/*?*/ 		pRuler_Imp->nColRightPix = (USHORT) ConvertSizePixel(pColumnItem->GetRight());
/*N*/ 	}
/*N*/ 
/*N*/ }

/*N*/ void SvxRuler::MouseMove( const MouseEvent& rMEvt )
/*N*/ {
/*N*/ 	if( bActive )
/*N*/ 	{
/*N*/ 		pBindings->Update( SID_RULER_LR_MIN_MAX );
/*N*/ 		pBindings->Update( SID_ATTR_LONG_ULSPACE );
/*N*/ 		pBindings->Update( SID_ATTR_LONG_LRSPACE );
/*N*/ 		pBindings->Update( SID_RULER_PAGE_POS );
/*N*/         pBindings->Update( bHorz ? SID_ATTR_TABSTOP : SID_ATTR_TABSTOP_VERTICAL);
/*N*/         pBindings->Update( bHorz ? SID_ATTR_PARA_LRSPACE : SID_ATTR_PARA_LRSPACE_VERTICAL);
/*N*/         pBindings->Update( bHorz ? SID_RULER_BORDERS : SID_RULER_BORDERS_VERTICAL);
/*N*/ 		pBindings->Update( SID_RULER_OBJECT );
/*N*/ 		pBindings->Update( SID_RULER_PROTECT );
/*N*/ 	}
/*N*/ 	Ruler::MouseMove( rMEvt );
/*N*/ }
/*N*/ void SvxRuler::StartListening_Impl()
/*N*/ {
/*N*/     if(!bListening)
/*N*/ 	{
/*N*/ 		bValid = FALSE;
/*N*/ 		StartListening(*pBindings);
/*N*/ 		bListening = TRUE;
/*N*/ 	}
/*N*/ }

/*N*/ void SvxRuler::UpdateFrame
/*N*/ (
/*N*/  const SvxLongLRSpaceItem *pItem    // neuer Wert LRSpace
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer LRSpace merken; alten gfs. loeschen

*/

/*N*/ {
/*N*/   if(bActive)
/*N*/   {
/*N*/ 	delete pLRSpaceItem; pLRSpaceItem = 0;
/*N*/ 	if(pItem)
/*N*/ 		pLRSpaceItem = new SvxLongLRSpaceItem(*pItem);
/*N*/     StartListening_Impl();
/*N*/   }
/*N*/ }


/*N*/ void SvxRuler::UpdateFrameMinMax
/*N*/ (
/*N*/  const SfxRectangleItem *pItem  // Werte fuer MinMax
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer MinMax setzen; alten gfs. loeschen

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pMinMaxItem; pMinMaxItem = 0;
/*N*/ 		if(pItem)
/*N*/ 			pMinMaxItem = new SfxRectangleItem(*pItem);
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::UpdateFrame
/*N*/ (
/*N*/  const SvxLongULSpaceItem *pItem    // neuer Wert
/*N*/ )

/*
   [Beschreibung]

   Rechten / unteren Rand aktualisieren

*/


/*N*/ {
/*N*/   if(bActive && !bHorz)
/*N*/   {
/*N*/ 	delete pULSpaceItem; pULSpaceItem = 0;
/*N*/ 	if(pItem)
/*N*/ 		pULSpaceItem = new SvxLongULSpaceItem(*pItem);
/*N*/     StartListening_Impl();
/*N*/   }
/*N*/ }

/*N*/ void SvxRuler::Update( const SvxProtectItem* pItem )
/*N*/ {
/*N*/ 	if( pItem ) pRuler_Imp->aProtectItem = *pItem;
/*N*/ }
/* -----------------------------22.08.2002 13:10------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void SvxRuler::UpdateTextRTL(const SfxBoolItem* pItem)
/*N*/ {
/*N*/   if(bActive)
/*N*/   {
/*N*/     delete pRuler_Imp->pTextRTLItem; pRuler_Imp->pTextRTLItem = 0;
/*N*/ 	if(pItem)
/*N*/         pRuler_Imp->pTextRTLItem = new SfxBoolItem(*pItem);
/*N*/     SetTextRTL(pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue());
/*N*/     StartListening_Impl();
/*N*/   }
/*N*/ }

/*N*/ void SvxRuler::Update
/*N*/ (
/*N*/  const SvxColumnItem *pItem             // neuer Wert
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer Spaltendarstellung setzen

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pColumnItem; pColumnItem = 0;
/*N*/ 		if(pItem)
/*N*/ 		{
/*N*/ 			pColumnItem = new SvxColumnItem(*pItem);
/*N*/ 			if(!bHorz)
/*?*/ 				pColumnItem->SetWhich(SID_RULER_BORDERS_VERTICAL);
/*N*/ 		}
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }


/*N*/ void SvxRuler::UpdateColumns()
/*
   [Beschreibung]

   Anzeige der Spaltendarstellung aktualisieren

*/
/*N*/ {
/*N*/ 	if(pColumnItem && pColumnItem->Count() > 1)
/*N*/ 	{
/*?*/ 		if( nBorderCount < pColumnItem->Count())
/*?*/ 		{
/*?*/ 			delete[] pBorders;
/*?*/ 			nBorderCount = pColumnItem->Count();
/*?*/ 			pBorders = new RulerBorder[nBorderCount];
/*?*/ 			size_t nSize = sizeof( RulerBorder ) * nBorderCount;
/*?*/ 		}
/*?*/ 		USHORT nFlags = RULER_BORDER_VARIABLE;
/*?*/ 		BOOL bProtectColumns =
/*?*/ 			pRuler_Imp->aProtectItem.IsSizeProtected() ||
/*?*/ 			pRuler_Imp->aProtectItem.IsPosProtected();
/*?*/ 		if( !bProtectColumns )
/*?*/ 			nFlags |= RULER_BORDER_MOVEABLE;
/*?*/ 		if( pColumnItem->IsTable() )
/*?*/ 			nFlags |= RULER_BORDER_TABLE;
/*?*/ 		else
/*?*/ 			if ( !bProtectColumns )
/*?*/ 				nFlags |= RULER_BORDER_SIZEABLE;
/*?*/ 
/*?*/ 		for(USHORT i = 0; i < pColumnItem->Count()-1;++i)
/*?*/ 		{
/*?*/ 			pBorders[i].nStyle = nFlags;
/*?*/ 			if(!(*pColumnItem)[i].bVisible)
/*?*/ 				pBorders[i].nStyle |= RULER_STYLE_INVISIBLE;
/*?*/ 			pBorders[i].nPos =
/*?*/ 				ConvertPosPixel((*pColumnItem)[i].nEnd + lAppNullOffset);
/*?*/ 			pBorders[i].nWidth =
/*?*/ 				ConvertSizePixel((*pColumnItem)[i+1].nStart -
/*?*/ 								 (*pColumnItem)[i].nEnd);
/*?*/ 		}
/*?*/ 		const size_t nSize = sizeof(RulerBorder) * (pColumnItem->Count()-1);
/*?*/ 		SetBorders(pColumnItem->Count()-1, pBorders);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SetBorders();
/*N*/ 	}
/*N*/ }


//STRIP001 void SvxRuler::UpdateObject()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Anzeige der Objektdarstellung aktualisieren
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if(pObjectItem)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(pObjectBorders, "kein Buffer");
//STRIP001 		// !! zum Seitenrand
//STRIP001 		long nMargin = pLRSpaceItem? pLRSpaceItem->GetLeft(): 0;
//STRIP001 		pObjectBorders[0].nPos =
//STRIP001 			ConvertPosPixel(pObjectItem->GetStartX() -
//STRIP001 							nMargin + lAppNullOffset);
//STRIP001 		pObjectBorders[1].nPos =
//STRIP001 			ConvertPosPixel(pObjectItem->GetEndX() - nMargin + lAppNullOffset);
//STRIP001 		nMargin = pULSpaceItem? pULSpaceItem->GetUpper(): 0;
//STRIP001 		pObjectBorders[2].nPos =
//STRIP001 			ConvertPosPixel(pObjectItem->GetStartY() -
//STRIP001 							nMargin + lAppNullOffset);
//STRIP001 		pObjectBorders[3].nPos =
//STRIP001 			ConvertPosPixel(pObjectItem->GetEndY() - nMargin + lAppNullOffset);
//STRIP001 
//STRIP001 		const size_t nSize = sizeof(RulerBorder) * 2;
//STRIP001 		const USHORT nOff = GetObjectBordersOff(0);
//STRIP001 		SetBorders(2, pObjectBorders + nOff);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetBorders();
//STRIP001 	}
//STRIP001 }


/*N*/ void SvxRuler::UpdatePara()

/*
   [Beschreibung]

   Anzeige der Absatzeinzuege aktualisieren:
   Linken Rand, Erstzeileneinzug, rechten Rand Absatz aktualisieren
   pIndents[0] = Buffer fuer alten Einzug
   pIndents[1] = Buffer fuer alten Einzug
   pIndents[INDENT_FIRST_LINE] = Erstzeileneinzug
   pIndents[3] = linker Rand
   pIndents[4] = rechter Rand
   pIndents[5] = left border distance
   pIndents[6] = right border distance

*/

/*N*/ {
/*N*/ 	// Abhaengigkeit zu PagePosItem
/*N*/ 	if(pParaItem && pPagePosItem && !pObjectItem)
/*?*/ 	{
/*?*/         BOOL bRTLText = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
/*?*/         // Erstzeileneinzug, ist negativ zum linken Absatzrand
/*?*/         long nLeftFrameMargin = GetLeftFrameMargin();
/*?*/         long nRightFrameMargin = GetRightFrameMargin();
/*?*/         if(bRTLText)
/*?*/             pIndents[INDENT_FIRST_LINE].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                 nRightFrameMargin -
/*?*/                 pParaItem->GetTxtLeft() -
/*?*/ 				pParaItem->GetTxtFirstLineOfst() + lAppNullOffset );
/*?*/         else
/*?*/             pIndents[INDENT_FIRST_LINE].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nLeftFrameMargin +
/*?*/                     pParaItem->GetTxtLeft() +
/*?*/                     pParaItem->GetTxtFirstLineOfst() +
/*?*/                     lAppNullOffset);
/*?*/ 		if( pParaItem->IsAutoFirst() )
/*?*/             pIndents[INDENT_FIRST_LINE].nStyle |= RULER_STYLE_INVISIBLE;
/*?*/ 		else
/*?*/             pIndents[INDENT_FIRST_LINE].nStyle &= ~RULER_STYLE_INVISIBLE;
/*?*/ 
/*?*/         if(bRTLText)
/*?*/         {
/*?*/             // left margin
/*?*/             pIndents[INDENT_LEFT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nRightFrameMargin -
/*?*/                     pParaItem->GetTxtLeft() + lAppNullOffset);
/*?*/             // right margin
/*?*/             pIndents[INDENT_RIGHT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nLeftFrameMargin +
/*?*/                     pParaItem->GetRight() + lAppNullOffset);
/*?*/         }
/*?*/         else
/*?*/         {
/*?*/             // linker Rand
/*?*/             pIndents[INDENT_LEFT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nLeftFrameMargin +
/*?*/                     pParaItem->GetTxtLeft() + lAppNullOffset);
/*?*/             // rechter Rand, immer negativ zum rechten Rand des umgebenden Frames
/*?*/             pIndents[INDENT_RIGHT_MARGIN].nPos =
/*?*/                 ConvertHPosPixel(
/*?*/                     nRightFrameMargin -
/*?*/                     pParaItem->GetRight() + lAppNullOffset);
/*?*/         }
/*?*/         if(pParaBorderItem)
/*?*/         {
/*?*/             pIndents[INDENT_LEFT_BORDER].nPos =
/*?*/             ConvertHPosPixel( nLeftFrameMargin + lAppNullOffset);
/*?*/             pIndents[INDENT_RIGHT_BORDER].nPos =
/*?*/                 ConvertHPosPixel(nRightFrameMargin - lAppNullOffset);
/*?*/             pIndents[INDENT_LEFT_BORDER].nStyle = pIndents[INDENT_RIGHT_BORDER].nStyle &= ~RULER_STYLE_INVISIBLE;
/*?*/         }
/*?*/         else
/*?*/             pIndents[INDENT_LEFT_BORDER].nStyle = pIndents[INDENT_RIGHT_BORDER].nStyle |= RULER_STYLE_INVISIBLE;
/*?*/ 
/*?*/         SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if(pIndents)
/*N*/ 		{
/*N*/             pIndents[INDENT_FIRST_LINE].nPos =
/*N*/             pIndents[INDENT_LEFT_MARGIN].nPos =
/*N*/             pIndents[INDENT_RIGHT_MARGIN].nPos = 0;
/*N*/ 		}
/*N*/ 		SetIndents();        // ausschalten
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::UpdatePara
/*N*/ (
/*N*/  const SvxLRSpaceItem *pItem    // neuer Wert Absatzeinzuege
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert Absatzeinzuege merken
*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pParaItem; pParaItem = 0;
/*N*/ 		if(pItem)
/*N*/ 			pParaItem = new SvxLRSpaceItem(*pItem);
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }
/*N*/ void SvxRuler::UpdateParaBorder(const SvxLRSpaceItem * pItem )
/*
   [Description]
   Border distance
*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/         delete pParaBorderItem; pParaBorderItem = 0;
/*N*/ 		if(pItem)
/*?*/             pParaBorderItem = new SvxLRSpaceItem(*pItem);
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }


/*N*/ void SvxRuler::UpdatePage()

/*
   [Beschreibung]

   Anzeige von Postion und Breite der Seite aktualisieren

*/

/*N*/ {
/*N*/ 	if(pPagePosItem)
/*N*/ 	{
/*N*/ 		// alle Objekte werden automatisch angepasst
/*N*/ 		if(bHorz)
/*N*/ 			SetPagePos(
/*N*/ 				pEditWin->LogicToPixel(pPagePosItem->GetPos()).X(),
/*N*/ 				pEditWin->LogicToPixel(Size(pPagePosItem->GetWidth(),0)).
/*N*/ 				Width());
/*N*/ 		else
/*N*/ 			SetPagePos(
/*N*/ 				pEditWin->LogicToPixel(pPagePosItem->GetPos()).Y(),
/*N*/ 				pEditWin->LogicToPixel(Size(0, pPagePosItem->GetHeight())).
/*N*/ 				Height());
/*N*/ 		if(bAppSetNullOffset)
/*?*/ 			SetNullOffset(ConvertSizePixel(-lAppNullOffset + lLogicNullOffset));
/*N*/ 	}
/*N*/ 	else
/*N*/ 		SetPagePos();
/*N*/ 
/*N*/ 	Point aPos(pEditWin->GetPosPixel()-GetPosPixel());
/*N*/ 	long lPos= bHorz ? aPos.X() : aPos.Y();
/*N*/ 
/*N*/ // Leider bekommen wir den Offset des Editfensters zum Lineal nie
/*N*/ // per Statusmeldung. Also setzen wir ihn selbst, wenn noetig.
/*N*/ 
/*N*/ 	if(lPos!=pRuler_Imp->lOldWinPos)
/*N*/ 	{
/*?*/ 		pRuler_Imp->lOldWinPos=lPos;
/*?*/ 		SetWinPos(lPos);
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::Update
/*N*/ (
/*N*/  const SvxPagePosSizeItem *pItem // neuer Wert Seitenattribute
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert Seitenattribute merken

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pPagePosItem; pPagePosItem = 0;
/*N*/ 		if(pItem)
/*N*/ 			pPagePosItem = new SvxPagePosSizeItem(*pItem);
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }


//

/*N*/ void SvxRuler::SetDefTabDist
/*N*/ (
/*N*/  long l                                                 // Neuer Abstand fuer DefaultTabs in App-Metrik
/*N*/ )

/*
   [Beschreibung]

   Neuer Abstand fuer DefaultTabs wird gesetzt

*/

/*N*/ {
/*N*/ 
/*N*/ 	lDefTabDist = l;
/*N*/ 	UpdateTabs();
/*N*/ }


//STRIP001 long SvxRuler::GetDefTabDist() const
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Wert fuer DefaultTabs erfragen (wird in App.-Methik geliefert)
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return lDefTabDist;
//STRIP001 }


//STRIP001 USHORT ToSvTab_Impl(SvxTabAdjust eAdj)
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Interne Konvertierungsroutinen zwischen SV-Tab.-Enum und Svx
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	switch(eAdj) {
//STRIP001 	case SVX_TAB_ADJUST_LEFT:    return RULER_TAB_LEFT;
//STRIP001 	case SVX_TAB_ADJUST_RIGHT:   return RULER_TAB_RIGHT;
//STRIP001 	case SVX_TAB_ADJUST_DECIMAL: return RULER_TAB_DECIMAL;
//STRIP001 	case SVX_TAB_ADJUST_CENTER:  return RULER_TAB_CENTER;
//STRIP001 	case SVX_TAB_ADJUST_DEFAULT: return RULER_TAB_DEFAULT;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 SvxTabAdjust ToAttrTab_Impl(USHORT eAdj)
//STRIP001 {
//STRIP001 	switch(eAdj) {
//STRIP001 	case RULER_TAB_LEFT:    return SVX_TAB_ADJUST_LEFT    ;
//STRIP001 	case RULER_TAB_RIGHT:   return SVX_TAB_ADJUST_RIGHT   ;
//STRIP001 	case RULER_TAB_DECIMAL: return SVX_TAB_ADJUST_DECIMAL ;
//STRIP001 	case RULER_TAB_CENTER:  return SVX_TAB_ADJUST_CENTER  ;
//STRIP001 	case RULER_TAB_DEFAULT: return SVX_TAB_ADJUST_DEFAULT ;
//STRIP001 	}
//STRIP001 	return SVX_TAB_ADJUST_LEFT;
//STRIP001 }


/*N*/ void SvxRuler::UpdateTabs()

/*
   [Beschreibung]

   Anzeige der Tabulatoren

*/

/*N*/ {
/*N*/ 	if(IsDrag())
/*N*/ 		return;
/*N*/ 	if(pPagePosItem && pParaItem && pTabStopItem && !pObjectItem)
/*N*/ 	{
/*N*/ 		// Puffer fuer DefaultTabStop
/*N*/ 		// Abstand letzter Tab <-> Rechter Absatzrand / DefaultTabDist
/*N*/ 		BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
/*N*/         long nLeftFrameMargin = GetLeftFrameMargin();
/*N*/         long nRightFrameMargin = GetRightFrameMargin();
/*N*/ 
/*N*/ 		const long lParaIndent =
/*N*/ 			nLeftFrameMargin + pParaItem->GetTxtLeft();
/*N*/ 		const long lLastTab =
/*N*/ 			 pTabStopItem->Count()?
/*N*/ 			  ConvertHPosPixel((*pTabStopItem)[pTabStopItem->Count()-1].GetTabPos()): 0;
/*N*/ 		const long lPosPixel =
/*N*/ 			ConvertHPosPixel(lParaIndent) + lLastTab;
/*N*/ 		const long lRightIndent =
/*N*/ 			ConvertHPosPixel(nRightFrameMargin - pParaItem->GetRight());
/*N*/ 		long nDefTabDist = ConvertHPosPixel(lDefTabDist);
/*N*/ 		if( !nDefTabDist )
/*N*/ 			nDefTabDist = 1;
/*N*/ 		const USHORT nDefTabBuf = lPosPixel > lRightIndent ||
/*N*/ 			lLastTab > lRightIndent
/*N*/ 				? 0
/*N*/ 				: (USHORT)( (lRightIndent - lPosPixel) / nDefTabDist );
/*N*/ 		const long nOldTabCount = nTabCount;
/*N*/ 
/*N*/ 		if(pTabStopItem->Count() + TAB_GAP + nDefTabBuf > nTabBufSize)
/*N*/ 		{
/*N*/ 			delete[] pTabs;
/*N*/ 			// 10 (GAP) auf Vorrat
/*N*/ 			nTabBufSize = pTabStopItem->Count() + TAB_GAP + nDefTabBuf + GAP;
/*N*/ 			pTabs = new RulerTab[nTabBufSize];
/*N*/ 		}
/*N*/ 
/*N*/ 		nTabCount = 0;
/*N*/ 		USHORT j;
/*N*/ 		const long lRightPixMargin = ConvertSizePixel(nRightFrameMargin - pParaItem->GetTxtLeft());
/*N*/ 		const long lParaIndentPix = ConvertSizePixel(lParaIndent);
/*N*/ 		for(j = 0; j < pTabStopItem->Count(); ++j)
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const SvxTabStop *pTab = &(*pTabStopItem)[j];
//STRIP001 /*?*/ 			pTabs[nTabCount+TAB_GAP].nPos =
//STRIP001 /*?*/ 				ConvertHPosPixel(
//STRIP001 /*?*/ 					lParaIndent + pTab->GetTabPos() + lAppNullOffset);
//STRIP001 /*?*/ 			// nicht ueber den rechten Absatzrand
//STRIP001 /*?*/ 			if(pTabs[nTabCount+TAB_GAP].nPos > lRightIndent)
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 			if(bRTL)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pTabs[nTabCount+TAB_GAP].nPos = lParaIndentPix + lRightPixMargin - pTabs[nTabCount+TAB_GAP].nPos;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			pTabs[nTabCount+TAB_GAP].nStyle = ToSvTab_Impl(pTab->GetAdjustment());
//STRIP001 /*?*/ 			++nTabCount;
/*N*/ 		}
/*N*/ 		if(!pTabStopItem->Count())
/*N*/ 			pTabs[0].nPos = bRTL ? lRightPixMargin : lParaIndentPix;
/*N*/ 
/*?*/ 		// Rest mit Default-Tabs fuellen
/*?*/ 		if(bRTL)
/*?*/ 		{
/*?*/ 			for(j = 0; j < nDefTabBuf; ++j)
/*?*/ 			{
/*?*/ 				pTabs[nTabCount + TAB_GAP].nPos =
/*?*/ 					pTabs[nTabCount].nPos - nDefTabDist;
/*?*/ 
/*?*/ 				if(j == 0 )
/*?*/ 					pTabs[nTabCount + TAB_GAP].nPos -=
/*?*/ 						((pTabs[nTabCount + TAB_GAP].nPos - lRightPixMargin)
/*?*/ 						 % nDefTabDist );
/*?*/ 				if(pTabs[nTabCount+TAB_GAP].nPos <= lParaIndentPix)
/*?*/ 					break;
/*?*/ 				pTabs[nTabCount + TAB_GAP].nStyle = RULER_TAB_DEFAULT;
/*?*/ 				++nTabCount;
/*?*/ 			}
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			for(j = 0; j < nDefTabBuf; ++j)
/*?*/ 			{
/*?*/ 				pTabs[nTabCount + TAB_GAP].nPos =
/*?*/ 					pTabs[nTabCount].nPos + nDefTabDist;
/*?*/ 
/*?*/ 				if(j == 0 )
/*?*/ 					pTabs[nTabCount + TAB_GAP].nPos -=
/*?*/ 						((pTabs[nTabCount + TAB_GAP].nPos - lParaIndentPix)
/*?*/ 						 % nDefTabDist );
/*?*/ 				if(pTabs[nTabCount+TAB_GAP].nPos >= lRightIndent)
/*?*/ 					break;
/*?*/ 				pTabs[nTabCount + TAB_GAP].nStyle = RULER_TAB_DEFAULT;
/*?*/ 				++nTabCount;
/*?*/ 			}
/*?*/ 		}
/*?*/ 		const size_t nSize = sizeof(RulerTab) * nTabCount;
/*?*/ 		SetTabs(nTabCount, pTabs+TAB_GAP);
/*?*/ 		DBG_ASSERT(nTabCount + TAB_GAP <= nTabBufSize, "BufferSize zu klein");
/*?*/ 	}
/*?*/ 	else
/*N*/ 	{
/*N*/ 		SetTabs();
/*N*/ 	}
/*N*/ }


/*N*/ void SvxRuler::Update
/*N*/ (
/*N*/  const SvxTabStopItem *pItem    // Neuer Wert fuer Tabulatoren
/*N*/ )

/*
   [Beschreibung]

   Neuen Wert fuer Tabulatoren merken; alten gfs. loeschen

*/

/*N*/ {
/*N*/ 	if(bActive)
/*N*/ 	{
/*N*/ 		delete pTabStopItem; pTabStopItem = 0;
/*N*/ 		if(pItem)
/*N*/ 		{
/*N*/ 			pTabStopItem = new SvxTabStopItem(*pItem);
/*N*/ 			if(!bHorz)
/*?*/ 				pTabStopItem->SetWhich(SID_ATTR_TABSTOP_VERTICAL);
/*N*/ 		}
/*N*/         StartListening_Impl();
/*N*/     }
/*N*/ }


//STRIP001 void SvxRuler::Update
//STRIP001 (
//STRIP001  const SvxObjectItem *pItem             // Neuer Wert fuer Objekte
//STRIP001 )
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Neuen Wert fuer Objekte merken
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if(bActive)
//STRIP001 	{
//STRIP001 		delete pObjectItem; pObjectItem = 0;
//STRIP001 		if(pItem)
//STRIP001 			pObjectItem = new SvxObjectItem(*pItem);
//STRIP001         StartListening_Impl();
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxRuler::SetNullOffsetLogic
//STRIP001 (
//STRIP001  long lVal                                              // Setzen des logischen NullOffsets
//STRIP001 )
//STRIP001 {
//STRIP001 	lAppNullOffset = lLogicNullOffset - lVal;
//STRIP001 	bAppSetNullOffset = TRUE;
//STRIP001 	Ruler::SetNullOffset(ConvertSizePixel(lVal));
//STRIP001 	Update();
//STRIP001 }


/*N*/ void SvxRuler::Update()

/*
   [Beschreibung]

   Aktualisierung der Anzeige anstossen

*/

/*N*/ {
/*N*/ 	if(IsDrag())
/*N*/ 		return;
/*N*/ 	UpdatePage();
/*N*/ 	UpdateFrame();
/*N*/ 	if((nFlags & SVXRULER_SUPPORT_OBJECT) == SVXRULER_SUPPORT_OBJECT)
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	UpdateObject();
/*N*/ 	else
/*N*/ 		UpdateColumns();
/*N*/ 
/*N*/     if(0 != (nFlags & (SVXRULER_SUPPORT_PARAGRAPH_MARGINS |SVXRULER_SUPPORT_PARAGRAPH_MARGINS_VERTICAL)))
/*N*/ 	  UpdatePara();
/*N*/     if(0 != (nFlags & SVXRULER_SUPPORT_TABS))
/*N*/       UpdateTabs();
/*N*/ }


//STRIP001 inline long SvxRuler::GetPageWidth() const
//STRIP001 {
//STRIP001 	return bHorz ? pPagePosItem->GetWidth() : pPagePosItem->GetHeight();
//STRIP001 
//STRIP001 }


//STRIP001 inline long SvxRuler::GetFrameLeft() const
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Erfragen des linken Randes in Pixeln
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 
//STRIP001 {
//STRIP001 	return  bAppSetNullOffset?
//STRIP001 			GetMargin1() + ConvertSizePixel(lLogicNullOffset):
//STRIP001 			Ruler::GetNullOffset();
//STRIP001 }

//STRIP001 inline void SvxRuler::SetFrameLeft(long l)
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Setzen des linken Randes in Pixeln
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	BOOL bProtectColumns =
//STRIP001 		pRuler_Imp->aProtectItem.IsSizeProtected() ||
//STRIP001 		pRuler_Imp->aProtectItem.IsPosProtected();
//STRIP001 	if(bAppSetNullOffset)
//STRIP001 		SetMargin1(l - ConvertSizePixel(lLogicNullOffset),
//STRIP001 				   bProtectColumns ? 0 : RULER_MARGIN_SIZEABLE);
//STRIP001 	else
//STRIP001 		Ruler::SetNullOffset(l);
//STRIP001 }


//STRIP001 long SvxRuler::GetFirstLineIndent() const
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Erstzeileneinzug in Pixels erfragen
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     return pParaItem? pIndents[INDENT_FIRST_LINE].nPos: GetMargin1();
//STRIP001 }


//STRIP001 long SvxRuler::GetLeftIndent() const
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Linken Absatzrand in Pixels erfragen
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     return pParaItem? pIndents[INDENT_LEFT_MARGIN].nPos: GetMargin1();
//STRIP001 }



//STRIP001 long SvxRuler::GetRightIndent() const
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Rechten Absatzrand in Pixels erfragen
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     return pParaItem? pIndents[INDENT_RIGHT_MARGIN].nPos: GetMargin2();
//STRIP001 }


//STRIP001 long SvxRuler::GetLogicRightIndent() const
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Rechten Absatzrand in Logic erfragen
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return pParaItem ? GetRightFrameMargin()-pParaItem->GetRight() : GetRightFrameMargin();
//STRIP001 }

// linker Rand in App-Werten; ist entweder der Seitenrand (=0)
// oder der linke Rand der Spalte, die im Spaltenattribut als
// altuelle Spalte eingestellt ist.

/*N*/ long SvxRuler::GetLeftFrameMargin() const
/*N*/ {
/*N*/     long nLeft =
/*N*/         pColumnItem && pColumnItem->Count()?
/*N*/         (*pColumnItem)[pColumnItem->GetActColumn()].nStart : 0;
/*N*/     if(pParaBorderItem && (!pColumnItem || pColumnItem->IsTable()))
/*N*/         nLeft += pParaBorderItem->GetLeft();
/*N*/     return nLeft;
/*N*/ }

//STRIP001 inline long SvxRuler::GetLeftMin() const
//STRIP001 {
//STRIP001 	DBG_ASSERT(pMinMaxItem, "kein MinMax-Wert gesetzt");
//STRIP001 	return pMinMaxItem?
//STRIP001 		bHorz? 	pMinMaxItem->GetValue().Left(): pMinMaxItem->GetValue().Top()
//STRIP001 				: 0;
//STRIP001 }

//STRIP001 inline long SvxRuler::GetRightMax() const
//STRIP001 {
//STRIP001 	DBG_ASSERT(pMinMaxItem, "kein MinMax-Wert gesetzt");
//STRIP001 	return pMinMaxItem?
//STRIP001 		bHorz? pMinMaxItem->GetValue().Right(): pMinMaxItem->GetValue().Bottom()
//STRIP001 			: 0;
//STRIP001 }


/*N*/ long SvxRuler::GetRightFrameMargin() const

/*
   [Beschreibung]

   Rechten umgebenden Rand erfragen (in logischen Einheiten)

*/

/*N*/ {
/*N*/ 	if(pColumnItem)
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(!IsActLastColumn( TRUE ))
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			long nRet = (*pColumnItem)[GetActRightColumn( TRUE )].nEnd;
//STRIP001 /*?*/ 			if(pColumnItem->IsTable() && pParaBorderItem)
//STRIP001 /*?*/ 				nRet -= pParaBorderItem->GetRight();
//STRIP001 /*?*/ 			return nRet;
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	long l = lLogicNullOffset;
/*N*/ 
/*N*/ 	// gfs. rechten Tabelleneinzug abziehen
/*N*/ 	if(pColumnItem && pColumnItem->IsTable())
/*?*/ 		l += pColumnItem->GetRight();
/*N*/     else if(bHorz && pLRSpaceItem)
/*N*/ 		l += pLRSpaceItem->GetRight();
/*N*/     else if(!bHorz && pULSpaceItem)
/*?*/         l += pULSpaceItem->GetLower();
/*N*/ 
/*N*/     if(pParaBorderItem &&
/*N*/         (!pColumnItem || pColumnItem->IsTable()||IsActLastColumn( TRUE )))
/*?*/         l += pParaBorderItem->GetRight();
/*N*/ 
/*N*/     if(bHorz)
/*N*/         l = pPagePosItem->GetWidth() - l;
/*N*/ 	else
/*?*/         l = pPagePosItem->GetHeight() - l;
/*N*/     return l;
/*N*/ }

#define NEG_FLAG ( (nFlags & SVXRULER_SUPPORT_NEGATIVE_MARGINS) == \
				   SVXRULER_SUPPORT_NEGATIVE_MARGINS )
#define TAB_FLAG ( pColumnItem && pColumnItem->IsTable() )

//STRIP001 long SvxRuler::GetCorrectedDragPos( BOOL bLeft, BOOL bRight )
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Korrigiert die Position innerhalb der errechneten Grenzwerte.
//STRIP001    Die Grenzwerte sind in Pixel relativ zum Seitenrand.
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const long lNullPix = Ruler::GetNullOffset();
//STRIP001 	long lDragPos = GetDragPos() + lNullPix;
//STRIP001 ADD_DEBUG_TEXT("lDragPos: ", String::CreateFromInt32(lDragPos))
//STRIP001  	if(bLeft && lDragPos < nMaxLeft)
//STRIP001 		lDragPos = nMaxLeft;
//STRIP001 	else if(bRight && lDragPos > nMaxRight)
//STRIP001 		lDragPos = nMaxRight;
//STRIP001 	return lDragPos - lNullPix;
//STRIP001 }



//STRIP001 void ModifyTabs_Impl
//STRIP001 (
//STRIP001  USHORT nCount,                                 // Anzahl Tabs
//STRIP001  RulerTab *pTabs,                               // Tab-Puffer
//STRIP001  long lDiff                                     // zu addierende Differenz
//STRIP001  )
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Hilfsroutine; alle Tabs um einen festen Wert verschieben
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	if( pTabs )
//STRIP001 		for(USHORT i = 0; i < nCount; ++i)	pTabs[i].nPos += lDiff;
//STRIP001 }



//STRIP001 void SvxRuler::DragMargin1()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Draggen des linken Frame-Randes
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	const long lDragPos = GetCorrectedDragPos( !TAB_FLAG || !NEG_FLAG, TRUE );
//STRIP001 	DrawLine_Impl(lTabPos, ( TAB_FLAG && NEG_FLAG ) ? 3 : 7, bHorz);
//STRIP001 	const long nOld = bAppSetNullOffset? GetMargin1(): GetNullOffset();
//STRIP001 	if(pColumnItem&&
//STRIP001 	   (//nDragType & DRAG_OBJECT_SIZE_LINEAR ||
//STRIP001 		nDragType & DRAG_OBJECT_SIZE_PROPORTIONAL))
//STRIP001 		DragBorders();
//STRIP001 
//STRIP001 	BOOL bProtectColumns =
//STRIP001 		pRuler_Imp->aProtectItem.IsSizeProtected() ||
//STRIP001 		pRuler_Imp->aProtectItem.IsPosProtected();
//STRIP001 
//STRIP001 	const USHORT nMarginStyle =
//STRIP001 		bProtectColumns ? 0 : RULER_MARGIN_SIZEABLE;
//STRIP001 
//STRIP001 	if(!bAppSetNullOffset)
//STRIP001 	{
//STRIP001 		long lDiff = lDragPos;
//STRIP001 		SetNullOffset(nOld + lDiff);
//STRIP001 		if(!pColumnItem||!(nDragType & DRAG_OBJECT_SIZE_LINEAR))
//STRIP001 		{
//STRIP001 			SetMargin2( GetMargin2() - lDiff, nMarginStyle );
//STRIP001 
//STRIP001 			if(!pColumnItem && !pObjectItem && pParaItem)
//STRIP001 			{
//STRIP001 				// Rechten Einzug an alter Position
//STRIP001                 pIndents[INDENT_RIGHT_MARGIN].nPos -= lDiff;
//STRIP001                 SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 			}
//STRIP001 			if(pObjectItem)
//STRIP001 			{
//STRIP001 				pObjectBorders[GetObjectBordersOff(0)].nPos -= lDiff;
//STRIP001 				pObjectBorders[GetObjectBordersOff(1)].nPos -= lDiff;
//STRIP001 				SetBorders(2, pObjectBorders + GetObjectBordersOff(0));
//STRIP001 			}
//STRIP001 			if(pColumnItem)
//STRIP001 			{
//STRIP001 				for(USHORT i = 0; i < pColumnItem->Count()-1; ++i)
//STRIP001 					pBorders[i].nPos -= lDiff;
//STRIP001 				SetBorders(pColumnItem->Count()-1, pBorders);
//STRIP001 				if(pColumnItem->IsFirstAct())
//STRIP001 				{
//STRIP001 					// Rechten Einzug an alter Position
//STRIP001 					if(pParaItem)
//STRIP001 					{
//STRIP001                         pIndents[INDENT_RIGHT_MARGIN].nPos -= lDiff;
//STRIP001                         SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if(pParaItem)
//STRIP001 					{
//STRIP001                         pIndents[INDENT_FIRST_LINE].nPos -= lDiff;
//STRIP001                         pIndents[INDENT_LEFT_MARGIN].nPos -= lDiff;
//STRIP001                         pIndents[INDENT_RIGHT_MARGIN].nPos -= lDiff;
//STRIP001                         SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if(pTabStopItem&& (nDragType & DRAG_OBJECT_SIZE_PROPORTIONAL)
//STRIP001 				   &&!IsActFirstColumn())
//STRIP001 				{
//STRIP001 					ModifyTabs_Impl(nTabCount+TAB_GAP, pTabs, -lDiff);
//STRIP001 					SetTabs(nTabCount, pTabs+TAB_GAP);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long lDiff = lDragPos - nOld;
//STRIP001 		SetMargin1(nOld + lDiff, nMarginStyle );
//STRIP001 
//STRIP001 		if(!pColumnItem||!(nDragType & (DRAG_OBJECT_SIZE_LINEAR |
//STRIP001 										DRAG_OBJECT_SIZE_PROPORTIONAL)))
//STRIP001 		{
//STRIP001 			if(!pColumnItem && !pObjectItem && pParaItem)
//STRIP001 			{
//STRIP001 				// Linke Einzuege an alter Position
//STRIP001                 pIndents[INDENT_FIRST_LINE].nPos += lDiff;
//STRIP001                 pIndents[INDENT_LEFT_MARGIN].nPos += lDiff;
//STRIP001                 SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 			}
//STRIP001 
//STRIP001 			if(pColumnItem)
//STRIP001 			{
//STRIP001 				for(USHORT i = 0; i < pColumnItem->Count()-1; ++i)
//STRIP001 					pBorders[i].nPos += lDiff;
//STRIP001 				SetBorders(pColumnItem->Count()-1, pBorders);
//STRIP001 				if(pColumnItem->IsFirstAct())
//STRIP001 				{
//STRIP001 					// Linke Einzuege an alter Position
//STRIP001 					if(pParaItem)
//STRIP001 					{
//STRIP001                         pIndents[INDENT_FIRST_LINE].nPos += lDiff;
//STRIP001                         pIndents[INDENT_LEFT_MARGIN].nPos += lDiff;
//STRIP001                         SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if(pParaItem)
//STRIP001 					{
//STRIP001                         pIndents[INDENT_FIRST_LINE].nPos += lDiff;
//STRIP001                         pIndents[INDENT_LEFT_MARGIN].nPos += lDiff;
//STRIP001                         pIndents[INDENT_RIGHT_MARGIN].nPos += lDiff;
//STRIP001                         SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if(pTabStopItem)
//STRIP001 			{
//STRIP001 				ModifyTabs_Impl(nTabCount+TAB_GAP, pTabs, lDiff);
//STRIP001 				SetTabs(nTabCount, pTabs+TAB_GAP);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxRuler::DragMargin2()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Draggen des rechten Frame-Randes
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	const long lDragPos = GetCorrectedDragPos( TRUE, !TAB_FLAG || !NEG_FLAG);
//STRIP001 	DrawLine_Impl(lTabPos, ( TAB_FLAG && NEG_FLAG ) ? 5 : 7, bHorz);
//STRIP001 	long lDiff = lDragPos - GetMargin2();
//STRIP001 
//STRIP001 	BOOL bProtectColumns =
//STRIP001 		pRuler_Imp->aProtectItem.IsSizeProtected() ||
//STRIP001 		pRuler_Imp->aProtectItem.IsPosProtected();
//STRIP001 	const USHORT nMarginStyle =
//STRIP001 		bProtectColumns ? 0 : RULER_MARGIN_SIZEABLE;
//STRIP001 	SetMargin2( lDragPos, nMarginStyle );
//STRIP001 
//STRIP001 	// Rechten Einzug an alter Position
//STRIP001 	if((!pColumnItem || IsActLastColumn()) && pParaItem)
//STRIP001 	{
//STRIP001         pIndents[INDENT_FIRST_LINE].nPos += lDiff;
//STRIP001         SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxRuler::DragIndents()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Draggen der Absatzeinzuege
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	const long lDragPos = NEG_FLAG ? GetDragPos() : GetCorrectedDragPos();
//STRIP001 	const USHORT nIdx = GetDragAryPos()+INDENT_GAP;
//STRIP001 	const long lDiff = pIndents[nIdx].nPos - lDragPos;
//STRIP001 
//STRIP001     BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 	if((nIdx == INDENT_FIRST_LINE ||
//STRIP001             nIdx == INDENT_LEFT_MARGIN )  &&
//STRIP001 		(nDragType & DRAG_OBJECT_LEFT_INDENT_ONLY) !=
//STRIP001         DRAG_OBJECT_LEFT_INDENT_ONLY)
//STRIP001         pIndents[INDENT_FIRST_LINE].nPos -= lDiff;
//STRIP001 
//STRIP001 	pIndents[nIdx].nPos = lDragPos;
//STRIP001 
//STRIP001     SetIndents(INDENT_COUNT, pIndents + INDENT_GAP);
//STRIP001 	DrawLine_Impl(lTabPos, 1, bHorz);
//STRIP001 }


//STRIP001 void SvxRuler::DrawLine_Impl(long &lTabPos, int nNew, BOOL Hori)
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Ausgaberoutine fuer Hilfslinie beim Vereschieben von Tabs, Tabellen-
//STRIP001    und anderen Spalten
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	if(Hori)
//STRIP001 	{
//STRIP001 		const long nHeight = pEditWin->GetOutputSize().Height();
//STRIP001 		Point aZero=pEditWin->GetMapMode().GetOrigin();
//STRIP001 		if(lTabPos!=-1)
//STRIP001 			pEditWin->InvertTracking(
//STRIP001 				Rectangle( Point(lTabPos, -aZero.Y()),
//STRIP001 						   Point(lTabPos, -aZero.Y()+nHeight)),
//STRIP001 				SHOWTRACK_SPLIT | SHOWTRACK_CLIP );
//STRIP001 		if( nNew & 1 )
//STRIP001 		{
//STRIP001 
//STRIP001 			lTabPos = ConvertHSizeLogic( GetCorrectedDragPos( nNew&4, nNew&2 )
//STRIP001 										 + GetNullOffset() );
//STRIP001 			if(pPagePosItem)
//STRIP001 				lTabPos += pPagePosItem->GetPos().X();
//STRIP001 			pEditWin->InvertTracking(
//STRIP001 				Rectangle(Point(lTabPos, -aZero.Y()),
//STRIP001 						  Point(lTabPos, -aZero.Y()+nHeight)),
//STRIP001 				SHOWTRACK_CLIP | SHOWTRACK_SPLIT );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const long nWidth = pEditWin->GetOutputSize().Width();
//STRIP001 		Point aZero=pEditWin->GetMapMode().GetOrigin();
//STRIP001 		if(lTabPos != -1)
//STRIP001 		{
//STRIP001 			pEditWin->InvertTracking(
//STRIP001 				Rectangle( Point(-aZero.X(), lTabPos),
//STRIP001 						   Point(-aZero.X()+nWidth, lTabPos)),
//STRIP001 				SHOWTRACK_SPLIT | SHOWTRACK_CLIP );
//STRIP001 		}
//STRIP001 
//STRIP001 		if(nNew & 1)
//STRIP001 		{
//STRIP001 			lTabPos = ConvertVSizeLogic(GetCorrectedDragPos()+GetNullOffset());
//STRIP001 			if(pPagePosItem)
//STRIP001 				lTabPos += pPagePosItem->GetPos().Y();
//STRIP001 			pEditWin->InvertTracking(
//STRIP001 				Rectangle( Point(-aZero.X(), lTabPos),
//STRIP001 						   Point(-aZero.X()+nWidth, lTabPos)),
//STRIP001 				SHOWTRACK_CLIP | SHOWTRACK_SPLIT );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }




//STRIP001 void SvxRuler::DragTabs()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Draggen von Tabs
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 
//STRIP001     BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 	long lDragPos = GetCorrectedDragPos();
//STRIP001 
//STRIP001 	USHORT nIdx = GetDragAryPos()+TAB_GAP;
//STRIP001 	DrawLine_Impl(lTabPos, 7, bHorz);
//STRIP001 
//STRIP001 	long nDiff = lDragPos - pTabs[nIdx].nPos;
//STRIP001 
//STRIP001 	if(nDragType & DRAG_OBJECT_SIZE_LINEAR)
//STRIP001 	{
//STRIP001 
//STRIP001 		for(USHORT i = nIdx; i < nTabCount; ++i)
//STRIP001 		{
//STRIP001 			pTabs[i].nPos += nDiff;
//STRIP001 			// auf Maximum begrenzen
//STRIP001 			if(pTabs[i].nPos > GetMargin2())
//STRIP001 				pTabs[nIdx].nStyle |= RULER_STYLE_INVISIBLE;
//STRIP001 			else
//STRIP001 				pTabs[nIdx].nStyle &= ~RULER_STYLE_INVISIBLE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if(nDragType & DRAG_OBJECT_SIZE_PROPORTIONAL)
//STRIP001 	{
//STRIP001 		pRuler_Imp->nTotalDist -= nDiff;
//STRIP001 		pTabs[nIdx].nPos = lDragPos;
//STRIP001 		for(USHORT i = nIdx+1; i < nTabCount; ++i)
//STRIP001 		{
//STRIP001 			if(pTabs[i].nStyle & RULER_TAB_DEFAULT)
//STRIP001 				// bei den DefaultTabs kann abgebrochen werden
//STRIP001 				break;
//STRIP001 			long nDelta = pRuler_Imp->nTotalDist * pRuler_Imp->pPercBuf[i];
//STRIP001 			nDelta /= 1000;
//STRIP001 			pTabs[i].nPos = pTabs[nIdx].nPos + nDelta;
//STRIP001 			if(pTabs[i].nPos+GetNullOffset() > nMaxRight)
//STRIP001 				pTabs[i].nStyle |= RULER_STYLE_INVISIBLE;
//STRIP001 			else
//STRIP001 				pTabs[i].nStyle &= ~RULER_STYLE_INVISIBLE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pTabs[nIdx].nPos = lDragPos;
//STRIP001 
//STRIP001 	if(IsDragDelete())
//STRIP001 		pTabs[nIdx].nStyle |= RULER_STYLE_INVISIBLE;
//STRIP001 	else
//STRIP001 		pTabs[nIdx].nStyle &= ~RULER_STYLE_INVISIBLE;
//STRIP001 	SetTabs(nTabCount, pTabs+TAB_GAP);
//STRIP001 }



/*N*/ void SvxRuler::SetActive(BOOL bOn)
/*N*/ {
/*N*/ 	if(bOn)
/*N*/ 	{
/*N*/ 		Activate();
/*		pBindings->Invalidate( SID_RULER_LR_MIN_MAX, TRUE, TRUE );
		pBindings->Update( SID_RULER_LR_MIN_MAX );
		pBindings->Invalidate( SID_ATTR_LONG_ULSPACE, TRUE, TRUE );
		pBindings->Update( SID_ATTR_LONG_ULSPACE );
		pBindings->Invalidate( SID_ATTR_LONG_LRSPACE, TRUE, TRUE );
		pBindings->Update( SID_ATTR_LONG_LRSPACE );
		pBindings->Invalidate( SID_RULER_PAGE_POS, TRUE, TRUE );
		pBindings->Update( SID_RULER_PAGE_POS );
		pBindings->Invalidate( SID_ATTR_TABSTOP, TRUE, TRUE );
		pBindings->Update( SID_ATTR_TABSTOP );
		pBindings->Invalidate( SID_ATTR_PARA_LRSPACE, TRUE, TRUE );
		pBindings->Update( SID_ATTR_PARA_LRSPACE );
		pBindings->Invalidate( SID_RULER_BORDERS, TRUE, TRUE );
		pBindings->Update( SID_RULER_BORDERS );
		pBindings->Invalidate( SID_RULER_OBJECT, TRUE, TRUE );
		pBindings->Update( SID_RULER_OBJECT );
		pBindings->Invalidate( SID_RULER_PROTECT, TRUE, TRUE );
		pBindings->Update( SID_RULER_PROTECT );*/
/*N*/ 	}
/*N*/ 	else
/*N*/ 		Deactivate();
/*N*/ 	if(bActive!=bOn)
/*N*/ 	{
/*N*/ 		pBindings->EnterRegistrations();
/*N*/ 		if(bOn)
/*N*/ 			for(USHORT i=0;i<pRuler_Imp->nControlerItems;i++)
/*N*/ 				pCtrlItem[i]->ReBind();
/*N*/ 		else
/*N*/ 			for(USHORT j=0;j<pRuler_Imp->nControlerItems;j++)
/*N*/ 				pCtrlItem[j]->UnBind();
/*N*/ 		pBindings->LeaveRegistrations();
/*N*/ 	}
/*N*/ 	bActive = bOn;
/*N*/ }




//STRIP001 void SvxRuler::UpdateParaContents_Impl
//STRIP001 (
//STRIP001  long l,                                                // Differenz
//STRIP001  UpdateType eType                               // Art (alle, links oder rechts)
//STRIP001 )
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Hilfsroutine; Mitfuehren von Tabulatoren und Absatzraendern
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	switch(eType) {
//STRIP001 	case MOVE_RIGHT:
//STRIP001         pIndents[INDENT_RIGHT_MARGIN].nPos += l;
//STRIP001 		break;
//STRIP001 	case MOVE_ALL:
//STRIP001         pIndents[INDENT_RIGHT_MARGIN].nPos += l;
//STRIP001 		// no break
//STRIP001 	case MOVE_LEFT:
//STRIP001 		{
//STRIP001             pIndents[INDENT_FIRST_LINE].nPos += l;
//STRIP001             pIndents[INDENT_LEFT_MARGIN].nPos += l;
//STRIP001 			if ( pTabs )
//STRIP001 			{
//STRIP001 				for(USHORT i = 0; i < nTabCount+TAB_GAP;++i)
//STRIP001 					pTabs[i].nPos += l;
//STRIP001 				SetTabs(nTabCount, pTabs+TAB_GAP);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001     SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 }



//STRIP001 void SvxRuler::DragBorders()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Draggen von Borders (Tabellen- und anderen Spalten)
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	BOOL bLeftIndentsCorrected = FALSE, bRightIndentsCorrected = FALSE;
//STRIP001 	int nIdx;
//STRIP001 
//STRIP001 	if(GetDragType()==RULER_TYPE_BORDER)
//STRIP001 	{
//STRIP001 		DrawLine_Impl(lTabPos, 7, bHorz);
//STRIP001 		nIdx = GetDragAryPos();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nIdx=0;
//STRIP001 
//STRIP001 	USHORT nDragSize = GetDragSize();
//STRIP001 	long lDiff = 0;
//STRIP001 
//STRIP001 	USHORT nRightCol = GetActRightColumn( FALSE, nIdx );
//STRIP001 	USHORT nLeftCol = GetActLeftColumn( FALSE, nIdx );
//STRIP001 	// the drag position has to be corrected to be able to prevent borders from passing each other
//STRIP001 	long lPos = GetCorrectedDragPos();
//STRIP001 
//STRIP001 
//STRIP001 	switch(nDragSize)
//STRIP001 	{
//STRIP001 	  case RULER_DRAGSIZE_MOVE:
//STRIP001 		{
//STRIP001 ADD_DEBUG_TEXT("lLastLMargin: ", String::CreateFromInt32(pRuler_Imp->lLastLMargin))
//STRIP001             lDiff=GetDragType()==RULER_TYPE_BORDER ?
//STRIP001 				lPos-nDragOffset - pBorders[nIdx].nPos
//STRIP001 				: lPos - pRuler_Imp->lLastLMargin;
//STRIP001 
//STRIP001 //			pBorders[nIdx].nPos += lDiff;
//STRIP001 //			lDiff = pBorders[nIdx].nPos - nOld;
//STRIP001 			if(nDragType & DRAG_OBJECT_SIZE_LINEAR)
//STRIP001 			{
//STRIP001 				long nRight = GetMargin2()-lMinFrame; // rechter Begrenzer
//STRIP001 				for(int i = nBorderCount-2; i >= nIdx; --i)
//STRIP001 				{
//STRIP001 					long l = pBorders[i].nPos;
//STRIP001 					pBorders[i].nPos += lDiff;
//STRIP001 					pBorders[i].nPos = Min(pBorders[i].nPos, nRight - pBorders[i].nWidth);
//STRIP001 					nRight = pBorders[i].nPos - lMinFrame;
//STRIP001 					// RR der Spalte aktualisieren
//STRIP001 					if(i == GetActRightColumn())
//STRIP001 					{
//STRIP001 						UpdateParaContents_Impl(pBorders[i].nPos - l, MOVE_RIGHT);
//STRIP001 						bRightIndentsCorrected = TRUE;
//STRIP001 					}
//STRIP001 					// LAR, EZE der Spalte aktualisieren
//STRIP001 					else if(i == GetActLeftColumn())
//STRIP001 					{
//STRIP001 						UpdateParaContents_Impl(pBorders[i].nPos - l, MOVE_LEFT);
//STRIP001 						bLeftIndentsCorrected = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if(nDragType & DRAG_OBJECT_SIZE_PROPORTIONAL)
//STRIP001 			{
//STRIP001 				int nLimit;
//STRIP001 				long lLeft;
//STRIP001 				if(GetDragType()==RULER_TYPE_BORDER)
//STRIP001 				{
//STRIP001 					nLimit=nIdx+1;
//STRIP001 					lLeft=(pBorders[nIdx].nPos+=lDiff);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nLimit=0;
//STRIP001 					lLeft=pRuler_Imp->lLastLMargin+lDiff;
//STRIP001 				}
//STRIP001 
//STRIP001 ADD_DEBUG_TEXT("lDiff: ", String::CreateFromInt32(lDiff))
//STRIP001 				pRuler_Imp->nTotalDist-=lDiff;
//STRIP001 ADD_DEBUG_TEXT("nTotalDist: ", String::CreateFromInt32(pRuler_Imp->nTotalDist))
//STRIP001 				for(int i  = nBorderCount-2; i >= nLimit; --i)
//STRIP001 				{
//STRIP001 
//STRIP001 					long l = pBorders[i].nPos;
//STRIP001 					pBorders[i].nPos=lLeft+
//STRIP001 						(pRuler_Imp->nTotalDist*pRuler_Imp->pPercBuf[i])/1000+
//STRIP001 							pRuler_Imp->pBlockBuf[i];
//STRIP001 
//STRIP001 					// RR der Spalte aktualisieren
//STRIP001 					if(i == GetActRightColumn())
//STRIP001 					{
//STRIP001 						UpdateParaContents_Impl(pBorders[i].nPos - l, MOVE_RIGHT);
//STRIP001 						bRightIndentsCorrected = TRUE;
//STRIP001 					}
//STRIP001 					// LAR, EZE der Spalte aktualisieren
//STRIP001 					else if(i == GetActLeftColumn())
//STRIP001 					{
//STRIP001 						UpdateParaContents_Impl(pBorders[i].nPos - l, MOVE_LEFT);
//STRIP001 						bLeftIndentsCorrected = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pBorders[nIdx].nPos+=lDiff;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	  case RULER_DRAGSIZE_1:
//STRIP001 		{
//STRIP001 			lDiff = lPos - pBorders[nIdx].nPos;
//STRIP001 			pBorders[nIdx].nWidth += pBorders[nIdx].nPos - lPos;
//STRIP001 			pBorders[nIdx].nPos = lPos;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	  case RULER_DRAGSIZE_2:
//STRIP001 		{
//STRIP001 			const long nOld = pBorders[nIdx].nWidth;
//STRIP001 			pBorders[nIdx].nWidth = lPos - pBorders[nIdx].nPos;
//STRIP001 			lDiff = pBorders[nIdx].nWidth - nOld;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if(!bRightIndentsCorrected &&
//STRIP001 	   GetActRightColumn() == nIdx &&
//STRIP001 	   nDragSize != RULER_DRAGSIZE_2 && pIndents)
//STRIP001 	{
//STRIP001 		UpdateParaContents_Impl(lDiff, MOVE_RIGHT);
//STRIP001 	}
//STRIP001 	else if(!bLeftIndentsCorrected &&
//STRIP001 			GetActLeftColumn()==nIdx &&
//STRIP001 			nDragSize != RULER_DRAGSIZE_1 && pIndents)
//STRIP001 	{
//STRIP001 		UpdateParaContents_Impl(lDiff, MOVE_LEFT);
//STRIP001 	}
//STRIP001 	SetBorders(pColumnItem->Count()-1, pBorders);
//STRIP001 }


//STRIP001 void SvxRuler::DragObjectBorder()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Draggen von Objektraendern
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	if(RULER_DRAGSIZE_MOVE == GetDragSize())
//STRIP001 	{
//STRIP001 		const long lPos = GetCorrectedDragPos();
//STRIP001 		const USHORT nIdx = GetDragAryPos();
//STRIP001 		pObjectBorders[GetObjectBordersOff(nIdx)].nPos = lPos;
//STRIP001 		SetBorders(2, pObjectBorders + GetObjectBordersOff(0));
//STRIP001 		DrawLine_Impl(lTabPos, 7, bHorz);
//STRIP001 
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxRuler::ApplyMargins()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Anwenden von Randeinstellungen; durch Draggen veraendert.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	const SfxPoolItem *pItem = 0;
//STRIP001 	USHORT nId = SID_ATTR_LONG_LRSPACE;
//STRIP001 	if(bHorz)
//STRIP001 	{
//STRIP001 		const long lOldNull = lLogicNullOffset;
//STRIP001 		if(pRuler_Imp->lMaxLeftLogic!=-1&&nMaxLeft==GetMargin1()+Ruler::GetNullOffset())
//STRIP001 			pLRSpaceItem->SetLeft(lLogicNullOffset=pRuler_Imp->lMaxLeftLogic);
//STRIP001 		else
//STRIP001 			pLRSpaceItem->SetLeft(PixelHAdjust(
//STRIP001 				lLogicNullOffset =	ConvertHPosLogic(GetFrameLeft()) -
//STRIP001 				lAppNullOffset,	pLRSpaceItem->GetLeft()));
//STRIP001 
//STRIP001 		if(bAppSetNullOffset)
//STRIP001 			lAppNullOffset += lLogicNullOffset - lOldNull;
//STRIP001 
//STRIP001 		if(pRuler_Imp->lMaxRightLogic!=-1
//STRIP001 		   &&nMaxRight==GetMargin2()+Ruler::GetNullOffset())
//STRIP001 			pLRSpaceItem->SetRight(GetPageWidth()-pRuler_Imp->lMaxRightLogic);
//STRIP001 		else
//STRIP001 			pLRSpaceItem->SetRight(
//STRIP001 				PixelHAdjust(
//STRIP001 					Max((long)0,pPagePosItem->GetWidth() -
//STRIP001 						pLRSpaceItem->GetLeft() -
//STRIP001 						(ConvertHPosLogic(GetMargin2()) -
//STRIP001 						 lAppNullOffset)),pLRSpaceItem->GetRight()));
//STRIP001 		pItem = pLRSpaceItem;
//STRIP001 #ifdef DEBUGLIN
//STRIP001 		Debug_Impl(pEditWin,*pLRSpaceItem);
//STRIP001 #endif // DEBUGLIN
//STRIP001 	}
//STRIP001 	else {
//STRIP001 		const long lOldNull = lLogicNullOffset;
//STRIP001 		pULSpaceItem->SetUpper(
//STRIP001 			PixelVAdjust(
//STRIP001 				lLogicNullOffset =
//STRIP001 				ConvertVPosLogic(GetFrameLeft()) -
//STRIP001 				lAppNullOffset,pULSpaceItem->GetUpper()));
//STRIP001 		if(bAppSetNullOffset)
//STRIP001 			lAppNullOffset += lLogicNullOffset - lOldNull;
//STRIP001 		pULSpaceItem->SetLower(
//STRIP001 			PixelVAdjust(
//STRIP001 				Max((long)0, pPagePosItem->GetHeight() -
//STRIP001 					pULSpaceItem->GetUpper() -
//STRIP001 					(ConvertVPosLogic(GetMargin2()) -
//STRIP001 					 lAppNullOffset)),pULSpaceItem->GetLower()));
//STRIP001 		pItem = pULSpaceItem;
//STRIP001 		nId = SID_ATTR_LONG_ULSPACE;
//STRIP001 #ifdef DEBUGLIN
//STRIP001 		Debug_Impl(pEditWin,*pULSpaceItem);
//STRIP001 #endif // DEBUGLIN
//STRIP001 	}
//STRIP001 	pBindings->GetDispatcher()->Execute( nId, SFX_CALLMODE_RECORD, pItem, 0L );
//STRIP001 	if(pTabStopItem)
//STRIP001 		UpdateTabs();
//STRIP001 }


//STRIP001 void SvxRuler::ApplyIndents()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Anwenden von Absatzeinstellungen; durch Draggen veraendert.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	long nNewTxtLeft;
//STRIP001 	if(pColumnItem&&!IsActFirstColumn( TRUE ))
//STRIP001 	{
//STRIP001 		long nLeftCol=GetActLeftColumn( TRUE );
//STRIP001 		nNewTxtLeft =
//STRIP001 			PixelHAdjust(
//STRIP001 				ConvertHPosLogic(
//STRIP001                     pIndents[INDENT_LEFT_MARGIN].nPos-
//STRIP001 					(pBorders[nLeftCol].nPos +
//STRIP001 					 pBorders[nLeftCol].nWidth))-
//STRIP001 				lAppNullOffset,pParaItem->GetTxtLeft());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nNewTxtLeft =
//STRIP001 			PixelHAdjust(
//STRIP001                 ConvertHPosLogic(pIndents[INDENT_LEFT_MARGIN].nPos),
//STRIP001 				pParaItem->GetTxtLeft());
//STRIP001 
//STRIP001     BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 
//STRIP001 	long nNewFirstLineOffset;
//STRIP001 	if(bRTL)
//STRIP001 	{
//STRIP001 		long nRightFrameMargin = GetRightFrameMargin();
//STRIP001 		nNewFirstLineOffset = 	PixelHAdjust(nRightFrameMargin -
//STRIP001 				ConvertHPosLogic(pIndents[INDENT_FIRST_LINE].nPos ) -
//STRIP001 				lAppNullOffset,
//STRIP001 				pParaItem->GetTxtFirstLineOfst());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nNewFirstLineOffset=
//STRIP001 			PixelHAdjust(
//STRIP001 				ConvertHPosLogic(pIndents[INDENT_FIRST_LINE].nPos -
//STRIP001                              pIndents[INDENT_LEFT_MARGIN].nPos) -
//STRIP001 				lAppNullOffset,
//STRIP001 				pParaItem->GetTxtFirstLineOfst());
//STRIP001 
//STRIP001 	// #62986# : Ist der neue TxtLeft kleiner als der alte FirstLineIndent,
//STRIP001     // dann geht die Differenz verloren und der Absatz wird insgesamt
//STRIP001 	// zu weit eingerueckt, deswegen erst den FirstLineOffset setzen, dann den TxtLeft
//STRIP001 	if(bRTL)
//STRIP001 	{
//STRIP001         long nLeftFrameMargin = GetLeftFrameMargin();
//STRIP001         long nRightFrameMargin = GetRightFrameMargin();
//STRIP001 		nNewTxtLeft = nRightFrameMargin - nNewTxtLeft - nLeftFrameMargin;
//STRIP001 		nNewFirstLineOffset -= nNewTxtLeft;
//STRIP001 		if(pParaBorderItem)
//STRIP001 		{
//STRIP001 			nNewTxtLeft += pParaBorderItem->GetLeft() + pParaBorderItem->GetRight();
//STRIP001 			nNewFirstLineOffset -= pParaBorderItem->GetRight();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	pParaItem->SetTxtFirstLineOfst(nNewFirstLineOffset);
//STRIP001 	pParaItem->SetTxtLeft(nNewTxtLeft);
//STRIP001 
//STRIP001 	if(pColumnItem && ((!bRTL && !IsActLastColumn( TRUE ))|| (bRTL && !IsActFirstColumn())))
//STRIP001 	{
//STRIP001 		if(bRTL)
//STRIP001 		{
//STRIP001 			long nActBorder = pBorders[GetActLeftColumn( TRUE )].nPos;
//STRIP001 			long nRightMargin = pIndents[INDENT_RIGHT_MARGIN].nPos;
//STRIP001 			long nConvert = ConvertHPosLogic( nRightMargin - nActBorder );
//STRIP001 			pParaItem->SetRight( PixelHAdjust( nConvert - lAppNullOffset, pParaItem->GetRight() ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pParaItem->SetRight(
//STRIP001 				PixelHAdjust(
//STRIP001 					ConvertHPosLogic(
//STRIP001 						pBorders[GetActRightColumn( TRUE )].nPos -
//STRIP001 						pIndents[INDENT_RIGHT_MARGIN].nPos) -
//STRIP001 					lAppNullOffset,
//STRIP001 					pParaItem->GetRight()));
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if(bRTL)
//STRIP001 		{
//STRIP001 			pParaItem->SetRight( PixelHAdjust(
//STRIP001 				ConvertHPosLogic(GetMargin1() +
//STRIP001                              pIndents[INDENT_RIGHT_MARGIN].nPos) - GetLeftFrameMargin() +
//STRIP001 							 (pParaBorderItem ? pParaBorderItem->GetLeft() : 0) - 
//STRIP001 				lAppNullOffset,	pParaItem->GetRight()));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pParaItem->SetRight( PixelHAdjust(
//STRIP001 				ConvertHPosLogic(GetMargin2() -
//STRIP001                              pIndents[INDENT_RIGHT_MARGIN].nPos) -
//STRIP001 				lAppNullOffset,	pParaItem->GetRight()));
//STRIP001 		}
//STRIP001 	}
//STRIP001     USHORT nParaId  = bHorz ? SID_ATTR_PARA_LRSPACE : SID_ATTR_PARA_LRSPACE_VERTICAL;
//STRIP001     pBindings->GetDispatcher()->Execute( nParaId, SFX_CALLMODE_RECORD, pParaItem, 0L );
//STRIP001 	UpdateTabs();
//STRIP001 }


//STRIP001 void SvxRuler::ApplyTabs()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Anwenden von Tabulatoreinstellungen; durch Draggen veraendert.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 	const USHORT nCoreIdx = GetDragAryPos();
//STRIP001 	if(IsDragDelete())
//STRIP001 	{
//STRIP001 		pTabStopItem->Remove(nCoreIdx);
//STRIP001 	}
//STRIP001 	else if(DRAG_OBJECT_SIZE_LINEAR & nDragType ||
//STRIP001 			DRAG_OBJECT_SIZE_PROPORTIONAL & nDragType)
//STRIP001 	{
//STRIP001 		SvxTabStopItem *pItem = new SvxTabStopItem(pTabStopItem->Which());
//STRIP001 		USHORT i;
//STRIP001 		for(i = 0; i < nCoreIdx; ++i)
//STRIP001 		{
//STRIP001 			pItem->Insert((*pTabStopItem)[i]);
//STRIP001 		}
//STRIP001 		for(; i < pTabStopItem->Count(); ++i)
//STRIP001 		{
//STRIP001 			SvxTabStop aTabStop = (*pTabStopItem)[i];
//STRIP001 			aTabStop.GetTabPos() = PixelHAdjust(
//STRIP001 				ConvertHPosLogic(pTabs[i+TAB_GAP].nPos -
//STRIP001 								 GetLeftIndent()) -
//STRIP001 				lAppNullOffset,
//STRIP001 				aTabStop.GetTabPos());
//STRIP001 			pItem->Insert(aTabStop);
//STRIP001 		}
//STRIP001 		delete pTabStopItem;
//STRIP001 		pTabStopItem = pItem;
//STRIP001 	}
//STRIP001 	else if( pTabStopItem->Count() == 0 )
//STRIP001 		return;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SvxTabStop aTabStop = (*pTabStopItem)[nCoreIdx];
//STRIP001 		if(pRuler_Imp->lMaxRightLogic!=-1&&
//STRIP001 		   pTabs[nCoreIdx+TAB_GAP].nPos+Ruler::GetNullOffset()==nMaxRight)
//STRIP001 			aTabStop.GetTabPos() = pRuler_Imp->lMaxRightLogic-lLogicNullOffset;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if(bRTL)
//STRIP001 				aTabStop.GetTabPos() = PixelHAdjust(
//STRIP001 					ConvertHPosLogic(GetLeftIndent() - pTabs[nCoreIdx+TAB_GAP].nPos) - lAppNullOffset,
//STRIP001 																						aTabStop.GetTabPos());
//STRIP001 			else
//STRIP001 				aTabStop.GetTabPos() = PixelHAdjust(
//STRIP001 					ConvertHPosLogic(pTabs[nCoreIdx+TAB_GAP].nPos - GetLeftIndent()) - lAppNullOffset, aTabStop.GetTabPos());
//STRIP001 		}
//STRIP001 		pTabStopItem->Remove(nCoreIdx);
//STRIP001 		pTabStopItem->Insert(aTabStop);
//STRIP001 	}
//STRIP001     USHORT nTabStopId = bHorz ? SID_ATTR_TABSTOP : SID_ATTR_TABSTOP_VERTICAL;
//STRIP001     pBindings->GetDispatcher()->Execute( nTabStopId, SFX_CALLMODE_RECORD, pTabStopItem, 0L );
//STRIP001 	UpdateTabs();
//STRIP001 }


//STRIP001 void SvxRuler::ApplyBorders()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Anwenden von (Tabellen-)Spalteneinstellungen; durch Draggen veraendert.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	if(pColumnItem->IsTable())
//STRIP001 	{
//STRIP001 		long l = GetFrameLeft();
//STRIP001 		if(l != pRuler_Imp->nColLeftPix)
//STRIP001 			pColumnItem->SetLeft( PixelHAdjust(
//STRIP001 				ConvertHPosLogic(l) - lAppNullOffset, pColumnItem->GetLeft()));
//STRIP001 		l = GetMargin2();
//STRIP001 		if(l != pRuler_Imp->nColRightPix)
//STRIP001 			pColumnItem->SetRight( PixelHAdjust( pPagePosItem->GetWidth() -
//STRIP001 					pColumnItem->GetLeft() - ConvertHPosLogic(l) -
//STRIP001 					lAppNullOffset, pColumnItem->GetRight() ) );
//STRIP001 	}
//STRIP001 	for(USHORT i = 0; i < pColumnItem->Count()-1; ++i)
//STRIP001 	{
//STRIP001 		USHORT& nEnd = (*pColumnItem)[i].nEnd;
//STRIP001 		nEnd = PIXEL_H_ADJUST(
//STRIP001 			ConvertPosLogic(pBorders[i].nPos),
//STRIP001 			(*pColumnItem)[i].nEnd);
//STRIP001 		USHORT& nStart = (*pColumnItem)[i+1].nStart;
//STRIP001 		nStart = PIXEL_H_ADJUST(
//STRIP001 			ConvertSizeLogic(pBorders[i].nPos +
//STRIP001 							 pBorders[i].nWidth) -
//STRIP001 			lAppNullOffset,
//STRIP001 			(*pColumnItem)[i+1].nStart);
//STRIP001 		// Es kann sein, dass aufgrund der PIXEL_H_ADJUST rejustierung auf
//STRIP001 		// alte Werte die Breite < 0 wird. Das rerejustieren wir.
//STRIP001 		if( nEnd > nStart ) nStart = nEnd;
//STRIP001 	}
//STRIP001 #ifdef DEBUGLIN
//STRIP001 		Debug_Impl(pEditWin,*pColumnItem);
//STRIP001 #endif // DEBUGLIN
//STRIP001 	SfxBoolItem aFlag(SID_RULER_ACT_LINE_ONLY,
//STRIP001 					  nDragType & DRAG_OBJECT_ACTLINE_ONLY? TRUE: FALSE);
//STRIP001     USHORT nColId = bHorz ? SID_RULER_BORDERS : SID_RULER_BORDERS_VERTICAL;
//STRIP001     pBindings->GetDispatcher()->Execute( nColId, SFX_CALLMODE_RECORD, pColumnItem, &aFlag, 0L );
//STRIP001 }

//STRIP001 void SvxRuler::ApplyObject()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Anwenden von Objekteinstellungen; durch Draggen veraendert.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 		// zum Seitenrand
//STRIP001 	long nMargin = pLRSpaceItem? pLRSpaceItem->GetLeft(): 0;
//STRIP001 	pObjectItem->SetStartX(
//STRIP001 						   PixelAdjust(
//STRIP001 							  ConvertPosLogic(pObjectBorders[0].nPos)
//STRIP001 							  + nMargin - lAppNullOffset,pObjectItem->GetStartX()));
//STRIP001 	pObjectItem->SetEndX(
//STRIP001 						 PixelAdjust(
//STRIP001 							 ConvertPosLogic(pObjectBorders[1].nPos)
//STRIP001 						 + nMargin -  lAppNullOffset,pObjectItem->GetEndX()));
//STRIP001 	nMargin = pULSpaceItem? pULSpaceItem->GetUpper(): 0;
//STRIP001 	pObjectItem->SetStartY(
//STRIP001 						 PixelAdjust(
//STRIP001 							 ConvertPosLogic(pObjectBorders[2].nPos)
//STRIP001 						   + nMargin - lAppNullOffset,pObjectItem->GetStartY()));
//STRIP001 	pObjectItem->SetEndY(
//STRIP001 					 PixelAdjust(
//STRIP001 						 ConvertPosLogic(pObjectBorders[3].nPos)
//STRIP001 						 + nMargin - lAppNullOffset,pObjectItem->GetEndY()));
//STRIP001 	pBindings->GetDispatcher()->Execute( SID_RULER_OBJECT, SFX_CALLMODE_RECORD, pObjectItem, 0L );
//STRIP001 }

//STRIP001 void SvxRuler::PrepareProportional_Impl(RulerType eType)
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Vorbereitung proportionales Draggen; es wird der proportionale
//STRIP001    Anteil bezogen auf die Gesamtbreite in Promille berechnet.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	pRuler_Imp->nTotalDist = GetMargin2();
//STRIP001 	switch((int)eType)
//STRIP001 	{
//STRIP001 	  case RULER_TYPE_MARGIN1:
//STRIP001 	  case RULER_TYPE_BORDER:
//STRIP001 		{
//STRIP001 			DBG_ASSERT(pColumnItem, "kein ColumnItem");
//STRIP001 
//STRIP001 			pRuler_Imp->SetPercSize(nBorderCount);
//STRIP001 
//STRIP001 			long lPos;
//STRIP001 			long lWidth=0;
//STRIP001 			USHORT nStart;
//STRIP001 			USHORT nIdx=GetDragAryPos();
//STRIP001 			lWidth=0;
//STRIP001 			long lActWidth=0;
//STRIP001 			long lActBorderSum;
//STRIP001 			long lOrigLPos;
//STRIP001 
//STRIP001 			if(eType==RULER_TYPE_MARGIN1)
//STRIP001 			{
//STRIP001 				lOrigLPos=GetMargin1();
//STRIP001 				nStart=0;
//STRIP001 				lActBorderSum=0;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				lOrigLPos=pBorders[nIdx].nPos+pBorders[nIdx].nWidth;
//STRIP001 				nStart=1;
//STRIP001 				lActBorderSum=pBorders[nIdx].nWidth;
//STRIP001 			}
//STRIP001 
//STRIP001 			lPos=lOrigLPos;
//STRIP001 			for(USHORT ii = nStart; ii < nBorderCount-1; ++ii)
//STRIP001 			{
//STRIP001 				lWidth+=pBorders[ii].nPos-lPos;
//STRIP001 				lPos=pBorders[ii].nPos+pBorders[ii].nWidth;
//STRIP001 			}
//STRIP001 
//STRIP001 			lWidth+=GetMargin2()-lPos;
//STRIP001 			pRuler_Imp->nTotalDist=lWidth;
//STRIP001 			lPos=lOrigLPos;
//STRIP001 
//STRIP001 			for(USHORT i = nStart; i < nBorderCount-1; ++i)
//STRIP001 			{
//STRIP001 				lActWidth+=pBorders[i].nPos-lPos;
//STRIP001 				lPos=pBorders[i].nPos+pBorders[i].nWidth;
//STRIP001 				pRuler_Imp->pPercBuf[i] = (USHORT)((lActWidth * 1000)
//STRIP001 												   / pRuler_Imp->nTotalDist);
//STRIP001 				pRuler_Imp->pBlockBuf[i]=(USHORT)lActBorderSum;
//STRIP001 				lActBorderSum+=pBorders[i].nWidth;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	  case RULER_TYPE_TAB:
//STRIP001 		{
//STRIP001 			const USHORT nIdx = GetDragAryPos()+TAB_GAP;
//STRIP001 			pRuler_Imp->nTotalDist -= pTabs[nIdx].nPos;
//STRIP001 			pRuler_Imp->SetPercSize(nTabCount);
//STRIP001 			for(USHORT n=0;n<=nIdx;pRuler_Imp->pPercBuf[n++]=0);
//STRIP001 			for(USHORT i = nIdx+1; i < nTabCount; ++i)
//STRIP001 			{
//STRIP001 				const long nDelta = pTabs[i].nPos - pTabs[nIdx].nPos;
//STRIP001 				pRuler_Imp->pPercBuf[i] = (USHORT)((nDelta * 1000) / pRuler_Imp->nTotalDist);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxRuler::EvalModifier()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Modifier Draggen auswerten
//STRIP001 
//STRIP001    Shift: Linear verschieben
//STRIP001    Control: Proportional verschieben
//STRIP001    Shift+Control: Tabelle: nur aktuelle Zeile
//STRIP001    alt: Bemassungspfeile (n.i.) //!!
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	switch(GetDragModifier()) {
//STRIP001 	 case KEY_SHIFT:
//STRIP001 		nDragType = DRAG_OBJECT_SIZE_LINEAR;
//STRIP001 		break;
//STRIP001 	 case KEY_MOD1:  {
//STRIP001 		 const RulerType eType = GetDragType();
//STRIP001 		 nDragType = DRAG_OBJECT_SIZE_PROPORTIONAL;
//STRIP001 		 if(RULER_TYPE_BORDER == eType || RULER_TYPE_TAB == eType||
//STRIP001 			RULER_TYPE_MARGIN1&&pColumnItem)
//STRIP001 			 PrepareProportional_Impl(eType);
//STRIP001 		 break;
//STRIP001 	 }
//STRIP001 	 case KEY_MOD1 | KEY_SHIFT:
//STRIP001 		if(GetDragType()!=RULER_TYPE_MARGIN1&&
//STRIP001 		   GetDragType()!=RULER_TYPE_MARGIN2)
//STRIP001 			nDragType = DRAG_OBJECT_ACTLINE_ONLY;
//STRIP001 		break;
//STRIP001 		// alt: Bemassungspfeile
//STRIP001 	}
//STRIP001 }


//STRIP001 void __EXPORT SvxRuler::Click()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Ueberladener Handler SV; setzt Tab per Dispatcheraufruf
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	Ruler::Click();
//STRIP001 	if( bActive )
//STRIP001 	{
//STRIP001 		pBindings->Update( SID_RULER_LR_MIN_MAX );
//STRIP001 		pBindings->Update( SID_ATTR_LONG_ULSPACE );
//STRIP001 		pBindings->Update( SID_ATTR_LONG_LRSPACE );
//STRIP001 		pBindings->Update( SID_RULER_PAGE_POS );
//STRIP001         pBindings->Update( bHorz ? SID_ATTR_TABSTOP : SID_ATTR_TABSTOP_VERTICAL);
//STRIP001         pBindings->Update( bHorz ? SID_ATTR_PARA_LRSPACE : SID_ATTR_PARA_LRSPACE_VERTICAL);
//STRIP001         pBindings->Update( bHorz ? SID_RULER_BORDERS : SID_RULER_BORDERS_VERTICAL);
//STRIP001 		pBindings->Update( SID_RULER_OBJECT );
//STRIP001 		pBindings->Update( SID_RULER_PROTECT );
//STRIP001 		pBindings->Update( SID_ATTR_PARA_LRSPACE_VERTICAL );
//STRIP001 	}
//STRIP001 	BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 	if(pTabStopItem &&
//STRIP001 	   (nFlags & SVXRULER_SUPPORT_TABS) == SVXRULER_SUPPORT_TABS) 
//STRIP001 	{
//STRIP001 		BOOL bContentProtected = pRuler_Imp->aProtectItem.IsCntntProtected();
//STRIP001 		if( bContentProtected ) return;
//STRIP001 		const long lPos = GetClickPos();
//STRIP001 		if((bRTL && lPos < Min(GetFirstLineIndent(), GetLeftIndent()) && lPos > GetRightIndent()) || 
//STRIP001 			(!bRTL && lPos > Min(GetFirstLineIndent(), GetLeftIndent()) && lPos < GetRightIndent())) 
//STRIP001 		{
//STRIP001 			//convert position in left-to-right text
//STRIP001 			long nTabPos;
//STRIP001 			if(bRTL)
//STRIP001 				nTabPos = GetLeftIndent() - lPos;
//STRIP001 			else
//STRIP001 				nTabPos = lPos - GetLeftIndent();
//STRIP001 			SvxTabStop aTabStop(ConvertHPosLogic(nTabPos),
//STRIP001 								ToAttrTab_Impl(nDefTabType));
//STRIP001 			pTabStopItem->Insert(aTabStop);
//STRIP001 			UpdateTabs();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 BOOL SvxRuler::CalcLimits
//STRIP001 (
//STRIP001  long &nMax1,                                   // zu setzenden Minimalwert
//STRIP001  long &nMax2,                                   // zu setzenden Maximalwert
//STRIP001  BOOL
//STRIP001 ) const
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Defaultimplementierung der virtuellen Funktion; kann die Applikation
//STRIP001    ueberladen, um eine eigene Grenzwertbehandlung zu implementieren.
//STRIP001    Die Werte sind auf die Seite bezogen.
//STRIP001 */
//STRIP001 {
//STRIP001 	nMax1 = LONG_MIN;
//STRIP001 	nMax2 = LONG_MAX;
//STRIP001 	return FALSE;
//STRIP001 }


//STRIP001 void SvxRuler::CalcMinMax()

/*
   [Beschreibung]

   Berechnet die Grenzwerte fuers Draggen; diese sind in Pixeln
   relativ zum Seitenrand

*/

//STRIP001 {
//STRIP001 	BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 	const long lNullPix = ConvertPosPixel(lLogicNullOffset);
//STRIP001 	pRuler_Imp->lMaxLeftLogic=pRuler_Imp->lMaxRightLogic=-1;
//STRIP001 	switch(GetDragType())
//STRIP001 	{
//STRIP001 	  case RULER_TYPE_MARGIN1:
//STRIP001 		{        // linker Rand umgebender Frame
//STRIP001 			// DragPos - NOf zwischen links - rechts
//STRIP001 			pRuler_Imp->lMaxLeftLogic = GetLeftMin();
//STRIP001 			nMaxLeft=ConvertSizePixel(pRuler_Imp->lMaxLeftLogic);
//STRIP001 
//STRIP001 			if(!pColumnItem || pColumnItem->Count() == 1 )
//STRIP001 			{
//STRIP001 				if(bRTL)
//STRIP001 				{
//STRIP001 					nMaxRight = lNullPix - GetRightIndent() +
//STRIP001 						Max(GetFirstLineIndent(), GetLeftIndent()) -
//STRIP001 						lMinFrame;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nMaxRight = lNullPix + GetRightIndent() -
//STRIP001 						Max(GetFirstLineIndent(), GetLeftIndent()) -
//STRIP001 						lMinFrame;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if(nDragType & DRAG_OBJECT_SIZE_PROPORTIONAL)
//STRIP001 				   //nDragType & DRAG_OBJECT_SIZE_LINEAR)
//STRIP001 				{
//STRIP001 					nMaxRight=lNullPix+CalcPropMaxRight();
//STRIP001 				}
//STRIP001 				else if(nDragType & DRAG_OBJECT_SIZE_LINEAR)
//STRIP001 				{
//STRIP001 					nMaxRight = ConvertPosPixel(
//STRIP001 						GetPageWidth() - (
//STRIP001 							(pColumnItem->IsTable() && pLRSpaceItem)
//STRIP001 							? pLRSpaceItem->GetRight() : 0))
//STRIP001 							- GetMargin2() + GetMargin1();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nMaxRight = lNullPix - lMinFrame;
//STRIP001 					if(pColumnItem->IsFirstAct())
//STRIP001 					{
//STRIP001 						if(bRTL)
//STRIP001 						{
//STRIP001 							nMaxRight += Min(
//STRIP001 								pBorders[0].nPos, 
//STRIP001 								Max(GetFirstLineIndent(), GetLeftIndent()) - GetRightIndent());
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{							
//STRIP001 							nMaxRight += Min(
//STRIP001 								pBorders[0].nPos, GetRightIndent() -
//STRIP001 								Max(GetFirstLineIndent(), GetLeftIndent()));
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else if( pColumnItem->Count() > 1 )
//STRIP001 						nMaxRight += pBorders[0].nPos;
//STRIP001 					else
//STRIP001 						nMaxRight +=GetRightIndent() -
//STRIP001 							Max(GetFirstLineIndent(), GetLeftIndent());
//STRIP001 					// den linken Tabellen-Rand nicht ueber den Seitenrand ziehen
//STRIP001 					if(pLRSpaceItem&&pColumnItem->IsTable())
//STRIP001 					{
//STRIP001 						long nTmp=ConvertSizePixel(pLRSpaceItem->GetLeft());
//STRIP001 						if(nTmp>nMaxLeft)
//STRIP001 							nMaxLeft=nTmp;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	  case RULER_TYPE_MARGIN2:
//STRIP001 	 {        // rechter Rand umgebender Frame
//STRIP001 		pRuler_Imp->lMaxRightLogic =
//STRIP001 			pMinMaxItem ?
//STRIP001 				GetPageWidth() - GetRightMax() : GetPageWidth();
//STRIP001 		nMaxRight = ConvertSizePixel(pRuler_Imp->lMaxRightLogic);
//STRIP001 
//STRIP001 
//STRIP001 		if(!pColumnItem)
//STRIP001 		{
//STRIP001 			if(bRTL)
//STRIP001 			{
//STRIP001 				nMaxLeft =  GetMargin2() + GetRightIndent() -
//STRIP001 					Max(GetFirstLineIndent(),GetLeftIndent())  - GetMargin1()+
//STRIP001 						lMinFrame + lNullPix;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nMaxLeft =  GetMargin2() - GetRightIndent() +
//STRIP001 					Max(GetFirstLineIndent(),GetLeftIndent())  - GetMargin1()+
//STRIP001 						lMinFrame + lNullPix;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nMaxLeft = lMinFrame + lNullPix;
//STRIP001 			if(IsActLastColumn() || pColumnItem->Count() < 2 ) //Falls letzte Spalte aktiv
//STRIP001 			{
//STRIP001 				if(bRTL)
//STRIP001 				{
//STRIP001 					nMaxLeft = lMinFrame + lNullPix + GetMargin2() +
//STRIP001 						GetRightIndent() - Max(GetFirstLineIndent(),
//STRIP001 											   GetLeftIndent());
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nMaxLeft = lMinFrame + lNullPix + GetMargin2() -
//STRIP001 						GetRightIndent() + Max(GetFirstLineIndent(),
//STRIP001 											   GetLeftIndent());
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if( pColumnItem->Count() >= 2 )
//STRIP001 			{
//STRIP001 				long nNewMaxLeft =
//STRIP001 					lMinFrame + lNullPix +
//STRIP001 					pBorders[pColumnItem->Count()-2].nPos +
//STRIP001 					pBorders[pColumnItem->Count()-2].nWidth;
//STRIP001 				nMaxLeft=Max(nMaxLeft,nNewMaxLeft);
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	case RULER_TYPE_BORDER:
//STRIP001 	{                // Tabelle, Spalten (Modifier)
//STRIP001 		const USHORT nIdx = GetDragAryPos();
//STRIP001 		switch(GetDragSize())
//STRIP001 		{
//STRIP001 		  case RULER_DRAGSIZE_1 :
//STRIP001 			{
//STRIP001 				nMaxRight = pBorders[nIdx].nPos +
//STRIP001 					pBorders[nIdx].nWidth + lNullPix;
//STRIP001 
//STRIP001 				if(0 == nIdx)
//STRIP001 					nMaxLeft = lNullPix;
//STRIP001 				else
//STRIP001 					nMaxLeft = pBorders[nIdx-1].nPos +
//STRIP001 						pBorders[nIdx-1].nWidth + lNullPix;
//STRIP001 				if(nIdx == pColumnItem->GetActColumn()) 
//STRIP001 				{
//STRIP001 					if(bRTL)
//STRIP001 					{
//STRIP001 						nMaxLeft += pBorders[nIdx].nPos +
//STRIP001 							GetRightIndent() - Max(GetFirstLineIndent(),
//STRIP001 												   GetLeftIndent());
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nMaxLeft += pBorders[nIdx].nPos -
//STRIP001 							GetRightIndent() + Max(GetFirstLineIndent(),
//STRIP001 												   GetLeftIndent());
//STRIP001 					}
//STRIP001 					if(0 != nIdx)
//STRIP001 						nMaxLeft -= pBorders[nIdx-1].nPos +
//STRIP001 							pBorders[nIdx-1].nWidth;
//STRIP001 				}
//STRIP001 				nMaxLeft += lMinFrame;
//STRIP001 				nMaxLeft += nDragOffset;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		  case RULER_DRAGSIZE_MOVE:
//STRIP001 			{
//STRIP001 				if(pColumnItem)
//STRIP001 				{
//STRIP001 					USHORT nLeftCol=GetActLeftColumn(FALSE, nIdx);
//STRIP001 					USHORT nRightCol=GetActRightColumn(FALSE, nIdx);
//STRIP001 					USHORT nActLeftCol=GetActLeftColumn();
//STRIP001 					USHORT nActRightCol=GetActRightColumn();
//STRIP001 					if(nLeftCol==USHRT_MAX)
//STRIP001 						nMaxLeft=lNullPix;
//STRIP001 					else
//STRIP001 						nMaxLeft = pBorders[nLeftCol].nPos +
//STRIP001 							pBorders[nLeftCol].nWidth + lNullPix;
//STRIP001 
//STRIP001 					if(nActRightCol == nIdx)
//STRIP001 					{
//STRIP001 						if(bRTL)
//STRIP001 						{
//STRIP001 							nMaxLeft += pBorders[nIdx].nPos +
//STRIP001 								GetRightIndent() - Max(GetFirstLineIndent(),
//STRIP001 													   GetLeftIndent());
//STRIP001 							if(nActLeftCol!=USHRT_MAX)
//STRIP001 								nMaxLeft -= pBorders[nActLeftCol].nPos +
//STRIP001 									pBorders[nActLeftCol].nWidth;
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							nMaxLeft += pBorders[nIdx].nPos -
//STRIP001 								GetRightIndent() + Max(GetFirstLineIndent(),
//STRIP001 													   GetLeftIndent());
//STRIP001 							if(nActLeftCol!=USHRT_MAX)
//STRIP001 								nMaxLeft -= pBorders[nActLeftCol].nPos +
//STRIP001 									pBorders[nActLeftCol].nWidth;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					nMaxLeft += lMinFrame;
//STRIP001 					nMaxLeft += nDragOffset;
//STRIP001 
//STRIP001 					// nMaxRight
//STRIP001 					// linear / proprotional verschieben
//STRIP001 					if(DRAG_OBJECT_SIZE_PROPORTIONAL & nDragType||
//STRIP001 					   (DRAG_OBJECT_SIZE_LINEAR & nDragType) )
//STRIP001 					{
//STRIP001 						nMaxRight=lNullPix+CalcPropMaxRight(nIdx);
//STRIP001 					}
//STRIP001 					else if(DRAG_OBJECT_SIZE_LINEAR & nDragType)
//STRIP001 					{
//STRIP001 						nMaxRight=lNullPix+GetMargin2()-GetMargin1()+
//STRIP001 							(nBorderCount-nIdx-1)*lMinFrame;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if(nRightCol==USHRT_MAX)
//STRIP001 						{ // letzte Spalte
//STRIP001 							nMaxRight = GetMargin2() + lNullPix;
//STRIP001 							if(IsActLastColumn())
//STRIP001 							{
//STRIP001 								if(bRTL)
//STRIP001 								{
//STRIP001 									nMaxRight -=
//STRIP001 										GetMargin2() + GetRightIndent() -
//STRIP001 											Max(GetFirstLineIndent(),
//STRIP001 												GetLeftIndent());
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									nMaxRight -=
//STRIP001 										GetMargin2() - GetRightIndent() +
//STRIP001 											Max(GetFirstLineIndent(),
//STRIP001 												GetLeftIndent());
//STRIP001 								}
//STRIP001 								nMaxRight += pBorders[nIdx].nPos +
//STRIP001 									pBorders[nIdx].nWidth;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							nMaxRight = lNullPix + pBorders[nRightCol].nPos;
//STRIP001 							USHORT nNotHiddenRightCol =
//STRIP001 								GetActRightColumn(TRUE, nIdx);
//STRIP001 
//STRIP001 							if( nActLeftCol == nIdx )
//STRIP001 							{
//STRIP001 								long nBorder = nNotHiddenRightCol ==
//STRIP001 									USHRT_MAX ?
//STRIP001 									GetMargin2() :
//STRIP001 									pBorders[nNotHiddenRightCol].nPos;
//STRIP001 								if(bRTL)
//STRIP001 								{
//STRIP001 									nMaxRight -= nBorder + GetRightIndent() -
//STRIP001 										Max(GetFirstLineIndent(),
//STRIP001 											GetLeftIndent());
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									nMaxRight -= nBorder - GetRightIndent() +
//STRIP001 										Max(GetFirstLineIndent(),
//STRIP001 											GetLeftIndent());
//STRIP001 								}
//STRIP001 								nMaxRight += pBorders[nIdx].nPos +
//STRIP001 									pBorders[nIdx].nWidth;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						nMaxRight -= lMinFrame;
//STRIP001 						nMaxRight -= pBorders[nIdx].nWidth;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				// ObjectItem
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if(pObjectItem->HasLimits())
//STRIP001 					{
//STRIP001 						if(CalcLimits(nMaxLeft, nMaxRight, nIdx & 1? FALSE: TRUE))
//STRIP001 						{
//STRIP001 							nMaxLeft = ConvertPosPixel(nMaxLeft);
//STRIP001 							nMaxRight = ConvertPosPixel(nMaxRight);
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nMaxLeft = LONG_MIN;
//STRIP001 						nMaxRight = LONG_MAX;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		  case RULER_DRAGSIZE_2:
//STRIP001 			{
//STRIP001 				nMaxLeft = lNullPix + pBorders[nIdx].nPos;
//STRIP001 				if(nIdx == pColumnItem->Count()-2) { // letzte Spalte
//STRIP001 					nMaxRight = GetMargin2() + lNullPix;
//STRIP001 					if(pColumnItem->IsLastAct()) {
//STRIP001 						nMaxRight -=
//STRIP001 							GetMargin2() - GetRightIndent() +
//STRIP001 								Max(GetFirstLineIndent(),
//STRIP001 									GetLeftIndent());
//STRIP001 						nMaxRight += pBorders[nIdx].nPos +
//STRIP001 							pBorders[nIdx].nWidth;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else {
//STRIP001 					nMaxRight = lNullPix + pBorders[nIdx+1].nPos;
//STRIP001 					if(pColumnItem->GetActColumn()-1 == nIdx) {
//STRIP001 						nMaxRight -= pBorders[nIdx+1].nPos  - GetRightIndent() +
//STRIP001 							Max(GetFirstLineIndent(),
//STRIP001 								GetLeftIndent());
//STRIP001 						nMaxRight += pBorders[nIdx].nPos +
//STRIP001 							pBorders[nIdx].nWidth;
//STRIP001 					}
//STRIP001 			}
//STRIP001 				nMaxRight -= lMinFrame;
//STRIP001 				nMaxRight -= pBorders[nIdx].nWidth;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nMaxRight += nDragOffset;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	  case RULER_TYPE_INDENT:
//STRIP001 		{
//STRIP001 		const USHORT nIdx = GetDragAryPos();
//STRIP001 		switch(nIdx) {
//STRIP001 		case INDENT_FIRST_LINE - INDENT_GAP:
//STRIP001 		case INDENT_LEFT_MARGIN - INDENT_GAP:
//STRIP001             {
//STRIP001                 if(bRTL)
//STRIP001                 {
//STRIP001                     nMaxLeft = lNullPix + GetRightIndent();
//STRIP001 
//STRIP001                     if(pColumnItem && !pColumnItem->IsFirstAct())
//STRIP001                         nMaxLeft += pBorders[pColumnItem->GetActColumn()-1].nPos +
//STRIP001                             pBorders[pColumnItem->GetActColumn()-1].nWidth;
//STRIP001                     nMaxRight = lNullPix + GetMargin2();
//STRIP001 
//STRIP001                     // zusammem draggen
//STRIP001                     if((INDENT_FIRST_LINE - INDENT_GAP) != nIdx &&
//STRIP001                        (nDragType & DRAG_OBJECT_LEFT_INDENT_ONLY) !=
//STRIP001                        DRAG_OBJECT_LEFT_INDENT_ONLY)
//STRIP001                     {
//STRIP001                         if(GetLeftIndent() > GetFirstLineIndent())
//STRIP001                             nMaxLeft += GetLeftIndent() - GetFirstLineIndent();
//STRIP001                         else
//STRIP001                             nMaxRight -= GetFirstLineIndent() - GetLeftIndent();
//STRIP001                     }
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     nMaxLeft = lNullPix;
//STRIP001 
//STRIP001                     if(pColumnItem && !pColumnItem->IsFirstAct())
//STRIP001                         nMaxLeft += pBorders[pColumnItem->GetActColumn()-1].nPos +
//STRIP001                             pBorders[pColumnItem->GetActColumn()-1].nWidth;
//STRIP001                     nMaxRight = lNullPix + GetRightIndent() - lMinFrame;
//STRIP001 
//STRIP001                     // zusammem draggen
//STRIP001                     if((INDENT_FIRST_LINE - INDENT_GAP) != nIdx &&
//STRIP001                        (nDragType & DRAG_OBJECT_LEFT_INDENT_ONLY) !=
//STRIP001                        DRAG_OBJECT_LEFT_INDENT_ONLY)
//STRIP001                     {
//STRIP001                         if(GetLeftIndent() > GetFirstLineIndent())
//STRIP001                             nMaxLeft += GetLeftIndent() - GetFirstLineIndent();
//STRIP001                         else
//STRIP001                             nMaxRight -= GetFirstLineIndent() - GetLeftIndent();
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001           break;
//STRIP001           case INDENT_RIGHT_MARGIN - INDENT_GAP:
//STRIP001             {
//STRIP001                 if(bRTL)
//STRIP001                 {
//STRIP001                     nMaxLeft = lNullPix;
//STRIP001                     nMaxRight = lNullPix + Min(GetFirstLineIndent(), GetLeftIndent()) - lMinFrame;
//STRIP001                     if(pColumnItem)
//STRIP001                     {
//STRIP001                         USHORT nRightCol=GetActRightColumn( TRUE );
//STRIP001                         if(!IsActLastColumn( TRUE ))
//STRIP001                             nMaxRight += pBorders[nRightCol].nPos;
//STRIP001                         else
//STRIP001                             nMaxRight += GetMargin2();
//STRIP001                     }
//STRIP001                     else
//STRIP001                         nMaxLeft += GetMargin1();
//STRIP001                     nMaxLeft += lMinFrame;
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     nMaxLeft = lNullPix +
//STRIP001                         Max(GetFirstLineIndent(), GetLeftIndent());
//STRIP001                     nMaxRight = lNullPix;
//STRIP001                     if(pColumnItem)
//STRIP001                     {
//STRIP001                         USHORT nRightCol=GetActRightColumn( TRUE );
//STRIP001                         if(!IsActLastColumn( TRUE ))
//STRIP001                             nMaxRight += pBorders[nRightCol].nPos;
//STRIP001                         else
//STRIP001                             nMaxRight += GetMargin2();
//STRIP001                     }
//STRIP001                     else
//STRIP001                         nMaxRight += GetMargin2();
//STRIP001                     nMaxLeft += lMinFrame;
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	case RULER_TYPE_TAB:                // Tabs (Modifier)
//STRIP001 		/*
//STRIP001 		   links = NOf + Max(LAR, EZ)
//STRIP001 		   rechts = NOf + RAR
//STRIP001 		   */
//STRIP001 		long nRightIndent = GetRightIndent();
//STRIP001 		long nLeftIndent = GetLeftIndent();
//STRIP001 		nMaxLeft = bRTL ? lNullPix + GetRightIndent()
//STRIP001 							: lNullPix + Min(GetFirstLineIndent(), GetLeftIndent());
//STRIP001 		pRuler_Imp->lMaxRightLogic=GetLogicRightIndent()+lLogicNullOffset;
//STRIP001 		nMaxRight = ConvertSizePixel(pRuler_Imp->lMaxRightLogic);
//STRIP001 		break;
//STRIP001 	}
//STRIP001 #ifdef DEBUGLIN
//STRIP001 	{
//STRIP001 		String aStr("MinLeft: ");
//STRIP001 		Size aSize(nMaxLeft + lNullPix, 0);
//STRIP001 		Size aSize2(nMaxRight + lNullPix, 0);
//STRIP001 		aSize = pEditWin->PixelToLogic(aSize, MapMode(MAP_MM));
//STRIP001 		aSize2 = pEditWin->PixelToLogic(aSize2, MapMode(MAP_MM));
//STRIP001 		aStr += String(aSize.Width());
//STRIP001 		aStr += " MaxRight: ";
//STRIP001 		aStr += String(aSize2.Width());
//STRIP001 		InfoBox(0, aStr).Execute();
//STRIP001 	}
//STRIP001 #endif
//STRIP001 }


//STRIP001 long __EXPORT SvxRuler::StartDrag()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Beginn eines Drag-Vorgangs (SV-Handler); wertet Modifier aus
//STRIP001    und berechnet Grenzwerte
//STRIP001 
//STRIP001    [Querverweise]
//STRIP001 
//STRIP001    <SvxRuler::EvalModifier()>
//STRIP001    <SvxRuler::CalcMinMax()>
//STRIP001    <SvxRuler::EndDrag()>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	BOOL bContentProtected = pRuler_Imp->aProtectItem.IsCntntProtected();
//STRIP001 	if(!bValid)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	pRuler_Imp->lLastLMargin=GetMargin1();
//STRIP001 	long bOk = 1;
//STRIP001 	if(GetStartDragHdl().IsSet())
//STRIP001 		bOk = Ruler::StartDrag();
//STRIP001 	if(bOk) {
//STRIP001 		lInitialDragPos = GetDragPos();
//STRIP001 		switch(GetDragType()) {
//STRIP001 		case RULER_TYPE_MARGIN1:        // linker Rand umgebender Frame
//STRIP001 		case RULER_TYPE_MARGIN2:        // rechter Rand umgebender Frame
//STRIP001 			if((bHorz && pLRSpaceItem) || (!bHorz && pULSpaceItem))
//STRIP001 			{
//STRIP001 				if(pColumnItem)
//STRIP001 					EvalModifier();
//STRIP001 				else
//STRIP001 					nDragType = DRAG_OBJECT;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bOk = FALSE;
//STRIP001 			break;
//STRIP001 		case RULER_TYPE_BORDER:                // Tabelle, Spalten (Modifier)
//STRIP001 			if(pColumnItem)
//STRIP001 			{
//STRIP001 				nDragOffset = pColumnItem->IsTable()? 0 :
//STRIP001 				GetDragPos() - pBorders[GetDragAryPos()].nPos;
//STRIP001 				EvalModifier();
//STRIP001 
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nDragOffset = 0;
//STRIP001 			break;
//STRIP001 		case RULER_TYPE_INDENT: {                // Absatzeinzuege (Modifier)
//STRIP001 			if( bContentProtected )
//STRIP001 				return FALSE;
//STRIP001 			BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 			USHORT nIndent = INDENT_LEFT_MARGIN;
//STRIP001             if((nIndent) == GetDragAryPos() + INDENT_GAP) {        // Linker Absatzeinzug
//STRIP001                 pIndents[0] = pIndents[INDENT_FIRST_LINE];
//STRIP001 				pIndents[0].nStyle |= RULER_STYLE_DONTKNOW;
//STRIP001 				EvalModifier();
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nDragType = DRAG_OBJECT;
//STRIP001             pIndents[1] = pIndents[GetDragAryPos()+INDENT_GAP];
//STRIP001 			pIndents[1].nStyle |= RULER_STYLE_DONTKNOW;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case RULER_TYPE_TAB:                // Tabs (Modifier)
//STRIP001 			if( bContentProtected ) return FALSE;
//STRIP001 			EvalModifier();
//STRIP001 			pTabs[0] = pTabs[GetDragAryPos()+1];
//STRIP001 			pTabs[0].nStyle |= RULER_STYLE_DONTKNOW;
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			nDragType = NONE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nDragType = NONE;
//STRIP001 	if(bOk)
//STRIP001 		CalcMinMax();
//STRIP001 	return bOk;
//STRIP001 }


//STRIP001 void  __EXPORT SvxRuler::Drag()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    SV-Draghandler
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	if(IsDragCanceled())
//STRIP001 	{
//STRIP001 		Ruler::Drag();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	switch(GetDragType()) {
//STRIP001 	case RULER_TYPE_MARGIN1:        // linker Rand umgebender Frame
//STRIP001 		DragMargin1();
//STRIP001 		pRuler_Imp->lLastLMargin=GetMargin1();
//STRIP001 		break;
//STRIP001 	case RULER_TYPE_MARGIN2:        // rechter Rand umgebender Frame
//STRIP001 		DragMargin2();
//STRIP001 		break;
//STRIP001 	case RULER_TYPE_INDENT:         // Absatzeinzuege
//STRIP001 		DragIndents();
//STRIP001 		break;
//STRIP001 	case RULER_TYPE_BORDER:         // Tabelle, Spalten
//STRIP001 		if(pColumnItem)
//STRIP001 			DragBorders();
//STRIP001 		else if(pObjectItem)
//STRIP001 			DragObjectBorder();
//STRIP001 		break;
//STRIP001 	case RULER_TYPE_TAB:            // Tabs
//STRIP001 		DragTabs();
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	Ruler::Drag();
//STRIP001 }


//STRIP001 void __EXPORT SvxRuler::EndDrag()
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    SV-Handler; wird beim Beenden des Draggens gerufen.
//STRIP001    Stoesst die Aktualisierung der Daten der Applikation an, indem
//STRIP001    durch Aufruf der jeweiligen Apply...()- Methoden die Daten an die
//STRIP001    Applikation geschickt werden.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	const BOOL bUndo = IsDragCanceled();
//STRIP001 	const long lPos = GetDragPos();
//STRIP001 	DrawLine_Impl(lTabPos, 6, bHorz);
//STRIP001 	lTabPos=-1;
//STRIP001 	if(!bUndo)
//STRIP001 		switch(GetDragType())
//STRIP001 		{
//STRIP001 		  case RULER_TYPE_MARGIN1:   // linker, oberer Rand umgebender Frame
//STRIP001 		  case RULER_TYPE_MARGIN2:   // rechter, unterer Rand umgebender Frame
//STRIP001 			{
//STRIP001 				if(!pColumnItem || !pColumnItem->IsTable())
//STRIP001 					ApplyMargins();
//STRIP001 
//STRIP001 				if(pColumnItem &&
//STRIP001 				   (pColumnItem->IsTable() ||
//STRIP001 					(nDragType & DRAG_OBJECT_SIZE_PROPORTIONAL)))
//STRIP001 					ApplyBorders();
//STRIP001 
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		  case RULER_TYPE_BORDER:                // Tabelle, Spalten
//STRIP001 			if(lInitialDragPos != lPos)
//STRIP001 			{
//STRIP001 				if(pColumnItem)
//STRIP001 				{
//STRIP001 					ApplyBorders();
//STRIP001 					if(bHorz)
//STRIP001 						UpdateTabs();
//STRIP001 				}
//STRIP001 				else if(pObjectItem)
//STRIP001 					ApplyObject();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		  case RULER_TYPE_INDENT:                // Absatzeinzuege
//STRIP001 			if(lInitialDragPos != lPos)
//STRIP001 				ApplyIndents();
//STRIP001             SetIndents(INDENT_COUNT, pIndents+INDENT_GAP);
//STRIP001 			break;
//STRIP001 		  case RULER_TYPE_TAB:                // Tabs
//STRIP001 			{
//STRIP001 				ApplyTabs();
//STRIP001 				pTabs[GetDragAryPos()].nStyle &= ~RULER_STYLE_INVISIBLE;
//STRIP001 				SetTabs(nTabCount, pTabs+TAB_GAP);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	nDragType = NONE;
//STRIP001 	Ruler::EndDrag();
//STRIP001 	if(bUndo)
//STRIP001 		for(USHORT i=0;i<pRuler_Imp->nControlerItems;i++)
//STRIP001 		{
//STRIP001 			pCtrlItem[i]->ClearCache();
//STRIP001 			pCtrlItem[i]->GetBindings().Invalidate(pCtrlItem[i]->GetId());
//STRIP001 			//		pCtrlItem[i]->UnBind();
//STRIP001 //			pCtrlItem[i]->ReBind();
//STRIP001 		}
//STRIP001 }


//STRIP001 void __EXPORT SvxRuler::ExtraDown()
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Ueberladene SV-Methode; setzt den neuen Typ fuer den Defaulttabulator.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// Tabulator Typ umschalten
//STRIP001 	if(pTabStopItem &&
//STRIP001 		(nFlags & SVXRULER_SUPPORT_TABS) ==        SVXRULER_SUPPORT_TABS) {
//STRIP001 		++nDefTabType;
//STRIP001 		if(RULER_TAB_DEFAULT == nDefTabType)
//STRIP001 			nDefTabType = RULER_TAB_LEFT;
//STRIP001 		SetExtraType(RULER_EXTRA_TAB, nDefTabType);
//STRIP001 	}
//STRIP001 	Ruler::ExtraDown();
//STRIP001 }


/*N*/ void __EXPORT SvxRuler::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 							   const SfxHint& rHint, const TypeId& rHintType)
/*

   [Beschreibung]

   Benachrichtigung durch die Bindings, dass die Statusaktualisierung
   beendet ist.
   Das Lineal aktualisiert seine Darstellung und meldet sich bei den
   Bindings wieder ab.

*/

/*N*/ {
/*N*/ 	// Aktualisierung anstossen
/*N*/ 	if(bActive &&
/*N*/ 		rHint.Type() == TYPE(SfxSimpleHint) &&
/*N*/ 	 ((SfxSimpleHint&) rHint ).GetId() == SFX_HINT_UPDATEDONE ) {
/*N*/ 		Update();
/*N*/ 		EndListening(*pBindings);
/*N*/ 		bValid = TRUE;
/*N*/ 		bListening = FALSE;
/*N*/ 	}
/*N*/ }


//STRIP001 IMPL_LINK_INLINE_START( SvxRuler, MenuSelect, Menu *, pMenu )
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Handler des Kontextmenues fuer das Umschalten der Masseinheit
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SetUnit(FieldUnit(pMenu->GetCurItemId()));
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxRuler, MenuSelect, Menu *, pMenu )


//STRIP001 IMPL_LINK( SvxRuler, TabMenuSelect, Menu *, pMenu )
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Handler des Tabulatormenues fuer das Setzen des Typs
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SvxTabStop aTabStop = (*pTabStopItem)[pRuler_Imp->nIdx];
//STRIP001 	aTabStop.GetAdjustment() = ToAttrTab_Impl(pMenu->GetCurItemId()-1);
//STRIP001 	pTabStopItem->Remove(pRuler_Imp->nIdx);
//STRIP001 	pTabStopItem->Insert(aTabStop);
//STRIP001     USHORT nTabStopId = bHorz ? SID_ATTR_TABSTOP : SID_ATTR_TABSTOP_VERTICAL;
//STRIP001     pBindings->GetDispatcher()->Execute( nTabStopId, SFX_CALLMODE_RECORD, pTabStopItem, 0L );
//STRIP001 	UpdateTabs();
//STRIP001 	pRuler_Imp->nIdx = 0;
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 void SvxRuler::Command( const CommandEvent& rCEvt )
//STRIP001 
//STRIP001 /*
//STRIP001    [Beschreibung]
//STRIP001 
//STRIP001    Mauskontextmenue fuer das Umschalten der Masseinheit
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( COMMAND_CONTEXTMENU == rCEvt.GetCommand() )
//STRIP001 	{
//STRIP001 		CancelDrag();
//STRIP001         BOOL bRTL = pRuler_Imp->pTextRTLItem && pRuler_Imp->pTextRTLItem->GetValue();
//STRIP001 		if ( pTabs &&
//STRIP001 			 RULER_TYPE_TAB ==
//STRIP001 			 GetType( rCEvt.GetMousePosPixel(), &pRuler_Imp->nIdx ) &&
//STRIP001 			 pTabs[pRuler_Imp->nIdx+TAB_GAP].nStyle < RULER_TAB_DEFAULT )
//STRIP001 		{
//STRIP001 			PopupMenu aMenu;
//STRIP001 			aMenu.SetSelectHdl(LINK(this, SvxRuler, TabMenuSelect));
//STRIP001 			VirtualDevice aDev;
//STRIP001 			const Size aSz(RULER_TAB_WIDTH+2, RULER_TAB_HEIGHT+2);
//STRIP001 			aDev.SetOutputSize(aSz);
//STRIP001 			aDev.SetBackground(Wallpaper(Color(COL_WHITE)));
//STRIP001 			const Point aPt(aSz.Width() / 2, aSz.Height() / 2);
//STRIP001 
//STRIP001 			for ( USHORT i = RULER_TAB_LEFT; i < RULER_TAB_DEFAULT; ++i )
//STRIP001 			{
//STRIP001                 USHORT nStyle = bRTL ? i|RULER_TAB_RTL : i;
//STRIP001 				nStyle |= bHorz ? WB_HORZ : WB_VERT;
//STRIP001 				DrawTab(&aDev, aPt, nStyle);
//STRIP001 				aMenu.InsertItem(i+1,
//STRIP001 								 String(ResId(RID_SVXSTR_RULER_START+i, DIALOG_MGR())),
//STRIP001 								 Image(aDev.GetBitmap(Point(), aSz), Color(COL_WHITE)));
//STRIP001 				aMenu.CheckItem(i+1, i == pTabs[pRuler_Imp->nIdx+TAB_GAP].nStyle);
//STRIP001 				aDev.SetOutputSize(aSz); // device loeschen
//STRIP001 			}
//STRIP001 			aMenu.Execute( this, rCEvt.GetMousePosPixel() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			PopupMenu aMenu(ResId(RID_SVXMN_RULER, DIALOG_MGR()));
//STRIP001 			aMenu.SetSelectHdl(LINK(this, SvxRuler, MenuSelect));
//STRIP001 			FieldUnit eUnit = GetUnit();
//STRIP001 			const USHORT nCount = aMenu.GetItemCount();
//STRIP001 
//STRIP001 			for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 			{
//STRIP001 				const USHORT nId = aMenu.GetItemId(i);
//STRIP001 				aMenu.CheckItem(nId, nId == (USHORT)eUnit);
//STRIP001 			}
//STRIP001 			aMenu.Execute( this, rCEvt.GetMousePosPixel() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Ruler::Command( rCEvt );
//STRIP001 }


//STRIP001 USHORT SvxRuler::GetActRightColumn(
//STRIP001 	BOOL bForceDontConsiderHidden, USHORT nAct ) const
//STRIP001 {
//STRIP001 	if( nAct == USHRT_MAX )
//STRIP001 		nAct = pColumnItem->GetActColumn();
//STRIP001 	else nAct++; //Damit man die ActDrag uebergeben kann
//STRIP001 
//STRIP001 	BOOL bConsiderHidden = !bForceDontConsiderHidden &&
//STRIP001 		!( nDragType & DRAG_OBJECT_ACTLINE_ONLY );
//STRIP001 
//STRIP001 	while( nAct < pColumnItem->Count() - 1 )
//STRIP001 	{
//STRIP001 		if( (*pColumnItem)[nAct].bVisible || bConsiderHidden )
//STRIP001 			return nAct;
//STRIP001 		else
//STRIP001 			nAct++;
//STRIP001 	}
//STRIP001 	return USHRT_MAX;
//STRIP001 }



//STRIP001 USHORT SvxRuler::GetActLeftColumn(
//STRIP001 	BOOL bForceDontConsiderHidden, USHORT nAct ) const
//STRIP001 {
//STRIP001 	if(nAct==USHRT_MAX)
//STRIP001 		nAct=pColumnItem->GetActColumn();
//STRIP001 
//STRIP001 	USHORT nLOffs=1;
//STRIP001 
//STRIP001 	BOOL bConsiderHidden = !bForceDontConsiderHidden &&
//STRIP001 		!( nDragType & DRAG_OBJECT_ACTLINE_ONLY );
//STRIP001 
//STRIP001 	while(nAct>=nLOffs)
//STRIP001 	{
//STRIP001 		if( (*pColumnItem)[ nAct - nLOffs ].bVisible || bConsiderHidden )
//STRIP001 			return nAct-nLOffs;
//STRIP001 		else
//STRIP001 			nLOffs++;
//STRIP001 	}
//STRIP001 	return USHRT_MAX;
//STRIP001 }


/*N*/ BOOL SvxRuler::IsActLastColumn(
/*N*/ 	BOOL bForceDontConsiderHidden, USHORT nAct) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
//STRIP001 	return GetActRightColumn(bForceDontConsiderHidden, nAct)==USHRT_MAX;
/*N*/ }

//STRIP001 BOOL SvxRuler::IsActFirstColumn(
//STRIP001 	BOOL bForceDontConsiderHidden, USHORT nAct) const
//STRIP001 {
//STRIP001 	return GetActLeftColumn(bForceDontConsiderHidden, nAct)==USHRT_MAX;
//STRIP001 }

//STRIP001 long SvxRuler::CalcPropMaxRight(USHORT nCol) const
//STRIP001 {
//STRIP001 
//STRIP001 	if(!(nDragType & DRAG_OBJECT_SIZE_LINEAR))
//STRIP001 	{
//STRIP001 
//STRIP001 		// ausgehend vom rechten Rand die Mindestbreiten
//STRIP001 		// aller betroffenen Spalten abziehen
//STRIP001 		long nMaxRight = GetMargin2()-GetMargin1();
//STRIP001 
//STRIP001 		long lFences=0;
//STRIP001 		long lMinSpace=USHRT_MAX;
//STRIP001 		long lOldPos;
//STRIP001 		long lColumns=0;
//STRIP001 		USHORT nStart;
//STRIP001 		if(!pColumnItem->IsTable())
//STRIP001 		{
//STRIP001 			if(nCol==USHRT_MAX)
//STRIP001 			{
//STRIP001 				lOldPos=GetMargin1();
//STRIP001 				nStart=0;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				lOldPos=pBorders[nCol].nPos+pBorders[nCol].nWidth;
//STRIP001 				nStart=nCol+1;
//STRIP001 				lFences=pBorders[nCol].nWidth;
//STRIP001 			}
//STRIP001 
//STRIP001 			for(USHORT i = nStart; i < nBorderCount-1; ++i)
//STRIP001 			{
//STRIP001 				long lWidth=pBorders[i].nPos-lOldPos;
//STRIP001 				lColumns+=lWidth;
//STRIP001 				if(lWidth<lMinSpace)
//STRIP001 					lMinSpace=lWidth;
//STRIP001 				lOldPos=pBorders[i].nPos+pBorders[i].nWidth;
//STRIP001 				lFences+=pBorders[i].nWidth;
//STRIP001 			}
//STRIP001 			long lWidth=GetMargin2()-lOldPos;
//STRIP001 			lColumns+=lWidth;
//STRIP001 			if(lWidth<lMinSpace)
//STRIP001 				lMinSpace=lWidth;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nActCol;
//STRIP001 			if(nCol==USHRT_MAX) //CalcMinMax fuer LeftMargin
//STRIP001 			{
//STRIP001 				lOldPos=GetMargin1();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				lOldPos=pBorders[nCol].nPos;
//STRIP001 			}
//STRIP001 			lColumns=GetMargin2()-lOldPos;
//STRIP001 			nActCol=nCol;
//STRIP001 			lFences=0;
//STRIP001 			while(nActCol<nBorderCount||nActCol==USHRT_MAX)
//STRIP001 			{
//STRIP001 				USHORT nRight;
//STRIP001 				if(nActCol==USHRT_MAX)
//STRIP001 				{
//STRIP001 					nRight=0;
//STRIP001 					while(!(*pColumnItem)[nRight].bVisible)
//STRIP001 						nRight++;
//STRIP001 				}
//STRIP001 				else
//STRIP001 					nRight=GetActRightColumn(FALSE, nActCol);
//STRIP001 				long lWidth;
//STRIP001 				if(nRight!=USHRT_MAX)
//STRIP001 				{
//STRIP001 					lWidth=pBorders[nRight].nPos-lOldPos;
//STRIP001 					lOldPos=pBorders[nRight].nPos;
//STRIP001 				}
//STRIP001 				else
//STRIP001 					lWidth=GetMargin2()-lOldPos;
//STRIP001 				nActCol=nRight;
//STRIP001 				if(lWidth<lMinSpace)
//STRIP001 					lMinSpace=lWidth;
//STRIP001 				if(nActCol==USHRT_MAX)
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		nMaxRight-=(long)(lFences+lMinFrame/(float)lMinSpace*lColumns);
//STRIP001 		return nMaxRight;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if(pColumnItem->IsTable())
//STRIP001 		{
//STRIP001 			USHORT nVisCols=0;
//STRIP001 			for(USHORT i=GetActRightColumn(FALSE, nCol);i<nBorderCount;)
//STRIP001 			{
//STRIP001 				if((*pColumnItem)[i].bVisible)
//STRIP001 					nVisCols++;
//STRIP001 				i=GetActRightColumn(FALSE, i);
//STRIP001 			}
//STRIP001 			return GetMargin2()-GetMargin1()-(nVisCols+1)*lMinFrame;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			long lWidth=0;
//STRIP001 			for(USHORT i=nCol;i<nBorderCount-1;i++)
//STRIP001 			{
//STRIP001 				lWidth+=lMinFrame+pBorders[i].nWidth;
//STRIP001 			}
//STRIP001 			return GetMargin2()-GetMargin1()-lWidth;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

}
