/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_graphctl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:44:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif

#ifndef _SV_DIALOG_HXX 
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
#include <svtools/syslocale.hxx>
#endif
#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif

#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include "graphctl.hxx"
#include "GraphCtlAccessibleContext.hxx"
#include "xoutbmp.hxx"
#include "svxids.hrc"
#include "svdpage.hxx"
namespace binfilter {

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrlUserCall::Changed( const SdrObject& rObj, SdrUserCallType eType, const Rectangle& rOldBoundRect )
//STRIP001 {
//STRIP001 	switch( eType )
//STRIP001 	{
//STRIP001 		case( SDRUSERCALL_MOVEONLY ):
//STRIP001 		case( SDRUSERCALL_RESIZE ):
//STRIP001 			rWin.SdrObjChanged( rObj );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( SDRUSERCALL_INSERTED ):
//STRIP001 			rWin.SdrObjCreated( rObj );
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 GraphCtrl::GraphCtrl( Window* pParent, const WinBits nWinBits ) :
//STRIP001 			Control			( pParent, nWinBits ),
//STRIP001 			aMap100			( MAP_100TH_MM ),
//STRIP001 			pModel			( NULL ),
//STRIP001 			pView			( NULL ),
//STRIP001 			eObjKind		( OBJ_NONE ),
//STRIP001 			nPolyEdit		( 0 ),
//STRIP001 			bEditMode		( FALSE ),
//STRIP001 			bSdrMode		( FALSE ),
//STRIP001 			mpAccContext	( NULL )
//STRIP001 {
//STRIP001 	pUserCall = new GraphCtrlUserCall( *this );
//STRIP001 	aUpdateTimer.SetTimeout( 200 );
//STRIP001 	aUpdateTimer.SetTimeoutHdl( LINK( this, GraphCtrl, UpdateHdl ) );
//STRIP001 	aUpdateTimer.Start();
//STRIP001 
//STRIP001 	SetWinStyle( nWinBits );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 GraphCtrl::GraphCtrl( Window* pParent, const ResId& rResId ) :
//STRIP001 			Control			( pParent, rResId ),
//STRIP001 			aMap100			( MAP_100TH_MM ),
//STRIP001 			pModel			( NULL ),
//STRIP001 			pView			( NULL ),
//STRIP001 			eObjKind		( OBJ_NONE ),
//STRIP001 			nPolyEdit		( 0 ),
//STRIP001 			bEditMode		( FALSE ),
//STRIP001 			bSdrMode		( FALSE ),
//STRIP001 			bAnim			( FALSE ),
//STRIP001 			nWinStyle		( 0 ),
//STRIP001 			mpAccContext	( NULL )
//STRIP001 {
//STRIP001 	pUserCall = new GraphCtrlUserCall( *this );
//STRIP001 	aUpdateTimer.SetTimeout( 500 );
//STRIP001 	aUpdateTimer.SetTimeoutHdl( LINK( this, GraphCtrl, UpdateHdl ) );
//STRIP001 	aUpdateTimer.Start();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 GraphCtrl::~GraphCtrl()
//STRIP001 {
//STRIP001 	if( mpAccContext )
//STRIP001 	{
//STRIP001 		mpAccContext->disposing();
//STRIP001 		mpAccContext->release();
//STRIP001 	}
//STRIP001 	delete pView;
//STRIP001 	delete pModel;
//STRIP001 	delete pUserCall;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::SetWinStyle( WinBits nWinBits )
//STRIP001 {
//STRIP001 	nWinStyle = nWinBits;
//STRIP001 	bAnim = ( nWinStyle & WB_ANIMATION ) == WB_ANIMATION;
//STRIP001 	bSdrMode = ( nWinStyle & WB_SDRMODE ) == WB_SDRMODE;
//STRIP001 
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	SetBackground( Wallpaper( rStyleSettings.GetWindowColor() ) );
//STRIP001 	SetMapMode( aMap100 );
//STRIP001 
//STRIP001 	delete pView;
//STRIP001 	pView = NULL;
//STRIP001 
//STRIP001 	delete pModel;
//STRIP001 	pModel = NULL;
//STRIP001 
//STRIP001 	if ( bSdrMode )
//STRIP001 		InitSdrModel();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::InitSdrModel()
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard (Application::GetSolarMutex());
//STRIP001 
//STRIP001 	SdrPage* pPage;
//STRIP001 
//STRIP001 	// alten Kram zerstoeren
//STRIP001 	delete pView;
//STRIP001 	delete pModel;
//STRIP001 
//STRIP001 	// Model anlegen
//STRIP001 	pModel = new SdrModel;
//STRIP001 	pModel->GetItemPool().FreezeIdRanges();
//STRIP001 	pModel->SetScaleUnit( aMap100.GetMapUnit() );
//STRIP001 	pModel->SetScaleFraction( Fraction( 1, 1 ) );
//STRIP001 	pModel->SetDefaultFontHeight( 500 );
//STRIP001 
//STRIP001 	pPage = new SdrPage( *pModel );
//STRIP001 
//STRIP001 	pPage->SetSize( aGraphSize );
//STRIP001 	pPage->SetBorder( 0, 0, 0, 0 );
//STRIP001 	pModel->InsertPage( pPage );
//STRIP001 	pModel->SetChanged( FALSE );
//STRIP001 
//STRIP001 	// View anlegen
//STRIP001 	pView = new GraphCtrlView( pModel, this );
//STRIP001 	pView->SetWorkArea( Rectangle( Point(), aGraphSize ) );
//STRIP001 	pView->SetHlplVisible( FALSE );
//STRIP001 	pView->SetGridVisible( FALSE );
//STRIP001 	pView->SetBordVisible( FALSE );
//STRIP001 	pView->SetPageVisible( FALSE );
//STRIP001 	pView->EnableExtendedMouseEventDispatcher( TRUE );
//STRIP001 	pView->ShowPagePgNum( 0, Point() );
//STRIP001 	pView->SetFrameDragSingles( TRUE );
//STRIP001 	pView->SetMarkedPointsSmooth( SDRPATHSMOOTH_SYMMETRIC );
//STRIP001 	pView->SetEditMode( TRUE );
//STRIP001 
//STRIP001     // Tell the accessibility object about the changes.
//STRIP001     if (mpAccContext != NULL)
//STRIP001         mpAccContext->setModelAndView (pModel, pView);
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::SetGraphic( const Graphic& rGraphic, BOOL bNewModel )
//STRIP001 {
//STRIP001 	// Bitmaps dithern wir ggf. fuer die Anzeige
//STRIP001 	if ( !bAnim && ( rGraphic.GetType() == GRAPHIC_BITMAP )  )
//STRIP001 	{
//STRIP001 		if ( rGraphic.IsTransparent() )
//STRIP001 		{
//STRIP001 			Bitmap	aBmp( rGraphic.GetBitmap() );
//STRIP001 
//STRIP001 			DitherBitmap( aBmp );
//STRIP001 			aGraphic = Graphic( BitmapEx( aBmp, rGraphic.GetBitmapEx().GetMask() ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Bitmap aBmp( rGraphic.GetBitmap() );
//STRIP001 			DitherBitmap( aBmp );
//STRIP001 			aGraphic = aBmp;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aGraphic = rGraphic;
//STRIP001 
//STRIP001 	if ( aGraphic.GetPrefMapMode().GetMapUnit() == MAP_PIXEL )
//STRIP001 		aGraphSize = Application::GetDefaultDevice()->PixelToLogic( aGraphic.GetPrefSize(), aMap100 );
//STRIP001 	else
//STRIP001 		aGraphSize = OutputDevice::LogicToLogic( aGraphic.GetPrefSize(), aGraphic.GetPrefMapMode(), aMap100 );
//STRIP001 
//STRIP001 	if ( bSdrMode && bNewModel )
//STRIP001 		InitSdrModel();
//STRIP001 
//STRIP001 	if ( aGraphSizeLink.IsSet() )
//STRIP001 		aGraphSizeLink.Call( this );
//STRIP001 
//STRIP001 	Resize();
//STRIP001 	Invalidate();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::Resize()
//STRIP001 {
//STRIP001 	Control::Resize();
//STRIP001 
//STRIP001 	if ( aGraphSize.Width() && aGraphSize.Height() )
//STRIP001 	{
//STRIP001 		MapMode			aDisplayMap( aMap100 );
//STRIP001 		Point           aNewPos;
//STRIP001 		Size			aNewSize;
//STRIP001 		const Size		aWinSize = PixelToLogic( GetOutputSizePixel(), aDisplayMap );
//STRIP001 		const long		nWidth = aWinSize.Width();
//STRIP001 		const long		nHeight = aWinSize.Height();
//STRIP001 		double          fGrfWH = (double) aGraphSize.Width() / aGraphSize.Height();
//STRIP001 		double          fWinWH = (double) nWidth / nHeight;
//STRIP001 
//STRIP001 		// Bitmap an Thumbgroesse anpassen
//STRIP001 		if ( fGrfWH < fWinWH)
//STRIP001 		{
//STRIP001 			aNewSize.Width() = (long) ( (double) nHeight * fGrfWH );
//STRIP001 			aNewSize.Height()= nHeight;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aNewSize.Width() = nWidth;
//STRIP001 			aNewSize.Height()= (long) ( (double) nWidth / fGrfWH );
//STRIP001 		}
//STRIP001 
//STRIP001 		aNewPos.X() = ( nWidth - aNewSize.Width() )  >> 1;
//STRIP001 		aNewPos.Y() = ( nHeight - aNewSize.Height() ) >> 1;
//STRIP001 
//STRIP001 		// MapMode fuer Engine umsetzen
//STRIP001 		aDisplayMap.SetScaleX( Fraction( aNewSize.Width(), aGraphSize.Width() ) );
//STRIP001 		aDisplayMap.SetScaleY( Fraction( aNewSize.Height(), aGraphSize.Height() ) );
//STRIP001 
//STRIP001 		aDisplayMap.SetOrigin( LogicToLogic( aNewPos, aMap100, aDisplayMap ) );
//STRIP001 		SetMapMode( aDisplayMap );
//STRIP001 	}
//STRIP001 
//STRIP001 	Invalidate();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	if ( aGraphic.GetType() != GRAPHIC_NONE )
//STRIP001 		aGraphic.Draw( this, Point(), aGraphSize );
//STRIP001 
//STRIP001 	if ( bSdrMode )
//STRIP001 		pView->InitRedraw( this , Region( rRect ) );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::SdrObjChanged( const SdrObject& rObj )
//STRIP001 {
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::SdrObjCreated( const SdrObject& rObj )
//STRIP001 {
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::MarkListHasChanged()
//STRIP001 {
//STRIP001 	if ( aMarkObjLink.IsSet() )
//STRIP001 		aMarkObjLink.Call( this );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	KeyCode aCode( rKEvt.GetKeyCode() );
//STRIP001 	BOOL	bProc = FALSE;
//STRIP001 
//STRIP001 	switch ( aCode.GetCode() )
//STRIP001 	{
//STRIP001 		case KEY_DELETE:
//STRIP001 		case KEY_BACKSPACE:
//STRIP001 		{
//STRIP001 			if ( bSdrMode )
//STRIP001 			{
//STRIP001 				pView->DeleteMarked();
//STRIP001 				bProc = TRUE;
//STRIP001 				if( !pView->HasMarkedObj() )
//STRIP001 					((Dialog*)GetParent())->GrabFocusToFirstControl();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		{
//STRIP001 			if ( bSdrMode )
//STRIP001 			{
//STRIP001 				if ( pView->IsAction() )
//STRIP001 				{
//STRIP001 					pView->BrkAction();
//STRIP001 				}
//STRIP001 				else if ( pView->HasMarkedObj() )
//STRIP001 				{
//STRIP001 					const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 					SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 					if(pHdl)
//STRIP001 					{
//STRIP001 						((SdrHdlList&)rHdlList).ResetFocusHdl();
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						((Dialog*)GetParent())->GrabFocusToFirstControl();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					((Dialog*)GetParent())->GrabFocusToFirstControl();
//STRIP001 				}
//STRIP001 				bProc = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_F11:
//STRIP001 		case KEY_TAB:
//STRIP001 		{
//STRIP001 			if( bSdrMode )
//STRIP001 			{
//STRIP001 				if( !aCode.IsMod1() && !aCode.IsMod2() )
//STRIP001 				{
//STRIP001 					bool bForward = !aCode.IsShift();
//STRIP001 					// select next object
//STRIP001 					if ( ! pView->MarkNextObj( bForward ))
//STRIP001                     {
//STRIP001                         // At first or last object.  Cycle to the other end
//STRIP001                         // of the list.
//STRIP001                         pView->UnmarkAllObj();
//STRIP001                         pView->MarkNextObj (bForward);
//STRIP001                     }
//STRIP001 					bProc = TRUE;
//STRIP001 				}
//STRIP001 				else if(aCode.IsMod1())
//STRIP001 				{
//STRIP001 					// select next handle
//STRIP001 					const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 					sal_Bool bForward(!aCode.IsShift());
//STRIP001 
//STRIP001 					((SdrHdlList&)rHdlList).TravelFocusHdl(bForward);
//STRIP001 
//STRIP001 					bProc = true;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_END:
//STRIP001 		{
//STRIP001 
//STRIP001 			if ( aCode.IsMod1() )
//STRIP001 			{
//STRIP001 				// #97016# mark last object
//STRIP001 				pView->UnmarkAllObj();
//STRIP001 				pView->MarkNextObj(FALSE);
//STRIP001 
//STRIP001 				bProc = true;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_HOME:
//STRIP001 		{
//STRIP001 			if ( aCode.IsMod1() )
//STRIP001 			{
//STRIP001 				pView->UnmarkAllObj();
//STRIP001 				pView->MarkNextObj(TRUE);
//STRIP001 
//STRIP001 				bProc = true;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_UP:
//STRIP001 		case KEY_DOWN:
//STRIP001 		case KEY_LEFT:
//STRIP001 		case KEY_RIGHT:
//STRIP001 		{
//STRIP001 			long nX = 0;
//STRIP001 			long nY = 0;
//STRIP001 
//STRIP001 			if (aCode.GetCode() == KEY_UP)
//STRIP001 			{
//STRIP001 				// Scroll nach oben
//STRIP001 				nX = 0;
//STRIP001 				nY =-1;
//STRIP001 			}
//STRIP001 			else if (aCode.GetCode() == KEY_DOWN)
//STRIP001 			{
//STRIP001 				// Scroll nach unten
//STRIP001 				nX = 0;
//STRIP001 				nY = 1;
//STRIP001 			}
//STRIP001 			else if (aCode.GetCode() == KEY_LEFT)
//STRIP001 			{
//STRIP001 				// Scroll nach links
//STRIP001 				nX =-1;
//STRIP001 				nY = 0;
//STRIP001 			}
//STRIP001 			else if (aCode.GetCode() == KEY_RIGHT)
//STRIP001 			{
//STRIP001 				// Scroll nach rechts
//STRIP001 				nX = 1;
//STRIP001 				nY = 0;
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pView->HasMarkedObj() && !aCode.IsMod1() )
//STRIP001 			{
//STRIP001 				if(aCode.IsMod2())
//STRIP001 				{
//STRIP001 					// #97016# move in 1 pixel distance
//STRIP001 					Size aLogicSizeOnePixel = PixelToLogic(Size(1,1));
//STRIP001 					nX *= aLogicSizeOnePixel.Width();
//STRIP001 					nY *= aLogicSizeOnePixel.Height();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// old, fixed move distance
//STRIP001 					nX *= 100;
//STRIP001 					nY *= 100;
//STRIP001 				}
//STRIP001 
//STRIP001 				// #97016# II
//STRIP001 				const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 				SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 				if(0L == pHdl)
//STRIP001 				{
//STRIP001 					// #90129# restrict movement to WorkArea
//STRIP001 					const Rectangle& rWorkArea = pView->GetWorkArea();
//STRIP001 
//STRIP001 					if(!rWorkArea.IsEmpty())
//STRIP001 					{
//STRIP001 						Rectangle aMarkRect(pView->GetMarkedObjRect());
//STRIP001 						aMarkRect.Move(nX, nY);
//STRIP001 
//STRIP001 						if(!aMarkRect.IsInside(rWorkArea))
//STRIP001 						{
//STRIP001 							if(aMarkRect.Left() < rWorkArea.Left())
//STRIP001 							{
//STRIP001 								nX += rWorkArea.Left() - aMarkRect.Left();
//STRIP001 							}
//STRIP001 
//STRIP001 							if(aMarkRect.Right() > rWorkArea.Right())
//STRIP001 							{
//STRIP001 								nX -= aMarkRect.Right() - rWorkArea.Right();
//STRIP001 							}
//STRIP001 
//STRIP001 							if(aMarkRect.Top() < rWorkArea.Top())
//STRIP001 							{
//STRIP001 								nY += rWorkArea.Top() - aMarkRect.Top();
//STRIP001 							}
//STRIP001 
//STRIP001 							if(aMarkRect.Bottom() > rWorkArea.Bottom())
//STRIP001 							{
//STRIP001 								nY -= aMarkRect.Bottom() - rWorkArea.Bottom();
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					// no handle selected
//STRIP001 					if(0 != nX || 0 != nY)
//STRIP001 					{
//STRIP001 						pView->MoveAllMarked(Size(nX, nY));
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// move handle with index nHandleIndex
//STRIP001 					if(pHdl && (nX || nY))
//STRIP001 					{
//STRIP001 						// now move the Handle (nX, nY)
//STRIP001 						Point aStartPoint(pHdl->GetPos());
//STRIP001 						Point aEndPoint(pHdl->GetPos() + Point(nX, nY));
//STRIP001 						const SdrDragStat& rDragStat = pView->GetDragStat();
//STRIP001 
//STRIP001 						// start dragging
//STRIP001 						pView->BegDragObj(aStartPoint, 0, pHdl, 0);
//STRIP001 
//STRIP001 					    if(pView->IsDragObj())
//STRIP001 						{
//STRIP001 							FASTBOOL bWasNoSnap = rDragStat.IsNoSnap();
//STRIP001 							BOOL bWasSnapEnabled = pView->IsSnapEnabled();
//STRIP001 
//STRIP001 							// switch snapping off
//STRIP001 							if(!bWasNoSnap)
//STRIP001 								((SdrDragStat&)rDragStat).SetNoSnap(TRUE);
//STRIP001 							if(bWasSnapEnabled)
//STRIP001 								pView->SetSnapEnabled(FALSE);
//STRIP001 
//STRIP001 							pView->MovAction(aEndPoint);
//STRIP001 							pView->EndDragObj();
//STRIP001 						
//STRIP001 							// restore snap
//STRIP001 							if(!bWasNoSnap)
//STRIP001 								((SdrDragStat&)rDragStat).SetNoSnap(bWasNoSnap);
//STRIP001 							if(bWasSnapEnabled)
//STRIP001 								pView->SetSnapEnabled(bWasSnapEnabled);
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				bProc = true;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_SPACE:
//STRIP001 		{
//STRIP001 			const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 			SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 			if(pHdl)
//STRIP001 			{
//STRIP001 				if(pHdl->GetKind() == HDL_POLY)
//STRIP001 				{
//STRIP001 					// rescue ID of point with focus
//STRIP001 					sal_uInt16 nPol(pHdl->GetPolyNum());
//STRIP001 					sal_uInt16 nPnt(pHdl->GetPointNum());
//STRIP001 					
//STRIP001 					if(pView->IsPointMarked(*pHdl))
//STRIP001 					{
//STRIP001 						if(rKEvt.GetKeyCode().IsShift())
//STRIP001 						{
//STRIP001 							pView->UnmarkPoint(*pHdl);
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if(!rKEvt.GetKeyCode().IsShift())
//STRIP001 						{
//STRIP001 							pView->UnmarkAllPoints();
//STRIP001 						}
//STRIP001 
//STRIP001 						pView->MarkPoint(*pHdl);
//STRIP001 					}
//STRIP001 		
//STRIP001 					if(0L == rHdlList.GetFocusHdl())
//STRIP001 					{
//STRIP001 						// restore point with focus
//STRIP001 						SdrHdl* pNewOne = 0L;
//STRIP001 
//STRIP001 						for(sal_uInt32 a(0); !pNewOne && a < rHdlList.GetHdlCount(); a++)
//STRIP001 						{
//STRIP001 							SdrHdl* pAct = rHdlList.GetHdl(a);
//STRIP001 							
//STRIP001 							if(pAct 
//STRIP001 								&& pAct->GetKind() == HDL_POLY 
//STRIP001 								&& pAct->GetPolyNum() == nPol
//STRIP001 								&& pAct->GetPointNum() == nPnt)
//STRIP001 							{
//STRIP001 								pNewOne = pAct;
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						if(pNewOne)
//STRIP001 						{
//STRIP001 							((SdrHdlList&)rHdlList).SetFocusHdl(pNewOne);
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					bProc = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bProc )
//STRIP001 		Control::KeyInput( rKEvt );
//STRIP001 	else
//STRIP001 		ReleaseMouse();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if ( bSdrMode && ( rMEvt.GetClicks() < 2 ) )
//STRIP001 	{
//STRIP001 		const Point aLogPt( PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 		if ( !Rectangle( Point(), aGraphSize ).IsInside( aLogPt ) && !pView->IsEditMode() )
//STRIP001 			Control::MouseButtonDown( rMEvt );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Focus anziehen fuer Key-Inputs
//STRIP001 			GrabFocus();
//STRIP001 
//STRIP001 			if ( nPolyEdit )
//STRIP001 			{
//STRIP001 				SdrViewEvent	aVEvt;
//STRIP001 				SdrHitKind		eHit = pView->PickAnything( rMEvt, SDRMOUSEBUTTONDOWN, aVEvt );
//STRIP001 
//STRIP001 				if ( nPolyEdit == SID_BEZIER_INSERT && eHit == SDRHIT_MARKEDOBJECT )
//STRIP001 					pView->BegInsObjPoint( aLogPt, rMEvt.IsMod1(), NULL, 0 );
//STRIP001 				else
//STRIP001 					pView->MouseButtonDown( rMEvt, this );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pView->MouseButtonDown( rMEvt, this );
//STRIP001 		}
//STRIP001 
//STRIP001 		SdrObject* pCreateObj = pView->GetCreateObj();
//STRIP001 
//STRIP001 		// Wir wollen das Inserten mitbekommen
//STRIP001 		if ( pCreateObj && !pCreateObj->GetUserCall() )
//STRIP001 			pCreateObj->SetUserCall( pUserCall );
//STRIP001 
//STRIP001 		SetPointer( pView->GetPreferedPointer( aLogPt, this ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Control::MouseButtonDown( rMEvt );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	const Point	aLogPos( PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 	if ( bSdrMode )
//STRIP001 	{
//STRIP001 		pView->MouseMove( rMEvt, this );
//STRIP001 
//STRIP001 		if( ( SID_BEZIER_INSERT == nPolyEdit ) &&
//STRIP001 			!pView->HitHandle( aLogPos, *this ) &&
//STRIP001 			!pView->IsInsObjPoint() )
//STRIP001 		{
//STRIP001 			SetPointer( POINTER_CROSS );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			SetPointer( pView->GetPreferedPointer( aLogPos, this ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Control::MouseButtonUp( rMEvt );
//STRIP001 
//STRIP001 	if ( aMousePosLink.IsSet() )
//STRIP001 	{
//STRIP001 		if ( Rectangle( Point(), aGraphSize ).IsInside( aLogPos ) )
//STRIP001 			aMousePos = aLogPos;
//STRIP001 		else
//STRIP001 			aMousePos = Point();
//STRIP001 
//STRIP001 		aMousePosLink.Call( this );
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if ( bSdrMode )
//STRIP001 	{
//STRIP001 		if ( pView->IsInsObjPoint() )
//STRIP001 			pView->EndInsObjPoint( SDRCREATE_FORCEEND );
//STRIP001 		else
//STRIP001 			pView->MouseButtonUp( rMEvt, this );
//STRIP001 
//STRIP001 		ReleaseMouse();
//STRIP001 		SetPointer( pView->GetPreferedPointer( PixelToLogic( rMEvt.GetPosPixel() ), this ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Control::MouseButtonUp( rMEvt );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SdrObject* GraphCtrl::GetSelectedSdrObject() const
//STRIP001 {
//STRIP001 	SdrObject* pSdrObj = NULL;
//STRIP001 
//STRIP001 	if ( bSdrMode )
//STRIP001 	{
//STRIP001 		const SdrMarkList&	rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 		if ( rMarkList.GetMarkCount() == 1 )
//STRIP001 			pSdrObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 	}
//STRIP001 
//STRIP001 	return pSdrObj;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::SetEditMode( const BOOL _bEditMode )
//STRIP001 {
//STRIP001 	if ( bSdrMode )
//STRIP001 	{
//STRIP001 		pView->SetEditMode( bEditMode = _bEditMode );
//STRIP001 		pView->SetCurrentObj( eObjKind = OBJ_NONE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bEditMode = FALSE;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::SetPolyEditMode( const USHORT _nPolyEdit )
//STRIP001 {
//STRIP001 	if ( bSdrMode && ( _nPolyEdit != nPolyEdit ) )
//STRIP001 	{
//STRIP001 		nPolyEdit = _nPolyEdit;
//STRIP001 		pView->SetFrameDragSingles( nPolyEdit == 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nPolyEdit = 0;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void GraphCtrl::SetObjKind( const SdrObjKind _eObjKind )
//STRIP001 {
//STRIP001 	if ( bSdrMode )
//STRIP001 	{
//STRIP001 		pView->SetEditMode( bEditMode = FALSE );
//STRIP001 		pView->SetCurrentObj( eObjKind = _eObjKind );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		eObjKind = OBJ_NONE;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 String GraphCtrl::GetStringFromDouble( const double& rDouble )
//STRIP001 {
//STRIP001     sal_Unicode cSep =
//STRIP001         SvtSysLocale().GetLocaleData().getNumDecimalSep().GetChar(0);
//STRIP001     String aStr( ::rtl::math::doubleToUString( rDouble,
//STRIP001                 rtl_math_StringFormat_F, 2, cSep ));
//STRIP001     return aStr;
//STRIP001 }


/*************************************************************************
www|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( GraphCtrl, UpdateHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	if ( aUpdateLink.IsSet() )
//STRIP001 		aUpdateLink.Call( this );
//STRIP001 
//STRIP001 	pTimer->Start();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > GraphCtrl::CreateAccessible()
//STRIP001 {
//STRIP001 	if( mpAccContext == NULL )
//STRIP001 	{
//STRIP001 		Window* pParent = GetParent();
//STRIP001 
//STRIP001 		DBG_ASSERT( pParent, "-GraphCtrl::CreateAccessible(): No Parent!" );
//STRIP001 
//STRIP001 		if( pParent )
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > xAccParent( pParent->GetAccessible() );
//STRIP001 
//STRIP001             // #103856# Disable accessibility if no model/view data available
//STRIP001 			if( pView &&                
//STRIP001                 pModel &&
//STRIP001                 xAccParent.is() )
//STRIP001 			{
//STRIP001 				mpAccContext = new SvxGraphCtrlAccessibleContext( xAccParent, *this );
//STRIP001 				mpAccContext->acquire();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return mpAccContext;
//STRIP001 }
}
