/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_viewprn.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:55:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef OS2
// auto strip #include <vcl/sysdep.hxx>
#endif

// auto strip #ifndef _COM_SUN_STAR_VIEW_PRINTABLESTATE_HPP_
// auto strip #include <com/sun/star/view/PrintableState.hpp>
// auto strip #endif

// auto strip #ifndef _SFXITEMPOOL_HXX //autogen
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif
// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_PRINTDLG_HXX //autogen
// auto strip #include <svtools/printdlg.hxx>
// auto strip #endif
// auto strip #ifndef _SV_PRNSETUP_HXX //autogen
// auto strip #include <svtools/prnsetup.hxx>
// auto strip #endif
// auto strip #ifndef _SFXFLAGITEM_HXX //autogen
// auto strip #include <svtools/flagitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <app.hxx>
// auto strip #endif
// auto strip #include <svtools/useroptions.hxx>
// auto strip #include <svtools/printwarningoptions.hxx>
#pragma hdrstop

// auto strip #include "viewsh.hxx"
// auto strip #include "viewimp.hxx"
// auto strip #include "viewfrm.hxx"
// auto strip #include "prnmon.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "request.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "docinf.hxx"
#include "event.hxx"
// auto strip #include "docfile.hxx"
// auto strip #include "docfilt.hxx"

#include "view.hrc"
#include "helpid.hrc"
namespace binfilter {

/*N*/ TYPEINIT1(SfxPrintingHint, SfxHint);

// -----------------------------------------------------------------------

//STRIP001 void DisableRanges( PrintDialog& rDlg, SfxPrinter* pPrinter )
//STRIP001 
//STRIP001 /*      [Beschreibung]
//STRIP001 
//STRIP001 	Mit dieser Funktion werden die nicht verf"ugbaren Ranges
//STRIP001 	vom Printer zum PrintDialog geforwarded.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( !pPrinter )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( !pPrinter->IsRangeEnabled( PRINTDIALOG_ALL ) )
//STRIP001 		rDlg.DisableRange( PRINTDIALOG_ALL );
//STRIP001 	if ( !pPrinter->IsRangeEnabled( PRINTDIALOG_SELECTION ) )
//STRIP001 		rDlg.DisableRange( PRINTDIALOG_SELECTION );
//STRIP001 	if ( !pPrinter->IsRangeEnabled( PRINTDIALOG_FROMTO ) )
//STRIP001 		rDlg.DisableRange( PRINTDIALOG_FROMTO );
//STRIP001 	if ( !pPrinter->IsRangeEnabled( PRINTDIALOG_RANGE ) )
//STRIP001 		rDlg.DisableRange( PRINTDIALOG_RANGE );
//STRIP001 }
//STRIP001 
//STRIP001 //====================================================================
//STRIP001 
//STRIP001 class SfxDialogExecutor_Impl
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Eine Instanz dieser Klasse wird f"ur die Laufzeit des Printer-Dialogs
//STRIP001 	erzeugt, um im dessen Click-Handler f"ur die Zus"atze den per
//STRIP001 	virtueller Methode von der abgeleiteten SfxViewShell erzeugten
//STRIP001 	Print-Options-Dialog zu erzeugen und die dort eingestellten Optionen
//STRIP001 	als SfxItemSet zu zwischenzuspeichern.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 private:
//STRIP001 	SfxViewShell*           _pViewSh;
//STRIP001 	PrintDialog*            _pParent;
//STRIP001 	SfxItemSet*             _pOptions;
//STRIP001 	sal_Bool                _bModified;
//STRIP001 	sal_Bool				_bHelpDisabled;
//STRIP001 
//STRIP001 	DECL_LINK( Execute, void * );
//STRIP001 
//STRIP001 public:
//STRIP001 			SfxDialogExecutor_Impl( SfxViewShell* pViewSh, PrintDialog* pParent );
//STRIP001 			~SfxDialogExecutor_Impl() { delete _pOptions; }
//STRIP001 
//STRIP001 	Link				GetLink() const { return LINK( this, SfxDialogExecutor_Impl, Execute); }
//STRIP001 	const SfxItemSet*	GetOptions() const { return _pOptions; }
//STRIP001 	void				DisableHelp() { _bHelpDisabled = sal_True; }
//STRIP001 };
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDialogExecutor_Impl::SfxDialogExecutor_Impl( SfxViewShell* pViewSh, PrintDialog* pParent ) :
//STRIP001 
//STRIP001 	_pViewSh		( pViewSh ),
//STRIP001 	_pParent		( pParent ),
//STRIP001 	_pOptions		( NULL ),
//STRIP001 	_bModified		( sal_False ),
//STRIP001 	_bHelpDisabled	( sal_False )
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxDialogExecutor_Impl, Execute, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	// Options lokal merken
//STRIP001 	if ( !_pOptions )
//STRIP001 		_pOptions = ( (SfxPrinter*)_pParent->GetPrinter() )->GetOptions().Clone();
//STRIP001 
//STRIP001 	// Dialog ausf"uhren
//STRIP001 	SfxPrintOptionsDialog* pDlg = new SfxPrintOptionsDialog( _pParent, _pViewSh, _pOptions );
//STRIP001 	if ( _bHelpDisabled )
//STRIP001 		pDlg->DisableHelp();
//STRIP001 	if ( pDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		delete _pOptions;
//STRIP001 		_pOptions = pDlg->GetOptions().Clone();
//STRIP001 	}
//STRIP001 	delete pDlg;
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL UseStandardPrinter_Impl( Window *pParent, SfxPrinter *pDocPrinter )
//STRIP001 {
//STRIP001 	// Optionen abfragen, ob gewarnt werden soll (Doc uebersteuert App)
//STRIP001 	BOOL bWarn = FALSE;
//STRIP001 	SfxApplication *pSfxApp = SFX_APP();
//STRIP001 	const SfxItemSet *pDocOptions = &pDocPrinter->GetOptions();
//STRIP001 	if ( pDocOptions )
//STRIP001 	{
//STRIP001 		USHORT nWhich = pDocOptions->GetPool()->GetWhich(SID_PRINTER_NOTFOUND_WARN);
//STRIP001 		const SfxBoolItem* pBoolItem = NULL;
//STRIP001 		pDocPrinter->GetOptions().GetItemState( nWhich, FALSE, (const SfxPoolItem**) &pBoolItem );
//STRIP001 		if ( pBoolItem )
//STRIP001 			bWarn = pBoolItem->GetValue();
//STRIP001 	}
//STRIP001 /*
//STRIP001 	// ggf. den User fragen
//STRIP001 	if ( bWarn )
//STRIP001 	{
//STRIP001 		// Geht nicht mehr ohne OrigJobSetup!
//STRIP001 		String aTmp( SfxResId( STR_PRINTER_NOTAVAIL ) );
//STRIP001 #if SUPD<532
//STRIP001 		aTmp.SearchAndReplace( "$1",
//STRIP001 				pDocPrinter->GetOrigJobSetup().GetPrinterName() );
//STRIP001 		aTmp.SearchAndReplace( "$2", pDocPrinter->GetName() );
//STRIP001 #endif
//STRIP001 		QueryBox aBox( pParent, WB_OK_CANCEL | WB_DEF_OK, aTmp );
//STRIP001 		return RET_OK == aBox.Execute();
//STRIP001 	}
//STRIP001 */
//STRIP001 	// nicht gewarnt => einfach so den StandardDrucker nehmen
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxPrinter* SfxViewShell::SetPrinter_Impl( SfxPrinter *pNewPrinter )
//STRIP001 
//STRIP001 /*  Interne Methode zum Setzen der Unterschiede von 'pNewPrinter' zum
//STRIP001 	aktuellen Printer. pNewPrinter wird entweder "ubernommen oder gel"oscht.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// aktuellen Printer holen
//STRIP001 	SfxPrinter *pDocPrinter = GetPrinter();
//STRIP001 
//STRIP001 	// Printer-Options auswerten
//STRIP001 	FASTBOOL bOriToDoc = FALSE;
//STRIP001 	FASTBOOL bSizeToDoc = FALSE;
//STRIP001 	if ( &pDocPrinter->GetOptions() )
//STRIP001 	{
//STRIP001         USHORT nWhich = GetPool().GetWhich(SID_PRINTER_CHANGESTODOC);
//STRIP001         const SfxFlagItem *pFlagItem = 0;
//STRIP001         pDocPrinter->GetOptions().GetItemState( nWhich, FALSE, (const SfxPoolItem**) &pFlagItem );
//STRIP001         bOriToDoc = pFlagItem ? (pFlagItem->GetValue() & SFX_PRINTER_CHG_ORIENTATION) : FALSE;
//STRIP001         bSizeToDoc = pFlagItem ? (pFlagItem->GetValue() & SFX_PRINTER_CHG_SIZE) : FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// vorheriges Format und Size feststellen
//STRIP001 	Orientation eOldOri = pDocPrinter->GetOrientation();
//STRIP001 	Size aOldPgSz = pDocPrinter->GetPaperSizePixel();
//STRIP001 
//STRIP001 	// neues Format und Size feststellen
//STRIP001 	Orientation eNewOri = pNewPrinter->GetOrientation();
//STRIP001 	Size aNewPgSz = pNewPrinter->GetPaperSizePixel();
//STRIP001 
//STRIP001 	// "Anderungen am Seitenformat feststellen
//STRIP001 	BOOL bOriChg = (eOldOri != eNewOri) && bOriToDoc;
//STRIP001 	BOOL bPgSzChg = ( aOldPgSz.Height() !=
//STRIP001 			( bOriChg ? aNewPgSz.Width() : aNewPgSz.Height() ) ||
//STRIP001 			aOldPgSz.Width() !=
//STRIP001 			( bOriChg ? aNewPgSz.Height() : aNewPgSz.Width() ) ) &&
//STRIP001 			bSizeToDoc;
//STRIP001 
//STRIP001 	// Message und Flags f"ur Seitenformat-"Anderung zusammenstellen
//STRIP001 	String aMsg;
//STRIP001 	USHORT nNewOpt=0;
//STRIP001 	if( bOriChg && bPgSzChg )
//STRIP001 	{
//STRIP001         aMsg = String(SfxResId(STR_PRINT_NEWORISIZE));
//STRIP001         nNewOpt = SFX_PRINTER_CHG_ORIENTATION | SFX_PRINTER_CHG_SIZE;
//STRIP001 	}
//STRIP001 	else if (bOriChg )
//STRIP001 	{
//STRIP001         aMsg = String(SfxResId(STR_PRINT_NEWORI));
//STRIP001         nNewOpt = SFX_PRINTER_CHG_ORIENTATION;
//STRIP001 	}
//STRIP001 	else if (bPgSzChg)
//STRIP001 	{
//STRIP001         aMsg = String(SfxResId(STR_PRINT_NEWSIZE));
//STRIP001         nNewOpt = SFX_PRINTER_CHG_SIZE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// in dieser Variable sammeln, was sich so ge"aendert hat
//STRIP001 	USHORT nChangedFlags = 0;
//STRIP001 
//STRIP001 	// ggf. Nachfrage, ob Seitenformat vom Drucker "ubernommen werden soll
//STRIP001 	if ( ( bOriChg  || bPgSzChg ) &&
//STRIP001 		RET_YES == QueryBox(0, WB_YES_NO | WB_DEF_OK, aMsg).Execute() )
//STRIP001 	// Flags mit "Anderungen f"ur <SetPrinter(SfxPrinter*)> mitpflegen
//STRIP001 	nChangedFlags |= nNewOpt;
//STRIP001 
//STRIP001 	// fuer den MAC sein "temporary of class String" im naechsten if()
//STRIP001 	String aTempPrtName = pNewPrinter->GetName();
//STRIP001 	String aDocPrtName = pDocPrinter->GetName();
//STRIP001 
//STRIP001 	// Wurde der Drucker gewechselt oder von Default auf Specific
//STRIP001 	// oder umgekehrt geaendert?
//STRIP001     if ( (aTempPrtName != aDocPrtName) || (pDocPrinter->IsDefPrinter() != pNewPrinter->IsDefPrinter()) )
//STRIP001 	{
//STRIP001         // neuen Printer "ubernehmen
//STRIP001         // pNewPrinter->SetOrigJobSetup( pNewPrinter->GetJobSetup() );
//STRIP001         nChangedFlags |= SFX_PRINTER_PRINTER|SFX_PRINTER_JOBSETUP;
//STRIP001         pDocPrinter = pNewPrinter;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         // Extra-Optionen vergleichen
//STRIP001         if ( ! (pNewPrinter->GetOptions() == pDocPrinter->GetOptions()) )
//STRIP001         {
//STRIP001             // Options haben sich geaendert
//STRIP001             pDocPrinter->SetOptions( pNewPrinter->GetOptions() );
//STRIP001             nChangedFlags |= SFX_PRINTER_OPTIONS;
//STRIP001         }
//STRIP001 
//STRIP001         // JobSetups vergleichen
//STRIP001         JobSetup aNewJobSetup = pNewPrinter->GetJobSetup();
//STRIP001         JobSetup aOldJobSetup = pDocPrinter->GetJobSetup();
//STRIP001         if ( aNewJobSetup != aOldJobSetup )
//STRIP001         {
//STRIP001             // JobSetup hat sich geaendert (=> App mu\s neu formatieren)
//STRIP001             // pDocPrinter->SetOrigJobSetup( aNewJobSetup );
//STRIP001             nChangedFlags |= SFX_PRINTER_JOBSETUP;
//STRIP001         }
//STRIP001 
//STRIP001         // alten, ver"anderten Printer behalten
//STRIP001         pDocPrinter->SetPrinterProps( pNewPrinter );
//STRIP001         delete pNewPrinter;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( 0 != nChangedFlags )
//STRIP001         // SetPrinter will delete the old printer if it changes
//STRIP001         SetPrinter( pDocPrinter, nChangedFlags );
//STRIP001 	return pDocPrinter;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 // Unter WIN32 tritt leider das Problem auf, dass nichts gedruckt
//STRIP001 // wird, wenn SID_PRINTDOCDIRECT auflaueft; bisher bekannte,
//STRIP001 // einzige Abhilfe ist in diesem Fall das Abschalten der Optimierungen
//STRIP001 // (KA 17.12.95)
//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", off )
//STRIP001 #endif
//STRIP001 
//STRIP001 void SfxViewShell::ExecPrint_Impl( SfxRequest &rReq )
//STRIP001 {
//STRIP001 	USHORT                  nCopies=1, nPaperBin = 0, nDialogRet = RET_CANCEL;
//STRIP001 	BOOL                    bCollate=FALSE;
//STRIP001 	SfxPrinter*             pPrinter = 0;
//STRIP001 	PrintDialog*            pPrintDlg = 0;
//STRIP001 	SfxDialogExecutor_Impl* pExecutor = 0;
//STRIP001 	FASTBOOL                bSilent = FALSE;
//STRIP001     BOOL bIsAPI = rReq.GetArgs() && rReq.GetArgs()->Count();
//STRIP001 
//STRIP001 	const USHORT nId = rReq.GetSlot();
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//STRIP001 
//STRIP001 	case SID_PRINTDOC:
//STRIP001 	case SID_SETUPPRINTER:
//STRIP001     case SID_PRINTER_NAME :
//STRIP001 	{
//STRIP001         // quiet mode (AppEvent, API call)
//STRIP001 		SFX_REQUEST_ARG(rReq, pSilentItem, SfxBoolItem, SID_SILENT, FALSE);
//STRIP001 		bSilent = pSilentItem ? pSilentItem->GetValue() : FALSE;
//STRIP001 
//STRIP001         // get printer and printer settings from the document
//STRIP001 		SfxPrinter *pDocPrinter = GetPrinter(TRUE);
//STRIP001 
//STRIP001         // look for printer in parameters
//STRIP001         SFX_REQUEST_ARG( rReq, pPrinterItem, SfxStringItem, SID_PRINTER_NAME, FALSE );
//STRIP001 		if ( pPrinterItem )
//STRIP001 		{
//STRIP001             // use PrinterName parameter to create a printer
//STRIP001             pPrinter = new SfxPrinter( pDocPrinter->GetOptions().Clone(), ((const SfxStringItem*) pPrinterItem)->GetValue() );
//STRIP001 
//STRIP001             // if printer is unknown, it can't be used - now printer from document will be used
//STRIP001 			if ( !pPrinter->IsOriginal() )
//STRIP001 				DELETEZ(pPrinter);
//STRIP001 		}
//STRIP001 
//STRIP001         if ( SID_PRINTER_NAME == nId )
//STRIP001         {
//STRIP001             // just set a recorded printer name
//STRIP001             if ( pPrinter )
//STRIP001                 SetPrinter( pPrinter, SFX_PRINTER_PRINTER  );
//STRIP001             return;
//STRIP001         }
//STRIP001 
//STRIP001         // no PrinterName parameter in ItemSet or the PrinterName points to an unknown printer
//STRIP001         if ( !pPrinter )
//STRIP001             // use default printer from document
//STRIP001 			pPrinter = pDocPrinter;
//STRIP001 
//STRIP001         if( !pPrinter || !pPrinter->IsValid() )
//STRIP001 		{
//STRIP001             // no valid printer either in ItemSet or at the document
//STRIP001             if ( bSilent )
//STRIP001 			{
//STRIP001 			    rReq.SetReturnValue(SfxBoolItem(0,FALSE));
//STRIP001 			    return;
//STRIP001 			}
//STRIP001             else
//STRIP001                 ErrorBox( NULL, WB_OK | WB_DEF_OK, String( SfxResId( STR_NODEFPRINTER ) ) ).Execute();
//STRIP001 		}
//STRIP001 
//STRIP001         if ( !pPrinter->IsOriginal() && rReq.GetArgs() && !UseStandardPrinter_Impl( NULL, pPrinter ) )
//STRIP001 		{
//STRIP001             // printer is not available, but standard printer should not be used
//STRIP001 			rReq.SetReturnValue(SfxBoolItem(0,FALSE));
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pPrinter->IsPrinting() )
//STRIP001 		{
//STRIP001             // if printer is busy, abort printing
//STRIP001             if ( !bSilent )
//STRIP001 				InfoBox( NULL, String( SfxResId( STR_ERROR_PRINTER_BUSY ) ) ).Execute();
//STRIP001 			rReq.SetReturnValue(SfxBoolItem(0,FALSE));
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001         // the print dialog shouldn't use a help button if it is called from the help window
//STRIP001         // (pressing help button would exchange the current page inside the help document that is going to be printed!)
//STRIP001 		String aHelpFilterName( DEFINE_CONST_UNICODE("writer_web_HTML_help") );
//STRIP001 		SfxMedium* pMedium = GetViewFrame()->GetObjectShell()->GetMedium();
//STRIP001 		const SfxFilter* pFilter = pMedium ? pMedium->GetFilter() : NULL;
//STRIP001 		sal_Bool bPrintOnHelp = ( pFilter && pFilter->GetFilterName() == aHelpFilterName );
//STRIP001 
//STRIP001         // if no arguments are given, retrieve them from a dialog
//STRIP001         if ( !bIsAPI )
//STRIP001 		{
//STRIP001             // PrinterDialog needs a temporary printer
//STRIP001 			SfxPrinter* pDlgPrinter = pPrinter->Clone();
//STRIP001 			nDialogRet = 0;
//STRIP001 			if ( SID_PRINTDOC == nId )
//STRIP001 			{
//STRIP001                 // execute PrintDialog
//STRIP001 				pPrintDlg = CreatePrintDialog( NULL );
//STRIP001 				if ( bPrintOnHelp )
//STRIP001 					pPrintDlg->DisableHelp();
//STRIP001 
//STRIP001 				if ( pImp->bHasPrintOptions )
//STRIP001 				{
//STRIP001                     // additional controls for dialog
//STRIP001 					pExecutor = new SfxDialogExecutor_Impl( this, pPrintDlg );
//STRIP001 					if ( bPrintOnHelp )
//STRIP001 						pExecutor->DisableHelp();
//STRIP001 					pPrintDlg->SetOptionsHdl( pExecutor->GetLink() );
//STRIP001 					pPrintDlg->ShowOptionsButton();
//STRIP001 				}
//STRIP001 
//STRIP001                 // set printer on dialog and execute
//STRIP001 				pPrintDlg->SetPrinter( pDlgPrinter );
//STRIP001                 ::DisableRanges( *pPrintDlg, pDlgPrinter );
//STRIP001 				nDialogRet = pPrintDlg->Execute();
//STRIP001 				if ( pExecutor && pExecutor->GetOptions() )
//STRIP001 				{
//STRIP001 					if ( nDialogRet == RET_OK )
//STRIP001                         // remark: have to be recorded if possible!
//STRIP001 						pDlgPrinter->SetOptions( *pExecutor->GetOptions() );
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pPrinter->SetOptions( *pExecutor->GetOptions() );
//STRIP001 						SetPrinter( pPrinter, SFX_PRINTER_OPTIONS );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001                 DELETEZ( pExecutor );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001                 // execute PrinterSetupDialog
//STRIP001                 PrinterSetupDialog* pPrintSetupDlg = new PrinterSetupDialog( GetWindow() );
//STRIP001 				pPrintSetupDlg->SetPrinter( pDlgPrinter );
//STRIP001 				nDialogRet = pPrintSetupDlg->Execute();
//STRIP001                 DELETEZ( pPrintSetupDlg );
//STRIP001 
//STRIP001                 // no recording of PrinterSetup except printer name (is printer dependent)
//STRIP001                 rReq.Ignore();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nDialogRet == RET_OK )
//STRIP001 			{
//STRIP001                 if ( pPrinter->GetName() != pDlgPrinter->GetName() )
//STRIP001                 {
//STRIP001                     // user has changed the printer -> macro recording
//STRIP001                     SfxRequest aReq( GetViewFrame(), SID_PRINTER_NAME );
//STRIP001                     aReq.AppendItem( SfxStringItem( SID_PRINTER_NAME, pDlgPrinter->GetName() ) );
//STRIP001                     aReq.Done();
//STRIP001                 }
//STRIP001 
//STRIP001                 // take the changes made in the dialog
//STRIP001 				pPrinter = SetPrinter_Impl( pDlgPrinter );
//STRIP001 
//STRIP001                 // forget new printer, it was taken over (as pPrinter) or deleted
//STRIP001                 pDlgPrinter = NULL;
//STRIP001 
//STRIP001 				if ( SID_PRINTDOC == nId )
//STRIP001 				{
//STRIP001                     nCopies  = pPrintDlg->GetCopyCount();
//STRIP001                     bCollate = pPrintDlg->IsCollateChecked();
//STRIP001 				}
//STRIP001                 else
//STRIP001                     break;
//STRIP001 			}
//STRIP001 			else
//STRIP001             {
//STRIP001                 // PrinterDialog is used to transfer information on printing,
//STRIP001                 // so it will only be deleted here if dialog was cancelled
//STRIP001                 DELETEZ( pDlgPrinter );
//STRIP001                 DELETEZ( pPrintDlg );
//STRIP001                 rReq.Ignore();
//STRIP001 				if ( SID_PRINTDOC == nId )
//STRIP001                     rReq.SetReturnValue(SfxBoolItem(0,FALSE));
//STRIP001                 break;
//STRIP001             }
//STRIP001 
//STRIP001             // recording
//STRIP001             rReq.AppendItem( SfxBoolItem( SID_PRINT_COLLATE, bCollate ) );
//STRIP001             rReq.AppendItem( SfxInt16Item( SID_PRINT_COPIES, (INT16) pPrintDlg->GetCopyCount() ) );
//STRIP001             if ( pPrinter->IsPrintFileEnabled() )
//STRIP001                 rReq.AppendItem( SfxStringItem( SID_FILE_NAME, pPrinter->GetPrintFile() ) );
//STRIP001             if ( pPrintDlg->IsRangeChecked(PRINTDIALOG_SELECTION) )
//STRIP001                 rReq.AppendItem( SfxBoolItem( SID_SELECTION, TRUE ) );
//STRIP001             else if ( pPrintDlg->IsRangeChecked(PRINTDIALOG_RANGE) )
//STRIP001                 rReq.AppendItem( SfxStringItem( SID_PRINT_PAGES, pPrintDlg->GetRangeText() ) );
//STRIP001             else if ( pPrintDlg->IsRangeChecked(PRINTDIALOG_FROMTO) )
//STRIP001             {
//STRIP001                 // currently this doesn't seem to work -> return values of dialog are always 0
//STRIP001                 // seems to be encoded as range string like "1-3"
//STRIP001                 rReq.AppendItem( SfxInt16Item( SID_PRINT_FIRST_PAGE, (INT16) pPrintDlg->GetFirstPage() ) );
//STRIP001                 rReq.AppendItem( SfxInt16Item( SID_PRINT_LAST_PAGE, (INT16) pPrintDlg->GetLastPage() ) );
//STRIP001             }
//STRIP001 		}
//STRIP001 		else if ( rReq.GetArgs() )
//STRIP001 		{
//STRIP001             if ( SID_PRINTDOC != nId )
//STRIP001             {
//STRIP001                 DBG_ERROR("Wrong slotid!");
//STRIP001                 break;
//STRIP001             }
//STRIP001 
//STRIP001             // PrinterDialog is used to transfer information on printing
//STRIP001 			pPrintDlg = CreatePrintDialog( GetWindow() );
//STRIP001 			if ( bPrintOnHelp )
//STRIP001 				pPrintDlg->DisableHelp();
//STRIP001 			pPrintDlg->SetPrinter( pPrinter );
//STRIP001 			::DisableRanges( *pPrintDlg, pPrinter );
//STRIP001 
//STRIP001             // PrintToFile requested?
//STRIP001 			SFX_REQUEST_ARG(rReq, pFileItem, SfxStringItem, SID_FILE_NAME, FALSE);
//STRIP001 			if ( pFileItem )
//STRIP001 			{
//STRIP001 				pPrinter->EnablePrintFile(TRUE);
//STRIP001 				pPrinter->SetPrintFile( pFileItem->GetValue() );
//STRIP001 			}
//STRIP001 
//STRIP001             // Collate
//STRIP001             SFX_REQUEST_ARG(rReq, pCollateItem, SfxBoolItem, SID_PRINT_COLLATE, FALSE);
//STRIP001             if ( pCollateItem )
//STRIP001                 bCollate = pCollateItem->GetValue();
//STRIP001 
//STRIP001             // Selection
//STRIP001             SFX_REQUEST_ARG(rReq, pSelectItem, SfxBoolItem, SID_SELECTION, FALSE);
//STRIP001 
//STRIP001 			// Pages (as String)
//STRIP001 			SFX_REQUEST_ARG(rReq, pPagesItem, SfxStringItem, SID_PRINT_PAGES, FALSE);
//STRIP001 
//STRIP001 			// FirstPage
//STRIP001 			SFX_REQUEST_ARG(rReq, pFirstPgItem, SfxInt16Item, SID_PRINT_FIRST_PAGE, FALSE);
//STRIP001 			USHORT nFrom = 1;
//STRIP001 			if ( pFirstPgItem )
//STRIP001 				nFrom = pFirstPgItem->GetValue();
//STRIP001 
//STRIP001 			// LastPage
//STRIP001 			SFX_REQUEST_ARG(rReq, pLastPgItem, SfxInt16Item, SID_PRINT_LAST_PAGE, FALSE);
//STRIP001 			USHORT nTo = 9999;
//STRIP001 			if ( pLastPgItem )
//STRIP001 				nTo = pLastPgItem->GetValue();
//STRIP001 
//STRIP001             // CopyCount
//STRIP001 			SFX_REQUEST_ARG(rReq, pCopyItem, SfxInt16Item, SID_PRINT_COPIES, FALSE);
//STRIP001 			if ( pCopyItem )
//STRIP001 			{
//STRIP001 				nCopies = pCopyItem->GetValue();
//STRIP001 				pPrintDlg->SetCopyCount( nCopies );
//STRIP001 			}
//STRIP001 
//STRIP001             // does the view support ranges?
//STRIP001             if ( pPagesItem || pPrintDlg->IsRangeEnabled(PRINTDIALOG_RANGE) )
//STRIP001 			{
//STRIP001                 // enable ranges
//STRIP001 				pPrintDlg->CheckRange(PRINTDIALOG_RANGE);
//STRIP001 
//STRIP001 				if ( pPagesItem )
//STRIP001                     // get range text from parameter
//STRIP001 					pPrintDlg->SetRangeText( pPagesItem->GetValue() );
//STRIP001 				else
//STRIP001 				{
//STRIP001                     // construct range text from page range
//STRIP001 					String aRange = String::CreateFromInt32( nFrom );
//STRIP001 					aRange += '-';
//STRIP001 					aRange += String::CreateFromInt32( nTo );
//STRIP001 					pPrintDlg->SetRangeText( aRange );
//STRIP001 				}
//STRIP001 			}
//STRIP001             else if ( pSelectItem && pSelectItem->GetValue() )
//STRIP001             {
//STRIP001                 // print selecion only
//STRIP001                 pPrintDlg->CheckRange(PRINTDIALOG_SELECTION);
//STRIP001             }
//STRIP001             else
//STRIP001 			{
//STRIP001                 // print page rage
//STRIP001 				pPrintDlg->CheckRange(PRINTDIALOG_FROMTO);
//STRIP001 				pPrintDlg->SetFirstPage( nFrom );
//STRIP001 				pPrintDlg->SetLastPage( nTo );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         // intentionally no break for SID_PRINTDOC
//STRIP001         // printing now proceeds like SID_PRINTDOCDIRECT
//STRIP001 	}
//STRIP001 
//STRIP001 	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//STRIP001 
//STRIP001 	case SID_PRINTDOCDIRECT:
//STRIP001 	{
//STRIP001         if ( SID_PRINTDOCDIRECT == nId )
//STRIP001         {
//STRIP001             // if no printer was selected before
//STRIP001             if ( !pPrinter )
//STRIP001                 pPrinter = GetPrinter(TRUE);
//STRIP001 
//STRIP001             if( !pPrinter->IsValid() )
//STRIP001             {
//STRIP001                 // redirect slot to call the print dialog if the document's printer is not valid!
//STRIP001                 rReq.SetSlot( SID_PRINTDOC );
//STRIP001 				ExecPrint_Impl( rReq );
//STRIP001 				return;
//STRIP001             }
//STRIP001 
//STRIP001             if( pPrinter->IsOriginal() && pPrinter->GetName() != Printer::GetDefaultPrinterName() )
//STRIP001             {
//STRIP001                 // redirect slot to call the print dialog if the document's printer is available but not system default
//STRIP001                 rReq.SetSlot( SID_PRINTDOC );
//STRIP001 				ExecPrint_Impl( rReq );
//STRIP001 				return;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // if "Collate" was checked, the SfxPrinter must handle the CopyCount itself,
//STRIP001         // usually this is handled by the printer driver
//STRIP001         if( bCollate )
//STRIP001             // set printer to default, handle multiple copies explicitly
//STRIP001             pPrinter->SetCopyCount( 1 );
//STRIP001         else
//STRIP001             pPrinter->SetCopyCount( nCopies );
//STRIP001 
//STRIP001         // enable background printing
//STRIP001         pPrinter->SetPageQueueSize( 1 );
//STRIP001 
//STRIP001         // refresh document info
//STRIP001         SfxObjectShell *pObjSh = GetObjectShell();
//STRIP001 		SfxDocumentInfo *pInfo = &pObjSh->GetDocInfo();
//STRIP001 		SfxStamp aOldStamp = pInfo->GetPrinted();
//STRIP001 		String aUserName = SvtUserOptions().GetFullName();
//STRIP001 		if ( !pInfo->IsUseUserData() )
//STRIP001 			aUserName.Erase();
//STRIP001 
//STRIP001         // check configuration: shall update of printing information in DocInfo set the document to "modified"?
//STRIP001         BOOL bOldFlag = pObjSh->IsEnableSetModified();
//STRIP001         BOOL bDontModifyDoc = !SvtPrintWarningOptions().IsModifyDocumentOnPrintingAllowed();
//STRIP001         if ( bDontModifyDoc && bOldFlag )
//STRIP001             // prevent document from getting into the "modified" state
//STRIP001             pObjSh->EnableSetModified( FALSE );
//STRIP001 
//STRIP001         pInfo->SetPrinted( aUserName );
//STRIP001         pObjSh->Broadcast( SfxDocumentInfoHint( pInfo ) );
//STRIP001 
//STRIP001         if ( bDontModifyDoc && bOldFlag != pObjSh->IsEnableSetModified() )
//STRIP001             pObjSh->EnableSetModified( bOldFlag );
//STRIP001 
//STRIP001 		GetObjectShell()->Broadcast( SfxPrintingHint( -1, pPrintDlg, pPrinter ) );
//STRIP001 		ErrCode nError = DoPrint( pPrinter, pPrintDlg, bSilent );
//STRIP001 		if ( nError == PRINTER_OK )
//STRIP001 		{
//STRIP001             // printer was started sucessfully
//STRIP001             bOldFlag = pObjSh->IsEnableSetModified();
//STRIP001             if ( bDontModifyDoc && bOldFlag )
//STRIP001                 pObjSh->EnableSetModified( FALSE );
//STRIP001 
//STRIP001             pObjSh->FlushDocInfo();
//STRIP001 
//STRIP001             if ( bDontModifyDoc && bOldFlag != pObjSh->IsEnableSetModified() )
//STRIP001                 pObjSh->EnableSetModified( bOldFlag );
//STRIP001 
//STRIP001 			Invalidate( SID_PRINTDOC );
//STRIP001 			Invalidate( SID_PRINTDOCDIRECT );
//STRIP001 			Invalidate( SID_SETUPPRINTER );
//STRIP001 			rReq.SetReturnValue(SfxBoolItem(0,TRUE));
//STRIP001 
//STRIP001 			SFX_REQUEST_ARG(rReq, pAsyncItem, SfxBoolItem, SID_ASYNCHRON, FALSE);
//STRIP001 			if ( pAsyncItem && !pAsyncItem->GetValue() )
//STRIP001 			{
//STRIP001                 // synchronous execution wanted - wait for end of printing
//STRIP001 				while ( pPrinter->IsPrinting())
//STRIP001 					Application::Yield();
//STRIP001 			}
//STRIP001 
//STRIP001             rReq.Done();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             bOldFlag = pObjSh->IsEnableSetModified();
//STRIP001             if ( bDontModifyDoc && bOldFlag )
//STRIP001                 pObjSh->EnableSetModified( FALSE );
//STRIP001 
//STRIP001             // printing not succesful, reset DocInfo
//STRIP001             pInfo->SetPrinted(aOldStamp);
//STRIP001 			pObjSh->Broadcast( SfxDocumentInfoHint( pInfo ) );
//STRIP001 
//STRIP001             if ( bDontModifyDoc && bOldFlag != pObjSh->IsEnableSetModified() )
//STRIP001                 pObjSh->EnableSetModified( bOldFlag );
//STRIP001 
//STRIP001 			if ( nError != PRINTER_ABORT )
//STRIP001 			{
//STRIP001                 // "real" problem (not simply printing cancelled by user)
//STRIP001 				String aMsg( SfxResId( STR_NOSTARTPRINTER ) );
//STRIP001                 if ( !bIsAPI )
//STRIP001                     ErrorBox( NULL, WB_OK | WB_DEF_OK,  aMsg ).Execute();
//STRIP001 				rReq.SetReturnValue(SfxBoolItem(0,FALSE));
//STRIP001 			}
//STRIP001 
//STRIP001             rReq.Ignore();
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pPrintDlg;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // Optimierungen wieder einschalten
//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", on )
//STRIP001 #endif
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 PrintDialog* SfxViewShell::CreatePrintDialog( Window* pParent )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode kann "uberladen werden, um einen speziellen PrintDialog
//STRIP001 	zu erzeugen. Dies ist z.B. notwendig wenn spezielle <StarView> Features
//STRIP001 	wie drucken von Seitenbereichen.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	PrintDialog *pDlg = new PrintDialog( pParent );
//STRIP001 	pDlg->SetFirstPage( 1 );
//STRIP001 	pDlg->SetLastPage( 9999 );
//STRIP001 	pDlg->EnableCollate();
//STRIP001 	return pDlg;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxViewShell::PreparePrint( PrintDialog * )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 ErrCode SfxViewShell::DoPrint( SfxPrinter *pPrinter,
//STRIP001 							   PrintDialog *pPrintDlg,
//STRIP001 							   BOOL bSilent )
//STRIP001 {
//STRIP001 	// Printer-Dialogbox waehrend des Ausdrucks mu\s schon vor
//STRIP001 	// StartJob erzeugt werden, da SV bei einem Quit-Event h"angt
//STRIP001 	SfxPrintProgress *pProgress = new SfxPrintProgress( this, !bSilent );
//STRIP001 	SfxPrinter *pDocPrinter = GetPrinter(TRUE);
//STRIP001 	if ( !pPrinter )
//STRIP001 		pPrinter = pDocPrinter;
//STRIP001 	else if ( pDocPrinter != pPrinter )
//STRIP001 	{
//STRIP001 		pProgress->RestoreOnEndPrint( pDocPrinter->Clone() );
//STRIP001 		SetPrinter( pPrinter, SFX_PRINTER_PRINTER );
//STRIP001 	}
//STRIP001 	pProgress->SetWaitMode(FALSE);
//STRIP001 
//STRIP001 	// Drucker starten
//STRIP001 	PreparePrint( pPrintDlg );
//STRIP001 	SfxObjectShell *pObjShell = GetViewFrame()->GetObjectShell();
//STRIP001 	if ( pPrinter->StartJob(pObjShell->GetTitle(0)) )
//STRIP001 	{
//STRIP001 		// Drucken
//STRIP001 		Print( *pProgress, pPrintDlg );
//STRIP001 		pProgress->Stop();
//STRIP001 		pProgress->DeleteOnEndPrint();
//STRIP001 		pPrinter->EndJob();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Printer konnte nicht gestartet werden
//STRIP001 		delete pProgress;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pPrinter->GetError();
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxViewShell::IsPrinterLocked() const
//STRIP001 {
//STRIP001 	return pImp->nPrinterLocks > 0;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxViewShell::LockPrinter( BOOL bLock)
//STRIP001 {
//STRIP001 	BOOL bChanged = FALSE;
//STRIP001 	if ( bLock )
//STRIP001 		bChanged = 1 == ++pImp->nPrinterLocks;
//STRIP001 	else
//STRIP001 		bChanged = 0 == --pImp->nPrinterLocks;
//STRIP001 
//STRIP001 	if ( bChanged )
//STRIP001 	{
//STRIP001 		Invalidate( SID_PRINTDOC );
//STRIP001 		Invalidate( SID_PRINTDOCDIRECT );
//STRIP001 		Invalidate( SID_SETUPPRINTER );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SfxViewShell::Print( SfxProgress &rProgress, PrintDialog *pDlg )
//STRIP001 {
//STRIP001 	SfxObjectShell *pObjShell = GetViewFrame()->GetObjectShell();
//STRIP001 	SFX_APP()->NotifyEvent(SfxEventHint(SFX_EVENT_PRINTDOC, pObjShell));
//STRIP001 	GetObjectShell()->Broadcast( SfxPrintingHint( ::com::sun::star::view::PrintableState_JOB_STARTED, pDlg, NULL ) );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxPrinter* SfxViewShell::GetPrinter( BOOL bCreate )
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SfxViewShell::SetPrinter( SfxPrinter *pNewPrinter, USHORT nDiffFlags )
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SfxViewShell::CreatePrintOptionsPage
//STRIP001 (
//STRIP001 	Window*             pParent,
//STRIP001 	const SfxItemSet&   rOptions
//STRIP001 )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese Factory-Methode wird vom SFx verwendet, um die TabPage mit den
//STRIP001 	Print-Optionen, welche "uber das <SfxItemSet> am <SfxPrinter>
//STRIP001 	transportiert werden, zu erzeugen.
//STRIP001 
//STRIP001 	Abgeleitete Klassen k"onnen diese Methode also "uberladen um die zu
//STRIP001 	ihren SfxPrinter passenden Einstellungen vorzunehmen. Dieses sollte
//STRIP001 	genau die <SfxTabPage> sein, die auch unter Extras/Einstellungen
//STRIP001 	verwendet wird.
//STRIP001 
//STRIP001 	Die Basisimplementierung liefert einen 0-Pointer.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }


}
