/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccTitle.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:04:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SCH_ACCTITLE_HXX_
#define _SCH_ACCTITLE_HXX_

#ifndef _SCH_ACCESSIBLECHARTELEMENT_HXX_
#include "AccessibleChartElement.hxx"
#endif

// for CHOBJID_...
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif
namespace binfilter {

namespace accessibility
{

class AccessibleTextHelper;

class Title : public AccessibleChartElement
{
public:
    enum TitleType
    {
        MAIN     = CHOBJID_TITLE_MAIN,
        SUB      = CHOBJID_TITLE_SUB,
        X_AXIS   = CHOBJID_DIAGRAM_TITLE_X_AXIS,
        Y_AXIS   = CHOBJID_DIAGRAM_TITLE_Y_AXIS,
        Z_AXIS   = CHOBJID_DIAGRAM_TITLE_Z_AXIS
    };

    Title( AccessibleBase * pParent, TitleType eType );
    virtual ~Title();

    // ________ XComponent ________
    virtual void SAL_CALL dispose() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleContext ________
    virtual sal_Int32 SAL_CALL getAccessibleChildCount() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleChild( sal_Int32 i ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getAccessibleName() throw (::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getAccessibleDescription() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleComponent ________
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleAtPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleEventBroadcaster ________
    virtual void SAL_CALL addEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);

    // ________ XServiceInfo ________
    virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);

protected:
    /** enables the SvxAccessibleTextHelper to support editable text
        You may lock the SolarMutex when calling this method
     */
    void InitTextEdit();

private:
    const TitleType         m_eType;
    /// this object is guarded by the SolarMutex
    AccessibleTextHelper *  m_pTextHelper;
};

}  // accessibility

// _SCH_ACCTITLE_HXX_
} //namespace binfilter
#endif
