/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_dwfunctr.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:23:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <bf_svx/editview.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
#include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #include <bf_sfx2/viewsh.hxx>

#include "bf_sc.hrc"
// auto strip #include "global.hxx"		// ScAddress
// auto strip #include "scresid.hxx"
// auto strip #include "reffact.hxx"
// auto strip #include "document.hxx"
// auto strip #include "cell.hxx"
// auto strip #include "scmod.hxx"
// auto strip #include "inputhdl.hxx"
// auto strip #include "tabvwsh.hxx"
// auto strip #include "appoptio.hxx"
// auto strip #include "compiler.hxx"

#include "dwfunctr.hrc"
#include "dwfunctr.hxx"
namespace binfilter {

// -----------------------------------------------------------------------

#define ARG_SEPERATOR String("; ")
/*N*/ SFX_IMPL_DOCKINGWINDOW( ScFunctionChildWindow, FID_FUNCTION_BOX )

/*************************************************************************
#*	Member:		ScFunctionChildWindow						Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionChildWindow
#*
#*  Funktion:	Konstruktor der Klasse ScFunctionChildWindow
#*				Ableitung vom SfxChildWindow als "Behaelter" fuer
#*				Funktions- Fenster in Clac
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 __EXPORT ScFunctionChildWindow::ScFunctionChildWindow( Window* pParent,
//STRIP001 									USHORT nId,
//STRIP001 									SfxBindings* pBindings,
//STRIP001 									SfxChildWinInfo* pInfo ) :
//STRIP001 	SfxChildWindow( pParent, nId )
//STRIP001 {
//STRIP001 	ScFunctionDockWin* pWin = new ScFunctionDockWin( pBindings, this,
//STRIP001 										pParent, ScResId( FID_FUNCTION_BOX ) );
//STRIP001 	pWindow = pWin;
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_RIGHT;
//STRIP001 
//STRIP001 	pWin->Initialize( pInfo );
//STRIP001 }

/*************************************************************************
#*	Member:		ScFunctionDockWin							Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Konstruktor der Klasse ScFunctionDockWin
#*
#*  Input:		Sfx- Verknuepfungen, Fenster, Resource
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 ScFunctionDockWin::ScFunctionDockWin( SfxBindings* pBindings,
//STRIP001 				SfxChildWindow *pCW, Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	SfxDockingWindow( pBindings, pCW, pParent, rResId ),
//STRIP001 	aCatBox			( this, ResId( CB_CAT ) ),
//STRIP001 	aDDFuncList		( this, ResId( DDLB_FUNC ) ),
//STRIP001 	aFuncList		( this, ResId( LB_FUNC ) ),
//STRIP001 	aInsertButton	( this, ResId( IMB_INSERT ) ),
//STRIP001 	aFiFuncDesc		( this, ResId( FI_FUNCDESC ) ),
//STRIP001 	aPrivatSplit	( this, ResId( FT_SPLIT ),SC_SPLIT_VERT),
//STRIP001 	aOldSize		(0,0)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	InitLRUList();
//STRIP001 	SetStyle(GetStyle()|WB_CLIPCHILDREN);
//STRIP001 
//STRIP001 	aTimer.SetTimeout(200);
//STRIP001 	aTimer.SetTimeoutHdl(LINK( this, ScFunctionDockWin, TimerHdl));
//STRIP001 
//STRIP001 	eSfxNewAlignment=GetAlignment();
//STRIP001 	eSfxOldAlignment=eSfxNewAlignment;
//STRIP001 	aFiFuncDesc.SetUpdateMode(TRUE);
//STRIP001 	pAllFuncList=&aFuncList;
//STRIP001 	aDDFuncList.Disable();
//STRIP001 	aDDFuncList.Hide();
//STRIP001 	nArgs=0;
//STRIP001 	nDockMode=0;
//STRIP001 	bSizeFlag=FALSE;
//STRIP001 	aCatBox.SetDropDownLineCount(9);
//STRIP001 	Font aFont=aFiFuncDesc.GetFont();
//STRIP001 	aFont.SetColor(Color(COL_BLACK));
//STRIP001 	aFiFuncDesc.SetFont(aFont);
//STRIP001 	aFiFuncDesc.SetBackground( GetBackground() );		//! never transparent?
//STRIP001 //?	SetBackground();
//STRIP001 
//STRIP001 	Link aLink=LINK( this, ScFunctionDockWin, SelHdl);
//STRIP001 	aCatBox.SetSelectHdl(aLink);
//STRIP001 	aFuncList.SetSelectHdl(aLink);
//STRIP001 	aDDFuncList.SetSelectHdl(aLink);
//STRIP001 
//STRIP001 	Link a2Link=LINK( this, ScFunctionDockWin, SetSelectionHdl);
//STRIP001 	aFuncList.SetDoubleClickHdl(a2Link);
//STRIP001 	aDDFuncList.SetSelectHdl(aLink);
//STRIP001 	aInsertButton.SetClickHdl(a2Link);
//STRIP001 
//STRIP001 	Link a3Link=LINK( this, ScFunctionDockWin, SetSplitHdl);
//STRIP001 	aPrivatSplit.SetCtrModifiedHdl(a3Link);
//STRIP001 	StartListening( *pBindings, TRUE );
//STRIP001 
//STRIP001 	Point aTopLeft=aCatBox.GetPosPixel();
//STRIP001 	//String aString=aCatBox.GetEntry( 0)+String("www");
//STRIP001 	String aString=String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("ww"));
//STRIP001 	Size aTxtSize( aFiFuncDesc.GetTextWidth(aString), aFiFuncDesc.GetTextHeight() );
//STRIP001 	nMinWidth=aTxtSize.Width()+aTopLeft.X()
//STRIP001 			+2*aFuncList.GetPosPixel().X();
//STRIP001 	nMinHeight=19*aTxtSize.Height();
//STRIP001 	aCatBox.SelectEntryPos(0);
//STRIP001 
//STRIP001 	Range aYRange(3*aTxtSize.Height()+aFuncList.GetPosPixel().Y(),
//STRIP001 				GetOutputSizePixel().Height()-2*aTxtSize.Height());
//STRIP001 	aPrivatSplit.SetYRange(aYRange);
//STRIP001 	SelHdl(&aCatBox);
//STRIP001 	bInit=TRUE;
//STRIP001 }

/*************************************************************************
#*	Member:		ScFunctionDockWin							Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Destruktor der Klasse ScFunctionDockWin
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 __EXPORT ScFunctionDockWin::~ScFunctionDockWin()
//STRIP001 {
//STRIP001 	EndListening( GetBindings() );
//STRIP001 }

/*************************************************************************
#*	Member:		UpdateFunctionList							Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Aktualisiert die Liste der Funktionen ab-
#*				haengig von der eingestellten Kategorie.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::InitLRUList()
//STRIP001 {
//STRIP001 	const ScAppOptions& rAppOpt = SC_MOD()->GetAppOptions();
//STRIP001 	USHORT nLRUFuncCount = Min( rAppOpt.GetLRUFuncListCount(), (USHORT)LRU_MAX );
//STRIP001 	USHORT*	pLRUListIds = rAppOpt.GetLRUFuncList();
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for ( i=0; i<LRU_MAX; i++ )
//STRIP001 		aLRUList[i] = NULL;
//STRIP001 
//STRIP001 	if ( pLRUListIds )
//STRIP001 	{
//STRIP001 		ScFunctionMgr* pFuncMgr = ScGlobal::GetStarCalcFunctionMgr();
//STRIP001 		for ( i=0; i<nLRUFuncCount; i++ )
//STRIP001 			aLRUList[i] = pFuncMgr->Get( pLRUListIds[i] );
//STRIP001 	}
//STRIP001 	
//STRIP001 	USHORT	nSelPos	  = aCatBox.GetSelectEntryPos();
//STRIP001 	
//STRIP001 	if(nSelPos == 0)
//STRIP001 		UpdateFunctionList();
//STRIP001 }

/*************************************************************************
#*	Member:		UpdateFunctionList							Datum:10.12.99
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Aktualisiert die Liste der zuletzt verwendeten Funktionen. 
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::UpdateLRUList()
//STRIP001 {
//STRIP001 	if (pFuncDesc && pFuncDesc->nFIndex!=0)
//STRIP001 	{
//STRIP001 		ScModule* pScMod = SC_MOD();
//STRIP001 		pScMod->InsertEntryToLRUList(pFuncDesc->nFIndex);
//STRIP001 	}
//STRIP001 }


/*************************************************************************
#*	Member:		SetSize										Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Groesse fuer die einzelnen Controls einzustellen.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetSize()
//STRIP001 {
//STRIP001 	USHORT nSelEntry=0;
//STRIP001 	SfxChildAlignment  aChildAlign=eSfxOldAlignment;//GetAlignment();
//STRIP001 	short nNewDockMode;
//STRIP001 	switch(aChildAlign)
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_HIGHESTTOP:
//STRIP001 		case SFX_ALIGN_TOP:
//STRIP001 		case SFX_ALIGN_LOWESTTOP:
//STRIP001 		case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 		case SFX_ALIGN_BOTTOM:
//STRIP001 		case SFX_ALIGN_TOOLBOXTOP:
//STRIP001 		case SFX_ALIGN_TOOLBOXBOTTOM:
//STRIP001 
//STRIP001 
//STRIP001 						nNewDockMode=1;
//STRIP001 						if(nDockMode!=nNewDockMode)
//STRIP001 						{
//STRIP001 							nDockMode=nNewDockMode;
//STRIP001 							nSelEntry=aFuncList.GetSelectEntryPos();
//STRIP001 							aFuncList.Clear();
//STRIP001 							aFiFuncDesc.SetPosPixel(aFuncList.GetPosPixel());
//STRIP001 							aDDFuncList.Enable();
//STRIP001 							aDDFuncList.Show();
//STRIP001 							aPrivatSplit.Disable();
//STRIP001 							aPrivatSplit.Hide();
//STRIP001 							aFuncList.Disable();
//STRIP001 							aFuncList.Hide();
//STRIP001 							pAllFuncList=&aDDFuncList;
//STRIP001 							SelHdl(&aCatBox);
//STRIP001 							aDDFuncList.SelectEntryPos(nSelEntry);
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 		default:		nNewDockMode=0;
//STRIP001 						if(nDockMode!=nNewDockMode)
//STRIP001 						{
//STRIP001 							nDockMode=nNewDockMode;
//STRIP001 							nSelEntry=aDDFuncList.GetSelectEntryPos();
//STRIP001 							aDDFuncList.Clear();
//STRIP001 							aDDFuncList.Disable();
//STRIP001 							aDDFuncList.Hide();
//STRIP001 							aPrivatSplit.Enable();
//STRIP001 							aPrivatSplit.Show();
//STRIP001 							aFuncList.Enable();
//STRIP001 							aFuncList.Show();
//STRIP001 							pAllFuncList=&aFuncList;
//STRIP001 							SelHdl(&aCatBox);
//STRIP001 							aFuncList.SelectEntryPos(nSelEntry);
//STRIP001 						}
//STRIP001 						break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nDockMode==0)
//STRIP001 	{
//STRIP001 		SetLeftRightSize();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetTopBottonSize();
//STRIP001 	}
//STRIP001 }
/*************************************************************************
#*	Member:		SetLeftRightSize							Datum:15.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Groesse fuer die einzelnen Controls einstellen,
#*				wenn Links oder Rechts angedockt wird.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetLeftRightSize()
//STRIP001 {
//STRIP001 	if(bSizeFlag==FALSE)
//STRIP001 	{
//STRIP001 		bSizeFlag=TRUE;
//STRIP001 
//STRIP001 		Size aDiffSize=GetSizePixel();
//STRIP001 		Size aNewSize=GetOutputSizePixel();
//STRIP001 		aDiffSize.Width()-=aNewSize.Width();
//STRIP001 		aDiffSize.Height()-=aNewSize.Height();
//STRIP001 
//STRIP001 		//@ SetUpdateMode( FALSE);
//STRIP001 
//STRIP001 		String aString = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("ww"));
//STRIP001 
//STRIP001 		Size aTxtSize( aFuncList.GetTextWidth(aString), aFuncList.GetTextHeight() );
//STRIP001 
//STRIP001 		Range aYRange(3*aTxtSize.Height()+aFuncList.GetPosPixel().Y(),
//STRIP001 					GetOutputSizePixel().Height()-2*aTxtSize.Height());
//STRIP001 		aPrivatSplit.SetYRange(aYRange);
//STRIP001 
//STRIP001 
//STRIP001 		if(aOldSize.Width()!=aNewSize.Width())
//STRIP001 			SetMyWidthLeRi(aNewSize);
//STRIP001 
//STRIP001 		if(aOldSize.Height()!=aNewSize.Height())
//STRIP001 			SetMyHeightLeRi(aNewSize);
//STRIP001 
//STRIP001 		aOldSize=aNewSize;
//STRIP001 		aNewSize.Width()+=aDiffSize.Width();
//STRIP001 		aNewSize.Height()+=aDiffSize.Height();
//STRIP001 		//SetSizePixel(aNewSize);
//STRIP001 		//@ SetUpdateMode( TRUE);
//STRIP001 		bSizeFlag=FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 }
/*************************************************************************
#*	Member:		SetTopBottonSize							Datum:15.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Groesse fuer die einzelnen Controls einzustellen.
#*				wenn oben oder unten angedockt wird.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetTopBottonSize()
//STRIP001 {
//STRIP001 	if(bSizeFlag==FALSE)
//STRIP001 	{
//STRIP001 		bSizeFlag=TRUE;
//STRIP001 		Size aDiffSize=GetSizePixel();
//STRIP001 		Size aNewSize=GetOutputSizePixel();
//STRIP001 		aDiffSize.Width()-=aNewSize.Width();
//STRIP001 		aDiffSize.Height()-=aNewSize.Height();
//STRIP001 
//STRIP001 		SetMyWidthToBo(aNewSize);
//STRIP001 		SetMyHeightToBo(aNewSize);
//STRIP001 
//STRIP001 		aNewSize.Width()+=aDiffSize.Width();
//STRIP001 		aNewSize.Height()+=aDiffSize.Height();
//STRIP001 		//SetSizePixel(aNewSize);
//STRIP001 		//@ SetUpdateMode( TRUE);
//STRIP001 		bSizeFlag=FALSE;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
#*	Member:		SetMyWidthLeRi								Datum:15.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Breite fuer die einzelnen Controls und
#*				das Fenster einstellen,wenn Li oder Re
#*
#*  Input:		neue Fenstergroesse
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetMyWidthLeRi(Size &aNewSize)
//STRIP001 {
//STRIP001 	if((ULONG)aNewSize.Width()<nMinWidth)	aNewSize.Width()=nMinWidth;
//STRIP001 
//STRIP001 	Size aCDSize=aCatBox.GetSizePixel();
//STRIP001 	Size aFLSize=aFuncList.GetSizePixel();
//STRIP001 	Size aSplitterSize=aPrivatSplit.GetSizePixel();
//STRIP001 	Size aFDSize=aFiFuncDesc.GetSizePixel();
//STRIP001 
//STRIP001 	Point aCDTopLeft=aCatBox.GetPosPixel();
//STRIP001 	Point aFLTopLeft=aFuncList.GetPosPixel();
//STRIP001 	Point aSplitterTopLeft=aPrivatSplit.GetPosPixel();
//STRIP001 	Point aFDTopLeft=aFiFuncDesc.GetPosPixel();
//STRIP001 
//STRIP001 	aCDSize.Width()=aNewSize.Width()-aCDTopLeft.X()-aFLTopLeft.X();
//STRIP001 	aFLSize.Width()=aNewSize.Width()-2*aFLTopLeft.X();
//STRIP001 	aFDSize.Width()=aFLSize.Width();
//STRIP001 	aSplitterSize.Width()=aFLSize.Width();
//STRIP001 
//STRIP001 	aCatBox.SetSizePixel(aCDSize);
//STRIP001 	aFuncList.SetSizePixel(aFLSize);
//STRIP001 	aPrivatSplit.SetSizePixel(aSplitterSize);
//STRIP001 	aFiFuncDesc.SetSizePixel(aFDSize);
//STRIP001 }

/*************************************************************************
#*	Member:		SetHeight									Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Hoehe fuer die einzelnen Controls und
#*				das Fenster einstellen bei Li oder Re
#*
#*  Input:		neue Fenstergroesse
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetMyHeightLeRi(Size &aNewSize)
//STRIP001 {
//STRIP001 	if((ULONG)aNewSize.Height()<nMinHeight) aNewSize.Height()=nMinHeight;
//STRIP001 
//STRIP001 	Size aFLSize=aFuncList.GetSizePixel();
//STRIP001 	Size aSplitterSize=aPrivatSplit.GetSizePixel();
//STRIP001 	Size aFDSize=aFiFuncDesc.GetSizePixel();
//STRIP001 
//STRIP001 	Point aFLTopLeft=aFuncList.GetPosPixel();
//STRIP001 	Point aSplitterTopLeft=aPrivatSplit.GetPosPixel();
//STRIP001 	Point aFDTopLeft=aFiFuncDesc.GetPosPixel();
//STRIP001 
//STRIP001 	long nTxtHeight = aFuncList.GetTextHeight();
//STRIP001 
//STRIP001 	short nY=(short)(3*nTxtHeight+
//STRIP001 		aFuncList.GetPosPixel().Y()+aSplitterSize.Height());
//STRIP001 
//STRIP001 	aFDTopLeft.Y()=aNewSize.Height()-aFDSize.Height()-4;
//STRIP001 	if(nY>aFDTopLeft.Y())
//STRIP001 	{
//STRIP001 		aFDSize.Height()-=nY-aFDTopLeft.Y();
//STRIP001 		aFDTopLeft.Y()=nY;
//STRIP001 	}
//STRIP001 	aSplitterTopLeft.Y()=aFDTopLeft.Y()-aSplitterSize.Height()-1;
//STRIP001 	aFLSize.Height()=aSplitterTopLeft.Y()-aFLTopLeft.Y()-1;
//STRIP001 
//STRIP001 	aFuncList.SetSizePixel(aFLSize);
//STRIP001 	aPrivatSplit.SetPosPixel(aSplitterTopLeft);
//STRIP001 	aFiFuncDesc.SetPosPixel(aFDTopLeft);
//STRIP001 	aFiFuncDesc.SetSizePixel(aFDSize);
//STRIP001 
//STRIP001 }

/*************************************************************************
#*	Member:		SetMyWidthToBo								Datum:16.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Breite fuer die einzelnen Controls und
#*				das Fenster einstellen, wenn oben oder
#*				unten angedockt werden soll.
#*
#*  Input:		neue Fenstergroesse
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetMyWidthToBo(Size &aNewSize)
//STRIP001 {
//STRIP001 	if((ULONG)aNewSize.Width()<nMinWidth)	aNewSize.Width()=nMinWidth;
//STRIP001 
//STRIP001 	Size aCDSize=aCatBox.GetSizePixel();
//STRIP001 	Size aDdFLSize=aDDFuncList.GetSizePixel();
//STRIP001 	Size aFDSize=aFiFuncDesc.GetSizePixel();
//STRIP001 
//STRIP001 	Point aCDTopLeft=aCatBox.GetPosPixel();
//STRIP001 	Point aDdFLTopLeft=aDDFuncList.GetPosPixel();
//STRIP001 	Point aFDTopLeft=aFiFuncDesc.GetPosPixel();
//STRIP001 
//STRIP001 	aCDSize.Width()=aDdFLTopLeft.X()-aFDTopLeft.X()-aCDTopLeft.X();
//STRIP001 	aDdFLTopLeft.X()=aCDSize.Width()+aCDTopLeft.X()+aFDTopLeft.X();
//STRIP001 
//STRIP001 	aDdFLSize.Width()=aNewSize.Width()-aDdFLTopLeft.X()-aFDTopLeft.X();
//STRIP001 
//STRIP001 	aFDSize.Width()=aNewSize.Width()-2*aFDTopLeft.X();
//STRIP001 
//STRIP001 	aDDFuncList.SetPosPixel(aDdFLTopLeft);
//STRIP001 	aDDFuncList.SetSizePixel(aDdFLSize);
//STRIP001 	aCatBox.SetSizePixel(aCDSize);
//STRIP001 	aFiFuncDesc.SetSizePixel(aFDSize);
//STRIP001 }

/*************************************************************************
#*	Member:		SetHeight									Datum:16.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Hoehe fuer die einzelnen Controls und
#*				das Fenster einstellen, wenn oben oder
#*				unten angedockt werden soll.
#*
#*  Input:		neue Fenstergroesse
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetMyHeightToBo(Size &aNewSize)
//STRIP001 {
//STRIP001 	if((ULONG)aNewSize.Height()<nMinHeight) aNewSize.Height()=nMinHeight;
//STRIP001 
//STRIP001 	Size aFDSize=aFiFuncDesc.GetSizePixel();
//STRIP001 
//STRIP001 	Point aFDTopLeft=aFiFuncDesc.GetPosPixel();
//STRIP001 	Point aCBTopLeft=aCatBox.GetPosPixel();
//STRIP001 	aFDSize.Height()=aNewSize.Height()-aFDTopLeft.Y()-aCBTopLeft.Y();
//STRIP001 	aFiFuncDesc.SetSizePixel(aFDSize);
//STRIP001 
//STRIP001 }

/*************************************************************************
#*	Member:		SetDescription								Datum:13.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Erklaerungstext fuer die Funktion einstellen.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::SetDescription()
//STRIP001 {
//STRIP001 	aFiFuncDesc.SetText( EMPTY_STRING );
//STRIP001 	ScFuncDesc* pDesc =
//STRIP001 			 (ScFuncDesc*)pAllFuncList->GetEntryData(
//STRIP001 					pAllFuncList->GetSelectEntryPos() );
//STRIP001 	if (pDesc)
//STRIP001 	{
//STRIP001 		String	aString=pAllFuncList->GetSelectEntry();
//STRIP001 		if(nDockMode==0)
//STRIP001 		{
//STRIP001 			aString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ":\n\n" ));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ":   " ));
//STRIP001 		}
//STRIP001 
//STRIP001 		String	a2String=pDesc->GetSignature();
//STRIP001 		xub_StrLen aStrtPos=a2String.Search('(');
//STRIP001 		xub_StrLen aEndPos=a2String.Search(')');
//STRIP001 		a2String.Erase(aEndPos-1);
//STRIP001 		a2String.Erase(0,aStrtPos+1);
//STRIP001 		a2String.EraseLeadingChars();
//STRIP001 		aString+=a2String;
//STRIP001 
//STRIP001 		if(nDockMode==0)
//STRIP001 		{
//STRIP001 			aString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "\n\n" ));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aString += '\n';
//STRIP001 		}
//STRIP001 
//STRIP001 		aString+=*(pDesc->pFuncDesc);
//STRIP001 
//STRIP001 		aFiFuncDesc.SetText(aString);
//STRIP001 		aFiFuncDesc.StateChanged(STATE_CHANGE_TEXT);
//STRIP001 		aFiFuncDesc.Invalidate();
//STRIP001 		aFiFuncDesc.Update();
//STRIP001 
//STRIP001 	}
//STRIP001  }

/*************************************************************************
#*	Member:		Resizing									Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Ueberladene Funktion um die Groesse der
#*				einzelnen Controls einzustellen.
#*
#*  Input:		neue Groesse
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void __EXPORT ScFunctionDockWin::Resizing( Size& rNewSize )
//STRIP001 {
//STRIP001 	if((ULONG)rNewSize.Width()<nMinWidth) rNewSize.Width()=nMinWidth;
//STRIP001 	if((ULONG)rNewSize.Height()<nMinHeight) rNewSize.Height()=nMinHeight;
//STRIP001 
//STRIP001 }

/*************************************************************************
#*	Member:		Close										Datum:07.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Schliessen des Fensters
#*
#*  Input:		---
#*
#*	Output:		TRUE
#*
#************************************************************************/

//STRIP001 BOOL __EXPORT ScFunctionDockWin::Close()
//STRIP001 {
//STRIP001 	SfxBoolItem aItem( FID_FUNCTION_BOX, FALSE );
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute( FID_FUNCTION_BOX,
//STRIP001 								SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 								&aItem, 0L );
//STRIP001 
//STRIP001 	SfxDockingWindow::Close();
//STRIP001 
//STRIP001 	return( TRUE );
//STRIP001 }


/*************************************************************************
#*	Member:		CheckAlignment								Datum:16.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Ueberprueft den Andockmodus und stellt die
#*				Groessen dementsprechend ein.
#*
#*  Input:		Das neue Alignment
#*
#*	Output:		Das uebergebene Alignment
#*
#************************************************************************/
//STRIP001 SfxChildAlignment __EXPORT ScFunctionDockWin::CheckAlignment(SfxChildAlignment abla,
//STRIP001 								SfxChildAlignment aChildAlign)
//STRIP001 {
//STRIP001 	String aString = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("ww"));
//STRIP001 	Size aTxtSize( aFiFuncDesc.GetTextWidth(aString), aFiFuncDesc.GetTextHeight() );
//STRIP001 	if(!bInit)
//STRIP001 	{
//STRIP001 		eSfxOldAlignment=eSfxNewAlignment;
//STRIP001 		eSfxNewAlignment=aChildAlign;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bInit=FALSE;
//STRIP001 		eSfxOldAlignment=aChildAlign;
//STRIP001 		eSfxNewAlignment=aChildAlign;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch(eSfxOldAlignment)
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_HIGHESTTOP:
//STRIP001 		case SFX_ALIGN_TOP:
//STRIP001 		case SFX_ALIGN_LOWESTTOP:
//STRIP001 		case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 		case SFX_ALIGN_BOTTOM:
//STRIP001 		case SFX_ALIGN_TOOLBOXTOP:
//STRIP001 		case SFX_ALIGN_TOOLBOXBOTTOM:
//STRIP001 
//STRIP001 						nMinWidth= 0;/*aDDFuncList.GetPosPixel().X()+
//STRIP001 									10*aTxtSize.Width()+
//STRIP001 									aFuncList.GetPosPixel().X();*/
//STRIP001 						nMinHeight=0;
//STRIP001 
//STRIP001 						break;
//STRIP001 
//STRIP001 		case SFX_ALIGN_NOALIGNMENT:
//STRIP001 
//STRIP001 						aString = aCatBox.GetEntry(0);
//STRIP001 						aString.AppendAscii(RTL_CONSTASCII_STRINGPARAM("www"));
//STRIP001 						aTxtSize = Size( aFiFuncDesc.GetTextWidth(aString),
//STRIP001 											aFiFuncDesc.GetTextHeight() );
//STRIP001 
//STRIP001 		default:		Point aTopLeft=aCatBox.GetPosPixel();
//STRIP001 						nMinWidth=aTxtSize.Width()+aTopLeft.X()
//STRIP001 								+2*aFuncList.GetPosPixel().X();
//STRIP001 						nMinHeight=19*aTxtSize.Height();
//STRIP001 							//aCatBox.SelectEntryPos(0);
//STRIP001 
//STRIP001 						break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aChildAlign;
//STRIP001 }
/*************************************************************************
#*	Member:		Close										Datum:07.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Aenderungen erkennen
#*
#*  Input:		---
#*
#*	Output:		TRUE
#*
#************************************************************************/
//STRIP001 void ScFunctionDockWin::SFX_NOTIFY( SfxBroadcaster& rBC,
//STRIP001 										 const TypeId& rBCType,
//STRIP001 										 const SfxHint& rHint,
//STRIP001 										 const TypeId& rHintType )
//STRIP001 {
//STRIP001 	const SfxPoolItemHint *pPoolItemHint = PTR_CAST(SfxPoolItemHint, &rHint);
	/*
	if ( pPoolItemHint
		 && ( pPoolItemHint->GetObject()->ISA( SvxColorTableItem ) ) )
	{
		// Die Liste der Farben hat sich geaendert
		pColorTable = ( (SvxColorTableItem*) pPoolItemHint->GetObject() )->GetColorTable();
		FillValueSet();
	}
	*/
//STRIP001 }


/*************************************************************************
#*	Member:		Resize									Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Ueberladene Funktion um die Groesse der
#*				einzelnen Controls einzustellen.
#*
#*  Input:		neue Groesse
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void __EXPORT ScFunctionDockWin::Resize()
//STRIP001 {
//STRIP001 	if ( !IsFloatingMode() ||
//STRIP001 		 !GetFloatingWindow()->IsRollUp() )
//STRIP001 	{
//STRIP001 		Size aQSize=GetOutputSizePixel();
//STRIP001 		Resizing( aQSize);
//STRIP001 		SetSize();
//STRIP001 	}
//STRIP001 	SfxDockingWindow::Resize();
//STRIP001 }

/*************************************************************************
#*	Member:		UpdateFunctionList							Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Aktualisiert die Liste der Funktionen ab-
#*				haengig von der eingestellten Kategorie.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::UpdateFunctionList()
//STRIP001 {
//STRIP001 	USHORT	nSelPos	  = aCatBox.GetSelectEntryPos();
//STRIP001 	USHORT	nCategory = ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001 							? (nSelPos-1) : 0;
//STRIP001 
//STRIP001 	pAllFuncList->Clear();
//STRIP001 	pAllFuncList->SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	if ( nSelPos > 0 )
//STRIP001 	{
//STRIP001 		ScFunctionMgr* pFuncMgr = ScGlobal::GetStarCalcFunctionMgr();
//STRIP001 
//STRIP001 		ScFuncDesc*	pDesc = pFuncMgr->First( nCategory );
//STRIP001 		while ( pDesc )
//STRIP001 		{
//STRIP001 			pAllFuncList->SetEntryData(
//STRIP001 				pAllFuncList->InsertEntry( *(pDesc->pFuncName) ),
//STRIP001 				pDesc );
//STRIP001 			pDesc = pFuncMgr->Next();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else // LRU-Liste
//STRIP001 	{
//STRIP001 		for ( USHORT i=0; i<LRU_MAX && aLRUList[i]; i++ )
//STRIP001 		{
//STRIP001 			ScFuncDesc*	pDesc = aLRUList[i];
//STRIP001 			pAllFuncList->SetEntryData(
//STRIP001 					pAllFuncList->InsertEntry( *(pDesc->pFuncName) ),
//STRIP001 					pDesc );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	//------------------------------------------------------
//STRIP001 	pAllFuncList->SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 	if ( pAllFuncList->GetEntryCount() > 0 )
//STRIP001 	{
//STRIP001 		pAllFuncList->Enable();
//STRIP001 		pAllFuncList->SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pAllFuncList->Disable();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
#*	Member:		DoEnter										Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Eingabe ins Dokument uebernehmen. Wird aufgerufen
#*				nach betaetigen der Uebernehmen- Schaltflaeche
#*				oder einem Doppelklick in die Funktionsliste.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void ScFunctionDockWin::DoEnter(BOOL bOk) //@@ ???
//STRIP001 {
//STRIP001 	String aFirstArgStr;
//STRIP001 	String aParaStr;
//STRIP001 	String aArgStr;
//STRIP001 	USHORT rStart=0;
//STRIP001 	USHORT rEnd=0;
//STRIP001 	String aString=pAllFuncList->GetSelectEntry();
//STRIP001 	SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001 	nArgs=0;
//STRIP001 
//STRIP001 	if(aString.Len()>0)
//STRIP001 	{
//STRIP001 
//STRIP001 		ScModule* pScMod = SC_MOD();
//STRIP001 		ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, pCurSh);
//STRIP001 		ScInputHandler* pHdl = pScMod->GetInputHdl( pViewSh );
//STRIP001 		if(!pScMod->IsEditMode())
//STRIP001 		{
//STRIP001 			pScMod->SetInputMode(SC_INPUT_TABLE);
//STRIP001 			aString = '=';
//STRIP001 			aString += pAllFuncList->GetSelectEntry();
//STRIP001 			if (pHdl)
//STRIP001 				pHdl->ClearText();
//STRIP001 		}
//STRIP001 		ScFuncDesc* pDesc =
//STRIP001 			 (ScFuncDesc*)pAllFuncList->GetEntryData(
//STRIP001 					pAllFuncList->GetSelectEntryPos() );
//STRIP001 		if (pDesc)
//STRIP001 		{
//STRIP001 			pFuncDesc=pDesc;
//STRIP001 			UpdateLRUList();
//STRIP001 			nArgs = pDesc->nArgCount;
//STRIP001 			if(nArgs>0)
//STRIP001 			{
//STRIP001 				aFirstArgStr = *(pDesc->aDefArgNames[0]);
//STRIP001 				aFirstArgStr.EraseLeadingAndTrailingChars();
//STRIP001                 aFirstArgStr.SearchAndReplaceAll(' ', '_');
//STRIP001 				aArgStr = aFirstArgStr;
//STRIP001 				if ( nArgs != VAR_ARGS )
//STRIP001 				{	// keine VarArgs oder Fix plus VarArgs, aber nicht nur VarArgs
//STRIP001 					String aArgSep = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM( "; " ));
//STRIP001 					USHORT nFix = ( nArgs < VAR_ARGS ? nArgs : nArgs - VAR_ARGS + 1 );
//STRIP001 					for ( USHORT nArg = 1;
//STRIP001 							nArg < nFix && !pDesc->aDefArgOpt[nArg]; nArg++ )
//STRIP001 					{
//STRIP001 						aArgStr += aArgSep;
//STRIP001                         String sTmp(*(pDesc->aDefArgNames[nArg]));
//STRIP001                         sTmp.EraseLeadingAndTrailingChars();
//STRIP001                         sTmp.SearchAndReplaceAll(' ', '_');
//STRIP001 						aArgStr += sTmp;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if (pHdl)
//STRIP001 		{
//STRIP001 			if(pHdl->GetEditString().Len()==0)
//STRIP001 			{
//STRIP001 				aString = '=';
//STRIP001 				aString += pAllFuncList->GetSelectEntry();
//STRIP001 			}
//STRIP001 			EditView *pEdView=pHdl->GetActiveView();
//STRIP001 			if(pEdView!=NULL) // @ Wegen Absturz bei Namen festlegen
//STRIP001 			{
//STRIP001 				if(nArgs>0)
//STRIP001 				{
//STRIP001 					pHdl->InsertFunction(aString);
//STRIP001 					pEdView->InsertText(aArgStr,TRUE);
//STRIP001 					ESelection	aESel=pEdView->GetSelection();
//STRIP001 					aESel.nEndPos=aESel.nStartPos+aFirstArgStr.Len();
//STRIP001 					pEdView->SetSelection(aESel);
//STRIP001 					pHdl->DataChanged();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "()" ));
//STRIP001 					pEdView->InsertText(aString,FALSE);
//STRIP001 					pHdl->DataChanged();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		InitLRUList();
//STRIP001 	}
//STRIP001 	if ( pCurSh )
//STRIP001 	{
//STRIP001 		Window* pShellWnd = pCurSh->GetWindow();
//STRIP001 
//STRIP001 		if ( pShellWnd )
//STRIP001 			pShellWnd->GrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 }



/*************************************************************************
#*	Handle:		SelHdl										Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Bei einer Aenderung der Kategorie wird die
#*				die Liste der Funktionen aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 IMPL_LINK( ScFunctionDockWin, SelHdl, ListBox*, pLb )
//STRIP001 {
//STRIP001 	if ( pLb == &aCatBox)
//STRIP001 	{
//STRIP001 		UpdateFunctionList();
//STRIP001 		SetDescription();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pLb == &aFuncList||pLb == &aDDFuncList)
//STRIP001 	{
//STRIP001 		SetDescription();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	//SetSize();
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
#*	Handle:		SelHdl										Datum:06.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Bei einer Aenderung der Kategorie wird die
#*				die Liste der Funktionen aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 IMPL_LINK( ScFunctionDockWin, SetSelectionHdl, void*, pCtrl )
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	ScFormEditData* pData = pScMod->GetFormEditData();
//STRIP001 
//STRIP001 	if ((ImageButton *)pCtrl == &aInsertButton ||
//STRIP001 		(ListBox *)pCtrl == &aFuncList)
//STRIP001 	{
//STRIP001 		DoEnter(TRUE);			// Uebernimmt die Eingabe
//STRIP001 	}
//STRIP001 	//...
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
#*	Handle:		SetSplitHdl									Datum:13.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScFunctionDockWin
#*
#*  Funktion:	Bei einer Aenderung des Split- Controls werden die
#*				einzelnen Controls an die neue Groesse angepasst.
#*
#*  Input:		Zeiger auf Control
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 IMPL_LINK( ScFunctionDockWin, SetSplitHdl, ScPrivatSplit*, pCtrl )
//STRIP001 {
//STRIP001 	if (pCtrl == &aPrivatSplit)
//STRIP001 	{
//STRIP001 		short nDeltaY=aPrivatSplit.GetDeltaY();
//STRIP001 		Size aFLSize=aFuncList.GetSizePixel();
//STRIP001 		Size aFDSize=aFiFuncDesc.GetSizePixel();
//STRIP001 		Point aFDTopLeft=aFiFuncDesc.GetPosPixel();
//STRIP001 
//STRIP001 		aFLSize.Height()+=nDeltaY;
//STRIP001 		aFDSize.Height()-=nDeltaY;
//STRIP001 		aFDTopLeft.Y()+=nDeltaY;
//STRIP001 		aFuncList.SetSizePixel(aFLSize);
//STRIP001 		aFiFuncDesc.SetPosPixel(aFDTopLeft);
//STRIP001 		aFiFuncDesc.SetSizePixel(aFDSize);
		/*
		aFuncList.Invalidate();
		aFuncList.Update();
		aFiFuncDesc.Invalidate();
		aFiFuncDesc.Update();
		*/
//STRIP001 	}
//STRIP001 	//...
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void ScFunctionDockWin::ToggleFloatingMode()
//STRIP001 {
//STRIP001 	aSplitterInitPos = Point();
//STRIP001 	SfxDockingWindow::ToggleFloatingMode();
//STRIP001 
//STRIP001 	eSfxNewAlignment=GetAlignment();
//STRIP001 	eSfxOldAlignment=eSfxNewAlignment;
//STRIP001 
//STRIP001 	aOldSize.Height()=0;
//STRIP001 	aOldSize.Width()=0;
//STRIP001 	aTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( ScFunctionDockWin, TimerHdl, Timer*, pTi)
//STRIP001 {
//STRIP001 	CheckAlignment(eSfxOldAlignment,eSfxNewAlignment);
//STRIP001 	SetSize();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void ScFunctionDockWin::Initialize(SfxChildWinInfo *pInfo)
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 	if(pInfo!=NULL)
//STRIP001 	{
//STRIP001 		if ( pInfo->aExtraString.Len() )
//STRIP001 		{
//STRIP001 			xub_StrLen nPos = pInfo->aExtraString.Search(
//STRIP001 				String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("ScFuncList:")));
//STRIP001 
//STRIP001 			// Versuche, den Alignment-String "ALIGN:(...)" einzulesen; wenn
//STRIP001 			// er nicht vorhanden ist, liegt eine "altere Version vor
//STRIP001 			if ( nPos != STRING_NOTFOUND )
//STRIP001 			{
//STRIP001 				xub_StrLen n1 = pInfo->aExtraString.Search('(', nPos);
//STRIP001 				if ( n1 != STRING_NOTFOUND )
//STRIP001 				{
//STRIP001 					xub_StrLen n2 = pInfo->aExtraString.Search(')', n1);
//STRIP001 					if ( n2 != STRING_NOTFOUND )
//STRIP001 					{
//STRIP001 						// Alignment-String herausschneiden
//STRIP001 						aStr = pInfo->aExtraString.Copy(nPos, n2 - nPos + 1);
//STRIP001 						pInfo->aExtraString.Erase(nPos, n2 - nPos + 1);
//STRIP001 						aStr.Erase(0, n1-nPos+1);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SfxDockingWindow::Initialize(pInfo);
//STRIP001 
//STRIP001 	if ( aStr.Len())
//STRIP001 	{
//STRIP001 		aSplitterInitPos=aPrivatSplit.GetPosPixel();
//STRIP001 		aSplitterInitPos.Y()=(USHORT) aStr.ToInt32();
//STRIP001 		xub_StrLen n1 = aStr.Search(';');
//STRIP001 		aStr.Erase(0, n1+1);
//STRIP001 		USHORT nSelPos=aStr.ToInt32();
//STRIP001 		aCatBox.SelectEntryPos(nSelPos);
//STRIP001 		SelHdl(&aCatBox);
//STRIP001 
//STRIP001 		//	if the window has already been shown (from SfxDockingWindow::Initialize if docked),
//STRIP001 		//	set the splitter position now, otherwise it is set in StateChanged with type INITSHOW
//STRIP001 
//STRIP001 		UseSplitterInitPos();
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void ScFunctionDockWin::FillInfo(SfxChildWinInfo& rInfo) const
//STRIP001 {
//STRIP001 	SfxDockingWindow::FillInfo(rInfo);
//STRIP001 	Point aPoint=aPrivatSplit.GetPosPixel();
//STRIP001 	rInfo.aExtraString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "ScFuncList:(" ));
//STRIP001 	rInfo.aExtraString += String::CreateFromInt32(aPoint.Y());
//STRIP001 	rInfo.aExtraString += ';';
//STRIP001 	rInfo.aExtraString += String::CreateFromInt32(aCatBox.GetSelectEntryPos());
//STRIP001 	rInfo.aExtraString += ')';
//STRIP001 }
//STRIP001 
//STRIP001 void ScFunctionDockWin::UseSplitterInitPos()
//STRIP001 {
//STRIP001 	if ( IsVisible() && aPrivatSplit.IsEnabled() && aSplitterInitPos != Point() )
//STRIP001 	{
//STRIP001 		aPrivatSplit.MoveSplitTo(aSplitterInitPos);
//STRIP001 		aSplitterInitPos = Point();		// use only once
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ScFunctionDockWin::StateChanged( StateChangedType nStateChange )
//STRIP001 {
//STRIP001 	SfxDockingWindow::StateChanged( nStateChange );
//STRIP001 
//STRIP001 	if (nStateChange == STATE_CHANGE_INITSHOW)
//STRIP001 	{
//STRIP001 		UseSplitterInitPos();			//	set initial splitter position if necessary
//STRIP001 	}
//STRIP001 }


}
