/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_htmlcfg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:13:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PRECOMPILED
// auto strip #include "ofapch.hxx"
#endif

#ifndef _PARHTML_HXX //autogen
#include <svtools/parhtml.hxx>
#endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
#ifndef _SVX_SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _SVX_TXENCBOX_HXX
// auto strip #include <bf_svx/txencbox.hxx>
// auto strip #endif

#include <bf_sfx2/viewfrm.hxx>

#pragma hdrstop

#include "htmlcfg.hxx"
// auto strip #include "resid.hxx"
#include "app.hrc"
namespace binfilter {

// -----------------------------------------------------------------------
#define HTMLCFG_UNKNOWN_TAGS 			0x01
//#define HTMLCFG_STYLE_SHEETS 			0x02
//#define HTMLCFG_NETSCAPE3    			0x04
#define HTMLCFG_STAR_BASIC   			0x08
#define HTMLCFG_LOCAL_GRF   			0x10
#define HTMLCFG_PRINT_LAYOUT_EXTENSION 	0x20
#define HTMLCFG_IGNORE_FONT_FAMILY	 	0x40
#define HTMLCFG_IS_BASIC_WARNING		0x80

using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;

#define C2U(cChar) OUString::createFromAscii(cChar)
/* -----------------------------23.11.00 11:39--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ struct HtmlOptions_Impl
/*N*/ {
/*N*/ 	sal_Int32 	nFlags;
/*N*/ 	sal_Int32 	nExportMode;
/*N*/ 	sal_Int32 	aFontSizeArr[HTML_FONT_COUNT];
/*N*/ 	sal_Int32 	eEncoding;
/*N*/     sal_Bool    bIsEncodingDefault;
/*N*/ 
/*N*/ 	HtmlOptions_Impl() :
/*N*/ 		nFlags(HTMLCFG_LOCAL_GRF|HTMLCFG_IS_BASIC_WARNING),
/*N*/ 		nExportMode(HTML_CFG_NS40),
/*N*/         eEncoding( gsl_getSystemTextEncoding() ),
/*N*/         bIsEncodingDefault(sal_True)
/*N*/ 	{
/*N*/ 		aFontSizeArr[0] = HTMLFONTSZ1_DFLT;
/*N*/ 		aFontSizeArr[1] = HTMLFONTSZ2_DFLT;
/*N*/ 		aFontSizeArr[2] = HTMLFONTSZ3_DFLT;
/*N*/ 		aFontSizeArr[3] = HTMLFONTSZ4_DFLT;
/*N*/ 		aFontSizeArr[4] = HTMLFONTSZ5_DFLT;
/*N*/ 		aFontSizeArr[5] = HTMLFONTSZ6_DFLT;
/*N*/ 		aFontSizeArr[6] = HTMLFONTSZ7_DFLT;
/*N*/ 	}
/*N*/ 
/*N*/ };

/* -----------------------------23.11.00 11:39--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ const Sequence<OUString>& OfaHtmlOptions::GetPropertyNames()
/*N*/ {
/*N*/ 	static Sequence<OUString> aNames;
/*N*/ 	if(!aNames.getLength())
/*N*/ 	{
/*N*/ 		static const char* aPropNames[] =
/*N*/ 		{
/*N*/ 			"Import/UnknownTag",					//  0
/*N*/ 			"Import/FontSetting",					//  1
/*N*/ 			"Import/FontSize/Size_1",				//  2
/*N*/ 			"Import/FontSize/Size_2",				//  3
/*N*/ 			"Import/FontSize/Size_3",				//  4
/*N*/ 			"Import/FontSize/Size_4",				//  5
/*N*/ 			"Import/FontSize/Size_5",				//  6
/*N*/ 			"Import/FontSize/Size_6",				//  7
/*N*/ 			"Import/FontSize/Size_7",				//  8
/*N*/ 			"Export/Browser",						//  9
/*N*/ 			"Export/Basic",							//  0
/*N*/ 			"Export/PrintLayout",					// 11
/*N*/ 			"Export/LocalGraphic",					// 12
/*N*/ 			"Export/Warning",    					// 13
/*N*/ 			"Export/Encoding"						// 14
/*N*/ 		};
/*N*/ 		const int nCount = sizeof(aPropNames) / sizeof(aPropNames[0]);
/*N*/ 		aNames.realloc(nCount);
/*N*/ 		OUString* pNames = aNames.getArray();
/*N*/ 		for(int i = 0; i < nCount; i++)
/*N*/ 			pNames[i] = C2U(aPropNames[i]);
/*N*/ 	}
/*N*/ 	return aNames;
/*N*/ }
// -----------------------------------------------------------------------
/*N*/ OfaHtmlOptions::OfaHtmlOptions() :
/*N*/ 	ConfigItem(C2U("Office.Common/Filter/HTML"))
/*N*/ {
/*N*/ 	pImp = new HtmlOptions_Impl;
/*N*/ 	const Sequence<OUString>& aNames = GetPropertyNames();
/*N*/ 	Sequence<Any> aValues = GetProperties(aNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/ 	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
/*N*/ 	if(aValues.getLength() == aNames.getLength())
/*N*/ 	{
/*N*/ 		pImp->nFlags = 0;
/*N*/ 		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
/*N*/ 		{
/*N*/ 			if(pValues[nProp].hasValue())
/*N*/ 			{
/*N*/ 				switch(nProp)
/*N*/ 				{
/*N*/ 					case  0:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_UNKNOWN_TAGS;
/*N*/ 					break;//"Import/UnknownTag",
/*N*/ 					case  1:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_IGNORE_FONT_FAMILY;
/*N*/ 					break;//"Import/FontSetting",
/*N*/ 					case  2: pValues[nProp] >>= pImp->aFontSizeArr[0]; break;//"Import/FontSize/Size_1",
/*N*/ 					case  3: pValues[nProp] >>= pImp->aFontSizeArr[1]; break;//"Import/FontSize/Size_2",
/*N*/ 					case  4: pValues[nProp] >>= pImp->aFontSizeArr[2]; break;//"Import/FontSize/Size_3",
/*N*/ 					case  5: pValues[nProp] >>= pImp->aFontSizeArr[3]; break;//"Import/FontSize/Size_4",
/*N*/ 					case  6: pValues[nProp] >>= pImp->aFontSizeArr[4]; break;//"Import/FontSize/Size_5",
/*N*/ 					case  7: pValues[nProp] >>= pImp->aFontSizeArr[5]; break;//"Import/FontSize/Size_6",
/*N*/ 					case  8: pValues[nProp] >>= pImp->aFontSizeArr[6]; break;//"Import/FontSize/Size_7",
/*N*/ 					case  9://"Export/Browser",
/*N*/ 						{
/*N*/ 							sal_Int32 nExpMode;
/*N*/ //							pValues[nProp] >>= pImp->nExportMode;
/*N*/ 							pValues[nProp] >>= nExpMode;
/*N*/ 							switch( nExpMode )
/*N*/ 							{
/*N*/ 								case 0:		nExpMode = HTML_CFG_HTML32;		break;
/*N*/ 								case 1:		nExpMode = HTML_CFG_MSIE_40;	break;
/*N*/ //								case 2:		nExpMode = HTML_CFG_NS30;		break;	depricated
/*N*/ 								case 3:		nExpMode = HTML_CFG_WRITER;		break;
/*N*/ 								case 4:		nExpMode = HTML_CFG_NS40;		break;
/*N*/ 								case 5:		nExpMode = HTML_CFG_MSIE_40_OLD;break;
/*N*/ 								default:	nExpMode = HTML_CFG_NS40;		break;
/*N*/ 							}
/*N*/ 
/*N*/ 							pImp->nExportMode = nExpMode;
/*N*/ 						}
/*N*/ 						break;
/*N*/ 					case 10:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_STAR_BASIC;
/*N*/ 					break;//"Export/Basic",
/*N*/ 					case 11:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_PRINT_LAYOUT_EXTENSION;
/*N*/ 					break;//"Export/PrintLayout",
/*N*/ 					case 12:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							pImp->nFlags |= HTMLCFG_LOCAL_GRF;
/*N*/ 					break;//"Export/LocalGraphic",
/*N*/ 					case 13:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							pImp->nFlags |= HTMLCFG_IS_BASIC_WARNING;
/*N*/ 					break;//"Export/Warning"
/*N*/ 
/*N*/                     case 14: pValues[nProp] >>= pImp->eEncoding;
/*?*/                              pImp->bIsEncodingDefault = sal_False;
/*N*/                     break;//"Export/Encoding"
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ OfaHtmlOptions::~OfaHtmlOptions()
/*N*/ {
/*N*/ 	delete pImp;
/*N*/ }
// -----------------------------------------------------------------------
//STRIP001 void	OfaHtmlOptions::Commit()
//STRIP001 {
//STRIP001 	const Sequence<OUString>& aNames = GetPropertyNames();
//STRIP001 
//STRIP001 	const OUString* pNames = aNames.getConstArray();
//STRIP001 	Sequence<Any> aValues(aNames.getLength());
//STRIP001 	Any* pValues = aValues.getArray();
//STRIP001 
//STRIP001 	const Type& rType = ::getBooleanCppuType();
//STRIP001 	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
//STRIP001 	{
//STRIP001 		sal_Bool bSet = sal_False;
//STRIP001 		switch(nProp)
//STRIP001 		{
//STRIP001 			case  0: bSet = 0 != (pImp->nFlags & HTMLCFG_UNKNOWN_TAGS);break;//"Import/UnknownTag",
//STRIP001 			case  1: bSet = 0 != (pImp->nFlags & HTMLCFG_IGNORE_FONT_FAMILY);break;//"Import/FontSetting",
//STRIP001 			case  2: pValues[nProp] <<= pImp->aFontSizeArr[0];break;//"Import/FontSize/Size_1",
//STRIP001 			case  3: pValues[nProp] <<= pImp->aFontSizeArr[1];break;//"Import/FontSize/Size_2",
//STRIP001 			case  4: pValues[nProp] <<= pImp->aFontSizeArr[2];break;//"Import/FontSize/Size_3",
//STRIP001 			case  5: pValues[nProp] <<= pImp->aFontSizeArr[3];break;//"Import/FontSize/Size_4",
//STRIP001 			case  6: pValues[nProp] <<= pImp->aFontSizeArr[4];break;//"Import/FontSize/Size_5",
//STRIP001 			case  7: pValues[nProp] <<= pImp->aFontSizeArr[5];break;//"Import/FontSize/Size_6",
//STRIP001 			case  8: pValues[nProp] <<= pImp->aFontSizeArr[6];break;//"Import/FontSize/Size_7",
//STRIP001 			case  9:				//"Export/Browser",
//STRIP001 				{
//STRIP001 					sal_Int32 nExpMode = pImp->nExportMode;
//STRIP001 
//STRIP001 					switch( nExpMode )
//STRIP001 					{
//STRIP001 						case HTML_CFG_HTML32:		nExpMode = 0;	break;
//STRIP001 						case HTML_CFG_MSIE_40:		nExpMode = 1;	break;
//STRIP001 //						case HTML_CFG_NS30:			nExpMode = 2;	break;	depricated
//STRIP001 						case HTML_CFG_WRITER:		nExpMode = 3;	break;
//STRIP001 						case HTML_CFG_NS40:			nExpMode = 4;	break;
//STRIP001 						case HTML_CFG_MSIE_40_OLD:	nExpMode = 5;	break;
//STRIP001 						default:					nExpMode = 4;	break;	// NS40
//STRIP001 					}
//STRIP001 
//STRIP001 					pValues[nProp] <<= nExpMode;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			case 10: bSet = 0 != (pImp->nFlags & HTMLCFG_STAR_BASIC);break;//"Export/Basic",
//STRIP001 			case 11: bSet = 0 != (pImp->nFlags & HTMLCFG_PRINT_LAYOUT_EXTENSION);break;//"Export/PrintLayout",
//STRIP001 			case 12: bSet = 0 != (pImp->nFlags & HTMLCFG_LOCAL_GRF);break;//"Export/LocalGraphic",
//STRIP001 			case 13: bSet = 0 != (pImp->nFlags & HTMLCFG_IS_BASIC_WARNING);break;//"Export/Warning"
//STRIP001             case 14:
//STRIP001                 if(!pImp->bIsEncodingDefault)
//STRIP001                     pValues[nProp] <<= pImp->eEncoding;
//STRIP001                 break;//"Export/Encoding",
//STRIP001 		}
//STRIP001 		if(nProp < 2 || ( nProp > 9 && nProp < 14 ))
//STRIP001 			pValues[nProp].setValue(&bSet, ::getCppuBooleanType());
//STRIP001 	}
//STRIP001 	PutProperties(aNames, aValues);
//STRIP001 }
// -----------------------------------------------------------------------
//STRIP001 USHORT 	OfaHtmlOptions::GetFontSize(USHORT nPos) const
//STRIP001 {
//STRIP001 	if(nPos < HTML_FONT_COUNT)
//STRIP001 		return (USHORT)pImp->aFontSizeArr[nPos];
//STRIP001 	return 0;
//STRIP001 }
// -----------------------------------------------------------------------
//STRIP001 void OfaHtmlOptions::SetFontSize(USHORT nPos, USHORT nSize)
//STRIP001 {
//STRIP001 	if(nPos < HTML_FONT_COUNT)
//STRIP001 	{
//STRIP001 		pImp->aFontSizeArr[nPos] = nSize;
//STRIP001 		SetModified();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------


//STRIP001 BOOL OfaHtmlOptions::IsImportUnknown() const
//STRIP001 {
//STRIP001 	return 0 != (pImp->nFlags & HTMLCFG_UNKNOWN_TAGS) ;
//STRIP001 }

// -----------------------------------------------------------------------


//STRIP001 void OfaHtmlOptions::SetImportUnknown(BOOL bSet)
//STRIP001 {
//STRIP001 	if(bSet)
//STRIP001 		pImp->nFlags |= HTMLCFG_UNKNOWN_TAGS;
//STRIP001 	else
//STRIP001 		pImp->nFlags &= ~HTMLCFG_UNKNOWN_TAGS;
//STRIP001 	SetModified();
//STRIP001 }

// -----------------------------------------------------------------------


//STRIP001 USHORT 	OfaHtmlOptions::GetExportMode() const
//STRIP001 {
//STRIP001 	return (USHORT)pImp->nExportMode;
//STRIP001 }

// -----------------------------------------------------------------------


//STRIP001 void OfaHtmlOptions::SetExportMode(USHORT nSet)
//STRIP001 {
//STRIP001 	if(nSet <= HTML_CFG_MAX )
//STRIP001 	{
//STRIP001 		pImp->nExportMode = nSet;
//STRIP001 		SetModified();
//STRIP001 		// Invalidierung, falls blinkender Text erlaubt/verboten wurde
//STRIP001         SfxViewFrame* pViewFrame = SfxViewFrame::Current();
//STRIP001         if(pViewFrame)
//STRIP001             pViewFrame->GetBindings().Invalidate(SID_DRAW_TEXT_MARQUEE);
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------


//STRIP001 BOOL OfaHtmlOptions::IsStarBasic() const
//STRIP001 {
//STRIP001 	return 0 != (pImp->nFlags & HTMLCFG_STAR_BASIC) ;
//STRIP001 }

// -----------------------------------------------------------------------


//STRIP001 void OfaHtmlOptions::SetStarBasic(BOOL bSet)
//STRIP001 {
//STRIP001 	if(bSet)
//STRIP001 		pImp->nFlags |=  HTMLCFG_STAR_BASIC;
//STRIP001 	else
//STRIP001 		pImp->nFlags &= ~HTMLCFG_STAR_BASIC;
//STRIP001 	SetModified();
//STRIP001 }

/*-----------------14.02.97 08.34-------------------

--------------------------------------------------*/

//STRIP001 BOOL OfaHtmlOptions::IsSaveGraphicsLocal() const
//STRIP001 {
//STRIP001 	return 0 != (pImp->nFlags & HTMLCFG_LOCAL_GRF) ;
//STRIP001 }
/*-----------------14.02.97 08.34-------------------

--------------------------------------------------*/
//STRIP001 void OfaHtmlOptions::SetSaveGraphicsLocal(BOOL bSet)
//STRIP001 {
//STRIP001 	if(bSet)
//STRIP001 		pImp->nFlags |=  HTMLCFG_LOCAL_GRF;
//STRIP001 	else
//STRIP001 		pImp->nFlags &= ~HTMLCFG_LOCAL_GRF;
//STRIP001 	SetModified();
//STRIP001 }

/*-----------------10/21/97 08:34am-----------------

--------------------------------------------------*/

/*N*/ BOOL 	OfaHtmlOptions::IsPrintLayoutExtension() const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	BOOL bRet = 0 != (pImp->nFlags & HTMLCFG_PRINT_LAYOUT_EXTENSION);
//STRIP001 	switch( pImp->nExportMode )
//STRIP001 	{
//STRIP001 		case HTML_CFG_MSIE_40:
//STRIP001 		case HTML_CFG_NS40  :
//STRIP001 		case HTML_CFG_WRITER :
//STRIP001 		break;
//STRIP001 		default:
//STRIP001 			bRet = FALSE;
//STRIP001 	}
//STRIP001 	return bRet;
/*N*/ }
/*-----------------10/21/97 08:34am-----------------

--------------------------------------------------*/
//STRIP001 void	OfaHtmlOptions::SetPrintLayoutExtension(BOOL bSet)
//STRIP001 {
//STRIP001 	if(bSet)
//STRIP001 		pImp->nFlags |=  HTMLCFG_PRINT_LAYOUT_EXTENSION;
//STRIP001 	else
//STRIP001 		pImp->nFlags &= ~HTMLCFG_PRINT_LAYOUT_EXTENSION;
//STRIP001 	SetModified();
//STRIP001 }

/*-----------------10.07.98 10.02-------------------

--------------------------------------------------*/

//STRIP001 BOOL OfaHtmlOptions::IsIgnoreFontFamily() const
//STRIP001 {
//STRIP001 	return 0 != (pImp->nFlags & HTMLCFG_IGNORE_FONT_FAMILY) ;
//STRIP001 }
/*-----------------10.07.98 10.02-------------------

--------------------------------------------------*/
//STRIP001 void OfaHtmlOptions::SetIgnoreFontFamily(BOOL bSet)
//STRIP001 {
//STRIP001 	if(bSet)
//STRIP001 		pImp->nFlags |=  HTMLCFG_IGNORE_FONT_FAMILY;
//STRIP001 	else
//STRIP001 		pImp->nFlags &= ~HTMLCFG_IGNORE_FONT_FAMILY;
//STRIP001 	SetModified();
//STRIP001 }
/* -----------------05.02.99 09:03-------------------
 *
 * --------------------------------------------------*/
//STRIP001 BOOL OfaHtmlOptions::IsStarBasicWarning() const
//STRIP001 {
//STRIP001 	return 0 != (pImp->nFlags & HTMLCFG_IS_BASIC_WARNING) ;
//STRIP001 }
/* -----------------05.02.99 09:03-------------------
 *
 * --------------------------------------------------*/
//STRIP001 void OfaHtmlOptions::SetStarBasicWarning(BOOL bSet)
//STRIP001 {
//STRIP001 	if(bSet)
//STRIP001 		pImp->nFlags |=  HTMLCFG_IS_BASIC_WARNING;
//STRIP001 	else
//STRIP001 		pImp->nFlags &= ~HTMLCFG_IS_BASIC_WARNING;
//STRIP001 	SetModified();
//STRIP001 }

/*-----------------19.02.2001 18:40-----------------
 *
 * --------------------------------------------------*/
//STRIP001 rtl_TextEncoding OfaHtmlOptions::GetTextEncoding() const
//STRIP001 {
//STRIP001     rtl_TextEncoding eRet;
//STRIP001     if(pImp->bIsEncodingDefault)
//STRIP001         eRet = SvxTextEncodingBox::GetBestMimeEncoding();
//STRIP001     else
//STRIP001         eRet = (rtl_TextEncoding)pImp->eEncoding;
//STRIP001     return eRet;
//STRIP001 }

/*-----------------19.02.2001 18:40-----------------
 *
 * --------------------------------------------------*/
//STRIP001 void OfaHtmlOptions::SetTextEncoding( rtl_TextEncoding eEnc )
//STRIP001 {
//STRIP001 	pImp->eEncoding = eEnc;
//STRIP001     pImp->bIsEncodingDefault = sal_False;
//STRIP001 	SetModified();
//STRIP001 }
/* -----------------------------15.08.2001 12:01------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool OfaHtmlOptions::IsDefaultTextEncoding() const
//STRIP001 {
//STRIP001     return pImp->bIsEncodingDefault;
//STRIP001 }
}
