/*
 * URLDispatcher.java
 *
 * Created on 22. Juli 2003, 15:08
 */
package com.sun.star.wizards.tutorial.executer.util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class URLDispatcher {
    /**
     * DOCUMENT ME!
     *
     * @param xframe DOCUMENT ME!
     * @param url DOCUMENT ME!
     * @param aTargetFrameName DOCUMENT ME!
     * @param nSearchFlags DOCUMENT ME!
     * @param aArgs DOCUMENT ME!
     */
    public static void dispatch_Thread(final XFrame xframe, final String url, final String aTargetFrameName, final int nSearchFlags, final PropertyValue[] aArgs) {
        Thread thread = new Thread(new Runnable() {
            public void run() {
                dispatch(xframe, url, aTargetFrameName, nSearchFlags, aArgs);
            }
        });
        thread.setPriority(Thread.MAX_PRIORITY);
        thread.start();
    }

    /**
     * DOCUMENT ME!
     *
     * @param xframe DOCUMENT ME!
     * @param url DOCUMENT ME!
     * @param aTargetFrameName DOCUMENT ME!
     * @param nSearchFlags DOCUMENT ME!
     * @param aArgs DOCUMENT ME!
     */
    public static synchronized void dispatch(XFrame xframe, String url, String aTargetFrameName, int nSearchFlags, PropertyValue[] aArgs) {
        if (xframe != null) {
            XDispatchProvider xdp = null;

            try {
                xdp = (XDispatchProvider) UnoRuntime.queryInterface(XDispatchProvider.class, xframe);
            } catch (Exception e) {
            }

            URL aURL = new URL();
            aURL.Complete = url;

            XDispatch xdis = xdp.queryDispatch(aURL, aTargetFrameName, nSearchFlags);

            if (xdis != null) {
                PropertyValue[] aArgss = new PropertyValue[0];
                xdis.dispatch(aURL, aArgss);
            } else {
                System.out.println("this is NULL!!");
            }
        }
    }
}
