/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fmdmod.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 15:53:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_FMDMOD_HXX
#include "fmdmod.hxx"
#endif

#ifndef _SVX_FMSERVS_HXX
#include "fmservs.hxx"
#endif
#ifndef _SVX_FMOBJ_HXX
#include <fmobj.hxx>
#endif
#ifndef _SVX_UNOSHAPE_HXX
#include <unoshape.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#include "fmglob.hxx"

using namespace ::svxform;

//-----------------------------------------------------------------------------
::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  SAL_CALL SvxFmMSFactory::createInstance(const ::rtl::OUString& ServiceSpecifier) throw( ::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException )
{
	::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  xRet;
	if ( ServiceSpecifier.indexOf( ::rtl::OUString::createFromAscii("com.sun.star.form.component.") ) == 0 )
	{
		xRet = ::comphelper::getProcessServiceFactory()->createInstance(ServiceSpecifier);
	}
	else if ( ServiceSpecifier == ::rtl::OUString( ::rtl::OUString::createFromAscii("com.sun.star.drawing.ControlShape") ) )
	{
		SdrObject* pObj = new FmFormObj(OBJ_FM_CONTROL);
		xRet = *new SvxShapeControl(pObj);
	}
	if (!xRet.is())
		xRet = SvxUnoDrawMSFactory::createInstance(ServiceSpecifier);
	return xRet;
}

//-----------------------------------------------------------------------------
::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > SAL_CALL  SvxFmMSFactory::createInstanceWithArguments(const ::rtl::OUString& ServiceSpecifier, const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& Arguments) throw( ::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException )
{
	return SvxUnoDrawMSFactory::createInstanceWithArguments(ServiceSpecifier, Arguments );
}

//-----------------------------------------------------------------------------
::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL SvxFmMSFactory::getAvailableServiceNames(void) throw( ::com::sun::star::uno::RuntimeException )
{
	static const ::rtl::OUString aSvxComponentServiceNameList[] =
	{
		FM_SUN_COMPONENT_TEXTFIELD,
		FM_SUN_COMPONENT_FORM,
		FM_SUN_COMPONENT_LISTBOX,
		FM_SUN_COMPONENT_COMBOBOX,
		FM_SUN_COMPONENT_RADIOBUTTON,
		FM_SUN_COMPONENT_GROUPBOX,
		FM_SUN_COMPONENT_FIXEDTEXT,
		FM_SUN_COMPONENT_COMMANDBUTTON,
		FM_SUN_COMPONENT_CHECKBOX,
		FM_SUN_COMPONENT_GRIDCONTROL,
		FM_SUN_COMPONENT_IMAGEBUTTON,
		FM_SUN_COMPONENT_FILECONTROL,
		FM_SUN_COMPONENT_TIMEFIELD,
		FM_SUN_COMPONENT_DATEFIELD,
		FM_SUN_COMPONENT_NUMERICFIELD,
		FM_SUN_COMPONENT_CURRENCYFIELD,
		FM_SUN_COMPONENT_PATTERNFIELD,
		FM_SUN_COMPONENT_HIDDENCONTROL,
		FM_SUN_COMPONENT_IMAGECONTROL
	};

	static const sal_uInt16 nSvxComponentServiceNameListCount = sizeof(aSvxComponentServiceNameList) / sizeof ( aSvxComponentServiceNameList[0] );

	::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq( nSvxComponentServiceNameListCount );
	::rtl::OUString* pStrings = aSeq.getArray();
	for( sal_uInt16 nIdx = 0; nIdx < nSvxComponentServiceNameListCount; nIdx++ )
		pStrings[nIdx] = aSvxComponentServiceNameList[nIdx];

	::com::sun::star::uno::Sequence< ::rtl::OUString > aParentSeq( SvxUnoDrawMSFactory::getAvailableServiceNames() );
	return concatServiceNames( aParentSeq, aSeq );
}

/*
// XServiceManager
::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  SvxFmDrawModel::createInstance(const ::rtl::OUString& ServiceName)
			const throw( ::com::sun::star::lang::ServiceNotRegisteredException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException )
{
	::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  xRet;
	sal_uInt16 nTokenCount = ServiceName.getTokenCount('.');
	if (nTokenCount == 5 &&
		ServiceName.getToken( 0, '.' ) == ::rtl::OUString::createFromAscii("stardiv") &&
		ServiceName.getToken( 1, '.' ) == ::rtl::OUString::createFromAscii("one") &&
		ServiceName.getToken( 2, '.' ) == ::rtl::OUString::createFromAscii("form") &&
		ServiceName.getToken( 3, '.' ) == ::rtl::OUString::createFromAscii("component"))
	{
		xRet = ::comphelper::getProcessServiceFactory()->createInstance(ServiceName);
	}
	else
	if (nTokenCount == 4 &&
		ServiceName.getToken( 0, '.' ) == ::rtl::OUString::createFromAscii("stardiv") &&
		ServiceName.getToken( 1, '.' ) == ::rtl::OUString::createFromAscii("one") &&
		ServiceName.getToken( 2, '.' ) == ::rtl::OUString::createFromAscii("drawing") &&
		ServiceName.getToken( 3, '.' ) == ::rtl::OUString::createFromAscii("ControlShape"))
	{
		SdrObject* pObj = new FmFormObj();
		xRet = *new SvxShapeControl(pObj);
	}
	if (!xRet.is())
		xRet = SvxUnoDrawModel::createInstance(ServiceName);
	return xRet;
}
*/


