/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tpappopt.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:55:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_TPAPPOPT_HXX
#define _SCH_TPAPPOPT_HXX

// header for SfxTabPage
#ifndef _SFXTABDLG_HXX
#include <sfx2/tabdlg.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
// header for ValueSet
#ifndef _VALUESET_HXX
#include <svtools/valueset.hxx>
#endif
// header for ColorLB
#ifndef _SVX_DLG_CTRL_HXX
#include <svx/dlgctrl.hxx>
#endif
// header for PushButton
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
// header for XColorTable
#ifndef _XTABLE_HXX
#include <xtable.hxx>
#endif

#include "schopt.hxx"

class ChartColorLB : public ColorLB
{
public:
	ChartColorLB( Window* pParent, ResId Id ) : ColorLB( pParent, Id ) {}
	ChartColorLB( Window* pParent, WinBits aWB ) : ColorLB( pParent, aWB ) {}

	virtual void Fill( const SchColorTable* pTab );
};


class SchDefaultColorOptPage : public SfxTabPage
{
private:
    FixedLine       aGbChartColors;
	ChartColorLB	aLbChartColors;
    FixedLine       aGbColorBox;
	ValueSet		aValSetColorBox;
	PushButton		aPBDefault;

	SchColorTableItem*	pColorConfig;
	XColorTable*		pColorTab;

	DECL_LINK( ResetToDefaults, void * );
	DECL_LINK( ListClickedHdl, ChartColorLB * );
	DECL_LINK( BoxClickedHdl, ValueSet * );

	void FillColorBox();
	long GetColorIndex( const Color& rCol );

public:
	SchDefaultColorOptPage( Window* pParent, const SfxItemSet& rInAttrs );
	virtual ~SchDefaultColorOptPage();

	void	Construct();

	static SfxTabPage* Create( Window* pParent, const SfxItemSet& rInAttrs );
	virtual BOOL FillItemSet( SfxItemSet& rOutAttrs );
	virtual void Reset( const SfxItemSet& rInAttrs );
};

#endif	// _SCH_TPAPPOPT_HXX

