/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ifcc_ty.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:18:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <store/ifcc_ty.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/idg.hxx>
#include <ary/cpp/c_namesp.hxx>
#include <ary/cpp/c_class.hxx>
#include <ary/cpp/usedtype.hxx>
#include <ary/cpp/c_osigna.hxx>
#include <cpp/predecla.hxx>
#include "sto_cpp.hxx"
#include "ti_storg.hxx"




namespace ary
{
namespace store
{
namespace cpp
{

using ary::cpp::TypeOwnerNode;
using ary::cpp::ToNode_Namespace;
using ary::cpp::ToNode_Class;
using ary::cpp::BuiltInType;


//********************		Less_OSPtr		**************//

struct Less_OSPtr
{
  bool          operator()(
						const ary::cpp::OperationSignature *
												i_p1,
						const ary::cpp::OperationSignature *
												i_p2 ) const;
};

bool
Less_OSPtr::operator()( const ary::cpp::OperationSignature * i_p1,
						const ary::cpp::OperationSignature * i_p2 ) const
{
	return *i_p1 < *i_p2;
}


//********************		CheshireCat		**************//

struct Type_Ifc::CheshireCat
{
	typedef std::map< uintt, DYN TypeOwnerNode * > 	NodeIndex;
	typedef std::map< Tid, BuiltInType * > 	    	BuiltInTypeIndex;
	typedef std::map< udmstri, BuiltInType * > 	    Index_Name2BuiltInType;
	typedef std::map< const ary::cpp::OperationSignature*, OSid, Less_OSPtr >
													Index_OSignature2Id;

	NodeIndex			aNodeIndex;		// Owned heap objects that have to be deleted.
	BuiltInTypeIndex	aBuiltInTypeIndex;
	Index_Name2BuiltInType
						aIndex_Name2BuiltInType;
	Index_OSignature2Id	aIndex_OSignature2Id;
	ary::store::Cpp *	pStorageCpp;
    TypeOwnerNode *		pNode_GlobalNamespace;
    Tid                 nFirstIdBuiltInTypes;

						CheshireCat(
							ary::store::Cpp &	io_rStorageCpp,
                            Tid                 i_nFirstIdBuiltInTypes );
						~CheshireCat();

	ToNode_Namespace &	CreateNspNode_AndPut2Index(
							const ary::cpp::Namespace &
												i_rNamespace,
							TypeOwnerNode *		i_pParent );
	void				Create_BuiltInTypeIndex();
	const char *		SpecialisedBuiltInType(
							const char * 		i_sName,
							ary::cpp::E_TypeSpecialisation
												i_eTypeSpecialisation ) const;
  private:
	void				Add_BuiltInType(
							Tid					i_nId,
							const char *		i_sName,
							ary::cpp::E_TypeSpecialisation
												i_eSpecialisation = ary::cpp::TYSP_none );
};


Type_Ifc::
CheshireCat::CheshireCat( ary::store::Cpp &	 io_rStorageCpp,
                          Tid                i_nFirstIdBuiltInTypes )
	:	// aNodeIndex,
		// aBuiltInTypeIndex,
        // aIndex_Name2BuiltInType,
	    // aIndex_OSignature2Id,
		pStorageCpp(&io_rStorageCpp),
		pNode_GlobalNamespace(0),
        nFirstIdBuiltInTypes(i_nFirstIdBuiltInTypes)
{
	Create_BuiltInTypeIndex();
}

Type_Ifc::
CheshireCat::~CheshireCat()
{
	csv::erase_map_of_heap_ptrs(aNodeIndex);
	csv::erase_map_of_heap_ptrs(aBuiltInTypeIndex);
}

ToNode_Namespace &
Type_Ifc::
CheshireCat::CreateNspNode_AndPut2Index( const ary::cpp::Namespace & i_rNamespace,
										 TypeOwnerNode *	         i_pParent )
{
	ToNode_Namespace * dpNew
			= new ToNode_Namespace( i_rNamespace, i_pParent );
	aNodeIndex.insert( NodeIndex::value_type(i_rNamespace.Id(), dpNew) );
	return *dpNew;
}

void
Type_Ifc::
CheshireCat::Create_BuiltInTypeIndex()
{
	Tid nCounter_TypeIds = nFirstIdBuiltInTypes;

	Add_BuiltInType( nCounter_TypeIds++, "void" );
	Add_BuiltInType( nCounter_TypeIds++, "char" );
	Add_BuiltInType( nCounter_TypeIds++, "char", ary::cpp::TYSP_signed );
	Add_BuiltInType( nCounter_TypeIds++, "char", ary::cpp::TYSP_unsigned );
	Add_BuiltInType( nCounter_TypeIds++, "short" );
	Add_BuiltInType( nCounter_TypeIds++, "short", ary::cpp::TYSP_unsigned );
	Add_BuiltInType( nCounter_TypeIds++, "int" );
	Add_BuiltInType( nCounter_TypeIds++, "int", ary::cpp::TYSP_unsigned );
	Add_BuiltInType( nCounter_TypeIds++, "long" );
	Add_BuiltInType( nCounter_TypeIds++, "long", ary::cpp::TYSP_unsigned );
	Add_BuiltInType( nCounter_TypeIds++, "bool" );
	Add_BuiltInType( nCounter_TypeIds++, "float" );
	Add_BuiltInType( nCounter_TypeIds++, "double" );
	Add_BuiltInType( nCounter_TypeIds++, "size_t" );
	Add_BuiltInType( nCounter_TypeIds++, "wchar_t" );
}

namespace
{
    StreamStr ret_(60);
}

const char *
Type_Ifc::
CheshireCat::SpecialisedBuiltInType( const char *					i_sName,
									 ary::cpp::E_TypeSpecialisation	i_eTypeSpecialisation ) const
{
    ret_.seekp(0);

	switch ( i_eTypeSpecialisation )
	{
		case ary::cpp::TYSP_none:
					ret_ << i_sName;
                    break;
		case ary::cpp::TYSP_unsigned:
		{
                    ret_ << "u_" << i_sName;
                    break;
        }
		case ary::cpp::TYSP_signed:
		{
                    ret_ << "s_" << i_sName;
                    break;
        }
	}	// end switch
    return ret_.c_str();
}

void
Type_Ifc::
CheshireCat::Add_BuiltInType( Tid							 i_nId,
							  const char *		             i_sName,
							  ary::cpp::E_TypeSpecialisation i_eSpecialisation )
{
	DYN BuiltInType * dpNew
			= new BuiltInType( i_nId, i_sName, i_eSpecialisation );

	aBuiltInTypeIndex.insert( BuiltInTypeIndex::value_type( i_nId, dpNew ) );
	udmstri sSpecialisedName(
				SpecialisedBuiltInType(i_sName, i_eSpecialisation) );
	aIndex_Name2BuiltInType.insert(
		Index_Name2BuiltInType::value_type( sSpecialisedName, dpNew ) );
}


//********************		Type_Ifc		**************//

Type_Ifc::Type_Ifc( ary::store::Cpp & io_rStorageCpp,
                    Tid               i_nFirstIdBuiltInTypes )
	:	pi( new CheshireCat(io_rStorageCpp, i_nFirstIdBuiltInTypes) )
{
}

void
Type_Ifc::Init_GlobalNamespaceNode( const ary::cpp::Namespace & i_rNamespace )
{
	pi->pNode_GlobalNamespace =
			& pi->CreateNspNode_AndPut2Index( i_rNamespace, 0 );
}

Type_Ifc::~Type_Ifc()
{
}

TypeOwnerNode &
Type_Ifc::Add_OwnerNode( const ary::cpp::Namespace & i_rNamespace,
						 TypeOwnerNode &	         i_rParent )
{
	ToNode_Namespace & rNew =
			pi->CreateNspNode_AndPut2Index( i_rNamespace, &i_rParent );
	i_rParent.Add_LocalOwner( rNew );
	return rNew;
}

TypeOwnerNode &
Type_Ifc::Add_OwnerNode( const ary::cpp::Class & 	i_rClass,
						 TypeOwnerNode &	        i_rParent )
{
	ToNode_Class * dpNew
			= new ToNode_Class( i_rClass, &i_rParent );
	pi->aNodeIndex.insert(
			CheshireCat::NodeIndex::value_type(i_rClass.Id(), dpNew) );
	i_rParent.Add_LocalOwner( *dpNew );
	return *dpNew;
}

const ary::cpp::Type &
Type_Ifc::Add_Type( DYN ary::cpp::UsedType & let_drUsedType )
{
	return pi->pStorageCpp->UsedTypes().Add( let_drUsedType.Id(), let_drUsedType );
}

void
Type_Ifc::Add_OperationSignature( OSid   							 i_nId,
								  DYN ary::cpp::OperationSignature & let_drOSigna )
{
	pi->pStorageCpp->OSigns().Add( i_nId, let_drOSigna );
	pi->aIndex_OSignature2Id.insert(
		CheshireCat::Index_OSignature2Id::value_type(&let_drOSigna, i_nId) );
}

uintt
Type_Ifc::ForEachType( const Manipulator< ary::cpp::UsedType > & i_rManip )
{
    return pi->pStorageCpp->UsedTypes().ForEach( i_rManip );
}

const ary::cpp::Type *
Type_Ifc::Find_Type( Tid i_nType ) const
{
	const ary::cpp::Type * ret
			= csv::value_from_map( pi->aBuiltInTypeIndex,i_nType );
	if ( ret == 0 )
		ret = pi->pStorageCpp->UsedTypes().Find( i_nType );
	return ret;
}

const ary::cpp::OperationSignature *
Type_Ifc::Find_OperationSignature( OSid i_nOSigna ) const
{
	return pi->pStorageCpp->OSigns().Find( i_nOSigna );
}

const ary::cpp::Type *
Type_Ifc::Search_BuiltInType( const udmstri & 				 i_sName,
							  ary::cpp::E_TypeSpecialisation i_eSpecialisation ) const
{
	udmstri sSpecialisedName(
				pi->SpecialisedBuiltInType(i_sName, i_eSpecialisation) );

	return csv::value_from_map( pi->aIndex_Name2BuiltInType, sSpecialisedName );
}

OSid
Type_Ifc::SearchId_OperationSignature( const ary::cpp::OperationSignature & i_rOSigna ) const
{
	CheshireCat::Index_OSignature2Id::const_iterator itFound
			= pi->aIndex_OSignature2Id.find( &i_rOSigna );
	return itFound != pi->aIndex_OSignature2Id.end()
							?   (*itFound).second
							:   static_cast<OSid>(0);
}

TypeOwnerNode &
Type_Ifc::GlobalNamespaceNode()
{
	return * pi->pNode_GlobalNamespace;
}



} // namespace cpp
} // namespace store
} // namespace ary

