/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: BlockStack.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:21:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

public final class BlockStack {
  private static final int STACKSIZE = 8;
  private int         _sp = -1; // stack pointer
  private int[]       _blStack; // internal block
  private int[]       _ixStack; // index of next key to look at
    
  public BlockStack() {
    _blStack = new int[STACKSIZE];
    _ixStack = new int[STACKSIZE];
  }
    
  public void push(int blockNumber, int index) {
    _sp++;
    _blStack[_sp] = blockNumber;
    _ixStack[_sp] = index;
  }

  public int topBlockNumber() {
    return _blStack[_sp];
  }

  public int topIndex() {
    return _ixStack[_sp];
  }

  public void increaseIndex() {
    _ixStack[_sp]++;
  }
  
  public void pop() {
    _sp--;
  }

  public int size() {
    return _sp + 1;
  }

  public void clear() {
    _sp = -1;
  }
}
  
