/*************************************************************************
 *
 *  $RCSfile: infocom.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "infocom.hxx"

/*************************************************************************

  content:	Holds all definations of Datapacks
			for informationserver communication

*************************************************************************/

//#include <string.h>



/************************************************************************/
InfoDataPack::InfoDataPack( )
/************************************************************************/
  : pValue( 0 ),
    sKey( "" )
{
  aInfoPack.bSubList       = FALSE;
  aInfoPack.bLastPacket    = TRUE;
  PutPacketNum( 1, 1 );
  SetKeyLen( 0 );
  aInfoPack.sInfoString[0] = 0;
  PutCommand( InfoDataPack::none );
}

/************************************************************************/
InfoDataPack::InfoDataPack( const char *pInfo, CommandType eCommand,
			    USHORT nAktuell, USHORT nGesamt )
/************************************************************************/
  : pValue( 0 ),
    sKey( "" )
{
  SetInfoStr( pInfo );
  aInfoPack.bSubList       = FALSE;
  aInfoPack.bLastPacket    = TRUE;
  PutPacketNum( nAktuell, nGesamt );
  PutCommand( eCommand );
}

/************************************************************************/
InfoDataPack::InfoDataPack( const char *pKey, const char *pSValue,  CommandType eCommand,
			    BOOL bHasLink , BOOL bLastPacket,
			    USHORT nAktuell, USHORT nGesamt )
/************************************************************************/
  : pValue( 0 ),
    sKey( pKey )
{
  SetKeyValueStr( pKey, pSValue );

  aInfoPack.bSubList       = bHasLink;
  aInfoPack.bLastPacket    = bLastPacket; // wenn ready, dann kommt nix more
  PutPacketNum( nAktuell, nGesamt );
  PutCommand( eCommand );
}

/************************************************************************/
InfoDataPack::InfoDataPack( const InfoPack &rInfoPack )
/************************************************************************/
{
  *this = rInfoPack;
}

/************************************************************************/
InfoDataPack& InfoDataPack::operator =( const InfoPack &rInfoPack )
/************************************************************************/
{
  //  PutCommand( CommandType( SVBT8ToByte( aInfoPack.nCommand)) );
  ByteToSVBT8( SVBT8ToByte( rInfoPack.nCommand ), aInfoPack.nCommand );
  aInfoPack.bSubList       = rInfoPack.bSubList;
  aInfoPack.bLastPacket    = rInfoPack.bLastPacket;
  PutPacketNum( SVBT16ToShort(rInfoPack.nAktuellPacket),
		SVBT16ToShort(rInfoPack.nGesamtPacket) );
  UINT16 nKeyLen = SVBT16ToShort(rInfoPack.nKeylen);
  SetKeyLen( nKeyLen );
  strncpy( aInfoPack.sInfoString,
	   rInfoPack.sInfoString,
	   INFODATA_MAX_STR_LEN );
  pValue = aInfoPack.sInfoString + nKeyLen ;
  sKey = ByteString( aInfoPack.sInfoString, nKeyLen );

  return *this;
}

/************************************************************************/
InfoDataPack& InfoDataPack::operator =( const ByteString &rStr )
/************************************************************************/
{
  SetInfoStr( rStr.GetBuffer() );
  return *this;
}

/************************************************************************/
InfoDataPack& InfoDataPack::operator =( const char *pChar )
/************************************************************************/
{
  SetInfoStr( pChar );
  return *this;
}



/************************************************************************/
void InfoDataPack::PutPacketNum( USHORT nAktuell, USHORT nGesamt )
/************************************************************************/
{
  ShortToSVBT16( nAktuell, aInfoPack.nAktuellPacket );
  ShortToSVBT16( nGesamt, aInfoPack.nGesamtPacket );
}

/************************************************************************/
void InfoDataPack::SetInfoStr( const char *pInfo )
/************************************************************************/
{
  /* kopiert maximal "INFODATA_MAX_INFO-1" Bytes in den Datenpack.
   * an das Ende wird noch ein '\0' angefuegt als String ende,
   * damit ist bei INFODATA_MAX_INFO-1 Schluss oder frueher,
   * falls vorher schon ein '\0'terminator kommt */
  strncpy ( aInfoPack.sInfoString, pInfo, INFODATA_MAX_STR_LEN );
  aInfoPack.sInfoString[INFODATA_MAX_STR_LEN] = '\0';
  SetKeyLen( 0 );
}

/************************************************************************/
//void InfoDataPack::SetInfoStr( const char *pInfo, ULONG nLength )
/************************************************************************/
/*{
  strncpy ( aInfoPack.sInfoString, pInfo, INFODATA_MAX_INFO - 1 );
  SetKeyLen( 0 );
}*/

/************************************************************************/
void InfoDataPack::SetKeyValueStr( const char *pKey, const char *pSValue )
/************************************************************************/
{
  if(strlen(pKey) < INFODATA_MAX_STR_LEN)
  	strcpy ( aInfoPack.sInfoString, pKey );
  else
  {
  	strncpy ( aInfoPack.sInfoString, pKey, INFODATA_MAX_STR_LEN );
 	aInfoPack.sInfoString[INFODATA_MAX_STR_LEN] = '\0';
  }
  SetKeyLen( USHORT( strlen( pKey )));
  pValue = aInfoPack.sInfoString + GetKeyLen(); // zeigt auf das ende hinter dem string
  /* wenn pSValue nicht NULL ist, dann kann der Wert kopiert werden
   * Wenn er NULL ist, muss keine Aktion angestossen werden, da pValue
   * schon auf '\x0' zeigt */
  if ( pSValue )
    strncpy ( pValue, pSValue, INFODATA_MAX_STR_LEN - GetKeyLen() );

}
