/*************************************************************************
 *
 *  $RCSfile: xout1.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "xoutx.hxx"

#ifdef JOEDEBUG
#include "Q:\joedebug.hxx"
#endif

#define GLOBALOVERFLOW

/*************************************************************************
|*
|*    XOutputDevice::SetOffset()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

void XOutputDevice::SetOffset( const Point& rOfs )
{
	if (rOfs!=aOfs)
	{
		Point aDelta(rOfs);
		Fraction aFact1(1,1);
		aDelta-=aOfs;
#ifdef neeJOEDEBUG
		DebWrite("XOutputDevice::SetOffset(");
		DebOut(rOfs);
		DebWrite("Alter Offset: ");
		DebOut(aOfs);
		DebWrite("Alter Origin: ");
		DebOut(pOut->GetMapMode().GetOrigin());
		DebWrite("Delta: ");
		DebOut(aDelta);
#endif
//#ifdef JOEDEBUG
////        pOut->SetMapMode(MapMode(MAP_RELATIVE,Point(-aOfs.X(),-aOfs.Y()),aFact1,aFact1));
////        pOut->SetMapMode(MapMode(MAP_RELATIVE,rOfs,aFact1,aFact1));
		pOut->SetMapMode(MapMode(MAP_RELATIVE,aDelta,aFact1,aFact1));
//#else
//        MapMode aMap(pOut->GetMapMode());
//        Point   aOrg(aMap.GetOrigin());
//        aOrg.X()+=aDelta.X();
//        aOrg.Y()+=aDelta.Y();
//        aMap.SetOrigin(aOrg);
//        pOut->SetMapMode(aMap);
//#endif
		aOfs=rOfs;
#ifdef neeJOEDEBUG
		DebWrite("Neuer Offset: ");
		DebOut(aOfs);
		DebWrite("Neuer Origin: ");
		DebOut(pOut->GetMapMode().GetOrigin());
#endif
	}
}

/*************************************************************************
|*
|*    XOutputDevice::GetMapMode()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

MapMode XOutputDevice::GetMapMode() const
{
	MapMode aMap = pOut->GetMapMode();
	Point   aPos = aMap.GetOrigin();

	aPos.X() -= aOfs.X();
	aPos.Y() -= aOfs.Y();

	aMap.SetOrigin( aPos );

	return aMap;
}


/*************************************************************************
|*
|*    XOutputDevice::SetMapMode()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

void XOutputDevice::SetMapMode( const MapMode& rMap )
{
	Point aPos = rMap.GetOrigin();
	aPos.X() += aOfs.X();
	aPos.Y() += aOfs.Y();

	MapMode aMap( rMap );
	aMap.SetOrigin( aPos );

	pOut->SetMapMode( aMap );
}



