/*************************************************************************
 *
 *  $RCSfile: lnkbase.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: jl $ $Date: 2001/07/31 08:13:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _LNKBASE_HXX
#define _LNKBASE_HXX

#ifndef _SOT_EXCHANGE_HXX //autogen
#include <sot/exchange.hxx>
#endif
#ifndef _TOOLS_REF_HXX
#include <tools/ref.hxx>
#endif
#ifndef _LINKSOURCE_HXX
#include <linksrc.hxx>
#endif

namespace com { namespace sun { namespace star { namespace uno
{
	class Any;
	//class Type;
}}}}

namespace so3
{

struct ImplBaseLinkData;
class SvLinkManager;
class SvLinkSource;

#ifndef OBJECT_DDE_EXTERN
#define	OBJECT_INTERN		0x00
//#define	OBJECT_SO_EXTERN	0x01
#define	OBJECT_DDE_EXTERN	0x02
#endif

#define	OBJECT_CLIENT_SO			0x80 // ein Link
#define	OBJECT_CLIENT_DDE			0x81
//#define	OBJECT_CLIENT_OLE			0x82 // ein Ole-Link
//#define	OBJECT_CLIENT_OLE_CACHE  	0x83 // ein Ole-Link mit SvEmbeddedObject
#define	OBJECT_CLIENT_FILE			0x90
#define	OBJECT_CLIENT_GRF			0x91

enum {
	// Ole2 compatibel und persistent
	LINKUPDATE_ALWAYS = 1,
	LINKUPDATE_ONCALL = 3,

	LINKUPDATE_END		// dummy!
};

class SvBaseLink : public SvRefBase
{
	friend class SvLinkManager;
	friend class SvLinkSource;

	SvLinkSourceRef			xObj;
	String					aLinkName;
	SvLinkManager* 			pLinkMgr;
	USHORT 					nObjType;
	BOOL					bVisible : 1;
	BOOL					bSynchron : 1;
	BOOL					bUseCache : 1;		// fuer GrafikLinks!

protected:
	void			SetObjType( USHORT );

					// setzen des LinkSourceName ohne aktion
	void			SetName( const String & rLn );
					// LinkSourceName der im SvLinkBase steht
	String		 	GetName() const;


	ImplBaseLinkData* pImplData;

					SvBaseLink();
					SvBaseLink( USHORT nLinkType, ULONG nContentType = FORMAT_STRING );
	virtual 		~SvBaseLink();

	void 			_GetRealObject( BOOL bConnect = TRUE );

	SvLinkSource*	GetRealObject()
					{
						if( !xObj.Is() )
							_GetRealObject();
						return xObj;
					}

public:
					TYPEINFO();
					// ask JP
	virtual void    Closed();
					SvBaseLink( const String& rNm, USHORT nObjectType,
								 SvLinkSource* );

	USHORT			GetObjType() const { return nObjType; }

	void			SetObj( SvLinkSource * pObj );
	SvLinkSource*	GetObj() const	{ return xObj; }

	void    		SetLinkSourceName( const String & rName );
	String		 	GetLinkSourceName() const;

	virtual void 	DataChanged( const String & rMimeType,
								const ::com::sun::star::uno::Any & rValue );

	void			SetUpdateMode( USHORT );
	USHORT 			GetUpdateMode() const;
	ULONG  			GetContentType() const;
	BOOL 			SetContentType( ULONG nType );

	SvLinkManager*	GetLinkManager()			{ return pLinkMgr; }
	const SvLinkManager* GetLinkManager() const	{ return pLinkMgr; }

	BOOL			Update();
	void			Disconnect();

	virtual BOOL 	Edit( Window* );

		// soll der Link im Dialog angezeigt werden ? (Links im Link im ...)
	BOOL 	        IsVisible() const   		{ return bVisible; }
	void 	        SetVisible( BOOL bFlag )	{ bVisible = bFlag; }
		// soll der Link synchron oder asynchron geladen werden?
	BOOL 	        IsSynchron() const   		{ return bSynchron; }
	void 	        SetSynchron( BOOL bFlag )	{ bSynchron = bFlag; }

	BOOL 	        IsUseCache() const   		{ return bUseCache; }
	void 			SetUseCache( BOOL bFlag )	{ bUseCache = bFlag; }
};

SV_DECL_IMPL_REF(SvBaseLink);

}

#endif
