/*************************************************************************
 *
 *  $RCSfile: dataurl.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_DATAURL_HXX
#define _SFX_DATAURL_HXX

#ifndef _TRANSPRT_HXX
#include <so3/transprt.hxx>
#endif

#if SUPD<582
#include "sfxjs.hxx"
#endif
#include "frame.hxx"

//=========================================================================

class DataLockByteFactory_Impl : public SvLockBytesFactory
{
public:
	DataLockByteFactory_Impl();
	virtual SvLockBytesRef CreateLockBytes(
		const String& rName, String& rMime );
	static String Encode64( const String& );
	static String Decode64( const String& );
};

//=========================================================================

class ImageLockByteFactory_Impl : public SvLockBytesFactory
{
public:
	ImageLockByteFactory_Impl();
	virtual SvLockBytesRef CreateLockBytes(
		const String& rName, String& rMime );
};

//=========================================================================

class InfoLockByteFactory_Impl : public SvLockBytesFactory
{
public:
	InfoLockByteFactory_Impl();
	virtual SvLockBytesRef CreateLockBytes(
		const String& rName, String& rMime );
};

//=========================================================================
#if SUPD<582
class JavaScriptTransportFactory_Impl : public SvBindingTransportFactory
{
	SfxFrameWeak wFrame;

public:
	JavaScriptTransportFactory_Impl()
	{}

	void SetFrame (SfxFrame *pFrame) { wFrame = pFrame; }

	virtual BOOL HasTransport (const String &rURL);

	virtual SvBindingTransport* CreateTransport (
		const String               &rURL,
		SvBindingTransportContext  &rCtx,
		SvBindingTransportCallback *pCB);
};

class JScriptResult;

class JavaScriptTransport_Impl : public SvBindingTransport
{
	String                      aURL;
	SvBindingTransportCallback *pCB;
	SfxJSCallRef                xCall;
	String                      aBaseURL;
	SfxFrameWeak                wFrame;

public:
	JavaScriptTransport_Impl (
		SvBindingTransportCallback *pCBP,
		const String               &rURL,
		SfxFrame                   *pFrame)
		: aURL (rURL), pCB (pCBP), wFrame (pFrame)
	{}

	virtual void Start();
	virtual void Abort();

	DECL_STATIC_LINK (JavaScriptTransport_Impl, ScriptDone, JScriptResult*);
};

#endif


#endif
