/*************************************************************************
 *
 *  $RCSfile: base.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __BASE_HXX
#define __BASE_HXX

#ifndef __cplusplus
#error Needs C++
#endif

class SALQueue;

// *** Item ***
// Die Basisklasse fuer Items in doppelt verketteten Listen

class SALItem
{
public:
    SALItem();
    virtual ~SALItem();

    virtual SALItem *nextItem() const {return mpNext;}
    virtual SALItem *prevItem() const {return mpPrev;}
    virtual SALQueue *getQueue() const {return mpQueue;}

protected:
    SALQueue *mpQueue;
    SALItem  *mpNext, *mpPrev;

    friend class SALQueue;
};

// *** Queue ***

class SALQueue
{
public:
    SALQueue();
    virtual ~SALQueue();

    virtual SALItem *removeItem(SALItem *);
    virtual SALItem *appendItem(SALItem *);
    virtual SALItem *firstItem() const {return mpFirst;}
    virtual SALItem *lastItem() const {return mpLast;}

protected:
    SALItem *mpFirst, *mpLast;
    friend class SALItem;
};


#define DECLARE_QUEUE(QueueName, ItemName)                                      \
class QueueName : public SALQueue                                               \
{                                                                               \
public:                                                                         \
    ItemName *append(ItemName *pItem) {return (ItemName *)appendItem(pItem);}   \
    ItemName *remove(ItemName *pItem) {return (ItemName *)removeItem(pItem);}   \
    ItemName *first() const {return (ItemName *)firstItem();}                   \
    ItemName *last() const {return (ItemName *)lastItem();}                     \
};

#define DECLARE_ITEMQUEUE(ItemName) DECLARE_QUEUE(ItemName##Queue, ItemName)

#endif

       

