/*************************************************************************
 *
 *  $RCSfile: stubs.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/26 12:27:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_SHARED_STUBS_HXX_
#define _DBA_SHARED_STUBS_HXX_

#ifndef _DBASHARED_APITOOLS_HXX_
#include "apitools.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif

#ifndef _CPPUHELPER_WEAKREF_HXX_
#include <cppuhelper/weakref.hxx>
#endif


// the correspondig CXX for this file is not build anymore.
// If you think you need these classes in the future (that's why this file is still here and not removed
// from the CVS archive), please add dbaccess/source/shared/stubs.cxx to your makefile, again.
// In addition, you would need to disambiguate the identifiers here by introducing namespaces.


//==========================================================================
//= OSharedMutex - a refcounted mutex to be shared between different components
//==========================================================================
class OSharedMutex : public ::osl::Mutex
{
	oslInterlockedCount	m_refCount;

public:
	OSharedMutex() { }
	void addRef() { osl_incrementInterlockedCount(&m_refCount); }
	void releaseRef() { if (0 == osl_decrementInterlockedCount(&m_refCount)) delete this; }
};

//==========================================================================
//= OShared - the base class for shared usage of OSharedMutex'es
//==========================================================================
class OShared
{
public:
	OSharedMutex* m_pMutex;

public:
	OShared(OSharedMutex* pMutex) : m_pMutex(pMutex) { m_pMutex->addRef(); }
	virtual ~OShared() { m_pMutex->releaseRef(); }
};

//==========================================================================
//= OServerComponent - a component which acts as server for a dynamic number
//=						of stubs (rerouting their functionallity to the server)
//==========================================================================
class OServerComponent	:public OShared
						,public OSubComponent
						,public ::com::sun::star::lang::XUnoTunnel
{
protected:
	OWeakRefArray	m_aStubs;

public:
	OServerComponent(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _xParent)
		:OShared(new OSharedMutex())
		,OSubComponent(*m_pMutex, _xParent)
	{
	}

// ::com::sun::star::lang::XTypeProvider
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes() throw (::com::sun::star::uno::RuntimeException);

// ::com::sun::star::uno::XInterface
	virtual void SAL_CALL acquire() throw() { OSubComponent::acquire(); }
	virtual void SAL_CALL release() throw() { OSubComponent::release(); }
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type & rType )
			throw(::com::sun::star::uno::RuntimeException);

// com::sun::star::lang::XUnoTunnel
	virtual sal_Int64 SAL_CALL getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& aIdentifier ) throw(::com::sun::star::uno::RuntimeException);

	// UnoTunnel IDs:
	// id for retrieving a pointer to the implementation
	static ::com::sun::star::uno::Sequence< sal_Int8 >	getUnoTunnelImplementationId();

	void appendStub(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >&);

protected:
	virtual void SAL_CALL disposing();
};

//==========================================================================
//= OStubComponent - a component which acts as stub for a OServerComponent
//==========================================================================
class OStubComponent	:public OShared
						,public OSubComponent
{
	OServerComponent* m_pServer;

public:
	OStubComponent(OServerComponent& rServer);

protected:
	// getServer is not protected by a guard
	virtual sal_Int64 getServer(const ::com::sun::star::uno::Sequence< sal_Int8 >& _rId) const
		throw( ::com::sun::star::lang::DisposedException );
};

//==========================================================================
//= macros for accessing the server from within a stub
//==========================================================================
#define GET_SERVER(server_name)	\
reinterpret_cast<server_name*>(getServer(server_name##::getUnoTunnelImplementationId()))

#define USE_SERVER(server_name)	\
server_name* pServer = GET_SERVER(server_name)

#define SERVER_EXECUTE(server_name, method)		\
	try											\
	{											\
		::osl::MutexGuard aGuard(*m_pMutex);	\
		GET_SERVER(server_name)->method;		\
	}											\
	catch (::com::sun::star::uno::Exception& e)	\
	{											\
		e.Context = static_cast<XWeak*>(this);	\
		throw;									\
	}

#define RETURN_SERVER_RESULT(server_name, method, returntype)	\
	returntype result;										\
	try														\
	{														\
		osl::MutexGuard aGuard(*m_pMutex);					\
		result = GET_SERVER(server_name)->method;			\
	}														\
	catch (::com::sun::star::uno::Exception& e)				\
	{														\
		e.Context = static_cast<XWeak*>(this);				\
		throw;												\
	}														\
	return result



#endif // _DBA_SHARED_STUBS_HXX_


