/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.src.Element;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.SourceEditSupport;

class ElementBeanModel
implements PropertyModel {
    private PropertyModel original;
    private Element bean;

    public ElementBeanModel(Element element, String string) {
        this(element, new DefaultPropertyModel((Object)element, string));
    }

    public ElementBeanModel(Element element, PropertyModel propertyModel) {
        this.bean = element;
        this.original = propertyModel;
    }

    public Class getPropertyEditorClass() {
        return this.original.getPropertyEditorClass();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.original.removePropertyChangeListener(propertyChangeListener);
    }

    public Class getPropertyType() {
        return this.original.getPropertyType();
    }

    public Object getValue() throws InvocationTargetException {
        return this.original.getValue();
    }

    public void setValue(final Object object) throws InvocationTargetException {
        final InvocationTargetException[] invocationTargetExceptionArray = new InvocationTargetException[1];
        Throwable[] throwableArray = new Throwable[]{null};
        SourceElement sourceElement = SourceEditSupport.findSource(this.bean);
        if (sourceElement == null) {
            this.original.setValue(object);
            return;
        }
        try {
            sourceElement.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        ElementBeanModel.this.original.setValue(object);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetExceptionArray[0] = invocationTargetException;
                        ErrorManager.getDefault().annotate((Throwable)invocationTargetException, invocationTargetException.getTargetException());
                    }
                }
            });
        }
        catch (SourceException sourceException) {
            invocationTargetExceptionArray[0] = new InvocationTargetException(sourceException);
            ErrorManager.getDefault().annotate((Throwable)invocationTargetExceptionArray[0], sourceException);
        }
        if (invocationTargetExceptionArray[0] == null) {
            return;
        }
        throw invocationTargetExceptionArray[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.original.addPropertyChangeListener(propertyChangeListener);
    }
}

