/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.openide.TopManager;
import org.openide.compiler.CompilerSysProcess;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.util.NbBundle;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.InputOutput;

final class CompilerExecutor
extends ProcessExecutor {
    static final long serialVersionUID = -2611259508166125914L;
    private List files = new LinkedList();
    private ExternalCompilerGroup eCompiler;
    private NbProcessDescriptor nbDescriptor;
    private ExternalCompiler.ErrorExpression errorExpression;
    private Object compilerType;
    static /* synthetic */ Class class$org$openide$compiler$CompilerExecutor;

    CompilerExecutor(ExternalCompilerGroup externalCompilerGroup, NbProcessDescriptor nbProcessDescriptor, ExternalCompiler.ErrorExpression errorExpression, Object object) {
        this.eCompiler = externalCompilerGroup;
        this.nbDescriptor = nbProcessDescriptor;
        this.errorExpression = errorExpression;
        this.compilerType = object;
    }

    public void addFile(String string) {
        this.files.add(string);
    }

    private static InputOutput getCompilerIO() {
        String string = NbBundle.getBundle("org.openide.compiler.Bundle").getString("CTL_CompileTab");
        return TopManager.getDefault().getIO(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(ExecInfo execInfo) throws IOException {
        CERunnable cERunnable;
        CERunnable cERunnable2 = cERunnable = new CERunnable(execInfo, this.eCompiler, this.errorExpression, this.nbDescriptor, this.files, this.compilerType);
        synchronized (cERunnable2) {
            ExecutorTask executorTask = ExecutionEngine.getDefault().execute(NbBundle.getBundle(class$org$openide$compiler$CompilerExecutor == null ? (class$org$openide$compiler$CompilerExecutor = CompilerExecutor.class$("org.openide.compiler.CompilerExecutor")) : class$org$openide$compiler$CompilerExecutor).getString("CTL_CompilationTask"), cERunnable, CompilerExecutor.getCompilerIO());
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                cERunnable.wait();
                Throwable throwable = cERunnable.getException();
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new FoldingIOException(throwable);
                }
                CompilerSysProcess compilerSysProcess = cERunnable.getCompilerSysProcess();
                compilerSysProcess.setExecutorTask(executorTask);
                CompilerSysProcess compilerSysProcess2 = compilerSysProcess;
                return compilerSysProcess2;
            }
            catch (InterruptedException interruptedException) {
                CompilerSysProcess.InterruptedProcess interruptedProcess = new CompilerSysProcess.InterruptedProcess();
                return interruptedProcess;
            }
        }
    }

    ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    NbProcessDescriptor getDescriptor() {
        return this.nbDescriptor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CERunnable
    implements Runnable {
        private ExecInfo info;
        private ExternalCompilerGroup eeg;
        private ExternalCompiler.ErrorExpression errorExpression;
        private NbProcessDescriptor nbDescriptor;
        private Throwable t;
        private CompilerSysProcess csp;
        private List files;
        private Object compilerType;

        CERunnable(ExecInfo execInfo, ExternalCompilerGroup externalCompilerGroup, ExternalCompiler.ErrorExpression errorExpression, NbProcessDescriptor nbProcessDescriptor, List list, Object object) {
            this.info = execInfo;
            this.eeg = externalCompilerGroup;
            this.errorExpression = errorExpression;
            this.nbDescriptor = nbProcessDescriptor;
            this.files = list;
            this.compilerType = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CERunnable cERunnable;
            try {
                try {
                    TopManager.getDefault().saveAll();
                    String string = this.eeg.getStatusLineText();
                    TopManager.getDefault().setStatusText(string);
                    this.csp = new CompilerSysProcess(this, this.eeg, this.eeg.createProcess(this.nbDescriptor, this.files.toArray(new String[0]), this.compilerType), this.errorExpression);
                }
                catch (Exception exception) {
                    this.t = exception;
                    Object var3_4 = null;
                    CERunnable cERunnable3 = this;
                    synchronized (cERunnable3) {
                        this.notifyAll();
                        return;
                    }
                }
                Object var3_3 = null;
                cERunnable = this;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                CERunnable cERunnable2 = this;
                synchronized (cERunnable2) {
                    this.notifyAll();
                    throw throwable;
                }
            }
            synchronized (cERunnable) {
                this.notifyAll();
                return;
            }
        }

        public Throwable getException() {
            return this.t;
        }

        public CompilerSysProcess getCompilerSysProcess() {
            return this.csp;
        }
    }
}

