'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_so7_pp1_ibis.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: oc $ $Date: 2007/08/03 09:37:39 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'**
'** owner : oliver.craemer@Sun.COM
'**
'** short description :  Test IBIS bug fixes 
'**
'************************************************************************
' **
' #1 tIBIS111099            ' Disable design mode of form controls after loading excel file
' #1 tIBIS111158            ' Lost properties of form controls
' #1 tIBIS111711            ' Crash when deleting chart in Menu->Window->New Window
' **
'\***********************************************************************

testcase tIBIS111099
Dim testdoc$
testdoc$ = convertpath(gTesttoolpath & "spreadsheet\level2\input\111099.xls")
'/// Open the test document
    Call hDateioeffnen(testdoc$)
    Call sMakeReadOnlyDocumentEditable    
    '/// Invoke Control Toolbar
    '///+ Try to click control 'Push Button'
    '///+> <ul><li>Click successful - BUG #111099#</li>
    '///+ <li>Click fails - document opened as expected in non-design mode</li>
    Call hToolbarSelect("CONTROLS", true)
    sleep(2)
    Kontext "FormControls"
    if SwitchControlDesignMode.IsEnabled then 
        if SwitchControlDesignMode.getState(2) = 0 then 
            printlog "OK, design mode is disabled"
        else
            warnlog "Document is opened in design mode -> #111099#"
        end if
    else
        printlog "Form controls toolbar was not enabled."
    end if
    call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tIBIS111158
Dim testdoc$, testString$
testdoc$ = convertpath(gTesttoolpath & "spreadsheet\level2\input\111158.xls")
    
'/// Open test document ...spreadsheet\level2\input\111158.xls
    Call hDateioeffnen(testdoc$)
    Call sMakeReadOnlyDocumentEditable      
    Kontext "Standardbar"
    '/// If 'Form Controls' toolbar is not visible: View / Toolbars / Form Controls     
    Call hToolbarSelect("CONTROLS", true)
    sleep(2)
    Kontext "FormControls"
    try
        if SwitchControlDesignMode.IsEnabled then
            '/// Click on 'Design Mode on/off' button on 'Form Controls'-toolbar
            SwitchControlDesignMode.click
            sleep(2)
            '/// Click on 'Form Design' button on 'Form Controls'-toolbar                
            FormDesignTools.Click
            sleep(2)
        else
            printlog "Form controls toolbar was not enabled."
        end if
    catch
        QAErrorlog "Document is opened in design mode -> #111099#"
        QAErrorlog "No need to test if that one isn't fixed -> aborted"
        call hCloseDocument
        goto endsub
    endcatch

    Kontext "FormDesignTools"
    if FormDesignTools.Exists(2) then
        If ShowFmExplorer.IsEnabled then
            '/// Show Form Navigator
            ShowFmExplorer.Click
        else
            warnlog "Button was not enabled!"
        end if
    else
        warnlog "'Form Design'-toolbar did not come up."
        Call hCloseDocument
        goto endsub
    end if
      
'/// Select the first 'ComboxBox' (9th entry from the top)
'/// Open context menu
    Kontext "FormularNavigator"
    Liste.TypeKeys "<HOME>" , true
    sleep(1)
    Liste.TypeKeys "<DOWN>" , 9 , true
    sleep(1)
    Liste.OpenContextmenu
    sleep(2)
    '/// Open 'Properties' (last entry)
    hMenuSelectNr(5)
    sleep(2)      
    Kontext "ControlPropertiesDialog"
    Kontext "ControlPropertiesTabControl"
    ControlPropertiesTabControl.SetPage TabGeneralControl
    Kontext "TabGeneralControl"
    '/// Enter in 'Help URL' as value exactly 'HID:123456'
    TabGeneralControl.TypeKeys "<TAB>" , true        
    HelpURL.setText "HID:123456"
    TabGeneralControl.TypeKeys "<RETURN>",true
    if HelpURL.GetText <> "HID:123456" then 
        warnlog "'HID:123456' has not been accepted as 'Help URL' value."
    end if
    '/// Close all disturbing menus
    Kontext "ControlPropertiesDialog" 
    ControlPropertiesDialog.close
    sleep(2)
    Kontext "FormularNavigator"
    FormularNavigator.close
    Kontext "FormDesignTools"
    FormDesignTools.close
    Kontext "FormControls"
    '/// Switch back from the design mode
    SwitchControlDesignMode.click
    FormControls.close
    sleep(1)
    '/// Check for right initial string ('Please select one:')in control
    Kontext "MSC_Special_Dialog"
    if MSC_Special_Dialog.Exists(3) then
        testString$ = MSC_Special_Dialog.getSelText
        if testString$ = "Please select one:" then
            printlog "OK, the right string was found in control"
        else
            warnlog "Wrong string found in Control: " & testString$
        endif
    else
        warnlog "The control seems to be not named in the document?! Verify!"
    end if
    call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tIBIS111711
printlog "iBIS Task 111711"
'/// Create a new document
    call hNewDocument
    call sMakeReadOnlyDocumentEditable
'/// enter some numbers as content
    Kontext "DocumentCalc"
    DocumentCalc.typekeys "1<RETURN>2<RETURN><UP>"
    sleep(2)

'/// create a chart from the content
'/// + NOTE: Do NOT leave the Implace mode
    InsertChartCalc
    '/// The Chart wizard occours
    Kontext "ChartWizard"
    '/// On the chart wizard press OK button 
    if ChartWizard.Exists(2) then
        printlog "Create chart"
        ChartWizard.OK
        sleep(2)
    else
        warnlog "Chart wizard did not occour! Exiting test case."
        call hCloseDocument
        goto endsub
    end if    
'/// Call slot Window->New Window
    Kontext "DocumentCalc"
    DocumentCalc.typekeys "<ESCAPE>"
    WindowNewWindow
    sleep(2)
    call gMouseClick(95,95)

'/// Select chart in new window
    Kontext "DocumentCalc"
    call fselectFirstOLE
    sleep(2)
  
'/// Delete chart in new window ...
'/// ... and check for crash
    Kontext "DocumentCalc"
    try  
        DocumentCalc.typekeys "<DELETE>"
        sleep (2)
        printlog "OK, there are still " & hWindowGetCount & " documents open"
    catch 
        warnlog "Probably the office did crash -> #111711#"
        call hCloseDocument
        goto endsub
    endcatch  
    call hCloseDocument
endcase


