'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_clipexport.inc,v $
'*
'*  $Revision: 1.21 $
'*
'*  last change: $Author: wg $ $Date: 2008/02/13 08:55:02 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : wolfram.garten@sun.com
'*
'* short description : Tests the clipboard-function with a rectangle
'*
'*******************************************************************
'*

' #1 MeasurementSetFirst
' #1 ResetMeasurement
' #1 SaveMeasurementSetFirst
' #1 Select_Copy
' #1 calctest
' #1 writertest
' #1 tClipboardFromDrawTest

' #1 Small_test_Draw
' #1 Small_test_Impress
' #1 Small_test_Calc
' #1 Small_test_Writer
' #1 Full_test_Writer
' #1 Full_test_Draw
' #1 Full_test_Impress
' #1 Full_test_Calc
' #1 clear_all_and_close
' #1 Make_LineObject_From_Application
' #1 Make_Rectangle_From_Application
' #1 Make_Make3dObject_From_Application
' #1 Make_TextSquare_From_Application
' #1 Make_And_Check_Formatted_Text_Line_From_Application
' #1 Make_ConnectorObject_From_Application
' #1 Make_Circle_From_Application
' #1 Make_CurveObject_From_Application
' #1 Make_Objectplugin_From_Application
'*
'\*******************************************************************

   global i as integer
   global sApplication as string
   global ReferenceOld as string
   global ReferenceNew as string
   global ToApp as string
   global ToAppCounter as integer
   global FromApp as string
   global FromApp2 as string
   global CheckValue1 as integer
   global Marker as integer
   global WindowsSting (4) as string
   global PositionPositionX as string
   global PositionPositionY as string
   global PositionWidth as string
   global PositionHeight as string

'/// Position ///'
   global PositionKeepRatio as string
   global PositionProtectPosition as string
   global PositionProtectSize as string
   global PositionFitWidthText as string
   global PositionFitHeightText as string
   global PositionAnchorPosition as string
   global PositionAnchor as string
   global PositionPositionPosition as string
   global PositionSizePosition as string

'/// Area ///'
   global AreaNoFillValue as string
   global AreaColorValue as string
   global AreaColourListValue as string
   global AreaGradientValue as string
   global AreaGradientListValue as string
   global AreaAutomaticValue as string
   global AreaHatchingValue as string
   global AreaHatchingListValue as string
   global AreaBackgroundColourValue as string
   global AreaBackgroundColourListValue as string
   global AreaIncrementsValue as string
   global AreaBitmapValue as string
   global AreaBitmapListValue as string
   global AreaOriginalListValue as string
   global AreaRelativeValue as string
   global AreaWidthValue as string
   global AreaHeightValue as string
   global AreaXOffsetValue as string
   global AreaYOffsetValue as string
   global AreaTileValue as string
   global AreaStretchValue as string
   global AreaRowValue as string
   global AreaColumnValue as string
   global AreaOffsetValue as string

'/// Shadow ///'
   global ShadowUseShadowsValue as string
   global ShadowDistanceValue as string
   global ShadowColorValue as string
   global ShadowTransparencyValue as string

'/// Transparency ///'
   global TransparencyTransparencyValue as string
   global TransparencyGradientType as string
   global TransparencyMFZentrumX as string
   global TransparencyMFZentrumY as string
   global TransparencyMFWinkel as string
   global TransparencyMFRand as string
   global TransparencyMFStartwert as string
   global TransparencyMFEndwert as string

'/// Color ///'
   global ColorName as string
   global ColorColor as string
   global ColorModel as string
   global ColorR as string
   global ColorG as string
   global ColorB as string
   global ColorC as string
   global ColorM as string
   global ColorY as string
   global ColorK as string

'/// Gradients ///'
   global GradientsType as string
   global GradientsCenterX as string
   global GradientsCenterZ as string
   global GradientsAngle as string
   global GradientsBorder as string
   global GradientsFromColor as string
   global GradientsFromValue as string
   global GradientsToColor as string
   global GradientsToValue as string

'/// Hatching ///'
   global HatchingDistance as string
   global HatchingAngle as string
   global HatchingLineType as string
   global HatchingLineColor as string
   global HatchingLineTable as string

'/// TabBitmap ///'
   global BitmapForeground as string
   global BitmapBackground as string
   global BitmapTable as string

'/// Text Formatting ///'
   global Text1 as string
   global Text2 as string
   global Text3 as integer
   global Text4 as string
   global Text5 as string
   global Text6 as string
   global Text7 as string
   
sub tClipboardFromDrawTest
EnableQAErrors = false
FromApp2 = gApplication
printlog "gApplication = " + gApplication

if gApplication = "WRITER" then
   call writertest
   exit sub
end if

if gApplication = "CALC" then
   call calctest
   exit sub
end if

'------------------------------- "object"-dependant tests -------------------------------

try
   call Make_Rectangle_From_Application
   call Full_test_Draw
   call Full_test_Impress
   call Full_test_Writer
   call Full_test_Calc
catch
   warnlog "something wrong with testing Rectangle"
endcatch

try
   call Make_Make3dObject_From_Application
   call Full_test_Draw
   call Small_test_Impress
   call Small_test_Calc
   call Small_test_Writer
catch
   warnlog "something wrong with testing 3dObject"
endcatch

'qaerrorlog "Make_CurveObject_From_Application needs an overview - FHA"
try
   call Make_CurveObject_From_Application
   call Small_test_Draw
   call Small_test_Impress
   call Small_test_Calc
   call Small_test_Writer
catch
   warnlog "something wrong with testing CurveObj"
endcatch

try
   call Make_ConnectorObject_From_Application
   call Small_test_Draw
   call Small_test_Impress
   call Small_test_Calc
   call Small_test_Writer
catch
   warnlog "something wrong with testing ConnectorObject"
endcatch

try
   call Make_LineObject_From_Application
   call Small_test_Draw
   call Small_test_Impress
'   call Small_test_Calc
'   call Small_test_Writer
catch
   warnlog "something wrong with testing LineObject"
endcatch

try
   call Make_Objectplugin_From_Application   '/// doesn't work to test ///'
catch
   warnlog "something wrong with testing ConnectorObject"
endcatch

try
   call Make_Circle_From_Application
   call Small_test_Draw
   call Small_test_Impress
   call Small_test_Calc
   call Small_test_Writer
catch
   warnlog "something wrong with testing Circle"
endcatch

try
   call Make_TextSquare_From_Application
   call Small_test_Draw
   call Small_test_Impress
   call Small_test_Calc
   call Small_test_Writer

catch
   warnlog "something wrong with testing TextSquare"
endcatch

call clear_all_and_close
   Printlog "tClipboardFromDrawTest finished"
end sub

'--------------------------- Tests for Writer ---------------------------

sub writertest

   try 
      call Make_And_Check_Formatted_Text_Line_From_Application
   catch 
      warnlog "Something went wrong with testing writertest"
   endcatch

   try
      call Make_Rectangle_From_Application
      call Full_test_Draw
      call Full_test_Impress
      call Full_test_Writer
      call Full_test_Calc
   catch
      warnlog "something wrong with testing writertest"
   endcatch
end sub ' big one

'---------------------------- Tests for Calc ----------------------------
sub calctest
try
   call Make_Rectangle_From_Application
   call Full_test_Draw
   call Full_test_Impress
   call Full_test_Writer
   call Full_test_Calc
catch
   warnlog "something wrong with calctest"
endcatch
   printlog "currently no specific tests from Calc"
end sub

'------------------------------- Objects --------------------------------
testcase Make_Make3dObject_From_Application
   printlog "--- 3D-Object --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call Make3dObject
   call Select_Copy
   Call Get_Position_Size_Attributes
   Call Get_Colour_Attributes
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_Objectplugin_From_Application
    goto endsub
    printlog "--- Objectplugin --- from --- " + gApplication
    Call hNewDocument                                   '/// Open base application ///'
    sleep 1
    call SaveMeasurementSetFirst
    SetKontextApplication                               '/// Create the object which we want to test ///'
    sleep 1
    Call Objectplugin
    call Select_Copy
    call Get_Position_Size_Attributes
    Call Get_Colour_Attributes
    Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_TextSquare_From_Application
   printlog "--------- TextSquare --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call MakeTextSquare
   call Select_Copy
   call Get_Position_Size_Attributes
'   Call Get_Colour_Attributes
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_Rectangle_From_Application
   printlog "--------- Rectangle --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call MakeRectangle
   call Select_Copy
   call Get_Position_Size_Attributes
   Call Get_Colour_Attributes
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_Circle_From_Application
   printlog "--------- Ellipse Object --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call MakeCircle
   call Select_Copy
   call Get_Position_Size_Attributes
   Call Get_Colour_Attributes
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_CurveObject_From_Application
   printlog "--------- Curve-Object --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call MakeCurveObject
   call Select_Copy
   call Get_Position_Size_Attributes
'   Call Get_Colour_Attributes
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_LineObject_From_Application
   printlog "--------- Line-Object --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call MakeLineObject
   call Select_Copy
   call Get_Position_Size_Attributes
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_ConnectorObject_From_Application
   printlog "--------- Connector-Object --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call MakeConnectorObject
   call Select_Copy
   Call Get_Position_Size_Attributes
'   Call Get_Colour_Attributes
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Make_And_Check_Formatted_Text_Line_From_Application
   printlog "--------- Formatted Text --- from --- " + gApplication
   Call hNewDocument                                   '/// Open base application ///'
   sleep 1
   call SaveMeasurementSetFirst
   SetKontextApplication                               '/// Create the object which we want to test ///'
   sleep 1
   Call MakeFormattedTextLine 'inclusive get variable-info.
   call Select_Copy
   Call hCloseDocument
   'call New_Draw
'   Call Check_Text_Formatting
'   Call hCloseDocument
   Call New_Impress
   Call Check_Text_Formatting
   Call hCloseDocument
   sleep 10
   Call New_Calc
   Call Check_Text_Formatting
   Call hCloseDocument
   Call New_Writer
   Call Check_Text_Formatting
   Call hCloseDocument
endcase

'--------------------------- Part with the different kinds of tests. -----------------------------------
testcase Full_test_Draw
   call New_Draw
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   call Check_Colors_Borders_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Small_test_Draw
   call New_Draw
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Full_test_Impress
   call New_Impress
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   call Check_Colors_Borders_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Small_test_Impress
   call New_Impress
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Full_test_Calc
   call New_Calc
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   call Check_Colors_Borders_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Small_test_Calc
   call New_Calc
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Full_test_Writer
   call New_Writer
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   call Check_Colors_Borders_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase Small_test_Writer
   call New_Writer
   call MeasurementSetFirst
   call Check_Position_Size_Attributes
   gApplication = FromApp2
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
testcase clear_all_and_close
    goto endsub
   printlog "   --------------------------------------------------------------"
   printlog "   All tests done... clearing up everything and finishing"
   if gApplication = "WRITER" then
      DocumentWriter.TypeKeys "<DELETE>"
   else
      printlog "   gApplication is " + gApplication
      EditSelectAll
      EditDelete
   end if
   call ResetMeasurement
   Call hCloseDocument
endcase
'--------------------------------------------------------------------------------------------------------
sub Select_Copy
   '/// Select and copy ///'
   Sleep 10
   if gApplication = "DRAW" then
      EditSelectAll
      printlog "   We just ran EditSelectAll - Application is Draw"
   end if
   if gApplication = "IMPRESS" then
      EditSelectAll
      printlog "   We just ran EditSelectAll - Application is Impress"
   end if
   Sleep 2
   EditCopy
   Sleep 2
   printlog "   Copied object"
end Sub

sub SaveMeasurementSetFirst
    if (lCase(gApplication) = "draw") then
       sApplication = "DRAWING"
    elseIf (lCase(gApplication) = "impress") then
       sApplication = "PRESENTATION"
    elseIf (lCase(gApplication) = "writer") then
       sApplication = "TEXTDOCUMENT"
    elseIf (lCase(gApplication) = "calc") then
       sApplication = "SPREADSHEET"
    endif
    printlog "   '/// - save states ///'"
    ToolsOptions
     hToolsOptions (sApplication,"General")
     ReferenceOld = Masseinheit.GetSelText
     Masseinheit.TypeKeys= "<HOME>" '(first entry)
     ReferenceNew = Masseinheit.GetSelText
     Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
end Sub
'--------------------------------------------------------------------------------------------------------
sub MeasurementSetFirst
    dim f as integer
    if (lCase(gApplication) = "draw") then
       sApplication = "DRAWING"
    elseIf (lCase(gApplication) = "impress") then
       sApplication = "PRESENTATION"
    elseIf (lCase(gApplication) = "writer") then
       sApplication = "TEXTDOCUMENT"
    elseIf (lCase(gApplication) = "calc") then
       sApplication = "SPREADSHEET"
    endif
    ToolsOptions
     hToolsOptions (sApplication,"General")
     if Masseinheit.GetSelText <> ReferenceNew then 'find the right one.
        Masseinheit.TypeKeys "<HOME>"
        for f = 1 to Masseinheit.GetItemCount
            if Masseinheit.GetSelText = ReferenceNew then
               i = Masseinheit.GetItemCount 'find the right one.
            else
               Masseinheit.TypeKeys "<DOWN>"
            endif
        next f
     endif
     Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
end Sub
'--------------------------------------------------------------------------------------------------------
sub ResetMeasurement
    dim f as integer
    if (lCase(gApplication) = "draw") then
       sApplication = "DRAWING"
    elseIf (lCase(gApplication) = "impress") then
       sApplication = "PRESENTATION"
    elseIf (lCase(gApplication) = "writer") then
       sApplication = "TEXTDOCUMENT"
    elseIf (lCase(gApplication) = "calc") then
       sApplication = "SPREADSHEET"
    endif
    printlog "'/// - Reset states back to what they were before ///'"
    ToolsOptions
     hToolsOptions (sApplication,"General")
     if Masseinheit.GetSelText <> ReferenceOld then 'find the right one.
        Masseinheit.TypeKeys "<HOME>"
        for f = 1 to Masseinheit.GetItemCount
            if Masseinheit.GetSelText = ReferenceOld then
               i = Masseinheit.GetItemCount 'find the right one.
            else
               Masseinheit.TypeKeys "<DOWN>"
            endif
        next f
     endif
     Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
end Sub
'--------------------------------------------------------------------------------------------------------
