'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_filters.inc,v $
'*
'*  $Revision: 1.35 $
'*  last change: $Author: jsk $ $Date: 2007/12/03 12:41:23 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Retrieve and set filternames and suffixes
'*
'*******************************************************************************
'**
' #1 hGetSuffix               ' get the suffix for a specified build-id
' #1 hGetFilter               ' get the filtername for a specified build-id
' #1 GetDefaultFilterNames    ' read the default filternames from a reference list
' #1 CreateFilterNamesList    ' write the default filternames to the reference list
' #1 hGetValueForKeyAsString  ' find key in list, return value as string
' #1 hGetValueForPairAsString ' find value in list, return key and value as string
' #1 hGetKeyForPairAsString   ' get key from a key=value string as string
' #1 hGetDataFileSection      ' read a section from a datafile into a list
' #1 hGetFileData             ' return value for key from file directly (ignores sections)
' #1 hGetStartOfSection       ' identify beginning of new section in datafile
' #1 hGetEndOfSection         ' identify end of section in datafile
' #1 hGetSection              ' retrieve list of strings from section
'**
'\******************************************************************************

private const LENGTH_OF_FILTERFILE = 100
private const FILE_DATA_SIZE = 300
private const FILTER_SWITCH_BUILD = 9241

function hGetSuffix( optional cBuildId as string ) as string

    '///<h1>Get the suffix for a specified Build-ID depending on gApplication</h1>

    dim clTemp( LENGTH_OF_FILTERFILE ) as string ' cFilterFile is stored here

    ' A number of variables that make the path to the filter-file
    dim cSuffixFile as string
    dim cFixPath as string
        cFixPath = "global\input\filters\"

    ' if no parameter is given, assume "current". This is the directory in
    ' which the information will be searched for.
    if ( ismissing( cBuildId ) ) then
        cBuildId = "current"
        qaerrorlog( "hGetSuffix::No Filter-String passed to function: Using default" )
    end if

    ' if the parameter is an empty string, default as well and warn
    if ( cBuildId = "" ) then
        cBuildId = "current"
        warnlog( "hGetSuffix::Empty Filter-String passed to function: Using default" )
    end if
    
    ' Automatically reroute the request for cBuildID = "680" to "current" from
    ' a given build-id on
    'if ( ( gBuild >= FILTER_SWITCH_BUILD ) and ( cBuildId = "680" ) ) then
    '    cBuildId = "current"
    'endif

    ' Build the path to the suffix-file, it depends on the build-id and
    ' the product brand as well as the language and gApplication
    cSuffixFile = gTesttoolPath & cFixPath & "native_suffixes.dat"
    cSuffixFile = convertpath( cSuffixFile )

    ' Retrieve the list of suffixes from the file (just read the file)
    hGetDataFileSection( cSuffixFile , clTemp() , cBuildId , "" , "" )

    ' Isolate the desired suffix from the list depending on gApplication
    hGetSuffix() = hGetValueForKeyAsString( clTemp() , gApplication )

end function

'*******************************************************************************

function hGetFilter( optional cBuildId as string ) as string
    '///<h1>Get the Filtername for a specified Build-ID</h1>
    dim clTemp( LENGTH_OF_FILTERFILE ) as string ' cFilterFile is stored here

    ' a number of variables that make the path to the filter-file
    dim cLangFile as string
        cLangFile = "\filter" & iSprache & ".txt"
    dim cFilterFile as string
    dim cFixPath as string
        cFixPath = "global\input\filters\"
        
    const CFN = "hGetFilter::"

    '/// If no parameter is given, assume "current". This is the directory in
    '///+ which the information will be searched for.

    if ( ismissing( cBuildId ) ) then
        cBuildId = "current"
        printlog( CFN & "No build ID provided, defaulting to <current>" )
    end if
    
    if ( cBuildId = "" ) then
        cBuildId = "current"
        warnlog( CFN & "Empty Filter-String passed to function: Using default" )
    end if
    
    ' Automatically reroute the request for cBuildID = "680" to "current" from
    ' a given build-id on - and vice versa, this allows for seamless transition from
    ' one set of filternames to another within the same or a new codeline
    if ( gBuild >= FILTER_SWITCH_BUILD ) then
        if ( cBuildId = "680" ) then
            cBuildId = "current"
        endif
    else
        if ( cBuildId = "current" ) then
            cBuildId = "680"
        endif
    endif    

    ' Building the path to the filter-file, it depends on the build-id and
    ' the product brand as well as the language
    cFilterFile = gTesttoolPath & cFixPath & cBuildId & "\" & gProductName
    cFilterFile = convertpath( cFilterFile & cLangFile )

    ' Retrieving the list of filternames from the file (just read the file)
    hGetDataFileSection( cFilterFile , clTemp() , "" , "" , "" )

    ' Isolating the desired filtername from the list depending on gApplication
    hGetFilter() = hGetValueForKeyAsString( clTemp() , ucase(gApplication) )
    
end function

'*******************************************************************************

sub GetDefaultFilternames( optional BuildId as string )

    '/// This sub reads the filternames from a reference list.
    '///+ Filternames are language-dependent and should be created using
    '///+ the getnames.bas script on Windows.
    '///+ The filternames are stored into global variables.

    const CFN = "GetDefaultFilternames()::"

    dim cProductName as string ' productname may differ from gProductName
    dim sPath as string

    ' handle omitted parameter, dynamically select the correct filter
    if ( ismissing( BuildId ) ) then
        ' Test for the version in which the filternames change    
        if ( gBuild >= FILTER_SWITCH_BUILD ) then
            sPath = gTesttoolPath & "global\input\filters\current"
        else
            sPath = gTesttoolPath & "global\input\filters\680"
        endif
    end if

    ' Test if we have a known productname. If this is not the case we default to
    ' StarOffice

    select case gProductName
    case "StarOffice"     : cProductName = gProductName
    case "StarSuite"      : cProductName = gProductName
    case "OpenOffice.org" : cProductName = gProductName
    case "BrOffice.org"   : cProductName = gProductName
    case "RedOffice"      : cProductName = gProductName
    case else
        cProductName = "StarOffice"
        warnlog( CFN & "Unknown Office branding: " & _
                 gProductName & ": Using default" )
    end select

    ' find the path to the reference files

    sPath = sPath & "\" & cProductName
    sPath = convertpath( sPath )

    ' collect the parts of the reference-filenames
    dim sFile as string
    sFile = convertpath( sPath & "\filter" & iSprache & ".txt" )

    ' the list where the filternames are stored
    dim sFilterList(20) as String
    sFilterList( 0 ) = "0"

    dim sShort as string
    dim iApplication as integer

    ' check if the reference file is present

    if ( dir( sFile ) = "" ) then

        warnlog( CFN & "The file for default-filter-names is missing. " & _
                 "Create it with ..\bas\tools\getnames.bas::GetFilterNames!" )
        exit sub

    end if

    ' read the reference file
    ListRead ( sFilterList(), sFile, "utf8" )

    ' assign all filters to their global variables (Note: The identifiers below - 
    ' "WRITER" etc. should ideally be 'gApplication' but some gApplication have
    ' more than one name so they are not unique.
    gWriterFilter    = hGetValueForKeyAsString( sFilterList() , "WRITER" )
    gCalcFilter      = hGetValueForKeyAsString( sFilterList() , "CALC" )
    gImpressFilter   = hGetValueForKeyAsString( sFilterList() , "IMPRESS" )
    gDrawFilter      = hGetValueForKeyAsString( sFilterList() , "DRAW" )
    gMathFilter      = hGetValueForKeyAsString( sFilterList() , "MATH" )
    gHTMLFilter      = hGetValueForKeyAsString( sFilterList() , "HTML" )
    gMasterDocFilter = hGetValueForKeyAsString( sFilterList() , "MASTERDOC" )

end sub

'*******************************************************************************

testcase CreateFilterNamesList( optional cMajorId as string )

    '/// This testcase creates the filter lists for an office version and allows
    '///+  creation of filternames for older file-formats as well, as long as the
    '///+  corresponding suffixes exist in global\input\filters\native_suffixes.dat
    '///+  and these are unique.

    dim suffixes( LENGTH_OF_FILTERFILE ) as string
    dim suffixfile as string
    dim sTargetFile as string
    dim sFilterList( 7 ) as string
        sFilterList( 0 ) = "7"

    dim iApplication as integer
    dim iFileTypes as integer
    dim iCurrentFileType as integer
    dim rc as integer

    dim cSuffix as string
    dim cFilter as string

    ' if the user omits the build, we make it "current"
    if ( ismissing( cMajorID ) ) then
        printlog "No parameter has been put into the routine. Using 'current'."
        cMajorID = "current"
    end if

    ' from here we get the suffixes that we search for in the filterlist
    suffixfile = gTesttoolPath & "global\input\filters\native_suffixes.dat"
    suffixfile = convertpath( suffixfile )

    ' this is the directory where the file gets written to
    sTargetFile = gOfficePath & "user\work\" & cMajorID
    sTargetFile = convertpath( sTargetFile )

    ' we need a valid output directory. it is named like cMajorID to make it
    ' possible to distingiush the "version" to which the filters beelong
    ' through this it becomes possible to run through a bunch of filters in a
    ' batch job.

    if ( dir( sTargetFile ) = "" ) then
        printlog( "creating output directory in local workdir." )
        mkdir( sTargetFile )
    end if

    ' this is the target file
    sTargetFile = sTargetFile & "\filter" & iSprache & ".txt"
    sTargetFile = convertpath( sTargetFile )

    ' retrieve the suffixes and store them in an array
    hGetDatafileSection( suffixfile , suffixes() , cMajorID , "" , "" )
    ' now run through all applications and retrieve the filternames

    for iApplication = 1 to 7

        select case iApplication

        case 1 : gApplication = "WRITER"
        case 2 : gApplication = "CALC"
        case 3 : gApplication = "IMPRESS"
        case 4 : gApplication = "DRAW"
        case 5 : gApplication = "MATH"
        case 6 : gApplication = "HTML"
        case 7 : gApplication = "MASTERDOC"

        end select

        ' get the suffix we search for:
        cSuffix = hGetValueForKeyAsString( suffixes() , gApplication )

        'printlog( gApplication & " : Suffix to search for: " & cSuffix )

        call hNewDocument()

        FileSaveAs

        Kontext "SpeichernDlg"
        iFileTypes = DateiTyp.getItemCount()

        ' walk through the list of filternames and grab the one that contains
        ' the expected suffix.

        for iCurrentFileType = 1 to iFileTypes

            ' wait a little
            wait( 500 )

            ' select the next filtername
            DateiTyp.select( iCurrentFileType )

            ' get the current filter
            cFilter = DateiTyp.getSelText( 1 )

            printlog( gApplication & "(" & cSuffix & ") = " & cFilter )
            sFilterList( iApplication ) = gApplication & "=" & cFilter
            iCurrentFileType = iFileTypes +1

        next iCurrentFileType

        ' leave the dialog
        SpeichernDlg.Cancel()

        ' close the document
        call hCloseDocument()

    next iApplication

    ' print the list to the log
    hListPrint( sFilterList() , "Filterlist" )

    ' write the list to the reference file
    listwrite( sFilterList() , sTargetFile , "UTF8" )

    ' some advice on how to continue
    warnlog ( "How to proceed:" )
    printlog( "Your new reference file has been copied to " & sTargetFile )
    printlog( "Please verify its content (DONT TAKE ANYTHING FOR GRANTED)" )
    printlog( "and copy the file to the appropriate place in your local CVS " )
    printlog( "workspace: global\input\filters\current\" & gProductName )
    printlog( "and - in case they are identical - place a copy in " )
    printlog( "workspace: global\input\filters\" & cMajorId  & "\" & gProductName )
    printlog( "Don't forget to check it into CVS after having tested it." )

endcase

'*******************************************************************************

function hGetValueForKeyAsString( lsList() as string, sKey as string ) as string

    '/// This function returns the value of a key as string.
    '///+ The form of the input strings is 'key=value', the list is parsed
    '///+ The Value for the first occurrence of sKey is returned

    dim iItem as integer
    dim cComp as string

    hGetValueForKeyAsString() = "Error: No matching VALUE found for key: " & sKey

    ' Scan through the list and look for sKey. If found, return the Value
    ' (everything to the right of the '=')

    for iItem = 1 to listcount( lsList() )

        if( instr( lsList( iItem ) , sKey ) <> 0 ) then

            cComp = hGetKeyforPairAsString( lsList( iItem ) )

            if( sKey = cComp ) then
                hGetValueForKeyAsString() = hGetValueForPairAsString( lsList( iItem ) )
                iItem = listcount( lsList() ) + 1
            end if

        end if

    next iItem

end function

'*******************************************************************************

function hGetValueForPairAsString( cLine as string ) as string

    '///  This function takes a string that (hopefully) contains one '='
    '///+  and returns the substringstring to the right from the '=' char.

    dim iCharPos as integer

    iCharPos = instr( cLine , "=" )
    iCharPos = len( cLine ) - iCharPos
    hGetValueForPairAsString() = right( cLine , iCharPos )

end function

'*******************************************************************************

function hGetKeyForPairAsString( cLine as string ) as string

    '///  This function returns the string to the left of the '='

    dim iCharPos as integer

    iCharPos = instr( cLine , "=" )

    ' get the string to the left of the = char

    if ( iCharPos > 0 ) then
        hGetKeyForPairAsString() = left( cLine , iCharPos -1 )
    else
        warnlog( "Invalid string passed to hGetKeyForPairAsString: " & cLine )
    end if

end function

'*******************************************************************************

function hGetDataFileSection( cFile as string, lsList() as string, cSection as string , cComment as string, cPrint as string ) as integer

    const CFN = "hGetDataFileSection:"

    '///  This function reads a datafile into a list.
    '///+ Comments (lines beginning with #) are removed from the list.
    '///+ A comment can be passed to the log.
    '///+ Furthermore a section in the source-file can be specified. Only
    '///+ lines within the section are returned then. The delimiter for a
    '///+ section is [section-name] <> [ ...] (or EOF)
    '///+ <ul>NOTES:<li>Instead of lsList() a temporary list should be used that is big
    '///+ enough to hold all the data from the datafile.</li>
    '///+ <li> this function does - basically the same as getinivalue(...) but
    '///+ is easier to debug and returns a list not the key.</li></ul>

    dim sFile as string

    dim iSectionBegin as integer
    dim iSectionEnd as integer
    dim iSectionItems as integer

    ' verify that the sourcefile exists, otherwise warn and abort
    if ( dir( cFile ) = "" ) then
        warnlog( CFN & "File not found: " & cFile )
        hGetDataFileSection() = 0 
        exit function
    end if

    ' print a comment to the logfile. Non optional parameter but might be ""
    if ( cComment <> "" ) then
        printlog( "" )
        printlog( CFN & cComment & " : " & cFile )
        printlog( "" )
    end if

    ' read the list from the file
    listread( lsList() , cFile , "utf8" )

    ' remove comments ( lines containing # )
    hListClearPattern( lsList() , "#" )

    ' remove all blank lines
    hListClearBlank( lsList() )

    ' honor the section, if given. Non-optional parameter that can be ""
    if ( cSection <> "" ) then
        iSectionBegin = hGetStartOfSection( lsList() , cSection )
        iSectionEnd   = hGetEndOfSection( lsList() , iSectionBegin )
        iSectionItems = hGetSection( lsList() , iSectionBegin , iSectionEnd )
    end if

    ' print the current list - if desired.
    if ( lcase( cPrint ) <> "" ) then
        hListPrint( lsList(), "Parent function: " & CFN )
    end if

    ' return the number of items
    hGetDataFileSection() = listcount( lsList() )

end function

'*******************************************************************************

function hGetFileData( sFile as string , sKey as string ) as string

    dim sList( FILE_DATA_SIZE ) as string
    dim iArraySize as integer

    ' This function reads a file and returns the first line containing sKey
    iArraySize = hGetDataFileSection( sFile, sList(), "", "", "" )
    hGetFileData() = hGetValueForKeyAsString( sList() , sKey )

end function

'*******************************************************************************

function hGetStartOfSection( lsList() as string , _section as string ) as integer

    const CFN = "hGetStartOfSection::"

    '/// This function takes a list and looks for a string of the type [_section].
    '///+ The position of this successful hit is returned.
    '///+ On error the returnvalue defaults to 0.

    dim iThisString as integer
    dim cThisString as string
    dim iListSize as integer
    dim cSection as string

    iThisString = 0
    cSection = lcase ( "[" & _section & "]" )
    iListSize = listcount( lsList() )

    do while ( iThisString <= iListSize )
    
        iThisString = iThisString + 1
        cThisString = lcase( lsList( iThisString ) )

        if ( instr( cThisString , cSection ) ) then
            hGetStartOfSection() = iThisString + 1
            iThisString = iListSize + 5
        end if

    loop

    if ( iThisString = ( iListSize + 1 ) ) then
        warnlog( CFN & "Section not found or empty: " & _section )
        hGetStartOfSection = 0
    end if

end function

'*******************************************************************************

function hGetEndOfSection( lsList() as string , iOffset as integer ) as integer

    dim iThisString as integer
    dim cThisString as string
    dim iListSize as integer

    iThisString = iOffset
    iListSize = listcount( lsList() )

    do while ( iThisString <= iListSize )
        cThisString = lsList( iThisString )

        if ( ( instr( cThisString , "[" ) > 0 ) and  ( instr( cThisString , "]" ) > 0 ) )then
            hGetEndOfSection() = iThisString - 1
            iThisString = iListSize + 5
        else
            iThisString = iThisString + 1
        end if

    loop

    if ( iThisString = ( iListSize + 1 ) ) then
        hGetEndOfSection() = iListSize
    end if

end function

'*******************************************************************************

function hGetSection( lsList() as string , iSectionBegin as integer , iSectionEnd as integer ) as integer

    dim iArraySize as integer
    dim iThisString as integer

    iArraySize = ubound( lsList() )

    dim lsTempList( iArraySize ) as string
    listcopy( lsList() , lsTempList() )
    listalldelete( lsList() )

    for iThisString = iSectionBegin to iSectionEnd

        listappend( lsList() , lsTempList( iThisString ) )

    next iThisString

    hGetSection() = listcount( lsList() )

end function


