'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: master.inc,v $
'*
'*  $Revision: 1.122 $
'*
'*  last change: $Author: jsi $ $Date: 2008/02/19 08:41:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : very important routines to start a testscript
'*
'************************************************************************
'*
' Global:
' #1 GetUseFiles             ' First routine which will be called automatically by starting a testscript
' #1 LoadDeclaration         ' Includes the whole declaration (.sid- and .win-files)
' #1 LoadGlobalIncludeFiles  ' Includes global .inc-files
'
' Recover routines:
' #1 TestEnter               ' Internal subroutine called at testcase-start -> start recovering
' #1 TestExit                ' Internal subroutine called at testcase-end
'                               If an error in a testscript occurs the test jumps directly into this routine
' #1 PleaseRecover           ' Recover routine used by TestExit- and TestEnter
'
' Office Startroutines:
' #1 hStartTheOffice         ' Routine to start the Office
' #1 ExitRestartTheOffice    ' Exit and restart the office - after 30 seconds
' #1 FirstOfficeStart        ' First office start with ResetApplication function
' #1 sStartUpOffice          ' sub routine which is being called from hStartTheOffice and ExitRestartTheOffice
' #1 hExitTheOffice          ' sub routine to just exit the office
'
' Special Information:
' #1 IsDebugVersion          ' bDebugVersion variable will be set TRUE if the office is a debug version
' #1 hFirstOutPut            ' Creates a general information header in result files for all tests
' #1 mMakeGeneralOptions     ' Sets general options in the office
' #1 mMakeGeneralOptionsAPI  ' Sets general options in the office via API, without UI
' #1 hIsResultWriteable      ' Is TT able to write the resultfile in the directory? 
' #0 hDetectStatusDatabase   ' Detecting the status database server
' #1 hDisableQuickstarter    ' Disable the Quickstart feature on win32 systems
'*
'\***********************************************************************

sub GetUseFiles
'///<i>GetUseFiles</i>: The first routine which will be called automatically by starting a testscript.
'/// Include all important libraries (.inc) for the startup.
    Dim bQuickstarterStatus as boolean
    Dim sTemp as string
    Dim sPrivateEnvironmentLocation as string
    Dim sEnvironmentVersion as string
    Dim sEnvironmentDisplayVersion as string

    use "global\system\inc\sysinfo.inc"     '///+ sysinfo.inc  : routines to get all system informations
    use "global\system\inc\inivalue.inc"    '///+ inivalue.inc : routines to work with ini-files
    use "global\system\inc\iniinfo.inc"     '///+ iniinfo.inc  : routines to get all informations about OpenOffice.org
    use "global\system\inc\status.inc"      '///+ status.inc   : all routines to put the status-info into database
    use "global\tools\inc\t_xml1.inc"       '///+ t_xml1.inc   : XML-parse-routines

'/// Call important system- and start-routines.
    Call LoadDeclaration                  '///+<ul><li><b>LoadDeclaration</b>: Load all declaration files (master.inc)</li>
    Call LoadGlobalIncludeFiles           '///+<li><b>LoadGlobalIncludeFiles</b>: Include file with global routines (master.inc)</li>

    Call GetToolPlatform                  '///+<li><b>GetToolPlatform</b>: Detect operating environment for the Testtool (sysinfo.inc)</li>
    Call GetOfficePlatform                '///+<li><b>GetOfficePlatform</b>: Detect operating environment for the office (sysinfo.inc)</li>
    Call GetIniInformation                '///+<li><b>GetIniInformation</b>: Get all information out of the <i>testtool.ini/.testtoolrc</i> and set it on global variables (iniinfo.inc)</li>
    Call GetOfficeInformation             '///+<li><b>GetOfficeInformation</b>: Set <i>sAppExe</i> for startup (iniinfo.inc)</li>
    Call FirstOfficeStart                 '///+<li><b>FirstOfficeStart</b>: Try to start the office for first time (master.inc)</li>
    Call GetLanguageInformation           '///+<li><b>GetLanguageInformation</b>: Detect the language of office (iniinfo.inc)</li>
    Call hFirstOutput                     '///+<li><b>hFirstOutput</b>: Make last adjustments and creat information output (master.inc)</li>

'/// make some default setting
    Call mMakeGeneralOptionsAPI           '///+<li><b>mMakeGeneralOptionsAPI</b></li>: Set general options <ol><li><u>system-file-dialogs off</u> on Win32</li><li>work-dir to internal ../user/work-dir</li></ol>(master.inc)</li>
   '///+<li>Disabling the Quickstarter.
        'This can't be done via API right now.
        bQuickstarterStatus = hDisableQuickstarter
        printlog "**  Quickstarter disabled         : " & bQuickstarterStatus      
    printlog    "----------------------------------------------------------------------------------------------------"
    printlog    ""
    Call GetDefaultFilternames            '///+<li><b>GetDefaultFilternames</b>: Get the correct <u>default names for filters</u> for each application</li></ul>
    if (NOT gSamePC) then
        gTestToolPath = gRemotePath
    end if
    
'/// Load private environment dependant settings
'/// BaseDirectory is the setting from the TestTool application at Extra->Settings->Profile->Base directory
'/// This path is available in the global variable: gTestToolPath
'/// The private environment location directory is taken from the file BaseDirectory+errorlog/privateenvironment.txt
'/// The default file is taken from cvs: qa/qatesttool/errorlog/privateenvironment.txt
'/// The default content is: 
'/// >[PrivateEnvironment]
'/// >Current=global/private/
'/// The path is defined relative to BaseDirectory and put into the global variable: gPrivateEnvironmentLocation
'/// At the resulting path of BaseDirectory + gPrivateEnvironmentLocation + 'inc/' there has to exist the file: privateenvironment.inc
'/// with at least the sub: getUseFilesPrivateEnvironment which will get executed

    sPrivateEnvironmentLocation = ConvertPath (gTestToolPath + "errorlog\privateenvironment.txt")
    if fileExists(sPrivateEnvironmentLocation) then
        gPrivateEnvironmentLocation = getIniValue(sPrivateEnvironmentLocation, "PrivateEnvironment", "Current")
        ' TODO: remove trailing path character
    else
        gPrivateEnvironmentLocation = "global/private/"
    end if
    sTemp = ConvertPath (gTestToolPath + gPrivateEnvironmentLocation + "inc/privateenvironment.inc")
    if fileExists(sTemp) then
        use sTemp
        call getUseFilesPrivateEnvironment
    else
        qaErrorLog "Private Environment Control File Location specified in '" + sPrivateEnvironmentLocation + "', but the file doesn't exist: '" +sTemp+ "'"
    end if
    
    ' Check if environment works with this OOo version
'/// Control the behaviour of the environment via the file qa/qatesttool/global/version.txt:
'/// [EnvironmentVersion]
'/// Current=OOH680
'/// DisplayName=2.4.x
'/// If 'Current' doesn't match the OOo version major string, the environment refuses to work, by exiting the test with a messagebox and a warning.
'/// The checking can be disabled, by using  Current=HEAD, or removing the file version.txt
    sPrivateEnvironmentLocation = ConvertPath (gTestToolPath + "global\version.txt")
    if fileExists(sPrivateEnvironmentLocation) then
	sEnvironmentVersion = getIniValue(sPrivateEnvironmentLocation, "EnvironmentVersion", "Current")
	sEnvironmentDisplayVersion = getIniValue(sPrivateEnvironmentLocation, "EnvironmentVersion", "DisplayName")
    else
        sEnvironmentVersion = "HEAD"
        sEnvironmentDisplayVersion = "Developer"
    end if
    if sEnvironmentVersion <> "HEAD" then
        if (len(gMajor) > 5) then
	    if lCase(left(gMajor,6)) <> lCase(left(sEnvironmentVersion,6)) then
                warnlog "This environment '" + sEnvironmentVersion + "' is not suitable for this OOo version '" + left(gMajor,6) + "'! Please get the environment suitable for this OOo version! This Environment only works with OOo " + sEnvironmentDisplayVersion + "!"
                if MsgBox ("This environment '" + sEnvironmentVersion + "' is not suitable for this OOo version '" + left(gMajor,6) + "'! Please get the environment suitable for this OOo version! This Environment only works with OOo " + sEnvironmentDisplayVersion + "!", 16, "Error at startup") = 1 then 
		    end
	        end if
	    end if
	end if
    end if
end sub

'-------------------------------------------------------------------------

sub LoadDeclaration
'/// Include all .sid-declarations (all menu-items as SlotIDs)
'///+&lt;German names&gt; (<u><b>DEPRECATED</u>, only fixes allowed!</b>)
    use "global\sid\all.sid"          '///+<ul><li>all.sid: All menuitems (German)</li>
    use "global\sid\bars.sid"         '///+<li>leisten.sid: All toolbars and toolboxes (German)</li>
    use "global\sid\context.sid"      '///+<li>kontext.sid: All context menus</li>
    use "global\sid\others.sid"       '///+<li>allgem.sid: other slots (German)</li></ul>
'///&lt;English names&gt;
    use "global\sid\e_all.sid"        '///+<ul><li>e_all.sid : all menuitems</li></ul>

'/// Include all .win-declarations (all dialogs as HelpIDs)
'///+&lt;German names&gt; (<u><b>OBSOLETE</u>, only fixes allowed!</b>)
    use "global\win\tab_a_d.win"      '///+<ul><li>All tabpages A...Z</li>
    use "global\win\tab_e_g.win"
    use "global\win\tab_h_o.win"
    use "global\win\tab_p_s.win"
    use "global\win\tab_t_z.win"

    use "global\win\dial_a_c.win"     '///+<li>All dialogs A...Z</li>
    use "global\win\dial_d_h.win"
    use "global\win\dial_i_o.win"
    use "global\win\dial_p_s.win"
    use "global\win\dial_t_z.win"

    use "global\win\sys_dial.win"     '///+<li>sys_dial.win: Systemdialogs</li>
    use "global\win\dokument.win"     '///+<li>dokument.win: All document-types</li>
    use "global\win\mathop.win"       '///+<li>mathop.win: Windows with all math operators</li>

    use "global\win\piloten.win"      '///+<li>piloten.win: Database-, Impress-, Microsoft(R) import-autopilots</li>
    use "global\win\w_autop.win"      '///+<li>w_autop.win: All Writer autopilots</li>

'///&lt;English names&gt;
    use "global\win\edia_a_c.win"     '///+<ul><li>All dialogs A...Z</li>
    use "global\win\edia_d_h.win"
    use "global\win\edia_i_o.win"
    use "global\win\edia_p_s.win"
    use "global\win\edia_t_z.win"

    use "global\win\etab_a_d.win"     '///+<li>All tabpages A...Z</li>
    use "global\win\etab_e_g.win"
    use "global\win\etab_h_o.win"
    use "global\win\etab_p_s.win"
    use "global\win\etab_t_z.win"

    use "global\win\e_mathop.win"     '///+<li>e_mathop.win: Mathoperators</li>

    use "global\win\bars.win"         '///+<li>bars.win:  All bars as windows</li>
    use "global\win\etoolbox.win"     '///+<li>etoolsbox.win: Toolboxes</li>
   
    use "global\win\spadmin.win"      '///+<li>spadmin.win: SPAdmin</li>

    use "global\win\reportdesigner.win" '///+<li>reportdesigner.win: ReportDesigner</li></ul>
end sub

'-------------------------------------------------------------------------

sub LoadGlobalIncludeFiles
'///Load all important global files.
    use "global\tools\inc\t_files.inc"        '///+<ul><li><b>t_files</b>: Routines to open/save/print files</li>
    use "global\tools\inc\t_dir.inc"          '///+<li><b>t_dir</b>: Routines to parse directories (methods execute on the office side)</li>
    use "global\tools\inc\t_dirloc.inc"       '///+<li><b>t_dirloc</b>: Routines to parse directories (execute on the testtool side)</li>
    use "global\tools\inc\t_doc1.inc"         '///+<li><b>t_doc1</b>: Global routines to work on office documents (I)</li>
    use "global\tools\inc\t_doc2.inc"         '///+<li><b>t_doc2</b>: Global routines to work on office documents (II)</li>
    use "global\tools\inc\t_menu.inc"         '///+<li><b>t_menu</b>: Routines to work with menus in the office</li>
    use "global\tools\inc\t_lists.inc"        '///+<li><b>t_lists</b>: Work with array/lists in basic scripts</li>
    use "global\tools\inc\t_option.inc"       '///+<li><b>t_option</b>: Routine to navigate in the options-dialoge of office (I)</li>
    use "global\tools\inc\t_option2.inc"      '///+<li><b>t_option2</b>: Routine to navigate in the options-dialoge of office (II)</li>
    use "global\tools\inc\t_tools1.inc"       '///+<li><b>t_tools1</b> : Global routines (I)</li>
    use "global\tools\inc\t_tools2.inc"       '///+<li><b>t_tools2</b>: Global routines (II)</li>
    use "global\tools\inc\t_tools3.inc"       '///+<li><b>t_tools3</b>: Global routines (III)</li>
    use "global\tools\inc\t_filters.inc"      '///+<li><b>t_filters</b>: Get information about filters</li></ul>
end sub

'-------------------------------------------------------------------------

sub FirstOfficeStart
'/// First start-routine.
    caselog ""                   '///+<ul><li>Stop the first default-output into the resultfile</li>
    Call hStartTheOffice         '///+<li>Start the office</li>
    ResetApplication             '///+<li>Make the first recovering without an error output.</li></ul>
    'Disabling crash handling by TestTool. The crash reporter is used instead.
    catchGPF false
end sub

'-------------------------------------------------------------------------

sub hStartTheOffice (optional sProfPath as String, optional sProfParameter as String)
    Dim tVersionsnummer as string
    Dim tLastVersion as string
    Dim tlVersion() as string
    Dim tilVersion as integer
    Dim tiPosA as integer
    Dim tiPosB as integer
    Dim sErrorInformation as string
    Dim sTemp as string
    Dim sPlatformProgramPath as string
    
    sErrorInformation = "global::systen::inc::master.inc:hStartTheOffice: "
    
    if gPlatform = lcase("osx") then
        sPlatformProgramPath = "MacOS"
    else
        sPlatformProgramPath = "program"
    end if
       
'/// <u>input</u>: <b>optional</b> <i>sProfPath</i> as String [path for profiling data]
'/// <u>input</u>: <b>optional</b> <i>sProfParameter</i> as String [filename for profiling data]

'///+<ol><li>Be sure the path to the result file exists and is writeable
'///+<ul><li>If it doesn't exist, try to create it</li>
'///+<li>If it isn't writeable a messagebox will be thrown</li>
'///+<li>The test will be stopped because without this path the testtool cannot write the resultfile to disk</li></ul></li>
    if (hIsResultWriteable() <> TRUE) then
        if MsgBox (sErrorInformation + "The test won't start! Please correct the error of the not createable RESULT file!", 16, "Error at startup") = 1 then 
            end
        end if
    end if
  
    if gSamePC = TRUE then
        tVersionsnummer = FindBuildID
        ' split versionstring into its parts
        tlVersion() = Split(tVersionsnummer, ",") 
        tilVersion = uBound(tlVersion()) ' array counts from 0 on!
        tLastVersion = tlVersion(tilVersion)
        ' major is from start to 'm'
        tiPosA = instr(tLastVersion, ":") + 1
        tiPosB = instr(tLastVersion, ")")
        gBuild = cInt(Mid(tLastVersion, tiPosA, tiPosB-tiPosA))
    end if        

'Startroutine for soffice.exe
    if sGetCrashreporterValues() <> TRUE then
        sTemp = "Please correct the entries in your testtool.ini/.testtoolrc." & Chr(13) & _
                "Here are the current entries:" & Chr(13) & Chr(13) & _
                "[Crashreporter]" & Chr(13) & _
                "UseProxy=" & gUseProxy & " (Has to be set to (true/false)" & Chr(13) & _
                "ProxyServer=" & gProxyServer & Chr(13) & _
                "ProxyPort=" & gProxyPort & Chr(13) & _
                "AllowContact=" & gAllowContact & " (Has to be set to (true/false)" &  Chr(13) & _
                "ReturnAddress=" & gReturnAddress
        printlog (sTemp)                                                        
        if MsgBox (sTemp, 16, "Error in TestTool control file!") = 1 then
                'TODO: Function to write the missing information to TT control file.
                'The test execution will be stopped here.
                end
        end if
    end if
'///+<li>The normal start routine.
'///+<ul><li>If you want to create a logfile for timestamps, the parameter <i>-env:RTL_LOGFILE=[Path]</i> is appended. (<u>Note</u>: On Win32 the path must have two backslashes)</li>
'///+<li>To ignore the crash- and recover- process for OpenOffice.org-documents the parameter <i>-norestore -nocrashreport</i> is also appended</li>
'///+<li>To disable the configuration lock dialog <i>-nolockcheck</i> is also appended</li>
'///+<li>To enable the automated testing <i>-enableautomation</i> has been added</li>
'///+<li>If you make a remote-test, the office process can't be started by the testtool; you would get an error message</li>
    try
        if IsMissing (sProfPath) then 
            sStartUpOffice
        else
            if IsMissing (sProfParameter) then
                QAErrorLog sErrorInformation & " Parameter 'sProfParameter' is NOT OPTIONAL if sProfPath has been set!"
                'The test execution will be stopped here.
                end
            else
                sStartUpOffice (sProfPath, sProfParameter)
            end if
        end if
    catch
        if gSamePC = FALSE then
            Exceptlog
            if MsgBox (sErrorInformation + "It is not possible to start the office application on a remote system." _
                & Chr(10) & "Please start the office application.", 1, "Starting the office application") = 2 then 
                end
            else
                warnlog sErrorInformation + "The test has a problem to start the office application. It needs a second chance!"
                '///+<li>Sometimes the first start instruction does not work correctly, so here it gets a second chance to start.</li></ul>
                if IsMissing (sProfPath) then 
                    sStartUpOffice
                else
                    if IsMissing (sProfParameter) then
                        QAErrorLog sErrorInformation & " Parameter 'sProfParameter' is NOT OPTIONAL if sProfPath has been set!"
                        'The test execution will be stopped here.
                        end
                    else
                        sStartUpOffice (sProfPath, sProfParameter)
                    end if
                end if
            end if
        end if
        wait 2000
    endcatch
'///+<li>Set the debug output in an non-product version to the Testtool
    try
        'Only in a debug version of the office: Setting the assertion output to TestTool.   
        CaptureAssertions TRUE            
    catch
    endcatch
    Kontext "WelcomeDialog"
    if WelcomeDialog.Exists(2) then
        '///+<li>Clicking on Next button</li>
        NextBtn.Click
        Kontext "TabFirstStartLicense"
        if TabFirstStartLicense.Exists(1) then
            '///+<li>If the next tabpage will be visible pressing <CTRL+a> to get the 'Next'-button available.</li>
            LicenseText.TypeKeys "<MOD1 a>" , TRUE
            Kontext "WelcomeDialog"
            '///+<li>Clicking on Next button </li>
            NextBtn.Click
            Kontext "TabPersonalDataMigration"
            '///+<li>If an OpenOffice 1.1.x exists the migration page will be visible.</li>
            if TabPersonalDataMigration.Exists(1) then
                '///+<li>Uncheck the checkbox for tranferring personal data to get a clean configuration.</li>
                TransferPersonalData.uncheck
                Kontext "WelcomeDialog"
                '///+<li>Clicking on Next button </li>
                NextBtn.Click
                'TODO: Add exception handling.
            end if
            Kontext "TabFirstStartUser"
            if TabFirstStartUser.Exists(1) then
                Kontext "WelcomeDialog"
                '///+<li>If the next tabpage will be visible clicking on 'Next'-button.</li>
                NextBtn.Click
                'TODO: Add exception handling.
            end if
            Kontext "TabFirstStartOnlineUpdate"
            if TabFirstStartOnlineUpdate.Exists(1) then
                Kontext "WelcomeDialog"
                '///+<li>If the next tabpage will be visible clicking on 'Next'-button.</li>
                NextBtn.Click
                'TODO: Add exception handling.
            end if
            Kontext "TabFirstStartRegistration"                
            if TabFirstStartRegistration.Exists(1) then
                '///+<li>If the next tabpage will be visible checking 'Already registered'-radio button.</li>
                AlreadyRegistered.Check
                Kontext "WelcomeDialog"
                '///+<li>Clicking on 'Next'-button.</li></ul>
                WelcomeDialog.OK
            else
                warnlog sErrorInformation & "The fourth page (register) of the 'Welcome to $PRODUCTNAME'-wizard is not visible!"
            end if                
        else
            warnlog sErrorInformation & "The second page (license) of the 'Welcome to $PRODUCTNAME'-wizard is not visible!"
        end if                
    end if                                         
    '///+<li>Waiting some time</li>
    '///+</ol>
    wait 1000
end sub

'-------------------------------------------------------------------------

sub ExitRestartTheOffice (optional sProfPath as String, optional sProfParameter as String)
'/// input: optional sProfPath as String [path for profiling data]
'/// input: optional sProfParameter as String [filename for profiling data]
'/// If a messagebox comes up (yes, no) it will be closed (only one messagbox)
    Dim i as integer
    Dim sErrorInformation as string
   
    sErrorInformation = "global::systen::inc::master.inc:ExitRestartTheOffice: "
   
    hExitTheOffice()

    if IsMissing (sProfPath) then
        sStartUpOffice
    else                
        if IsMissing (sProfParameter) then
            QAErrorLog sErrorInformation & " Parameter 'sProfParameter' is NOT OPTIONAL if sProfPath has been set!"
            'The test execution will be stopped here.
            end
        else
            sStartUpOffice (sProfPath, sProfParameter)            
        end if
    end if           
end sub

'-------------------------------------------------------------------------

sub hExitTheOffice()
'/// Just shut down OOo
'/// If a messagebox comes up (yes, no) it will be closed (only one messagbox)
    try
        FileExit "SynchronMode", TRUE
    catch
    endcatch
    try
        Kontext "Active"
        if Active.Exists(2) then 
            Active.No
        end if
    catch
    endcatch    
    ' This is only >0 if defined in TestTool configuration file
    ' It is needed for a gcov enabled OOo build (Code coverage)
    ' and for valgrind (Memory leaks) tests
    ' valgrind: 90;1,5min, gcov 290;4,5min
    sleep(30+gOOoShutdownTimeOut)
end sub

'-------------------------------------------------------------------------

sub TestEnter
    '/// Automatically called, when a testcase-routine starts
    Call PleaseRecover  ("TestEnter")
    'Needed for status.inc
    gTestcaseStart = Now()
    Call writeCrashRepFile()
end sub

'-------------------------------------------------------------------------

sub TestExit
    '/// Automatically called at the end of a testcase or directly called when an error occured
    '///+<li>Write the data for status page in a list in status.inc</li></ul>
    Call PleaseRecover  ("TestExit")    
    if ((gTestName <> "") AND isStatusEnabled()) then  
        'gTestName set in hStatusIn
        call hStatusAddTestcase()
    end if
end sub

'-------------------------------------------------------------------------

sub PleaseRecover (sWhat as String)
    Dim sError as String
    Dim sInterrupt as Boolean
    Dim sOtherError as Boolean
    
    sInterrupt = FALSE
    sOtherError = FALSE

'/// Close the translation window.
    try
        if gDasNicht = 0 then
            Kontext "TranslationWindow"
            if TranslationWindow.Exists then 
                TranslationWindow.Close
            end if
        end if
   catch
   endcatch

'/// Use <i>ResetApplication</i> method
    try
        call hCloseAllToolbars
        'All error-strings are in sError
        sError = ResetApplication                       
        'If sError = empty then no error occured.
        if sError <> "" then                            
            printlog "   **    Error in " + sWhat + " -Routine      **"
            warnlog sError
        end if
    catch
        printlog "global::system::inc::PleaseRecover: No office running while trying to recover: " + sError
        sInterrupt = TRUE
    endcatch

    try
        'Kill all commands after the reset
        AppAbort
    catch
    endcatch

'/// If the office crashes interrupt = TRUE and the office should be started again.
    if sInterrupt = TRUE then
        try
            Call hStartTheOffice
            SetClipboard ""
        catch
            try
                QAErrorLog "killapp: "+gTestName+"--"+getTestcaseName
                killapp
            catch
                ExceptLog
            endcatch
        endcatch

        try
            'kill all commands after the reset
            AppAbort
        catch
        endcatch
    end if

    try
        'Only in a debug version of the office: Setting the assertion output to TestTool
        CaptureAssertions TRUE            
    catch
    endcatch
    'Disabling crash handling by TestTool. The crash reporter is used instead.
    try
        catchGPF false
    catch
    endcatch
    Kontext
end sub

'-------------------------------------------------------------------------

sub hFirstOutput
'/// Create a general header in result files for all tests.
    Dim sDir as String
    Dim sDir1 as String
    Dim sMajor as String
  
    if gSamePC = TRUE then
        gVersionsnummer = FindBuildID
        ' split versionstring into its parts
        call hSetBuildVersionInformation(False)
        if (len(gMajor)>3) then
            sMajor = left(gMajor,3)
        end if
        'Detecting child workspaces (CWS) and status database server
        if InStr(gVersionsnummer , "[CWS:") <> 0 then
            gCWS = TRUE
        else
            gCWS = FALSE
        end if
        if hDetectStatusDatabase = TRUE then
            gStatusDatabase = TRUE
        else
            gStatusDatabase = FALSE
        end if
    else
        gVersionsnummer = "REMOTE"
    end if
    iSystemSprache  = hGetSystemLanguage
    bDebugVersion   = IsDebugVersion
    printlog    "----------------------------------------------------------------------------------------------------"
    printlog    "              I n f o r m a t i o n   A b o u t   T h e   T e s t   E n v i r o n m e n t"
    printlog    "----------------------------------------------------------------------------------------------------"
    printlog    "**  Application build ID          : " & sMajor & gVersionsnummer
    if bDebugVersion = TRUE then
        printlog "**  DEBUG version                 : " & bDebugVersion 
    end if
    if gCWS = FALSE then
        printlog "**  Build type                    : MASTER"
    else
        printlog "**  Build type                    : CWS"
    end if
    if isStatusEnabled() then
        printlog "**  Status feature (mySQL)        : Enabled " + gLocalStatusDatabase  
    end if
    printlog    "**  HID.LST based on milestone    : " + GetBuildNumHidLst
    printlog    "----------------------------------------------------------------------------------------------------"  
    printlog    "**  Application installation path : " +  gNetzOfficePath
    printlog    "**  User configuration path       : " +  gOfficePath
    printlog    "**  Started application           : " + sAppExe
    printlog    "----------------------------------------------------------------------------------------------------"
    printlog    "**  Application language          : " + iSprache + "  (" + gLanguage + " / " + gISOLang + ")"
    printlog    "**  System language               : " + iSystemSprache + "  (" + GetLanguageText (iSystemSprache) + ")"
    if gSamePC = FALSE then
        printlog "**  Platform VCL TestTool         : " + gtSYSName
        printlog "**  Platform application          : " + gSYSName + "   (" + gHost + ") "
        printlog "**  Path to remote base path      : " + gRemotePath
    else
        printlog "**  Testing platform              : " + gtSYSName
    end if
    printlog    "----------------------------------------------------------------------------------------------------"
    sDir1 = ConvertPath (gOfficePath + "user\work\"
    sDir = App.Dir (sDir1, 16)
    if sDir = "" then
        App.MKDir (sDir1)        
        printlog "**  Work path has been created    : " +  sDir1
    end if
    'Disabling embedded translation tooling 
    gDasNicht = 1
    'Disabling embedded screenshot tooling depending on value in .testtoolrc/ini
    gbSnapShot = sGetScreenshotValue   
end sub

'-------------------------------------------------------------------------

function IsDebugVersion as Boolean
'/// If the tested OpenOffice.org is a debug- or a product version
'///+<ul>
'///+<li>Win32: Check only the file length of the <i>svx-library</i>. 
'///+ If it is bigger than 3.500.000 bytes the version has to be a 
'///+ debug-version because the product build is under 2.000.000 bytes long.</li>
'///+<li>Unix: Take a look into Tools->Options: in a debugversion exists a tabpage 'Interner Test'</li>
'///+</ul>
    Dim sfile as String
    Dim sOfficePathName as String
    Dim sTemp as string
    Dim sOldApplication as string
    Dim iLengthOfDLL as Double
    Dim sPlatformProgramPath as string

    IsDebugVersion = FALSE
    
    if gPlatform = lcase("osx") then
        sPlatformProgramPath = "MacOS"
    else
        sPlatformProgramPath = "program"
    end if
    
    sOfficePathName = gNetzOfficePath
    if gPlatgroup = "w95" then
        sfile = app.dir (ConvertPath (sOfficePathName & sPlatformProgramPath & "\svx*.dll"))
        if sfile = "" then
            IsDebugVersion = False
        else
            iLengthOfDLL = app.FileLen (ConvertPath (sOfficePathName & sPlatformProgramPath & "\" & sfile))
            if (iLengthOfDLL > 7000000) then 
                IsDebugVersion = TRUE
            end if
        end if
    else
        sOldApplication = gApplication
        Do Until GetDocumentCount = 0
            Call hCloseDocument
        Loop               
        gApplication = "writer"
        Call hNewDocument
            wait 500
            ToolsOptions
            if gOOO then
                call hToolsOptions ("TEXTDOCUMENT", "AUTOCAPTION")
            else
                call hToolsOptions ("TEXTDOCUMENT", "MAILMERGEEMAIL")
            end if
            Kontext "ExtrasOptionenDlg"
            Optionsliste.TypeKeys "<Down>"
            sTemp = Optionsliste.GetText
            if (sTemp = "Interner Test") then
                IsDebugVersion = TRUE
            else
                IsDebugVersion = FALSE
            end if
            Kontext "ExtrasOptionenDlg"
            ExtrasOptionenDlg.OK
            wait 500
        Call hCloseDocument
        gApplication = sOldApplication
    end if
end function

'-------------------------------------------------------------------------

sub mMakeGeneralOptions
'/// At the beginning of each testrun set some defaults
'///+ and write them down into the result file (.res).
'///+<ul>
    Dim iJump as Integer
    Dim sComXML as String
    Dim sHelpTip as String
    Dim sHelpExtendedTip as String
    Dim bHelpTip as Boolean
    Dim bHelpExtendedTip as Boolean
    Dim Silent as Boolean
    Dim sTempPath as string
    Dim sTempList(10) as string

    'Used for GetXMLValueGlobal (DEPRECATED function!) to get no output in resultfile. 
    Silent = TRUE

    try
        ToolsOptions
        '///+<li>Tools / Language Settings / Languages
        call hToolsOptions ("Languagesettings", "Languages")
        '///+ Check if Asian language support is enabled and set <i>gAsianSup</i> variable TRUE or FALSE. 
        gAsianSup = Aktivieren.IsChecked
        '///+ Check if CTL (=complex text layout) is enabled amd set <i>gCTLSup</i> variable TRUE or FALSE.
        gCTLSup   = ComplexScriptEnabled.IsChecked
    
        if gAsianSup then            
            printlog    "**  Asian language support        : " & gAsianSup
        end if
        if gCTLSup then
            printlog    "**  Complex text layout support   : " & gCTLSup
        end if
        '///+<li>Set <i>gAccessibility</i> for Win32 (from Options UI) and Unix (ask external program <i>gconftool-2</i>)</li>
        gAccessibility = FALSE
        if gPlatGroup = "unx" then
            'TODO: (TBO?) or VCL.xcu...Application::GetSettings().GetMiscSettings().GetEnableATToolSupport();
            try 
                sTempPath = ConvertPath (gOfficePath + "user\work\accessibility."
                if (dir(sTempPath + "txt") <> "") then
                    kill (sTempPath + "txt")
                end if
                if (dir(sTempPath + "sh") = "") then
                    TextInDatei ("gconftool-2 -g /desktop/gnome/interface/accessibility > " + chr(34) + sTempPath + "txt" + chr(34), sTempPath + "sh")
                end if
                '///+<li>The output to the console about a not found <i>gconftool-2</i> can't be supressed,
                '///+ because every shell handels redirection of error output differently.</li>
                shell ("sh", 0, chr(34) + sTempPath + "sh" + chr(34), FALSE)
                'DON'T WAIT until command is executed
                sTempList(0) = 0 : sTempList(1) = 0
                if (dir(sTempPath + "txt") = "") then
                    gAccessibility = FALSE
                else
                    ListRead ( sTempList(), sTempPath + "txt")
                    if (inStr (lCase(sTempList(1)), "true") > 0) then
                        gAccessibility = TRUE
                    else
                        gAccessibility = FALSE
                    end if
                end if
            catch
                gAccessibility = FALSE
            endcatch
        else
            call hToolsOptions ("STAROFFICE", "ACCESSIBILITY")            
            if SupportAssistiveTechnologyTools.IsVisible then
                gAccessibility = SupportAssistiveTechnologyTools.IsChecked 
            end if
        end if                
        printlog    "**  Accessibility support         : " & gAccessibility
    
        '///+ <li>Switch the <i>system</i> dialogs to &quot;internal&quot; dialogs.
        call hToolsOptions ("StarOffice", "General")
        if StarOfficeDialogeBenutzen.Exists then
            'Only on Gnome 2.6 <and Windows> this checkbox needs to be checked for automated tests.
            StarOfficeDialogeBenutzen.Check
            gUseSysDlg = FALSE
        else
            gUseSysDlg = FALSE
        end if       
        printlog    "**  Using system file dialogs     : " & gUseSysDlg 
           
        '///+<li>Setting the <i>work</i> directory in Tools / Options,
        '///+ <b>except the Asian languages</b> because the sequence of the listed items
        '///+ depends on the system locale.
        call hToolsOptions ("StarOffice", "Paths")
        select case iSprache
            case 01   : iJump =  9      ' English (USA)
            case 03   : iJump =  0      ' Portuguese
            case 07   : iJump =  0      ' Russian
            case 30   : iJump =  0      ' Greek
            case 31   : iJump =  9      ' Netherlands
            case 33   : iJump = 12      ' French
            case 34   : iJump = 13      ' Spanish
            case 35   : iJump =  0      ' Finnish
            case 36   : iJump =  0      ' Hungaria
            case 37   : iJump =  0      ' Catalan
            case 39   : iJump =  7      ' Italian
            case 42   : iJump =  0      ' Czech
            case 43   : iJump =  0      ' Slowak
            case 44   : iJump =  0      ' English (GB)
            case 45   : iJump =  0      ' Danish
            case 46   : iJump =  11     ' Swedish
            case 47   : iJump =  0      ' Norwegian
            case 48   : iJump =  6      ' Polish
            case 49   : iJump =  1      ' German
            case 51   : iJump =  0      ' Slowak
            case 55   : iJump =  18     ' Portuguese (Brazil)
            case 66   : iJump =  14     ' Thai
            case 81   : iJump =  0      ' Japanese ' disabled, because locale dependant!
            case 82   : iJump =  0      ' Korean   ' disabled, because locale dependant!
            case 84   : iJump =  0      ' Vietnamese
            case 86   : iJump =  0      ' Chinese (simplified)  ' disabled, because locale dependant!
            case 88   : iJump =  0      ' Chinese (traditional) ' disabled, because locale dependant!
            case 90   : iJump =  0      ' Turkish
            case 91   : iJump =  0      ' Hindi
            case 96   : iJump =  16     ' Arab
            case 97   : iJump =  0      ' Hebrew
            case else : warnlog "The work-dir can't changed to the internal office-work-dir! Please insert the language in this list!"
                        iJump =  0
        end select
    
        if iJump <> 0 then
            Typ.TypeKeys " <HOME>"
            Typ.TypeKeys "<DOWN>", iJump-1
            Bearbeiten.Click
            Kontext "OeffnenDlg"
            Pfad.SetText (ConvertPath (gOfficePath + "user\work\"))
            Auswaehlen.Click            
            printlog    "**  'My Documents'-path is now    : " & (ConvertPath (gOfficePath + "user\work\"))
        else
            if (bAsianLan = FALSE) then
                QAErrorLog "**  global::system::inc::master.inc::mMakeGeneralOptions::iJump(" & iSprache & ") has not been defined."
                QAErrorLog "**  Please find find out which entry number is the path entry under Tools / Options / OpenOffice.org / Paths."
                QAErrorLog "**  The number has to be entered as iJump variable in master.inc -> mMakeGeneralOptions!"
            end if
        end if
        sleep(1)
        '///+<li>Disabling the <i>bubble help</i>. 
        sComXML = gOfficePath + ConvertPath ("user\registry\data\org\openoffice\Office\Common.xcu")
        if app.Dir (sComXML) = "" then
            bHelpTip = TRUE
        else
            sHelpTip = GetXMLValue (sComXML, "oor:component-data", "node oor:name="+ Chr(34) + "Help"+Chr(34) + ";prop oor:name="+Chr(34) + "Tip" + Chr(34)+ ";value", Silent)
            sHelpExtendedTip = GetXMLValue (sComXML, "oor:component-data", "node oor:name="+ Chr(34) + "Help"+Chr(34) + ";prop oor:name="+Chr(34) + "ExtendedTip" + Chr(34)+ ";value", Silent)
            if (sHelpTip = "") then
                bHelpTip = TRUE
            else
                bHelpTip = sHelpTip
            end if
            if (sHelpExtendedTip <> "") then
                bHelpExtendedTip = sHelpExtendedTip
                ' no action required, because only normal Tips count
            end if
        end if
        if (bHelpTip) then
            call hToolsOptions ("StarOffice", "General")
            sleep(1)
            Tips.uncheck
            bHelpTip = FALSE
            sleep(1)
            printlog    "**  Help/Tips                     : " & bHelpTip      
        end if
        
        '///+<li>Setting the directory for temporary files (=temp-path).
        '///+ <b>except the Asian languages</b> because the sequence of the listed items
        '///+ depends on the system locale.      
        call hToolsOptions ("StarOffice", "Paths")
        select case iSprache
            case 01   : iJump = 12      ' English (USA)
            case 03   : iJump =  0      ' Portuguese
            case 07   : iJump =  0      ' Russian
            case 30   : iJump =  0      ' Greek
            case 31   : iJump =  14      ' Netherlands
            case 33   : iJump =  7      ' French
            case 34   : iJump =  1      ' Spanish
            case 35   : iJump =  0      ' Finnish
            case 36   : iJump =  0      ' Hungaria
            case 37   : iJump =  0      ' Catalan
            case 39   : iJump =  8      ' Italian
            case 42   : iJump =  0      ' Czech
            case 43   : iJump =  0      ' Slowak
            case 44   : iJump =  0      ' English (GB)
            case 45   : iJump =  0      ' Danish
            case 46   : iJump =  15     ' Swedish
            case 47   : iJump =  0      ' Norwegian
            case 48   : iJump =  7     ' Polish
            case 49   : iJump =  14     ' German
            case 51   : iJump =  0      ' Slowak
            case 55   : iJump =  18     ' Portuguese (Brazil)
            case 66   : iJump =  0      ' Thai
            case 81   : iJump =  0      ' Japanese ' disabled, because locale dependant!
            case 82   : iJump =  0      ' Korean   ' disabled, because locale dependant!
            case 84   : iJump =  0      ' Vietnamese
            case 86   : iJump =  0      ' Chinese (simplified)  ' disabled, because locale dependant!
            case 88   : iJump =  0      ' Chinese (traditional) ' disabled, because locale dependant!
            case 90   : iJump =  0      ' Turkish
            case 91   : iJump =  0      ' Hindi
            case 96   : iJump =  0      ' Arab
            case 97   : iJump =  0      ' Hebrew
            case else : warnlog "The temp-dir can't changed to the internal office-temp-dir! Please insert the language in this list!"
                        iJump =  0
        end select
        if iJump <> 0 then
            Kontext "TabPfade"
            Typ.TypeKeys " <HOME>"
            Typ.TypeKeys "<DOWN>", iJump-1
            Bearbeiten.Click
            Kontext "OeffnenDlg"
            sTempPath = ConvertPath (gOfficePath + "user\temp")
            Pfad.SetText (sTempPath)
            '///+<li>If the temp-path does not exist it will be created. 
            if (app.dir(sTempPath, 16) <> "temp") then
                try
                    app.mkdir (sTempPath)
                catch
                    QAErrorLog "global::system::inc::master.inc::mMakeGeneralOptions: Couldn't create temp-directory: '" + sTempPath + "'"
                endcatch
            end if
            Auswaehlen.Click                       
            printlog    "**  'Temporary files'-path        : " + (ConvertPath (gOfficePath + "user\temp\"))
        else
            if (bAsianLan = FALSE) then
                '///+<li>If a &quot;jump&quot;-position for the Tools / Options entry didn't defined a <i>qaerrorlog</i> entry
                '///+ will be written into the resultfile.
                QAErrorLog "**  global::system::inc::master.inc::mMakeGeneralOptions::iJump(" & iSprache & ") has not been defined."
                QAErrorLog "**  Please find find out which entry number is the path entry under Tools / Options / OpenOffice.org / Paths."
                QAErrorLog "**  The number has to be entered as iJump variable in master.inc -> mMakeGeneralOptions!"
            end if
        end if
        sleep(1)
        '///Check which 'Macro Security Level' is set and put it into <i>gMacroSecurityLevel</i> variable. 
        call hToolsOptions ("StarOffice", "General")
        ' Unfortunately XML Security does not build on eCS yet so we need to skip it	
	    if ( gtSYSName <> "eComStation" ) then
            hToolsOptions( "Staroffice" , "Security" )
            Kontext "TabSecurity"
            if MacroSecurity.exists(5) then
                MacroSecurity.click
                Kontext
                active.setPage TabSecurityLevel
                Kontext "TabSecurityLevel"
                if TabSecurityLevel.exists(5) then
                    if veryhigh.isChecked then
                        gMacroSecurityLevel = 3
                    elseIf high.isChecked then
                        gMacroSecurityLevel = 2
                    elseIf medium.isChecked then
                        gMacroSecurityLevel = 1
                    elseIf low.isChecked then
                        gMacroSecurityLevel = 0
                    end if
                    TabSecurityLevel.cancel
                else
                    qaErrorLog "global::system::inc::master.inc::mMakeGeneralOptions: coouldn't get Macro Security Level"
                end if
            else
                qaErrorLog "global::system::inc::master.inc::mMakeGeneralOptions: coouldn't get Macro Security Level"
            end if
	    end if
        sleep(1)
        if gPlatgroup = "unx" then
            call hToolsOptions ("StarOffice", "General")
        end if
        sleep(1)
        Kontext "ExtrasOptionenDlg"
        ExtrasOptionenDlg.OK
        sleep(4)
   catch
        ExceptLog
        MsgBox ("global::systen::inc::master.inc:mMakeGeneralOptions: The test did not start correctly or the application has been crashed." & Chr(13) & _
            "Please correct the problem to make the general settings otherwise the test won't start!", 16, "Error at startup")
        'The test stops here if mMakeGeneralOptions has been run into problems (GPF, failure, ..)
        end
   endcatch
   '///+</ul>
end sub

'-------------------------------------------------------------------------

sub mMakeGeneralOptionsAPI
'/// At the beginning of each testrun set some defaults with the API
'///+ and write them down into the result file (.res).
'///+<ul>
    Dim bHelpTip as Boolean
    Dim sTempPath as string
    Dim sWorkPath as string    
    Dim sFileFunction as string
    Dim oUnoOfficeConnection as object
    Dim oUnoConfigurationAccess as object
    Dim aPropertyValue(1) As new com.sun.star.beans.PropertyValue ' Array of pairs: Property with Value
    Dim xViewRoot
    Dim sTempList
    Dim bError as boolean
   
    sFileFunction="global::system::inc::master.inc::hMakeGeneralOptionsAPI:: "

    ' Open OOo UNO-Port for communication
    oUnoOfficeConnection=hGetUnoService(TRUE)
    if (isNull(oUnoOfficeConnection)) then
        qaErrorLog(sFileFunction+"Couldn't create Uno access")
        ' Do it the UI way
        call mMakeGeneralOptions
        exit sub
    end if

    try
        ' Open Configuration access
        oUnoConfigurationAccess=oUnoOfficeConnection.createInstance("com.sun.star.configuration.ConfigurationProvider")
        if (isNull(oUnoConfigurationAccess)) then
            qaErrorLog(sFileFunction+"Couldn't create Configuration access")
            ' Do it the UI way
            call mMakeGeneralOptions
            exit sub
        end if
        ' These Value pairs don't change inside this function, so they are only set once here.
        ' Specifies the location of the view root in the configuration:
        ' The value is the Path name of teh configuration item to change.
        aPropertyValue(0).Name="nodepath"
        ' Controls how updates are handled in the cache: If false , the cache 
        ' must operate in  write-through mode, where updates are written to 
        ' persistent storage at once - that is before ::commitChanges()  returns.
        aPropertyValue(1).Name="lazywrite"
        aPropertyValue(1).Value=False

        '///+<li>Tools / Language Settings / Languages
        '///+ Check if Asian language support is enabled and set <i>gAsianSup</i> variable TRUE or FALSE. 
        aPropertyValue(0).Value="/org.openoffice.Office.Common/I18N/CJK"
        xViewRoot=oUnoConfigurationAccess.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess",aPropertyValue())
        gAsianSup = xViewRoot.getByName("AsianTypography")
        ' I don't use something more on the path: "/org.openoffice.Office.Common/I18N/CJK"
        ' Destroy, discard, dump, get rid of, put away, throw away, trash, the object:
        xViewRoot.dispose()
        '///+ Check if CTL (=complex text layout) is enabled amd set <i>gCTLSup</i> variable TRUE or FALSE.
        aPropertyValue(0).Value="/org.openoffice.Office.Common/I18N/CTL"
        xViewRoot=oUnoConfigurationAccess.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess",aPropertyValue())
        gCTLSup = xViewRoot.getByName("CTLFont")
        xViewRoot.dispose()
    
        if gAsianSup = TRUE then
            printlog    "**  Asian language support        : " & gAsianSup
        end if
        if gCTLSup = TRUE then
            printlog    "**  Complex text layout support   : " & gCTLSup            
        end if
        '///+<li>Set <i>gAccessibility</i> from Options API</li>
        aPropertyValue(0).Value="/org.openoffice.VCL/Settings/ConfigurableSettings['Accessibility']"
        xViewRoot=oUnoConfigurationAccess.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess",aPropertyValue())
        gAccessibility = xViewRoot.getByName("EnableATToolSupport")
        xViewRoot.dispose()
        if gAccessibility then
            printlog    "**  Accessibility  support        : " & gAccessibility
        end if
    
        '///+ <li>Switch the <i>system</i> dialogs to &quot;internal&quot; dialogs.
        aPropertyValue(0).Value="/org.openoffice.Office.Common/Misc"
        xViewRoot=oUnoConfigurationAccess.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess",aPropertyValue())
        xViewRoot.setPropertyValue("UseSystemFileDialog", false)
        xViewRoot.commitChanges()
        ' Since we use lazywrite=false, the call to '.commitChanges()' returns if all data is written.
        ' This call to ask for pending changes is just to convince me;
        if xViewRoot.hasPendingChanges() then
            qaErrorLog(sFileFunction+"Changes still pending...: UseSystemFileDialog")
            ' At this point there is no needed to think about what to do, if it doesn't work.
        end if
        xViewRoot.dispose()
        gUseSysDlg = FALSE
        printlog    "**  Using system file dialogs     : " & gUseSysDlg     
        
        '///+<li>Disabling the <i>bubble help</i>.
        aPropertyValue(0).Value="/org.openoffice.Office.Common/Help"
        xViewRoot=oUnoConfigurationAccess.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess",aPropertyValue())
        bHelpTip = xViewRoot.getByName("Tip")
        
        if (bHelpTip) then
            xViewRoot.setPropertyValue("Tip", false)
            xViewRoot.commitChanges()
            bHelpTip = FALSE
            if xViewRoot.hasPendingChanges() then
                qaErrorLog(sFileFunction+"Changes still pending...: HelpTip")
            end if
            printlog    "**  Help/Tips                     : " & bHelpTip           
        end if
        xViewRoot.dispose()
    
        '///+<li>Setting the <i>work</i> directory in Tools / Options,
        sTempPath = ConvertPath (gOfficePath + "user\work")
        '///+<li>If the temp-path does not exist it will be created. 
        if (app.dir(sTempPath, 16) <> "work") then
            try
                app.mkdir (sTempPath)
                bError = FALSE
            catch
                QAErrorLog sFileFunction + "Couldn't create temp-directory: '" + sTempPath + "'"
                bError = TRUE
            endcatch
        else
                bError = FALSE
        end if
        if (NOT bError) then
            oUnoConfigurationAccess=oUnoOfficeConnection.createInstance("com.sun.star.util.PathSettings")
            oUnoConfigurationAccess.Work = convertToURL(ConvertPath (gOfficePath + "user\work"))
            sWorkPath = convertFromURL(oUnoConfigurationAccess.Work)
            printlog    "**  'My Documents'-path is now    : " & sWorkPath             
        end if

'///+<li>Setting the directory for temporary files (=temp-path).
        sTempPath = ConvertPath (gOfficePath + "user\temp")
        '///+<li>If the temp-path does not exist it will be created. 
        if (app.dir(sTempPath, 16) <> "temp") then
            try
                app.mkdir (sTempPath)
                bError = FALSE
            catch
                QAErrorLog sFileFunction + "Couldn't create temp-directory: '" + sTempPath + "'"
                bError = TRUE
            endcatch
        else
                bError = FALSE
        end if
        if (NOT bError) then
            ' recycle from above: oUnoConfigurationAccess=oUnoOfficeConnection.createInstance("com.sun.star.util.PathSettings")
            oUnoConfigurationAccess.Temp = convertToURL(ConvertPath (gOfficePath + "user\temp"))
            sTempPath = convertFromURL(oUnoConfigurationAccess.Temp)          
            printlog    "**  'Temporary files'-path        : " & sTempPath             
        end if
        '///Check which 'Macro Security Level' is set and put it into <i>gMacroSecurityLevel</i> variable. 
        gMacroSecurityLevel = fGetSetMacroSecurityUNO()
    catch
        ExceptLog
        MsgBox (sFileFunction + "The test did not start correctly or the application has been crashed." & Chr(13) & _
            "Please correct the problem to make the general settings otherwise the test won't start!", 16, "Error at startup")
            'The test stops here if mMakeGeneralOptionsAPI has been run into problems (GPF, failure, ..)
        end
    endcatch
    '///+</ul>
end sub

'-------------------------------------------------------------------------

function hIsResultWriteable() as boolean    
    '///Running a test without being able to write the RESULT file to disk is worthless.
    '///+This functions checks if the directory exists, tries to create it and checks if it is writeable.
    '///+If this fails, the test won't start and presents a messagebox.
    Dim sResultFilePath as string
    Dim sTestDir as string

    'Get the path to the RESULT directory
    sResultFilePath = GetIniValue (gTesttoolIni, gTTProfileName , "LogBaseDir")
    if (dir(sResultFilePath, 16) = "") then ' doesn't exist      
        try
            MkDir (ConvertPath(sResultFilePath, gtPlatform))
            ' WorkAround for bug in dir() #104037#
            MkDir (ConvertPath(sResultFilePath+ gPathSigne+"ID104037", gtPlatform))
            if (dir(sResultFilePath, 16) <> "") then 
                ' does exist
                hIsResultWriteable = TRUE
                printlog "global::system::inc::master.inc::hIsResultWriteable: created RESULT directory: '" + sResultFilePath + "'"
                ' WorkAround for bug in dir()
                RmDir (ConvertPath(sResultFilePath + gPathsigne + "ID104037", gtPlatform))
            else
                warnlog "global::system::inc::master.inc::hIsResultWriteable: Make the directory '" + sResultFilePath + "' writeable; RESULT file can not be saved;"
                hIsResultWriteable = FALSE
            end if
        catch
            warnlog "global::system::inc::master.inc::hIsResultWriteable: Create the directory '" + sResultFilePath + "'; RESULT file can not be saved; (no right to create the directory)"
            hIsResultWriteable = FALSE
        endcatch
    else
        ' Check if it is writeable
        try
            sTestDir = "tbotest"   ' nasty bug, if the path is with a path sign at the end; usually on on windows root dirs :-(
            if (right(ConvertPath(sResultFilePath, gtPlatform), 1) <> hGetPathSigne(gtPlatform)) then
                sTestDir = hgetPathSigne(gtPlatform) + sTestDir
            end if
            MkDir (ConvertPath(sResultFilePath + sTestDir, gtPlatform))
            RmDir (ConvertPath(sResultFilePath + sTestDir, gtPlatform))
            hIsResultWriteable = TRUE
        catch
            warnlog "global::system::inc::master.inc::hIsResultWriteable: Make the directory '" + convertPath(sResultFilePath, gtPlatform) + "' writeable; RESULT file can not be saved;"
            hIsResultWriteable = FALSE
      endcatch
   end if
end function

'-------------------------------------------------------------------------

sub hDetectStatusDatabase as Boolean
'/// Detecting the status database server.
    dim sOOoLocalStatusDatabase as string
    dim sPrivateEnvironmentLocation as string
  
    sPrivateEnvironmentLocation = ConvertPath (gTestToolPath + "errorlog\privateenvironment.txt")
    if fileExists(sPrivateEnvironmentLocation) then
        gStatusFeatureLevel = getIniValue(sPrivateEnvironmentLocation, "StatusFeatureLevel", "Current")
    else
        gStatusFeatureLevel = 0
    end if
    if gStatusFeatureLevel = 1 then
        hDetectStatusDatabase = TRUE
        '/// working without the status database server:
        '/// on win32 just the volume; 'c:\'
        '/// on Unix a path; '/here/we/are'
        sOOoLocalStatusDatabase = GetIniValue ( gTesttoolIni, "OOoLocalStatusDatabase" , "Current" )
        if sOOoLocalStatusDatabase <> "" then
            if dir(sOOoLocalStatusDatabase,16) <> "" then
                gLocalStatusDatabase = sLocalStatusDatabase
                printlog "**  OOo Local Status Database Path: '" + sOOoLocalStatusDatabase + "'"
            else
                qaErrorLog "**  OOo Local Status Database Path: '" + sOOoLocalStatusDatabase + "' doesn't exist or is not a directory."
                gLocalStatusDatabase = ""
            end if
        else
            gLocalStatusDatabase = ""
        end if
    else
        if gStatusFeatureLevel = 2 then
            hDetectStatusDatabase = TRUE
            gLocalStatusDatabase = "errorlog directory"
        else
            hDetectStatusDatabase = FALSE
            gLocalStatusDatabase = ""
        end if
    end if
end sub

'-------------------------------------------------------------------------

function hDisableQuickstarter as boolean
'/// On all systems, disable the Quickstart feature which is enabled by default.
'///+ Returns: Answer to the question 'Was action taken, to disable it?'
    Dim bTemp as boolean    
    Dim xQuickStarter as object
    Dim oUnoOfficeConnection as object
    
    bTemp = FALSE
    hDisableQuickstarter = FALSE
    
    'First, disabling the Quickstarter via UI
    ToolsOptions
    call hToolsOptions ("STAROFFICE", "MEMORY")
    try        
        bTemp = LoadQuickstarter.isChecked
        if bTemp then
            LoadQuickstarter.uncheck                
        end if                   
    catch
        hDisableQuickstarter = FALSE
    endcatch
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    'Second, closing the Quickstarter process that a restart of the office
    'would result into one process (the Quickstart would hinder otherwise
    'the communication to the office.    
    oUnoOfficeConnection=hGetUnoService(TRUE)
    if (isNull(oUnoOfficeConnection)) then
        QAErrorLog "Couldn't create UNO access. Can't disable Quickstarter via UNO API."                
    else
        try
            xQuickStarter = oUnoOfficeConnection.createInstance("com.sun.star.office.Quickstart")        
            'DEBUG: printlog xQuickStarter.dbg_supportedinterfaces
            'disable quickstart veto (not quickstart UI)
            xQuickStarter.setFastPropertyValue(0, FALSE)        
            hDisableQuickstarter = TRUE
        catch
            hDisableQuickstarter = FALSE    
        endcatch
    end if
end function

'-------------------------------------------------------------------------

sub sStartUpOffice (optional sProfPath as String, optional sProfParameter as String)
    Dim sParameter as String
    Dim sErrorInformation as string
    Dim sUnoPort as string
    
    sErrorInformation = "global::systen::inc::master.inc:sStartUpOffice: " 

    '/// The environment for the non-GUI Crashreporter function will be set.
    setChildEnv("ERRORREPORT_HTTPPROXYSERVER",gProxyServer)
    setChildEnv("ERRORREPORT_HTTPPROXYPORT",gProxyPort)
    setChildEnv("ERRORREPORT_HTTPCONNECTIONTYPE",gConnectionType)
    setChildEnv("ERRORREPORT_RETURNADDRESS",gReturnAddress)
    setChildEnv("ERRORREPORT_SUBJECT","Error_Report_from_TestTool")
    setChildEnv("ERRORREPORT_BODYFILE",ConvertPath (gOfficePath & "user\work\crashrep.txt"))
            
    ' Getting UNO-port
    hGetUNOService(true, sUnoPort)
    if sUnoPort <> "" then
        sUnoPort = "-accept=socket,host=localhost,port=" + sUnoPort + ";urp "
    else
        sUnoPort = ""
        warnlog "UNO port is not defined: Set it in the TestTool application: Extra -> Settings -> Misc -> Remote UNO Port"
    end if
    
    '/// To start the application some parameter need to be set:
    '///+ <ol><li><i>-enableautomation</i> to enable the TCP/IP connection between office application and TestTool</li>
    '///+ <li><i>-norestore</i> to eliminate the the document recovery functionylity after a crash</li>
    '///+ <li><i>-nolockcheck</i> to elimante the 'parallel running instances'-check and always start the application</li>
    '///+ <li><i>-autocrashreport</i> to enable the non-GUI crash report functionality</li>
    '///+ <li><i>-accept=socket,host=localhost,port=12345;urp</i> to enable UNO connection</li>
    '///+ <li><i>OPTIONAL application parameters</i> for profiling tests</li>    
    sParameter = "-enableautomation -norestore -nolockcheck -autocrashreport " & sUnoPort & sAppParameter & " "
    if IsMissing (sProfPath) then
        '///+ <li><i>Factory</i>-parameter which depends on the value of <b>gApplication</b> (WRITER, CALC, ...)</li></ol>
        sParameter = sParameter & sFactory
        ' try/catch is needed for special tasks, to workaround time outs
        try
            Start sAppExe, sParameter
        catch
        endcatch
        try
            ' This is only >0 if defined in TestTool configuration file
            ' It is needed for valgrind (Memory leaks) tests
            ' Valgrind: 420;8min
            sleep(gOOoStartupTimeOut)
        catch
        endcatch
    else
         if IsMissing (sProfParameter) then
            '/// If OPTIONAL profiling path parameters have been set the profiling filename will be checked
            '///+ because then this parameter is not optional.
            QAErrorLog sErrorInformation & " Parameter 'sProfParameter' is NOT OPTIONAL if sProfPath has been set!"
            'The test execution will be stopped here.
            end
        else
            '/// If both OPTIONAL parameters (path, filename) have been set, the office application
            '///+ will be started with an additional parameter:
            '///+ <ul><li><i>-env:RTL_LOGFILE=pathname/filename</i> to write the profiling log.</li>             
            sParameter = sParameter & "-env:RTL_LOGFILE=" & sProfPath & sProfParameter
        end if
        '///+ <li><i>Factory</i>-parameter which depends on the value of <b>gApplication</b> (WRITER, CALC, ...)</li></ul>        
        Start sAppExe, sParameter & " " & sFactory
    end if      
end sub

