'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_dialog_export.inc,v $
'*
'*  $Revision: 1.2.4.1 $
'*
'*  last change: $Author: jsk $ $Date: 2008/03/13 09:29:13 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Update test for the dialog export feature
'*
'*******************************************************************************
'**
' #1 tUpdtDialogExport ' Update test for the dialog export feature
'**
'\******************************************************************************

testcase tUpdtDialogExport


    '///<h3>Update test for the dialog export feature</h3>
    
    if ( gBuild < 9196 ) then
        printlog( "Test disabled for Build-Id < 9196" )
        goto endsub
    endif

    use "framework\tools\inc\basicide_tools.inc"
    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\stringtools.inc"

    dim brc as boolean
    dim cMsg as string
    
    dim cDlgName as string
        cDlgName = hGetWorkPath() & "DialogTest"
        
    const DLG_SUFFIX = ".xdl"
        
    
    '///<ul>
    '///+<li>Create a new document</li>
    hCreateDocument()

    '///+<li>Open the Macro Organizer</li>
    '///+<li>Create a new module for the document</li>
    '///+<li>Open the BASIC IDE</li>
    '///+<li>Create a new Dialog via the tabbar at the bottom of the IDE</li>
    printlog( "Test init: Setting up environment" )
    brc = hInitFormControls( "DialogExport" )
    if ( not brc ) then
        warnlog( "Failed to initialize BAIC IDE/Dialog editor, aborting" )
        goto endsub
    endif
    
    '///+<li>Access the DialogBar, it should be visible by default</li>
    printlog( "Test begin" )
    kontext "DialogBar"
    if ( not DialogBar.exists() ) then
        warnlog( "DialogBar does not exist, aborting" )
        hClosebasicIDE()
        hDestroyDocument()
        goto endsub
    endif
    
    '///+<li>Just click the export button to open the Export dialog</li>
    printlog( "Click the Export button on the DialogBar" )
    kontext "DialogBar"
    Export.click()
    
    '///+<li>Verify that the Export Dialog comes up</li>
    kontext "ExportierenDlg"
    if ( not ExportierenDlg.exists( 1 ) ) then
        warnlog( "Export dialog is not open, aborting" )
        hCloseBasicIDE()
        hDestroyDocument()
        goto endsub
    endif
    
    printlog( "Export dialog is open. Good." )
    
    '///+<li>Save the dialog without providing an extension</li>
    kontext "ExportierenDlg"
    DateiName.setText( cDlgName )
    Speichern.click()
    
    kontext "Active"
    if ( Active.exists() ) then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "File appears to exist, overwriting: " & cMsg )
        Active.Yes()
    endif
    
    '///+<li>Verify that we are back on the BASIC IDE</li>
    kontext "DialogBar"
    if ( not DialogBar.exists() ) then
        warnlog( "DialogBar is not visible, please check." )
    endif
    
    printlog( "Back on the Basic IDE / Dialog Editor. Good." )
        
    '///+<li>Verify that the file has been saved (on filesystem level)</li>
    '///+<li>Delete it if found</li>
    cDlgName = cDlgName & DLG_SUFFIX
    if ( dir( cDlgName ) = "" ) then
        warnlog( "The dialog was not saved to the expected location" )
    else
        hDeleteFile( cDlgName )
        printlog( "Dialog was exported and deleted. Good." )
    endif
    
    '///+<li>Close the BASIC IDE and the document</li>
    printlog( "Test end. Cleanup" )
    hCloseBasicIDE()
    hDestroyDocument()    
    '///</ul>

endcase

