'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_incorrect_password.inc,v $
'*
'*  $Revision: 1.16 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/13 14:14:17 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Password protect files
'*
'*******************************************************************************
'**
' #1 tIncorrectPassword ' Save and load files with non-matching password
'**
'\******************************************************************************

testcase tIncorrectPassword( filetypeID as string )

    '///<H1>Save and load files with incorrect password</H1>
    '///This test saves a file from each application with a password. Then the 
    '///document is closed and reloaded. When prompted an icorrect password is
    '///entered. The document will not be loaded then, an error is displayed.
 
    const WORKFILE = "password"
    dim suffix as string 
    dim workpath as string

    dim rc as integer
    dim brc as boolean
    dim iCurrentFilter as integer
    dim cCurrentFilter as string
    
    const PASSWORD_VALID = "MyPasswd09#+1"
    const PASSWORD_FALSE = "MyPasswd00#+1"
    const DOC_ID = "F_sec_incorrect_password.bas testdocument"
    
    '///<ul>
    '///+<li>Get the workpath from configuration</li>
    workpath = hGetWorkPath()
    
    '///+<li>Get the suffix for the current filetype</li>
    suffix = hGetSuffix( filetypeID )
    
    '///+<li>Delete the workfile (just in case it still exists from prior run)</li>
    printlog( "Delete the workfile - if it was left over by a former testrun" )
    hDeleteFile( workpath & WORKFILE & suffix )    

    '///+<li>Ensure that we have exactly one open document</li>
    printlog( "Make sure we have exactly one single document open" )
    do while( getDocumentCount > 0 )
        hDestroyDocument()
    loop
    hCreateDocument()

    '///+<li>Change the document so the 'save' button becomes active</li>
    printlog( "Change the document" )
    hChangeDoc()

    '///+<li>Click on FileSave</li>
    printlog( "Click on FileSave" )
    FileSave

    Kontext "SpeichernDlg"
    '///+<li>Check the password-checkbox, name the file and click 'Save'</li>
    printlog( "Check the password checkbox" )
    Passwort.check()
    
    '///+<li>Enter a name for the file, click on &quot;Save&quot;</li>
    printlog( "Name the file as " & workpath & WORKFILE )
    Dateiname.settext( workpath & WORKFILE )
    
    '///+<li>Adjust the filter if it differs from &quot;curren&quot;</li>
    if ( filetypeID <> "current" ) then
        for iCurrentFilter = 1 to DateiTyp.getItemCount()
        
            DateiTyp.select( iCurrentFilter )
            cCurrentFilter = DateiTyp.getSelText()
            if ( instr( cCurrentFilter , suffix ) > 0 ) then
                printlog( "Using custom filter: " & cCurrentFilter )
                exit for
            endif
        next iCurrentFilter
    else
        printlog( "Using default filter: " & DateiTyp.getSelText() )
    endif
    
    printlog( "Click on the Save-Button" )
    Speichern.click()

    '///+<li>On the password-dialog enter a password and confirm it (confirm with 
    '///+ incorrect password on first attempt), close warning, reenter correct pair 
    '///+ of passwords.</li>
    brc = hSecurityEnterPasswordOnSave( PASSWORD_VALID )

    '///+<li>Close the document, verify that only one document remains open</li>
    if ( brc ) then

        kontext "AlienWarning"
        if ( AlienWarning.exists( 3 ) ) then
            AlienWarning.ok()
            if ( filetypeID <> "current" ) then
                printlog( "Accepted to save in alien format" )
            else
                warnlog( "Alien warning not expected for default file format" )
            endif
        endif

        printlog( "Close the document" )
        brc = hDestroyDocument()
        if ( not brc ) then
            warnlog( "Something went wrong while closing the document. please check" )
        endif
        
    else
        warnlog( "Something went wrong setting the password for the docuemnt" )
    endif

    '///+<li>Load the file again, when prompted enter incorrect password</li>
    printlog( "Load the file again" )
    FileOpen
    
    kontext "OeffnenDlg"
    if ( OeffnenDlg.exists( 2 ) ) then
        DateiName.setText( workpath & WORKFILE & suffix )
        Oeffnen.click()

        brc = hSecurityEnterPasswordOnLoad( PASSWORD_FALSE , false )
        if ( not brc ) then
            warnlog( "Something went wrong while using the password dialog" )
        endif
        
        '///+<li>Close the current document</li>
        hDestroyDocument()

        '///+<li>Verify that we have no open documents</li>
        printlog( "Verify that we have no open documents" )
        if ( getDocumentCount <> 0 ) then
            warnlog( "There should be exactly one open document" )
        endif
    else
        warnlog( "File Open dialog is not open" )
    endif

    '///+<li>Delete the workfile</li>
    printlog( "Delete the workfile" )
    hDeleteFile( workpath & WORKFILE & suffix )

    '///</ul>

endcase

