'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_function_external_applications.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: tbo $ $Date: 2006/01/17 13:26:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Call external applications that can not be handled by TestTool
'*
'*************************************************************************
'*
' #1 tInsertHyperlink
' #1 tFileSendDocumentAsEmail
'*
'\************************************************************************

' From calc update test PJ
testcase tInsertHyperlink
'///<u><b>Insert::Hyperlink</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    call hNewDocument
    '///<li>Insert::Hyperlink</li>///
    InsertHyperlink
    Kontext "Hyperlink"
    '///<li>Go to 'New Document' option</li>///
    Auswahl.TypeKeys "<END>"
    Kontext "Hyperlink"
    Auswahl.TypeKeys "<Up>"
    Kontext "Hyperlink"
    Auswahl.TypeKeys "<Up>", 2
    
    Kontext "TabHyperlinkInternet"
        ''///<li>Click 'Browser' button</li>///
        WWWBrowser.Click
        TabHyperlinkInternet.Cancel
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>    
endcase

testcase tFileSendDocumentAsEmail
'///<u><b>File::Send::Document as E-Mail...</b></u>///

  '///<ul>
  '///<li>Open new document</li>///
  Call hNewDocument
  Kontext "DocumentCalc"
  '///<li>Edit random stuff to obtain 'dirty' document</li>///
  DocumentCalc.typekeys "1<RETURN>"
  '///<li>File::Send::Document as E-Mail...</li>///
  FileSendDocumentAsEmail
  Kontext "Active"
  '///<li>Check for MsgBox the indicates unconfigured E-Mail settings</li>///
  if Active.Exists then
     if Active.GetRT = 304 then 
     '///<li>+ Test this box if it exists</li>///
        printlog "Probably no configuration for E-Mail found. See error message below:"
        printlog Active.GetText
        Active.OK
     else
        warnlog "Active Dialog has wrong resource type -> Check this out!"
     endif
   else   
     qaErrorLog "In case of correct E-Mail configuration the e-mail client should be visible now!"
     qaErrorLog "BTW, it's correct that nothing happens in OOo!"
  endif
  
   Call hCloseDocument
  '///</ul>
endcase

