'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch2_lvl1_wizard.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsi $ $Date: 2007/11/09 10:18:11 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Chart wizard general functionality
'*
'************************************************************************
'*
' #1 tCreateNew3DChart      ' Create a new 3D chart and check the preserved values
' #1 tCreateNewLineChart    ' Create a new line chart and check the preserved values
'*
'\************************************************************************

testcase tCreateNew3DChart
'///<u><b>Test creation of new 3D Cone chart using the Chart Wizard</b></u>
    Dim sInputFile as STRING
    Dim sOutputFile as STRING
    Dim sControlString as STRING
    Dim iChartVariant as integer
    Dim iChartVariantText as string
    
   
    sInputFile = convertpath ( gTesttoolPath & "chart2/level1/input/randomData.ods" )
    sOutputFile = convertpath ( gOfficePath & "user/work/tCreateNew3DChart.ods" )

    '/// Load test document <i>TesttoolPath</i>/chart2/level1/input/randomData.ods
    call hDateiOeffnen sInputFile
    sleep(2)
    '/// Save document as <i>OfficePath</i>/user/work/tCreateNew3DChart.ods
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , gCalcFilter ) then
        warnlog "Saving test document localy failed -> Aborting"
        call hCloseDocument
        goto endsub
    endif
    '/// Insert / Chart
    InsertChart
    sleep(5)
    '/// Chart Wizard will be opened
    Kontext "ChartType"
    '/// Choose the Chart type <i>bar</i> (should be the second in the top-down list)
    if fSetChartType( "bar" ) > 0 then
        warnlog "Something went wrong setting chart type to BAR."
    endif
    '/// Select 2nd chart variant from left
    if fSetChartTypeVariant( 2 ) > 0 then
        warnlog "Something went wrong setting chart type VARIANT."
    endif
    '/// Check <i>3D Look</i> checkbox
    if fSetChartType3D( TRUE ) > 0 then
        warnlog "Something went wrong setting 3D chart."
    endif
    '/// Change Chart type look to <i>simple</i>
    if fSetChartLook3D( "simple" ) > 0 then
       warnlog "Something went wrong setting 3D look."
    endif
    '/// Change Chart shape to <i>cone</i>
    if fSetChartShape3D( "cone" ) > 0 then
        warnlog "Something went wrong setting 3D shape."
    endif
    '/// Change to <b>Data Range</b> tab page by clicking the <i>Next</i>-button
    Kontext "ChartWizard"
    GoNext.Click
    Kontext "TabChartTypeDataRange"
    '/// Set data range text box to <pre>$Sheet1.$A$2:$E$13</pre>
    if fSetTextBox ( DataRange , "$Sheet1.$A$2:$E$13" ) > 0 then
        warnlog "Something went wrong setting Text."
    endif
   '/// Select data series in <i>Rows</i> radiobox
   if fSetRadioButton ( Rows ) > 0 then
       warnlog "Something went wrong selecting 'Data Series in: Rows'."
   endif
   '/// Uncheck <i>First row as label</i> checkbox
   if fSetCheckBox ( FirstRowAsLabel , FALSE ) > 0 then
       warnlog "Something went wrong unselecting 'First row as label'."
   endif
   '/// Change to <b>Data Series</b> tab page by clicking the <i>Next</i>-button
   Kontext "ChartWizard"
   GoNext.Click
   Kontext "TabChartTypeDataSeries"
   '/// Select last (12th) entry in <i>Data Series</i> list on the left
   if fSetListBoxByItem ( DataSeries , 12 ) > 0 then
       warnlog "Something went wrong selecting 'Data Series' item no. 12."
   endif
   '/// Click on the <i>add</i>-button
   AddButton.Click
   '/// Set <i>Range for Name' text field to <pre>A17</pre>
   if fSetTextBox ( RangeFor , "A17" ) > 0 then
       warnlog "Something went wrong setting Text."
   endif
   '/// Select 2nd entry in <i>Data Ranges</i> (Y-Values) list on the right
   if fSetListBoxByItem ( DataRanges , 2 ) > 0 then
       warnlog "Something went wrong selecting 'Data Ranges' item No. 2."
   endif
   '/// Set <i>Range for Y-Values</i> text field to <pre>B17:E17</pre>
   if fSetTextBox ( RangeFor , "B17:E17" ) > 0 then
       warnlog "Something went wrong setting Text."
   endif
   '/// Change to Chart Elements tab-page by clicking the <i>Next</i>-button
   Kontext "ChartWizard"
   GoNext.Click
   Kontext "TabChartTypeChartElements"
   '/// Set 'Title' text box to <i>MyTitle</i>
   if fSetTextBox ( Title , "MyTitle" ) > 0 then
       warnlog "Something went wrong setting Text."
   endif
   '/// Set 'Subtitle' text box to <i>1 2 3</i>
   if fSetTextBox ( Subtitle , "1 2 3" ) > 0 then
       warnlog "Something went wrong setting Text."
   endif
   '/// Set 'X Title' text box to <i>Grått</i>
   if fSetTextBox ( TitleXAxis , "Grått" ) > 0 then
       warnlog "Something went wrong setting Text."
   endif
   '/// Set 'Y Title' text box to <i>Gräulich</i>
   if fSetTextBox ( TitleYAxis , "Gräulich" ) > 0 then
       warnlog "Something went wrong setting Text."
   endif
   '/// Set 'Z Title' text box to <i>灰色</i>
   if fSetTextBox ( TitleZAxis , "灰色" ) > 0 then
       warnlog "Something went wrong setting Text."
   endif
   '/// Check <i>X Axis</i>-checkbox
   if fSetCheckBox ( GridLinesXAxis , TRUE ) > 0 then
       warnlog "Something went wrong checking 'X Axis'."
   endif
   '/// Uncheck <i>Y Axis</i>-checkbox
   if fSetCheckBox ( GridLinesYAxis , FALSE ) > 0 then
       warnlog "Something went wrong unchecking 'Y Axis'."
   endif
   '///Check <i>Z Axis</i>-checkbox
   if fSetCheckBox ( GridLinesZAxis , TRUE ) > 0 then
       warnlog "Something went wrong checking 'Z Axis'."
   endif
   '/// Select under Legend (on the right) the <i>Left</i> radio-button
   if fSetRadioButton ( PositionLeft ) > 0 then
       warnlog "Something went wrong selecting 'Legend Display Left'."
   endif
   '/// Click the <i>Finish</i>-button
   Kontext "ChartWizard"
   ChartWizard.OK
   sleep(2)
   '/// File / Save
   FileSave
   Kontext "DocumentCalc"
   '/// Press ESCAPE button (deselecting the OLE object)
   DocumentCalc.TypeKeys "<Escape>"
   '/// Close the document
   Call hCloseDocument
   sleep(2)
   '/// Open saved file again
   call hDateiOeffnen sOutputFile
   sleep(2)
   '/// Select chart OLE using navigator
   call fSelectFirstOLE
   '/// Invoke Edit / Object / Edit to enter <i>inplace mode</i> of the chart (enabling the chart menus and editing possibilities)
   EditObjectEdit
   '/// Format / Chart Type
   FormatChartType
   sleep(1)   
   Kontext "ChartType"
   '/// Verify now the made settings in the <i>Chart Type</i> dialog:
   '///+<ul><li>Check if chart type is <i>bar</i></li>
    if ChooseType.GetSelIndex <> 2 Then
        warnlog "Selected chart type (bar) wasn't preserved after save and reload."
    endif
    '///+<li>Check that variant is <i>stacked</i></li>    
    iChartVariant = variant.GetSelIndex
    iChartVariantText = variant.GetSelText(iChartVariant)
    '///+<li>Check that the chart variant is 'Stacked' (2nd entry)</li>
    if iChartVariant = 2 then
        printlog "Chart variant " & iChartVariantText & " (2) has been used - PASSED."
    else
        warnlog "Instead of chart variant 'Stacked' (2) the variant " & iChartVariant & "(" & iChartVariantText & ") has been used - FAILED" 
    end if
    '///+<li>Check the the <i>3D Look</i> box is checked</li>
    if NOT Look3D.IsChecked then
        warnlog "Check box 3D (enabled) wasn't preserved after save and reload."
    endif
    '///+<li>Check that 3D look is <i>simple</i> (=default)</li>
    if Scheme3D.GetSelIndex <> 1 then
        warnlog "Default 3D Look ('simple') has not been preserved after save and reload."
    endif
    '///+<li>Check that 3D shape <i>cone</i> is selected</li>
    if BarColumnShape.GetSelIndex <> 3 Then
        warnlog "3D Shape CONE wasn't preserved after save and reload."
   endif   
	Kontext "ChartType"
    '/// Leave dialog with CANCEL button.
    ChartType.CANCEL
    '/// Invoke Format / Data Ranges
    FormatDataRanges
    '/// Goto tab-page Data Range
    '/// Verify now the made settings in the <i>Data Ranges</i> dialog:
    Kontext
    active.SetPage TabFormatDataRangesDataRange
    Kontext "TabFormatDataRangesDataRange"
    if TabFormatDataRangesDataRange.Exists(2) then
        '///+<ul><li>Check substrings <pre>$A$2:$E$13</pre> and <pre>$A$17:$E$17</pre> in <i>Data Range</i></li>
        'NOTE: We cannot check the whole string due to language dependencies
        sControlString = DataRange.GetText
        printlog "Data Range is: " & sControlString
        if instr ( sControlString , "$A$2:$E$13" ) = 0 Then
            warnlog "Data range wasn't correctly preserved after save and reload and does not caontain $A$2:$E$13."
        else
            printlog "Data range has been correctly preserved after save and reload."
        endif
        if instr ( sControlString , "$A$17:$E$17" ) = 0 Then
            warnlog "#i72241# - Data range wasn't correctly preserved after save and reload and does not contain $A$17:$E$17."
        else
            printlog "Data range has been correctly preserved after save and reload."
        endif
        '///+<li>Check that radio button <i>rows</i> is checked</li>
        if NOT Rows.IsChecked then
            warnlog "Radio Button ROWS (enabled) wasn't preserved after save and reload."
        endif
        '///+<li>Check that radio button <i>columns is <u>un</u>checked.</li>
        if Columns.IsChecked then
            warnlog "Radio Button COLUMNS (disabled) wasn't preserved after save and reload."
        endif
        '///+<li>Check if <i>First row as label</i> checkbox is <u>un</u>checked</li>
        if FirstRowAsLabel.IsChecked then
            warnlog "Check box 'First row as label' (disabled) wasn't preserved after save and reload."
        endif
        '///+<li>Check that <i>First column as label</i> checkbox is checked.</li>
        if NOT FirstColumnAsLabel.IsChecked then
            warnlog "#i72241# - Check box 'First column as label' (enabled) wasn't preserved after save and reload."
        endif
    else
        warnlog "Tab page 'Data Range' not visible!"
    end if
    '///+<li>Go to tab page <b>Data Series</b></li>
   Kontext
   active.SetPage TabFormatDataRangesDataSeries
   Kontext "TabFormatDataRangesDataSeries"
    if TabFormatDataRangesDataSeries.Exists(2) then
        '///+<li>Check if added range (13 in list on the left) was preserved.</li>
        if fSetListBoxByItem ( DataSeries , 13 ) > 0 then
            warnlog "Selecting 13th item in Data Series seems to fail. Added range wasn't preserved."
        else
            '///+<li>Select <i>Name</i>-entry in Data Ranges list on the right.</li>
            if fSetListBoxByItem ( DataRanges , 1 ) > 0 then
                warnlog "Something went wrong selecting 'Data Ranges' item No. 1."
            else
                '///+<li>Check that the string <pre>$A$17</pre> exists in range for <i>Name</i></li>
                'We can't check the whole string due to language dependencies
                sControlString = RangeFor.GetText
                printlog "'Range for name' is: " & sControlString
                if instr ( sControlString , "$A$17" ) = 0 Then
                    warnlog "#i72241# - 'Range for name' wasn't correctly preserved after save and reload."
                else
                    '///+<li>Select <i>Y-Values</i> in Data Ranges list on the right.</li>
                    if fSetListBoxByItem ( DataRanges , 2 ) > 0 then
                        warnlog "Something went wrong selecting 'Data Ranges' item No. 2."
                    else
                        '///+<li>Check that the string <pre>$B$17:$E$17</pre> is in range for <i>Y-Values</i></li></ul>
                        'We can't check the whole string due to language dependencies
                        sControlString = RangeFor.GetText
                        printlog "'Range for Y-Values' is: " & sControlString
                        if instr ( sControlString , "$B$17:$E$17" ) = 0 Then
                            warnlog "'Range for Y-Values' wasn't correctly preserved after save and reload."
                        endif                    
                    endif            
                endif            
            endif
        endif
        '/// Close the dialog with <i>cancel</i>-button</ul>
        TabFormatDataRangesDataSeries.Cancel        
    else
        warnlog "Tab page 'Data series' not visible!"
    end if
    if fInvokeTitlesDialog() = 0 then
        '/// Insert / Title 
        '/// Verify now the made settings in the <i>Titles</i> dialog:
        Kontext "InsertTitleDialog"
        '///+<ul><li>Check that <i>Title</i> text field contains <i>MyTitle</i></li>
        sControlString = MainTitle.GetText
        printlog "'Title' is: " & sControlString
        if sControlString <> "MyTitle" then
            warnlog "Title string 'MyTitle' wasn't preserved after save and reload."
        endif
        '///+<li>Check that <i>Subtitle</i> text field contains <i>1 2 3</i></li>
        sControlString = SubTitle.GetText
        printlog "'Subtitle' is: " & sControlString
        if sControlString <> "1 2 3" then
            warnlog "Subtitle string '1 2 3' wasn't preserved after save and reload."
        endif
        '///+<li>Check that <i>X Title</i> text field contains <i>Grått</i></li>
        sControlString = TitleXAxis.GetText
        printlog "'X Title' is: " & sControlString
        if sControlString <> "Grått" then
            warnlog "X Title string 'Grått' wasn't preserved after save and reload."
        endif
        '///+<li>Check that <i>Y Title</i> text field contains <i>Gräulich</i></li>
        sControlString = TitleYAxis.GetText
        printlog "'Y Title' is: " & sControlString
        if sControlString <> "Gräulich" then
            warnlog "Y Title string 'Gräulich' wasn't preserved after save and reload."
        endif
        '///+<li>Check that <i>Z Title</i> text field contains <i>灰色</i></li></ul>
        sControlString = TitleZAxis.GetText
        printlog "'Z Title' is: " & sControlString
        if sControlString <> "灰色" then
            warnlog "Z Title string '灰色' wasn't preserved after save and reload."
        endif
        '/// Close the <i>Title</i> dialog by pressing <i>Cancel</i>-button
        InsertTitleDialog.Cancel        
    endif    
    if fInvokeGridsDialog() = 0 then
        '/// Insert / Grid 
        Kontext "InsertGridsDialog"
        '/// Verify now the made settings in the <i>Grid</i> dialog:
        printlog "*Main grid*"
        if NOT MainGridXaxis.IsChecked then
            '///+<ul><li>Check that <i>Main Grid X Axis</i> checkbox is checked</li>
            warnlog "Check box 'Gridlines X Axis' (checked) wasn't preserved after save and reload."
        endif
            '///+<li>Check that 'Main Grid Y Axis' checkbox is checked</i>
        if MainGridYaxis.IsChecked then
            warnlog "Check box 'Gridlines Y Axis' (unchecked) wasn't preserved after save and reload."
        endif
            '///+<li>Check that 'Main Grid Z Axis' checkbox is checked</li>
        if NOT  MainGridZaxis.IsChecked then
            warnlog "Check box 'Gridlines Z Axis' (checked) wasn't preserved after save and reload."
        endif
        printlog "*Minor grid*"
        if MinorGridXaxis.IsChecked then
            '///+<li>Check that 'Minor Grid X Axis' checkbox is <u>un</u>checked</li>
            warnlog "Check box 'Minor Grid X Axis' (unchecked) wasn't preserved after save and reload."
        endif
        if MinorGridYaxis.IsChecked then
            '///+<li>Check that <i>Minor Grid Y Axis</i> checkbox is <u>un</u>checked</li>
            warnlog "Check box 'Minor Grid Y Axis' (unchecked) wasn't preserved after save and reload."
        endif
        if MinorGridZaxis.IsChecked then
            '///+<li>Check that <i>Minor Grid Z Axis</i> checkbox is <u>un</u>checked</li></ul>
            warnlog "Check box 'Minor Grid Z Axis' (unchecked) wasn't preserved after save and reload."
        endif
        '/// Leave dialog with <i>Cancel</i>-button.
        InsertGridsDialog.Cancel
    endif    
    if fInvokeLegendDialog() = 0 then
        '/// Insert / Legend 
        Kontext "InsertLegendDialog"
        '/// Verify now the made settings in the <i>Legend</i> dialog:
        '///+<ul><li>Check that <i>Legend Display</i> checkbox is checked</li>
        if NOT Display.IsChecked then
            warnlog "Check box 'Legend Display' (enabled) wasn't preserved after save and reload."
        endif
        '///+Check that <li>Left</li> radio button is selected</li></ul>
        if NOT PositionLeft.IsChecked then
            warnlog "Radio button 'Left' (enabled) wasn't preserved after save and reload."
        endif
        '/// Cancel InsertLegendDialog
        Kontext "InsertLegendDialog"
        InsertLegendDialog.Cancel
    end if
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"
    '/// Close document    
    Call hCloseDocument
endcase
'
'--------------------------------------------------------------------
'
testcase tCreateNewLineChart
    '///<u><b>Test creation of new Line chart using the Chart Wizard</b></u>
    dim sInputFile as STRING
    dim sOutputFile as STRING
    dim sControlString as STRING
    sInputFile = convertpath ( gTesttoolPath & "chart2/level1/input/randomData.ods" )
    sOutputFile = convertpath ( gOfficepath & "user/work/tCreateNewLineChart.ods" )

    '/// File / Load <i>TesttoolPath</i>/chart2/level1/input/randomData.ods
    call hDateiOeffnen sInputFile
    sleep(2)
    '/// Save document as <i>Officepath</i>/user/work/tCreateNewLineChart.ods
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , gCalcFilter ) then
        warnlog "Saving test document localy failed -> Aborting"
        call hCloseDocument
        goto endsub
    endif
    '/// Insert / Chart
    InsertChart   
    '/// Change Chart type to LINE (5th entry from the top)
    Kontext "ChartType"
    if NOT ChartType.Exists(5) then
        warnlog "Chart Wizard was not visible. EXITING!"
        goto endsub
    else
        printlog "Chart Wizard visible."
    end if
    if fSetChartType ( "line" ) > 0 then
        warnlog "Something went wrong setting chart type to LINE."
    else
        printlog "Set chart type to LINE (5th entry from the top) was successful."
    endif
    '/// Select 3rd Change chart type variant (lines only)
    if fSetChartTypeVariant ( 3 ) > 0 then
        warnlog "Something went wrong setting chart type to 3rd variant (lines only)."
    else
        printlog "Setting chart type LINE to 3rd variant (lines only) was successful." 
    endif
    '/// Enable 'Stack Series' and select 'Percent'
    if fSetStackSeries ( "percent" ) > 0 then
        warnlog "Something went wrong setting Stack Series to Percent."
    else
        printlog "Setting Stack Series to Percent was successful."
    endif
    '/// Enable 'Smooth Lines'
    if fSetSmoothLines ( TRUE ) > 0 then
        warnlog "Something went wrong enabling Smooth Lines."
    else
        printlog "Enabling 'smooth lines' was successful."
    endif
    '/// Invoke 'Smooth Lines' dialog
    if fInvokeSmoothLineProperties() > 0 then
        warnlog "Something went wrong invoking Smooth Lines Dialog."
    else
        printlog "Smooth Lines dialog is visible."
    endif
    '/// Check B-Spline
    BSpline.check
    printlog "Checked B-Spline"
    '/// Set Resolution to 33
    Resolution.SetText "33"
    printlog "Resultion set to 33"
    '///Set Data Points Order to 5
    printlog "Set Data Points Order to 5"
    DataPointsOrder.SetText "5"
    '/// Close 'Smooth Lines' dialog
    if fCloseSmoothLinePropertiesOK() > 0 then
        warnlog "Something went wrong closing Smooth Lines Dialog."
    else
        printlog "Closing Smooth Lines dialog was successful."
    endif
    '/// Change to Data Range tab-page
    Kontext "ChartWizard"
    GoNext.Click
    Kontext "TabChartTypeDataRange"
    '/// Set Data Range text box to "$Sheet1.$A$1:$F$13;$Sheet1.$A$17:$F$17"
    if fSetTextBox ( DataRange , "$Sheet1.$A$1:$F$13;$Sheet1.$A$17:$F$17" ) > 0 then
        warnlog "Something went wrong setting Text."
    else
        printlog "Set Data Range text box to '$Sheet1.$A$1:$F$13;$Sheet1.$A$17:$F$17'"
    endif
    '/// Change to Data Series tab-page
    Kontext "ChartWizard"
    GoNext.Click
    Kontext "TabChartTypeDataSeries"
    '/// Select 3rd entry in Data Series
    if fSetListBoxByItem ( DataSeries , 3 ) > 0 then
        warnlog "Something went wrong selecting 'Data Series' item No. 3."
    else
        printlog "Selected 3rd entry in Data Series."
    endif
    '/// Remove series labeled 'John'
    RemoveButton.Click
    printlog "Removed series labeled 'John'"
    '/// Select 4th entry in Data Series
    if fSetListBoxByItem ( DataSeries , 4 ) > 0 then
        warnlog "Something went wrong selecting 'Data Series' item No. 4."
    else
        printlog "Select 4th entry in Data Series"
    endif
    '/// Select 2nd entry in Data Ranges
    if fSetListBoxByItem ( DataRanges , 2 ) > 0 then
        warnlog "Something went wrong selecting 'Data Ranges' item No. 2."
    else
        printlog "Selected 2nd entry in Data Ranges."
    endif
    '/// Set 'Range for Y-Values' text box to "$Sheet1.$F$2:$F$13;$Sheet1.$D$17"
    if fSetTextBox ( RangeFor , "$Sheet1.$F$2:$F$13;$Sheet1.$D$17" ) > 0 then
        warnlog "Something went wrong setting Text."
    else
        printlog "Set 'Range for Y-Values' text box to '$Sheet1.$F$2:$F$13;$Sheet1.$D$17'"
    endif
    '/// Set 'Categories' text box to "$Sheet1.$A$2:$A$13;$Sheet1.$A$1"
    if fSetTextBox ( Categories , "$Sheet1.$A$2:$A$13;$Sheet1.$A$19" ) > 0 then
        warnlog "Something went wrong setting Text."
    else
        printlog "Set 'Categories' text box to '$Sheet1.$A$2:$A$13;$Sheet1.$A$1'"
    endif
    '/// Change to Chart Elements tab-page
    Kontext "ChartWizard"
    GoNext.Click
    Kontext "TabChartTypeChartElements"
    '/// Uncheck 'Y Axis'
    if fSetCheckBox ( GridLinesYAxis , FALSE ) > 0 then
        warnlog "Something went wrong unselecting 'Y Axis'."
    else
        printlog "Uncheck 'Y Axis'"
    endif
    '/// Uncheck 'Legend Display'
    if fSetCheckBox ( Display , FALSE ) > 0 then
        warnlog "Something went wrong unselecting 'Legend Display'."
    else
        printlog "Uncheck 'Legend Display'"
    endif
    '/// Create Chart by clicking Finish-button
    Kontext "ChartWizard"
    ChartWizard.OK
    printlog "Create Chart by clicking Finish"
    sleep(2)
    '/// File / Save
    FileSave
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>" , 2
    '/// Press <Escape>-key
    printlog "Pressed ESCAPE-key"
    '/// File / Close document
    Call hCloseDocument
    sleep(2)
    '/// Open saved file again
    call hDateiOeffnen sOutputFile
    sleep(2)
    '/// Open the Navigator (F5)
    '/// Select the first OLE object in the Navigator
    call fSelectFirstOLE
    '/// Edit / Object / Edit to enter Inplace Mode
    EditObjectEdit
    '/// Format / Chart Type
    printlog "Format / Chart Type"
    FormatChartType
    Kontext "ChartType"
    if ChartType.Exists(2) then
        '/// Check if chart type is LINE
        if ChooseType.GetSelIndex <> 5 then
            warnlog "Selected chart type wasn't preserved after save and reload."
        else
            printlog "Selected chart type has been preserved after save and reload."
        endif
        '/// Check if chart variant is LINES ONLY (third variant in non-CTL versions from the left)
        if Variant.GetSelIndex <> 3 then
            warnlog "Selected chart type variant wasn't preserved after save and reload."
        else
            printlog "Selected chart type variant has been preserved after save and reload."
        end if    
        '/// Check if 'Stack Series' box is checked
        if NOT StackSeries.IsChecked then
            warnlog "Check box 'Stack Series' (enabled) wasn't preserved after save and reload."
        else
            printlog "Check box 'Stack Series' (enabled) has been preserved after save and reload."
        endif
        '/// Check if 'Percent' radio button is checked
        if NOT Percent.IsChecked then
            warnlog "Radio button box 'Percent' (enabled) wasn't preserved after save and reload."
        else
            printlog "Radio button box 'Percent' (enabled) has been preserved after save and reload."
        endif
        '/// Check if 'Smooth Lines' box is checked
        if NOT SmoothLines.IsChecked then
            warnlog "Check box 'Smooth Lines' (enabled) wasn't preserved after save and reload."
        else
            printlog "Check box 'Smooth Lines' (enabled) has been preserved after save and reload."
        endif
        '/// Invoke 'Smooth Lines' dialog
        if fInvokeSmoothLineProperties() > 0 then
            warnlog "Something went wrong invoking Smooth Lines dialog."
        else
            printlog "Smooth Lines dialog is up."
        endif
        '/// Check if 'B-Spline' radio button is checked
        if NOT BSpline.IsChecked then
            warnlog "Radio button box 'B-Spline' (enabled) wasn't preserved after save and reload."
        else
            printlog "Radio button box 'B-Spline' (enabled) has been preserved after save and reload."
        endif
        '/// Check if 'Resolution' has value '33'
        if Resolution.GetText <> "33" then
            warnlog "Value for Resolution '33' wasn't preserved after save and reload."
        else
            printlog "Value for Resolution '33' has been preserved after save and reload."
        endif
        '/// Check if 'Data Points Order' has value '5'
        if DataPointsOrder.GetText <> "5" then
            warnlog "Value for Data Points Order '5' wasn't preserved after save and reload."
        else
            printlog "Value for Data Points Order '5' has been preserved after save and reload."
        endif
        '/// Close 'Smooth Lines' dialog
        if fCloseSmoothLinePropertiesOK() > 0 then
            warnlog "Something went wrong closing Smooth Lines Dialog."
        else
            printlog "Smooth Lines dialog has been closed."
        endif
        '/// Leave Chart Type dialog with Cancel
        Kontext "ChartType"
        if ChartType.Exists(2) then
	        ChartType.Cancel
	    else
	        warnlog "ChartType dialog was not visible!?"
	    end if
        printlog "Chart Type dialog has been closed with CANCEL."
    else
        warnlog "Chart Type dialog was not up!"
    end if
    '/// Format / Data Ranges
    printlog "Format / Data Ranges"
    FormatDataRanges
    Kontext
    Active.SetPage TabChartTypeDataRange        
    Kontext "TabChartTypeDataRange"
    if TabChartTypeDataRange.Exists(2) then
        '/// Check substrings '$A$2:$C$13', '$A$19', '$B$1:$C$13', '$E$1:$F$13' and '$B$17:$E$17' in Data Range
        'NOTE: We cannot check the whole string due to language dependencies
        sControlString = DataRange.GetText
        printlog "Data Range is: " & sControlString
        if instr ( sControlString , "$A$2:$C$13" ) = 0 Then
            warnlog "Data range wasn't correctly preserved after save and reload."
        else
            printlog "Data range has been correctly preserved after save and reload."
        endif
        if instr ( sControlString , "$A$19" ) = 0 Then
            warnlog "Data range wasn't correctly preserved after save and reload."
        else
            printlog "Data range has been correctly preserved after save and reload."
        endif
        if instr ( sControlString , "$B$1:$C$13" ) = 0 Then
            warnlog "Data range wasn't correctly preserved after save and reload."
        else
            printlog "Data range has been correctly preserved after save and reload."
        endif
        if instr ( sControlString , "$E$1:$F$13" ) = 0 Then
            warnlog "Data range wasn't correctly preserved after save and reload."
        else
            printlog "Data range has been correctly preserved after save and reload."
        endif
        if instr ( sControlString , "$B$17:$E$17" ) = 0 Then
            warnlog "Data range wasn't correctly preserved after save and reload."
        else
            printlog "Data range has been correctly preserved after save and reload."
        endif
        '/// Check if Radio Button ROWS is checked
        if Rows.IsChecked then
            warnlog "Radio Button ROWS (disabled) wasn't preserved after save and reload."
        else
            printlog "Radio Button ROWS (disabled) has been preserved after save and reload."
        endif
        '/// Check if Radio Button COLUMNS is unchecked
        if NOT Columns.IsChecked then
            warnlog "Radio Button COLUMNS (enabled) wasn't preserved after save and reload."
        else
            printlog "Radio Button COLUMNS (enabled) has been preserved after save and reload."
        endif
        '/// Check if 'First row as label' box is unchecked
        if NOT FirstRowAsLabel.IsChecked then
            warnlog "Check box 'First row as label' (enabled) wasn't preserved after save and reload."
        else
            printlog "Check box 'First row as label' (enabled) has been preserved after save and reload."
        endif
        '/// Check if 'First column as label' box is checked
        if NOT FirstColumnAsLabel.IsChecked then
            warnlog "Check box 'First column as label' (enabled) wasn't preserved after save and reload."
        else
            printlog "Check box 'First column as label' (enabled) has been preserved after save and reload."
        endif
    else
        warnlog "Tab page Data Range was not up!"
        printlog "Trying to get tab page Dara Series"
        FormatDataRanges        
    end if
    '/// Switch to tab page Data Series
    Kontext
    Active.SetPage TabFormatDataRangesDataSeries 
    Kontext "TabChartTypeDataSeries"
    if TabChartTypeDataSeries.Exists(2) then
        '/// Select 4th entry in Data Series
        if fSetListBoxByItem ( DataSeries , 4 ) > 0 then
            warnlog "Selecting 4th item in Data Series failed. EXITING!"
            TabChartTypeDataSeries.Cancel
            call hCloseDocument
            goto endsub
        else
            printlog "Selecting 4th item in Data Series was successful."
        endif
        '/// Select Name in Data Ranges
        if fSetListBoxByItem ( DataRanges , 1 ) > 0 then
            warnlog "Something went wrong selecting 'Data Ranges' item No. 1."
        else
            printlog "Data Ranges item No. 1 has been selected."
        endif
        '/// Check substring '$F$1' in Range for Name
        'NOTE: We cannot check the whole string due to language dependencies
        sControlString = RangeFor.GetText
        printlog "'Range for name' is: " & sControlString
        if instr ( sControlString , "$F$1" ) = 0 Then
            warnlog "'Range for name' wasn't correctly preserved after save and reload."
        else
            printlog "'Range for name' has been correctly preserved after save and reload."
        endif
        '/// Select Y-Values in Data Ranges
        if fSetListBoxByItem ( DataRanges , 2 ) > 0 then
            warnlog "Something went wrong selecting 'Data Ranges' item No. 2. EXITING!"
            TabChartTypeDataSeries.Cancel
            call hCloseDocument
            goto endsub
        endif
        '/// Check substring '$F$2:$F$13' and '$D$17'in Range for Name
        'NOTE: We cannot check the whole string due to language dependencies
        sControlString = RangeFor.GetText
        printlog "'Range for Y-Values' is: " & sControlString
        if instr ( sControlString , "$F$2:$F$13" ) = 0 Then
            warnlog "'Range for Y-Values' wasn't correctly preserved after save and reload."
        else
            printlog "'Range for Y-Values' has been correctly preserved after save and reload."
        endif
        if instr ( sControlString , "$D$17" ) = 0 Then
            warnlog "'Range for Y-Values' wasn't correctly preserved after save and reload."
        else
            printlog "'Range for Y-Values' has been correctly preserved after save and reload."
        endif
        '/// Check substring '$A$2:$A$13' and '$A$19'in Categories
        'NOTE: We cannot check the whole string due to language dependencies
        sControlString = Categories.GetText
        printlog "'Categories' is: " & sControlString
        if instr ( sControlString , "$A$2:$A$13" ) = 0 Then
            warnlog "'Categories' wasn't correctly preserved after save and reload."
        else
            printlog "'Categories' has been correctly preserved after save and reload."
        endif
        if instr ( sControlString , "$A$19" ) = 0 Then
            warnlog "'Categories' wasn't correctly preserved after save and reload."
        else
            printlog "'Categories' has been correctly preserved after save and reload."
        endif
        TabChartTypeDataSeries.Cancel
    else
        warnlog "Tab page Data Series was not up!"
    end if
    InsertTitle
    '/// Insert Title
    printlog "Insert / Title"
    Kontext "InsertTitleDialog"
    if InsertTitleDialog.Exists(2) then
        '/// Check if 'Title' text box is empty
        sControlString = MainTitle.GetText    
        if sControlString <> "" then
            warnlog "Empty Title string wasn't preserved after save and reload."
        else
            printlog "'Title' is empty - PASSED."
        endif
        '/// Check if 'Subtitle' text box is empty
        sControlString = SubTitle.GetText    
        if sControlString <> "" then
            warnlog "Empty Subtitle string wasn't preserved after save and reload."
        else
            printlog "'Subtitle' is empty - PASSED."
        endif
        '/// Check if 'X Title' text box is empty
        sControlString = TitleXaxis.GetText    
        if sControlString <> "" then
            warnlog "Empty X Title string wasn't preserved after save and reload."
        else
            printlog "'X Title' is empty - PASSED."
        endif
        '/// Check if 'Y Title' text box is empty
        sControlString = TitleYaxis.GetText   
        if sControlString <> "" then
            warnlog "Empty Y Title string wasn't preserved after save and reload."
        else
            printlog "'Y Title' is empty - PASSED."
        endif
        '/// Check if 'Z Title' text box is empty
        sControlString = TitleZaxis.GetText    
        if sControlString <> "" then
            warnlog "Empty Z Title string wasn't preserved after save and reload."
        else
            printlog "'Z Title' is empty - PASSED."
        endif
        '/// Leaving Title dialog with Cancel
        InsertTitleDialog.Cancel
    else
        warnlog "Title dialog was not up!"    
    end if
    '/// Insert / Grids
    printlog "Insert / Grids"
    If fInvokeGridsDialog = 0 then
        Kontext "InsertGridsDialog"    
        '/// Check if 'Gridlines X Axis' box is checked
        if MainGridXaxis.IsChecked then
            warnlog "Check box 'Gridlines X Axis' (disabled) wasn't preserved after save and reload."
        else
            printlog "Gridlines X Axis - PASSED"
        endif
        '/// Check if 'Gridlines Y Axis' box is unchecked
        if MainGridYaxis.IsChecked then
            warnlog "Check box 'Gridlines Y Axis' (disabled) wasn't preserved after save and reload."
        else
            printlog "Gridlines Y Axis - PASSED"                    
        endif
        '/// Check if 'Gridlines Z Axis' box is checked
        if MainGridZaxis.IsEnabled then
            warnlog "Check box 'Gridlines Z Axis' shouldn't be enabled after save and reload."
        else
            printlog "Gridlines Z Axis - PASSED"                                
        endif
        InsertGridsDialog.Cancel
    else
        warnlog "Insert Grids dialog was not up!"
    end if
    '/// Insert / Legend
    printlog "Insert / Legend"
    if fInvokeLegendDialog() = 0 then                 
        '/// Check if 'Legend Display' box is checked
        Kontext "InsertLegendDialog"
        if Display.IsChecked then
            warnlog "Check box 'Legend Display' (disabled) wasn't preserved after save and reload."
        else
            printlog "Legend Display - PASSED"                                
        endif
        InsertLegendDialog.Cancel
    else
        warnlog "Insert Legend dialog was not up!"
    end if
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"
    '/// Close document
    Call hCloseDocument
endcase

