'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_chinesetranslate.bas,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsi $ $Date: 2007/12/05 13:46:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner :  joerg.sievers@sun.com
'*
'* short description : Test Chinese Translation
'*
'\*******************************************************************

sub main   
    Dim bAsianLanguage as Boolean
    Dim DefaultLanguage as String
   
    use "calc\special\inc\chinesetranslate\c_chinesetranslate1.inc"
    use "calc\special\inc\chinesetranslate\c_chinesetranslate2.inc"
    use "calc\tools\c_tool.inc"
    use "calc\tools\c_tool_1.inc"
   
    Call hStatusIn ( "calc", "c_chinesetranslate.bas" , "Chinese translation" )
        select case iSprache
            case 01 , 86 , 88
                   printlog Chr(13) + "- Test Chinese Translation"
                           
                   ' Enable 'Asian Language support' ON
                     bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)
                   ' Set default language(asian) for document is "Simplified Chinese"
                     DefaultLanguage = fSetAsian(fGetLanguageName(86))
                
                     printlog Chr(13) + " -- Default setting -- "  
                     'Don't need to test tDefaultSetting_1
                     'Call tDefaultSetting_1
                     Call tDefaultSetting_2     
                     Call tDefaultSetting_3
                     
                     printlog Chr(13) + " -- Standard Function -- "
                     Call tChineseTranslate_1
                     Call tChineseTranslate_2
                     Call tChineseTranslate_3
                     Call tChineseTranslate_4
                     'Mark this case , since we don't use 'Use Taiwan , Hongkong SAR...'s statue so far
                     'Call tChineseTranslate_5
                
                     printlog Chr(13) + " -- Chinese Dictionary -- "
                     Call tChineseTranslate_6
                     Call tChineseTranslate_7
                     Call tChineseTranslate_8
                     Call tChineseTranslate_9
                     Call tChineseTranslate_10
                     Call tChineseTranslate_11
                
                     printlog Chr(13) + " -- Undo/Redo -- "
                     Call tUndoRedo
                                                               
                   'Set default language(asian) to default
                     Call fSetAsian(DefaultLanguage)
                
                     ToolsLanguageChineseTranslation
                     Kontext "ChineseTranslation"
                       TranslateCommonTerms.UnCheck
                     ChineseTranslation.OK
                             
                    'Set the 'Asian Language support' to default
                     if bAsianLanguage = FALSE then
                         Call ActiveDeactivateAsianSupport(FALSE)
                     end if                
   case else
        qaErrorLog "This test is only designed to run on English (01) and chinese (86, 88)!"
   end select
   Call hStatusOut
end sub
'
'-------------------------------------------------------------------------------
'
sub LoadIncludeFiles
   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   gApplication   = "CALC"
   Call GetUseFiles
end sub
