'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_105b.inc,v $
'*
'*  $Revision: 1.21 $
'*
'*  last change: $Author: jsi $ $Date: 2007/07/26 05:12:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Detailed test of the functions in the Format menu - Part 2
'*
'************************************************************************
'*
' #1 C_105b     ' Initial routine
' #1 tFormatLine
' #1 tFormatText
' #1 tFormatArea
' #1 tFormatPositionAndSize_1
' #1 tFormatPositionAndSize_2
' #1 tFormatGroup
' #1 tFormatStandard
'*
'\***********************************************************************

sub C_105b

   Printlog Chr(13) + "---  Formatmenu for DrawingObjects  ---"

   call tFormatLine
   call tFormatText
   call tFormatArea
   call tFormatPositionAndSize_1
   call tFormatPositionAndSize_2
   call tFormatGroup

   Printlog Chr(13) + "---  ContextFormatmenu for cellcontents  ---"
   call tFormatStandard

end sub
'
'---------------------------------------------------------------------------
'
testcase tFormatLine
'/// In this testcase a line is painted on a calcdocument. Then some properties of this line ///
'/// are modified and the document is saved. After reload the document it is checked, if ///
'/// the made modifies are taken over. ///

   dim vwert2 as Integer
   dim sTestFile
   dim modLine as string, currLine as string

   sTestFile = convertpath(gOfficePath & "user/work/tFormatLine.ods")

      call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Linie.click
      call gMouseMove (10,10,60,60)

      call gMouseClick (1,1)        ' deselect
      Sleep 1
      call gMouseClick (20,20)      ' select
      Sleep 1

      FormatLine
   printlog "Adjustments"
   printlog "Line values"
      kontext
      active.setpage TabLinie
      Sleep 2
      Kontext "TabLinie"
      Stil.Select 2
      currLine = Breite.GetText
      Breite.More 2
      modLine = Breite.GetText
      Farbe.Select 3

   printlog "Line style"
      kontext
      active.setpage TabLinienstile
      Sleep 2
      Kontext "TabLinienstile"
      try
         Linienstil.select 7
   catch
      warnlog "Line styles aren't available!?"
   endcatch
   printlog "Line ends"
      kontext
      active.setpage TabLinienenden
      try
         Kontext "Linienstil"
         if Linienstil.exists then
            warnlog "Dialog 'Linienstil' has appeared"
            Linienstil.Cancel
         end if
      catch
      endcatch
      Kontext "TabLinienenden"
      try
      Liste.Select 8
      catch
         warnlog "Line ends aren't available"
      endcatch
      Kontext "TabLinienenden"
      TabLinienenden.OK

      call gMouseClick (70,70)      ' deselektieren
      Sleep 1
      call gMouseClick (20,20)      ' selektieren
      Sleep 1

      FormatLine
   printlog "Check line values"
      kontext
      active.setpage TabLinie
      Kontext "TabLinie"
      if Breite.GetText <> modLine then Warnlog "Width isn't anymore " + modLine + " but " + Breite.GetText
      if Farbe.GetSelIndex <> 3 then
         Warnlog "Color isn't the 3. but the " + Farbe.GetSelIndex +"." & "Bug?!"
      end if

   printlog "linestyle"
      kontext
      active.setpage TabLinienstile
      Kontext "TabLinienstile"
      if Linienstil.GetSelIndex <> 7 then Warnlog "Adjusted Line Style isn't the 7. but " + Linienstil.GetSelIndex + "."

   printlog "Line ends"
      kontext
      active.setpage TabLinienenden
      try
         Kontext "Linienstil"
         if Linienstil.exists then
            warnlog "Dialog 'Linienstil' has appeared"
            Linienstil.Cancel
         end if
      catch
      endcatch
      Kontext "TabLinienenden"
      vwert2 = Liste.GetSelIndex
      if vwert2 <> 8 then
      if vwert2 = 1 then
         Warnlog "Bug 70203 : The current Style from the line ends isn't shown"
         else
         Warnlog "Adjusted line ends aren't the 8. but " + Liste.GetSelIndex + "."
         end if
      end if
      TabLinienenden.OK
   printlog "Save, close and reload document and check adjustments a second time."
      Call hSpeichernUnterMitFilterKill sTestFile, gCalcFilter
      FileClose
      Call hDateiOeffnen sTestFile
      sleep(2)
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "DocumentCalc"
      call gMouseClick (20,20)      ' selektieren
      sleep(2)
      FormatLine

   printlog "Line values"
      kontext
      active.setpage TabLinie
      Kontext "TabLinie"
      if Breite.GetText <> modLine then Warnlog "Width isn't " + modLine + " but " + Breite.GetText
      if Farbe.GetSelIndex <> 3 then
         Warnlog "Color isn't the 3. but " + Farbe.GetSelIndex +"." & "Bug:99163"
      end if

   printlog "Line style"
      kontext
      active.setpage TabLinienstile
      Kontext "TabLinienstile"
      if Linienstil.GetSelIndex <> 7 then Warnlog "Adjusted line style isn't the 7. but " + Linienstil.GetSelIndex + "."

   printlog "Line ends"
      kontext
      active.setpage TabLinienenden
      try
         Kontext "Linienstil"
         if Linienstil.exists then
            warnlog "Dialog 'Linienstil' has appeared"
            Linienstil.Cancel
         end if
      catch
      endcatch
      Kontext "TabLinienenden"
      if vwert2 <> 1 then
      if Liste.GetSelIndex <> 8 then Warnlog "Adjusted line ends aren't the 8. but " + Liste.GetSelIndex + "."
      end if
      TabLinienenden.OK
      sleep 5
      call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatText
Dim sTestFile as string
Dim iEffektIndex as integer

sTestFile = convertpath(gOfficePath & "user/work/tFormatText.ods")

call hNewDocument
    Kontext "Drawbar"
    if NOT DrawBar.Exists(1) then
        Call hToolbarSelect("Drawing", true)
    end if
    sleep(2)
    Kontext "Drawbar"
    Textobjekt.click
    Kontext "DocumentCalc"    
    call gMouseMove (5,5,25,15)
    DocumentCalc.typeKeys ("Quod errat demonstrandum")
    Kontext "DocumentCalc"
    DocumentCalc.MouseDown(70,70)
    DocumentCalc.MouseUp(70,70)    
    sleep(7)
    DocumentCalc.MouseDown(70,70)
    DocumentCalc.MouseUp(70,70)
    Kontext "DocumentCalc"
    DocumentCalc.MouseDown(15,15)
    DocumentCalc.MouseUp(15,15)
    sleep(7)    
    FormatTextCalc
    sleep(7)
    printlog "Adjustments"
    printlog "Text"
    Kontext
    Active.SetPage TabText
    Kontext "TabText"
    BreiteAnTextAnpassen.Uncheck
    HoeheAnTextAnpassen.Uncheck
    AmRahmenAnpassen.Check
    
    printlog "Running Letters"
    Kontext
    Active.SetPage TabLauftext
    Kontext "TabLauftext"
    Effekt.Select(4)
    Endlos.Uncheck
    TabLauftext.OK
    
    printlog "Save, close and reload document and check adjustments a second time."
    Call hSpeichernUnterKill(sTestFile)
Call hCloseDocument
Call hDateiOeffnen(sTestFile)
    Kontext "DocumentCalc"    
    DocumentCalc.MouseDown(10, 10)
    DocumentCalc.MouseUp(10, 10)
    sleep(7)
    printlog "Text"
    FormatTextCalc
    Kontext
    Active.SetPage TabText
    Kontext "TabText"
    if AmRahmenAnpassen.IsEnabled = FALSE then
        warnlog "'Fit to size' isn't enabled anymore"
    else
        if AmRahmenAnpassen.IsChecked = FALSE then 
            warnlog "'Fit to size' isn't checked anymore"
        end if
    end if
    
    printlog "Text Animation"
    Kontext
    Active.SetPage TabLauftext
    Kontext "TabLauftext"
    iEffektIndex = Effekt.GetSelIndex
    if iEffektIndex <> 4 then 
        warnlog "The Text Animation style isn't anymore the expected 4. It is " & iEffektIndex & "."
    end if
    if Endlos.IsChecked then 
        warnlog "Continuous is checked."
    end if
    TabLauftext.OK
call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatArea
'/// See above descriptions ///


   Dim sTestFile
   sTestFile = convertpath(gOfficePath & "user/work/tFormatArea.ods")
      call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Rechteck.click

      call gMouseMove (10,10,60,60)
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (20,20)      ' selektieren
      Sleep 1

      FormatArea
   printlog "Einstellungen"
   printlog "Area"
      kontext
      active.setpage TabArea
      Kontext "TabArea"
      FillOptions.Select (3)
   printlog "Shadow"
      kontext
      active.setPage TabSchatten
      Kontext "TabSchatten"
      Anzeigen.Check
   printlog "Transparency"
      kontext
      active.setPage TabTransparenz
      Kontext "TabTransparenz"
      Transparenzverlauf.Check
      TransparenzverlaufTyp.Select 4
      TabTransparenz.OK
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (20,20)      ' selektieren
      Sleep 1
   printlog "Check settings"
   printlog "Area"
      FormatArea
      kontext
      active.setpage TabArea
      Kontext "TabArea"
      if FillOptions.GetSelIndex <> 3 then
          Warnlog "Gradient should be selected in ListBox"
      endif
   printlog "Shadow"
      kontext
      active.setPage TabSchatten
      Kontext "TabSchatten"
      if Anzeigen.IsChecked = FALSE then Warnlog "Shadow isn't switched on anymore"
   printlog "Transparency"
      kontext
      active.setPage TabTransparenz
      Kontext "TabTransparenz"
      if Transparenzverlauf.IsChecked = FALSE then
      Warnlog "Transparence Gradient isn't switched on anymore"
      else
      if TransparenzverlaufTyp.GetSelIndex <> 4 then Warnlog "The Gradient isn't the 4. entry but the " + TransparenzverlaufTyp.GetSelIndex + "."
      end if
      TabTransparenz.OK
   printlog "Save, close and reload document and check adjustments a second time."
      Call hSpeichernUnterMitFilterKill sTestFile, gCalcFilter
      sleep 5
      FileClose
      sleep 5
      Call hDateiOeffnen sTestFile
      call gMouseClick (20,20)      ' selektieren
      FormatArea
   printlog "Area"
      kontext
      active.setpage TabArea
      Kontext "TabArea"
     if FillOptions.GetSelIndex <> 3 then
          Warnlog "Gradient should be selected in ListBox"
      endif
   printlog "  Schatten"
      kontext
      active.setPage TabSchatten
      Kontext "TabSchatten"
      if Anzeigen.IsChecked = FALSE then Warnlog "Shadow isn't switched on anymore"
   printlog "Transparency"
   sleep 10
      kontext
      active.setPage TabTransparenz
      Kontext "TabTransparenz"
      if Transparenzverlauf.IsChecked = FALSE then
      Warnlog "Transparency Gradient isn't switched on anymore"
      else
      if TransparenzverlaufTyp.GetSelIndex <> 4 then Warnlog "The Gradient type isn't on the 4. entry but on the " + TransparenzverlaufTyp.GetSelIndex + "."
      end if
      TabTransparenz.OK
      call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatPositionAndSize_1
Dim sGetPosX as string 
Dim sGetPosY as string
Dim sGetWidth as string
Dim sGetHeight as string
Dim sGetPosX2 as string
Dim sGetPosY2 as string
Dim sCornerRadius as string
Dim sRotationAngle as string
Dim sTestFile as string
Dim sPositionXNow as string
Dim sPositionYNow as string
Dim sWidthNow as string
Dim sHeightNow as string
Dim sGetPosX2Now as string
Dim sGetPosY2Now as string
Dim sCornerRadiusNow as string
Dim sRotationAngleNow as string


'/// [testfile1] = OFFICEPATH/user/work/tFormat_1.ods
    sTestFile = convertpath(gOfficePath & "user/work/tFormat_1.ods")

'/// New spreadsheet
call hNewDocument
    Kontext "Drawbar"
    if Not DrawBar.Exists(1) then
        Call hToolbarSelect("Drawing", true)
    end if
    sleep(2)
    Kontext "Drawbar"
    '/// Click on rectangle on the Drawing toolbar
    Rechteck.click
    '/// Create a rectangle 10, 10, 60 60
    call gMouseMove (10,10,60,60)
    sleep(2)
    '/// Click on 1,1 (upper left corner) to deselect the rectangle
    call gMouseClick (1,1)
    sleep(1)
    '/// Select the rectangle (20,20) again
    call gMouseClick (20,20)
    sleep(5)
    '/// Open context menu (right mouse click) and select 'Position and Size'
    ContextPositionAndSize
    printlog "Adjustments - modify positions"
    printlog "TabPositionAndSize"
    Kontext
    '/// Select tab page 'position and size'
    Active.SetPage TabPositionAndSize
    Kontext "TabPositionAndSize"
    '/// Set for position X a value of '1'
    PositionX.SetText "1"
    '/// Set for position Y a value of '2'
    PositionY.SetText "2"
    '/// Get the values of all position fields on that tab page.
    sGetPosX = PositionX.GetText
    sGetPosY = PositionY.GetText
    sGetWidth = Width.GetText
    sGetHeight = Height.GetText
    TabPositionAndSize.OK
    '/// Leave dialog with OK
    '/// Format>Graphic>Position and Size
    FormatPositionAndSize
    printlog "Rotation"
    Kontext
    '/// Select tab page 'rotation'
    Active.SetPage TabDrehung
    Kontext "TabDrehung"
    '/// Remember the values of Position X and Y.
    sGetPosX2 = PositionX.GetText
    sGetPosY2 = PositionY.GetText
    printlog "Slant"
    Kontext
    '/// Select tab page 'Slant'
    Active.SetPage TabSchraegstellen
    Kontext "TabSchraegstellen"
    '/// Remember the values in Corner Radius and Slant Angle
    sCornerRadius = Radius.GetText
    sRotationAngle = Winkel.GetText
    '/// Leave dialog with OK
    TabSchraegstellen.OK
    '/// Deselect object with clicking into upper left corner (1,1)
    call gMouseClick (1,1)        
    sleep(1)
    '/// Select first OLE
    call fselectFirstOLE
    '/// Select the object again (20,50)
    call gMouseClick (20,50)
    sleep(1)
    printlog "Check settings"
    '/// Now Check the remembered values on the different tab pages. Are they the same?    
    FormatPositionAndSize
    printlog "Position"
    Kontext
    Active.SetPage TabPositionAndSize
    Kontext "TabPositionAndSize"
    sPositionXNow = PositionX.GetText 
    if sPositionXNow <> sGetPosX then 
        warnlog "X-value has been modified. Expected: " + sGetPosX + " Is: " & sPositionXNow
    end if
    sPositionYNow = PositionY.GetText
    if sPositionYNow <> sGetPosY then 
        warnlog "Y-value has been modified. Expected: " + sGetPosY + " Is: " + sPositionYNow
    end if
    sWidthNow = Width.GetText
    if sWidthNow <> sGetWidth then 
        warnlog "Width has been modified. Expected: " + sGetWidth + " Is: " + sWidthNow
    end if
    sHeightNow = Height.GetText
    if sHeightNow <> sGetHeight then 
        warnlog "Height has been modified. Expected: " + sGetHeight + "Is: " + sHeightNow
    end if    
    printlog "Rotation"
    Kontext
    Active.SetPage TabDrehung
    Kontext "TabDrehung"
    sGetPosX2Now = PositionX.GetText
    sGetPosY2Now = PositionY.GetText    
    if sGetPosX2Now <> sGetPosX2 then 
        warnlog "X-value has been modified. Expected: " + sGetPosX2 + "Is: " + sGetPosX2Now
    end if
    if sGetPosY2Now <> sGetPosY2 then 
        warnlog "Y-value has been modified. Expected: " + sGetPosY2 + " Is: " + sGetPosY2Now
    end if
    printlog "Incline"
    Kontext
    Active.SetPage TabSchraegstellen
    Kontext "TabSchraegstellen"
    sCornerRadiusNow = Radius.GetText
    sRotationAngleNow = Winkel.GetText
    if sCornerRadiusNow <> sCornerRadius then 
        warnlog "Radius has been modified. Expected: " + sCornerRadius + " Is: " + sCornerRadiusNow
    end if
    if sRotationAngleNow <> sRotationAngle then 
        warnlog "Degree has been modified. Expected: " + sRotationAngle + " Is: " + sRotationAngleNow
    end if
    TabSchraegstellen.OK
    printlog "Save document, close it, load it again and check the values."
    '/// Save the document as [testfile1]
    Call hSpeichernUnterMitFilterKill sTestFile, gCalcFilter
    '/// Close the document
    Call hCloseDocument
    '/// Open the [testfile1] again
    Call hDateiOeffnen sTestFile
    '/// Select the object with mouse
    call gMouseClick (20,50)      ' selektieren
    '/// Now Check the remembered values on the different tab pages. Are they the same?    
    FormatPositionAndSize
    printlog "Position"
    Kontext
    Active.SetPage TabPositionAndSize
    Kontext "TabPositionAndSize"
    sPositionXNow = PositionX.GetText 
    if sPositionXNow <> sGetPosX then 
        warnlog "X-value has been modified. Expected: " + sGetPosX + " Is: " & sPositionXNow
    end if
    sPositionYNow = PositionY.GetText
    if sPositionYNow <> sGetPosY then 
        warnlog "Y-value has been modified. Expected: " + sGetPosY + " Is: " + sPositionYNow
    end if
    sWidthNow = Width.GetText
    if sWidthNow <> sGetWidth then 
        warnlog "Width has been modified. Expected: " + sGetWidth + " Is: " + sWidthNow
    end if
    sHeightNow = Height.GetText
    if sHeightNow <> sGetHeight then 
        warnlog "Height has been modified. Expected: " + sGetHeight + "Is: " + sHeightNow
    end if    
    printlog "Rotation"
    Kontext
    Active.SetPage TabDrehung
    Kontext "TabDrehung"
    sGetPosX2Now = PositionX.GetText
    sGetPosY2Now = PositionY.GetText    
    if sGetPosX2Now <> sGetPosX2 then 
        warnlog "X-value has been modified. Expected: " + sGetPosX2 + "Is: " + sGetPosX2Now
    end if
    if sGetPosY2Now <> sGetPosY2 then 
        warnlog "Y-value has been modified. Expected: " + sGetPosY2 + " Is: " + sGetPosY2Now
    end if
    printlog "Incline"
    Kontext
    Active.SetPage TabSchraegstellen
    Kontext "TabSchraegstellen"
    sCornerRadiusNow = Radius.GetText
    sRotationAngleNow = Winkel.GetText
    if sCornerRadiusNow <> sCornerRadius then 
        warnlog "Radius has been modified. Expected: " + sCornerRadius + " Is: " + sCornerRadiusNow
    end if
    if sRotationAngleNow <> sRotationAngle then 
        warnlog "Degree has been modified. Expected: " + sRotationAngle + " Is: " + sRotationAngleNow
    end if
    TabSchraegstellen.OK
    sleep(2)
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatPositionAndSize_2
'/// See above descriptions ///

   Dim vw1, vw2, vw3, vw4, vw5
   Dim sTestFile
   sTestFile = convertpath(gOfficePath & "user/work/tFormat_2.ods")

      call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Legende.click

      call gMouseMove (5,5,15,15)
      sleep(2)
      DocumentCalc.typekeys "<ESCAPE>"
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (17,17)      ' selektieren
      Sleep 5
   Printlog "Modify size"
      ContextPositionAndSize
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      Width.Less 4
      Height.More 4
      vw1 = Width.GetText
      vw2 = Height.GetText
      vw3 = PositionX.GetText
      vw4 = PositionY.GetText
      'TabPositionAndSize.OK

   Printlog "Modify Legend"
      Kontext
      Active.SetPage TabLegende
      Kontext "TabLegende"
      Ansatz.Select 3
      vw5 = Abstand.GetText
      TabLegende.OK
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (17,17)      ' selektieren
      Sleep 5
   Printlog "Check"
      ContextPositionAndSize
   Printlog "Size"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if Width.GetText <> vw1 then Warnlog "Width has been modified. Current : " + vw1 + "    Actual  : " + Width.GetText
      if Height.GetText <> vw2 then Warnlog "Heigth has been modified. Current : " + vw2 + "    Actual  : " + Height.GetText
      if PositionX.GetText <> vw3 then Warnlog "X-value has been modified. Current : " + vw3 + "    Actual  : " + PositionX.GetText
      if PositionY.GetText <> vw4 then Warnlog "Y-value has been modified. Current : " + vw4 + "    Actual  : " + PositionX.GetText
   Printlog "Legend"
      Kontext
      Active.SetPage TabLegende
      Kontext "TabLegende"
      if Abstand.GetText <> vw5 then Warnlog "Distance has been modified. Current : " + vw5 + "    Actual  : " + Abstand.GetText
      if Ansatz.GetSelIndex <> 3 then Warnlog "Beginning isn't anymore the 3. entry but" + Ansatz.GetSelIndex
      TabLegende.OK

   printlog "Save document, close, load it anf check the settings again."
      Call hSpeichernUnterMitFilterKill sTestFile, gCalcFilter
      FileClose
      Call hDateiOeffnen sTestFile
      Kontext "DocumentCalc"
      sleep(3)
    call gMouseClick (17,17)      ' selektieren
    Kontext "DocumentCalc"
    Sleep 1
    Printlog "Check"
    try
      ContextPositionAndSize
      Printlog "TabPositionAndSize"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if Width.GetText <> vw1 then Warnlog "Width has been modified. Current : " + vw1 + "    Actual  : " + Width.GetText
      if Height.GetText <> vw2 then Warnlog "Height has been modified. Current : " + vw2 + "    Actual  : " + Height.GetText
      if PositionX.GetText <> vw3 then Warnlog "X-value has been modified. Current : " + vw3 + "    Actual  : " + PositionX.GetText
      if PositionY.GetText <> vw4 then Warnlog "Y-value has been modified. Current : " + vw4 + "    Actual  : " + PositionX.GetText
      printlog "Legend"
      sleep(2)
      Kontext
      Active.SetPage TabLegende
      Kontext "TabLegende"
      if Abstand.GetText <> vw5 then Warnlog "Distance has been modified. Current : " + vw5 + "    Actual  : " + Abstand.GetText
      if Ansatz.GetSelIndex <> 5 then Warnlog "Beginning isn't anymore 3 but" + Ansatz.GetSelIndex
      TabLegende.OK
    catch
      warnlog "Bug?!"
    endcatch

   Kontext "DocumentCalc"

   Call hCloseDocument

endcase

'-----------------------------------------------------------

testcase tFormatGroup
'/// See above descriptions ///

   call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Rechteck.click

   call gMouseMove (10,10,60,60)
   call gMouseMove (10,65,50,80)
   sleep(2)
   DocumentCalc.typekeys "<ESCAPE>"

   gMouseClick ( 1, 1 )
   Kontext "Drawbar"
   Auswahl.click
   call gMouseMove (5,5,65,90)
   PrintLog "- Format/Gruppe/Gruppieren"
   sleep 5
   FormatGroupGroup
   Sleep 1
   printLog "- Format/Gruppe/Betreten"
   FormatGroupEditGroupCalc
   Sleep 1

   try
      FormatGroupEditGroupCalc
   catch
   endcatch

   PrintLog "Format|LeaveGroup"
   FormatExitGroupDraw
   Sleep 1

   PrintLog "Format|Ungroup"
   FormatUngroupDraw
   Sleep 1
   Call hCloseDocument

endcase

'---------------------------------------------------------------------------

testcase tFormatStandard
    dim iId as integer
    dim iCountOfMenuEntries as integer
    dim iValidate as integer
    '/// File / New / Spreadsheet
    call hNewDocument
        ToolsOptions
        '/// Tools / Options / Language Settings / Languages
        call hToolsOptions ("Languagesettings", "Languages")
        '///  Is in 'Enhanced language support'
        '///+ Is check-box 'Enabled for Asian languages' checked (TRUE) or not (FALSE)?
        '///+ (you need it later in the test case)     
        Kontext "TabSprachen"
        if Aktivieren.IsChecked then 
            gAsianSup = TRUE
        else
            gAsianSup = FALSE
        end if   
        Kontext "ExtrasOptionenDLG"
        '/// Leave Tools Options dialog with OK
        ExtrasOptionenDLG.Ok
        sleep(1)    
        Kontext "DocumentCalc"
        '/// Type in [CTRL + HOME]
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        '/// Type '1000000000' and [ENTER]
        DocumentCalc.TypeKeys "1000000000 <RETURN>"
        '/// Go one cell [UP]
        DocumentCalc.TypeKeys "<UP>"
        '/// Type [F2]
        DocumentCalc.TypeKeys "<F2>"
        '/// Type [CTRL + SHIFT + LEFT]
        DocumentCalc.TypeKeys "<MOD1 SHIFT LEFT>"
        sleep(3)
        printlog "First, check, if the default font(-size) is set."        
        DocumentCalc.MouseMove(1, 1)
        for iValidate = 1 to 2
            Kontext "DocumentCalc"
            DocumentCalc.OpenContextMenu
            iCountOfMenuEntries = hMenuItemGetCount
            '///<ul><li>Select the 5th entry (without seperators) if there are 8 entries in the
            '///+ context menu</li>
            if iCountOfMenuEntries = 8 then
                'the 7th entry INCL. seperators!
                iId = MenuGetItemID (7)
            '///+<li>Select the 6th entry (without seperators) if there are 9 entries in the
            '///+ context menu</li></ul>
            elseif iCountOfMenuEntries = 9 then
                'the 9th entry INCL. seperators!
                iId = MenuGetItemID (9)
            else
                warnlog "The context menu has not been opened or has a wrong count of entries."
                if iCountOfMenuEntries > 0 then
                    MenuSelect(0)
                end if
                call hCloseDocument
                goto endsub
            end if
            sleep(3)      
            MenuSelect(iId)
            sleep(2)
            Kontext
            '/// The 'Character' dialog occours
            '/// Select the tab page 'Font' (1st) if it's not already there
            Active.SetPage TabFont
            sleep(2)
            Kontext "TabFont"
            if TabFont.IsVisible(2) then
                if gAsianSup = TRUE then
                    '///<ul><li>If in 'Enhance language support' the 'Enabled for Asian languages' has been
                    '///+ enabled validate that the font for western languages has been set to
                    '///+ 'Albany' and the size has been set to '10' (default values).</li>
                    if FontWest.getselText = "Albany" and SizeEast.getselText = "10" then
                        printlog "OK the font is Albany and it's size is 10"
                    else
                        warnlog "Font is: " & FontEast.getselText & " and Size is: " & SizeEast.getselText             
                    end if
                else
                    if Font.getselText = "Albany" and Size.getselText = "10" then
                        '///+<li>In non-Asian language supported installations the onliest Font
                        '///+ field should have as default 'Albany' and as size '10'</li></ul>
                        printlog "The Font and it's size are OK"
                   else
                      warnlog "Font is: " & Font.getselText & " and Size is: " & Size.getselText
                   end if
                end if
                Kontext
                '/// Leave the Font tab page with cancel
                TabFont.Cancel
            else
                warnlog "Tab page 'font' is not visible. This could be also a script problem."
            end if
            'Only in the first round select 'Standard' entry
            'In the second round only validating that 'Standard' results into the correct
            'default values
            if iValidate = 1 then
                sleep(2)
                printlog "Now open the contextmenu again, call the menuitem 'Standard'..."
                '/// Now open the contextmenu again
                Kontext "DocumentCalc"
                DocumentCalc.OpenContextMenu
                iCountOfMenuEntries = hMenuItemGetCount
                '///<ul><li>Select the 1st entry (without seperators) if there are 8 entries in the
                '///+ context menu ('Standard')</li>
                if iCountOfMenuEntries = 8 then
                    'the 1st entry INCL. seperators!
                    iId = MenuGetItemID (1)
                '///+<li>Select the 2nd entry (without seperators) if there are 9 entries in the
                '///+ context menu ('Standard')</li></ul>
                elseif iCountOfMenuEntries = 9 then
                    'the 3rd entry INCL. seperators!
                    iId = MenuGetItemID (3)
                else
                    warnlog "The context menu has not been opened or has a wrong count of entries."
                    if iCountOfMenuEntries > 0 then
                        MenuSelect(0)
                    end if
                    call hCloseDocument
                    goto endsub
                end if
                sleep(2)
                MenuSelect(iId)
                sleep(2)
            end if
            '/// Now check again through the 'Characters' dialog if the default values
            '///+ are the same as in the first check. Then the test case has been passed.
        next iValidate    
        sleep(2)
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<ESCAPE>"
        sleep(2)
    call hCloseDocument
endcase

