'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_104_.inc,v $
'*
'*  $Revision: 1.33 $
'*
'*  last change: $Author: jsi $ $Date: 2008/02/18 14:32:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Detailed test of the functions in the Insert menu - Part 1
'*
'*************************************************************************
'*
' #1 C_104_ ' Initial routine
' #1 tInsertCells
' #1 tInsertRowsColumns
' #1 tInsertSheet
' #1 tInsertSheetFromFile
' #1 tInsertSpecialCharacter
' #1 tInsertDefineName
' #1 tInsertChart
' #1 tInsertGraphicFromFile
' #1 tInsertObjectFormula
' #1 tInsertObjectOLE
' #1 tInsertObjectPlugin
' #1 deleteObject
'*
'\************************************************************************


sub C_104_

Printlog Chr(13) + "--------- C_104_ ---------"

   call tInsertObjectOLE 
   call tInsertCells
   call tInsertRowsColumns
   call tInsertSheet
   call tInsertSheetFromFile
   call tInsertSpecialCharacter
'   call tInsertDefineName
   call tInsertChart
   call tInsertGraphicFromFile
   call tInsertObjectFormula
   call tInsertObjectPlugin
End sub
'
'---------------------------------------------------------------------------
'
testcase tInsertCells
'/// This test check the insert of contents in cells with several options like moving cells down, ///
'/// right, left, whole columns, lines and so on. Further there was tested the inserting of whole ///
'/// cellareas. ///

   dim iwh as integer 
   dim sWorkfile as string
   dim sfile as string
   sfile = convertpath(gtesttoolpath & "calc\level1\input\c_104\teinfuegenzellen.sxc")
   printlog "Insert cells"
   Call hDateioeffnen sfile
'/// Open the file 'gtesttoolpath & "calc\level1\input\c_104\teinfuegenzellen"' and go to table name
'/// "EinfuegenZellen"
   call fCalcSelectSheet("EinfuegenZellen")
   sWorkfile = convertpath(gOfficePath & "user/work/teinfuegenzellen" & isprache & "" & ".ods")   
'/// Save the file in your working directory, call the option dialog and uncheck 'expand formatting'
   call hSpeichernUnterMitFilterKill sWorkfile, gCalcFilter

   ToolsOptions
   hToolsOptions( "SPREADSHEET", "GENERAL" )
   Referenzenausdehnen.UnCheck
   Printlog "References at the edges is switched off"
   Kontext "ExtrasOptionenDLG"
   ExtrasOptionenDLG.Ok
   InsertCells
   Kontext "ZellenEinfuegen"
   If ZellenEinfuegen.exists (2) then
      ZellenEinfuegen.Cancel
   else
      warnlog "dialog isn't available"
   end if
'/// Go to cell 'C3' and insert a cell with option 'shift cells down'
    if cgotocell("C3") <> 0 then
        warnlog "Traveling to C3 failed! Exiting test!"
        goto endsub
    end if
    Kontext "DocumentCalc"
    InsertCells
    Kontext "ZellenEinfuegen"
    ZellenNachUnten.check
    ZellenEinfuegen.Ok
'/// Check if the cell was correctly inserted
    if cZellwert("H8") = "357" then
        printlog "  cells downward OK"
    elseif cZellwert("H8") = "389" Then
        DocumentCalc.typekeys("<MOD1 SHIFT F9>")
        if cZellwert("H8") = "357" then
            warnlog "Results in cells are only available after hard recalc"
        else
            warnlog "Area adjusted by moving cells down"
        end if
   else
        warnlog "Wrong result by moving cells down"
   end if
'/// insert a cell with the option 'shift cells right' and check if this operation works
    Kontext "DocumentCalc"
    if cgotocell("C3") <> 0 then
        warnlog "Traveling to C3 failed! Exiting test!"
        goto endsub
    end if
    Kontext "DocumentCalc"
    InsertCells
    Kontext "ZellenEinfuegen"
    ZellenNachRechts.check
    ZellenEinfuegen.Ok
    if cZellwert("H8") = "339" then
        printlog " cells to the right OK"
        elseif cZellwert("H8") = "357" Then
            Kontext "DocumentCalc"
            DocumentCalc.typekeys("<MOD1 SHIFT F9>")
            if cZellwert("H8") = "339" then
                warnlog "cells are OK by moving right after hard recalc "
            else
                warnlog "area adjusted by moving cells right"
            end if
    else
        warnlog "wrong result by moving cells right"
    end if
'/// Do the same with the option 'entire row' and 'entire column'
    Kontext "DocumentCalc"
    if cgotocell("C3") <> 0 then
        warnlog "Traveling to C3 failed! Exiting test!"
        goto endsub
    end if
    InsertCells
    Kontext "ZellenEinfuegen"
    GanzeZeile.check
    ZellenEinfuegen.Ok
    if cZellwert("H9") = "339" then
        printlog " entire row OK"
        elseif cZellwert("H9") = "357" Then
        Kontext "DocumentCalc"
        DocumentCalc.typekeys("<MOD1 SHIFT F9>")
        if cZellwert("H9") = "339" then
            warnlog "Entire row OK after hard recalc"
        else
            warnlog "Area adjusted at whole row"
        end if
    else
        warnlog "Wrong result at entire row"
    end if
    Kontext "DocumentCalc"
    if cgotocell("C3") <> 0 then
        warnlog "Traveling to C3 failed! Exiting test!"
        goto endsub
    end if
    Kontext "DocumentCalc"
    InsertCells
    Kontext "ZellenEinfuegen"
    GanzeSpalte.check
    ZellenEinfuegen.Ok
    if cZellwert("I9") = "339" then
        printlog "entire column OK"
        elseif cZellwert("I9") = "357" Then
            Kontext "DocumentCalc"
            DocumentCalc.typekeys("<MOD1 SHIFT F9>")
            if cZellwert("I9") = "339" then
                warnlog "column OK after hard recalc"
            else
                warnlog "area adjusted at entire column"
            end if
    else
        warnlog "wrong result at entire column"
    end if
'/// Call the options dialog and check 'expand formatting', then go to cell 'B2' and insert one
'/// cell with the option 'entire row' and one cell with the option 'entire column'
    ToolsOptions
    hToolsOptions( "SPREADSHEET", "GENERAL" )
    Referenzenausdehnen.Check
    Printlog "References at the edges is switched on"
    Kontext "OptionenDlg"
    OptionenDlg.Ok
    Kontext "DocumentCalc"
    call cgotoCell ("B2")
    Kontext "DocumentCalc"
    InsertCells
    Kontext "ZellenEinfuegen"
    GanzeSpalte.check
    ZellenEinfuegen.Ok
    Kontext "DocumentCalc"
    InsertCells
    Kontext "ZellenEinfuegen"
    GanzeZeile.check
    ZellenEinfuegen.Ok
'/// Check now, if the cell 'B2' is a part of the cellrange 'Holodeck' (it must be. because
'/// the expand formatting is switched on)
    Kontext "DocumentCalc"
    InsertNamesDefine
    Kontext "NamenFestlegen"
    Bereichsname.select "Holodeck"
    if (ZugeordnetZu.gettext) = "$EinfuegenZellen.$B$2:$H$8" then
        printlog "The area is correct expanded"
    else
        warnlog "The area isn't correct adjusted" & right(ZugeordnetZu.gettext,instr(ZugeordnetZu.gettext,".")) & "instead of .$B$2:$H$8"
    end if
    NamenFestlegen.Ok    
    ToolsOptions
    hToolsOptions("SPREADSHEET", "GENERAL" )
'/// Switch of the expand formatting
    Referenzenausdehnen.UnCheck
    Kontext "OptionenDlg"
    OptionenDlg.Ok
    Kontext
'/// Go to cell 'IV32000' and attempt to insert a cell with the option 'entire column' and
'/// 'entire row'. There must be appear a warning that this is impossible.
    for iwh = 1 to 10
      DocumentCalc.typekeys "<MOD1 DOWN RIGHT>"
    next iwh
    DocumentCalc.typekeys "Ende<RETURN LEFT>"
    InsertCells
    Kontext "ZellenEinfuegen"
    GanzeSpalte.check
    ZellenEinfuegen.Ok
    Kontext
    if Active.exists then
        Printlog "OK warning: " & Active.GetText
        Active.Ok
    else
        warnlog "No error message bei moving of filled cells over the edge at columns"
    end if
    for iwh = 1 to 5
        Kontext "DocumentCalc"
        DocumentCalc.typekeys "<MOD1 Down Right>"
    next iwh
    DocumentCalc.typekeys "Ende<Return Up>"
    InsertCells
    Kontext "ZellenEinfuegen"
    GanzeZeile.check
    ZellenEinfuegen.Ok
    Kontext
    if Active.exists(1) then
        printlog "OK warning: " & Active.GetText
        Active.Ok
    else
        warnlog "No error message by moving of filled cells over the edge at rows"
    end if
    Call hCloseDocument
    if dir(sWorkfile) <> "" and gsamepc = true then 
        kill(sWorkfile)
    end if
endcase
'
'-----------------------------------------------------------
'
testcase tInsertRowsColumns
'/// This test the insert of rows and columns and check if links and formulas ///
'/// are updated when rows and columns are moved the appropriate cellareas. ///
'/// The same procedure is executed with cellareas. Here is checked if the ///
'/// cellareas are updated when rows and columns are inserted in the appropriate ///
'/// cellarea. ///

    Dim sFile as string
    dim sWorkfile as string
    dim iWh as integer
    
    sfile = convertpath(gtesttoolpath & "calc\level1\input\c_104\teinfuegenzellen.sxc")
    
    printlog "Check insert rows and columns"
    
'/// Open the file <i>gTesttoolPath</i>\calc\level1\input\c_104\teinfuegenzellen.sxc and go to sheet
'/// <i>EinfuegenZellen</i>, then save this file in your working directory

    Call hDateioeffnen sFile
    call fCalcSelectSheet("EinfuegenZellen")
    sWorkfile = convertpath(gOfficePath & "user/work/einfz" & isprache & ".ods")
    call hSpeichernUnterMitFilterKill sWorkfile, gCalcFilter
'/// Call the option dialog and uncheck 'Expand references'
    ToolsOptions
    Kontext "ExtrasOptionenDLG"
    hToolsOptions( "SPREADSHEET", "GENERAL" )
    Kontext "TabLayoutCalc"
    Referenzenausdehnen.UnCheck
    Kontext "OptionenDlg"
    OptionenDlg.OK
    Kontext "DocumentCalc"    
    if cgotocell("C3") <> 0 then
        warnlog "Traveling to C3 failed! Exiting test!"
        goto endsub
    end if
    Kontext "DocumentCalc"
'/// Insert one row and one column in cell 'C3' and check if this operation was successfull
    InsertRowsCalc
    if cZellwert("H9") = "389" then
        Printlog "The result is OK after insert a row"
    else
        warnlog "The result is wrong after insert a row"
    end if
    Kontext "DocumentCalc"
    if cgotocell("C3") <> 0 then
        warnlog "Traveling to C3 failed! Exiting test!"
        goto endsub
    end if
    Kontext "DocumentCalc"
    InsertColumnsCalc
    if cZellwert("I9") = "389" then
        printlog "The result is OK after insert a column"
    else
        warnlog "The result is wrong after insert a column"
    end if
    Kontext "DocumentCalc"
'/// Insert two rows and columns in cellarea 'B2:C3: with adapt reference to top left, and check if
'/// this operation was successfull
   call cBereichmarkieren ("B2:C3")
   Kontext "DocumentCalc"
   InsertRowsCalc
   if cZellwert("I11") = "389" then
      printlog "The result is OK after insert two rows"
   else
      Warnlog "The result is wrong after insert two rows"
   end if
'/// Check if the cellrange 'Holodeck' was updated (range should be "$EinfuegenZellen.$B$4:$G$9")
    InsertNamesDefine
    Kontext "NamenFestlegen"
    Bereichsname.select "Holodeck"
    if ZugeordnetZu.gettext = "$EinfuegenZellen.$B$4:$G$9" then
      Printlog "The area is Ok after insert two rows"
    else
      Warnlog "The area is wrong after insert two rows" & right(ZugeordnetZu.gettext,instr(ZugeordnetZu.gettext,".")) & "instead of .$B$4:$G$9"
    end if
    NamenFestlegen.Ok
'/// Select the cellrange 'B2:C3' and insert a column, then check, if this operation was successfull
    call cBereichmarkieren ("B2:C3")
    InsertColumnsCalc
    if cZellwert("K11") = "389" then
      Printlog "The result is OK after insert two columns"
    else
      Warnlog "The result is wrong after insert two columns"
    end if
'/// Check if the cellrange 'Holodeck' was updated (range should be "$EinfuegenZellen.$D$4:$I$9")
    InsertNamesDefine
    sleep 3
    Kontext "NamenFestlegen"
    Bereichsname.select "Holodeck"
    if ZugeordnetZu.gettext = "$EinfuegenZellen.$D$4:$I$9" then
      Printlog " the area is Ok after insert two columns"
    else
      Warnlog " the area is wrong after insert two columns" & right(ZugeordnetZu.gettext,instr(ZugeordnetZu.gettext,".")) & "instead of .$D$4:$I$9"
    end if
    NamenFestlegen.Ok
'/// Select the cellrange 'J10:K11', insert a row and check if this operation was successfull
    'two rows/columns adapt references to bottom right
    call cBereichmarkieren ("J10:K11")
    InsertRowsCalc
    if cZellwert("K13") = "389" then
      Printlog "The result is OK after insert two rows"
    else
      Warnlog "The result is wrong after insert two rows"
    end if
'/// Check if the cellrange 'Holodeck' was constant (range should be "$EinfuegenZellen.$D$4:$I$9")
    InsertNamesDefine
    Kontext "NamenFestlegen"
    Bereichsname.select "Holodeck"
    if ZugeordnetZu.gettext = "$EinfuegenZellen.$D$4:$I$9" then
      Printlog " the area is OK after insert two rows"
    else
      Warnlog " the area is wrong after insert two rows" & right(ZugeordnetZu.gettext,instr(ZugeordnetZu.gettext,".")) & "instead of .$D$4:$I$9"
    end if
    NamenFestlegen.Ok
'/// Select cellrange 'J10:K11', insert a column and check if this operation was successfull
    call cBereichmarkieren ("J10:K11")
    InsertColumnsCalc
    if cZellwert("M13") = "389" then
      Printlog " the result is OK after inserting two columns"
    else
      Warnlog " the result is wrong after insert two columns"
    end if
'/// Check if the cellrange 'Holodeck' is constant (range should be "$EinfuegenZellen.$D$4:$I$9")
    InsertNamesDefine
    Kontext "NamenFestlegen"
    Bereichsname.select "Holodeck"
    if ZugeordnetZu.gettext = "$EinfuegenZellen.$D$4:$I$9" then
      Printlog " the area is Ok after inert two columns"
    else
      Warnlog " the area is wrong after insert two columns" & right(ZugeordnetZu.gettext,instr(ZugeordnetZu.gettext,".")) & "instead of .$D$4:$I$9"
    end if
    NamenFestlegen.Ok
'/// Make undo all settings and check if the cellrange 'Holodeck' is "$EinfuegenZellen.$B$2:$F$6"
    try
        Kontext "DocumentCalc"
        for iwh = 1 to 10
            EditUndo
            wait(666)
        next iwh
    catch
        warnlog "making undo only " & iwh - 1 & ". times available.(1)"
    endcatch
    if cZellwert("H8") = "389" then
      Printlog "The result is OK after insert a row"
    else
      Warnlog "Undoing the insertions of rows/columns did not reestablish the initial state!"
      call hCloseDocument
      goto endsub
    end if
    InsertNamesDefine
    Kontext "NamenFestlegen"
    Bereichsname.select "Holodeck"
    if ZugeordnetZu.gettext = "$EinfuegenZellen.$B$2:$F$6" then
      Printlog " the area is Ok after undo 10 times"
      NamenFestlegen.Ok
    else
        Warnlog " the area is wrong after undo 10 times "& ZugeordnetZu.gettext & " instead of .$B$2:$F$6"
        Warnlog "The document is loaded again"
        NamenFestlegen.Ok
        call hCloseDocument
        Call hDateioeffnen file$
        sWorkfile = convertpath(gOfficePath & "user/work/einfz" & isprache & ".ods")
        call hSpeichernUnterMitFilterKill sWorkfile, gCalcFilter
    end if
'/// Now call the optiondialog and check 'expand formatting'
   ToolsOptions
   hToolsOptions( "SPREADSHEET", "GENERAL" )
   Referenzenausdehnen.Check
   Kontext "OptionenDlg"
   OptionenDlg.OK
   Printlog " expand reference is switched on"
'/// Select the cells 'B2:C3', insert two rows and check the result
   '*zwei Zeilen / Spalten oben links Referenz anpassen an
   call cBereichmarkieren ("B2:C3")
   InsertRowsCalc
   if cZellwert("H10") = "389" then
      Printlog " the result is OK after insert two rows"
   else
      Warnlog " the result is wrong after insert two rows"
   end if
'/// Check, if the range 'Holodeck' was updated (should be: "$EinfuegenZellen.$B$2:$F$8")
   InsertNamesDefine
   Kontext "NamenFestlegen"
   Bereichsname.select "Holodeck"
   if ZugeordnetZu.gettext = "$EinfuegenZellen.$B$2:$F$8" then
      Printlog " the area is Ok after insert two rows"
   else
      Warnlog " the area is wrong after insert two rows" & ZugeordnetZu.gettext & " instead of .$B$2:$F$8"
   end if
   NamenFestlegen.Ok
'/// Select the cells 'B2:C3', insert two columns and check the result
   call cBereichmarkieren ("B2:C3")
   InsertColumnsCalc
   if cZellwert("J10") = "389" then
      Printlog " the result is OK after insert two columns"
   else
      Warnlog " the result is wrong after insert two columns"
   end if
'/// Check if the range 'Holodeck' was updated (should be: "$EinfuegenZellen.$B$2:$H$8")
   InsertNamesDefine
   Kontext "NamenFestlegen"
   Bereichsname.select "Holodeck"
   if ZugeordnetZu.gettext = "$EinfuegenZellen.$B$2:$H$8" then
      Printlog " the area is Ok after insert two columns"
   else
      Warnlog " the area is wrong afer insert two columns"& ZugeordnetZu.gettext & " instead of .$B$2:$H$8"
   end if
   NamenFestlegen.Ok
'/// Select the cellrange 'I9:J10', insert two rows and check the result
   '*zwei Zeilen / Spalten unten rechts Referenz anpassen an
   call cBereichmarkieren ("I9:J10")
   InsertRowsCalc
   if cZellwert("J12") = "389" then
      Printlog " the result is OK after insert two columns"
   else
      Warnlog " the result is wrong after insert two columns"
   end if
'/// Check if the range 'Holodeck' was updated (should be: "$EinfuegenZellen.$B$2:$H$10")
   InsertNamesDefine
   Kontext "NamenFestlegen"
   Bereichsname.select "Holodeck"
   if ZugeordnetZu.gettext = "$EinfuegenZellen.$B$2:$H$10" then
      Printlog " the area is Ok after insert two rows"
   else
      Warnlog " the area is wrong after insert two columns"& ZugeordnetZu.gettext & " instead of .$B$2:$H$10"
   end if
   NamenFestlegen.Ok
'/// Select the cellrange 'I9:J10', insert two columns and check the result
   call cBereichmarkieren ("I9:J10")
   InsertColumnsCalc
   if cZellwert("L12") = "389" then
      Printlog " the result is OK after insert two columns"
   else
      Warnlog " the result is wrong after insert two columns"
   end if

'/// Check if the range 'Holodeck' was updated (should be: "$EinfuegenZellen.$B$2:$J$10")
   InsertNamesDefine
   Kontext "NamenFestlegen"
   Bereichsname.select "Holodeck"
   if ZugeordnetZu.gettext = "$EinfuegenZellen.$B$2:$J$10" then
      Printlog " the area is Ok after insert two columns"
   else
      Warnlog " the area is wrong after insert two columns"& ZugeordnetZu.gettext & " instead of .$B$2:$J$10"
   end if
   NamenFestlegen.Ok
   try
      for iwh = 1 to 9
         EditUndo
         wait 300
      next iwh
   catch
      Warnlog "making undo only " & iwh - 1 & ". times available.(2)"
   endcatch
'/// Make undo all settings and check if the cellrange 'Holodeck' has the current
'/// range "$EinfuegenZellen.$B$2:$F$6"
   InsertNamesDefine
   Kontext "NamenFestlegen"
   Bereichsname.select "Holodeck"
   if ZugeordnetZu.gettext = "$EinfuegenZellen.$B$2:$F$6" then
      Printlog "  Ok Der Bereich stimmt nach 9 * Rueckgaengig"
   else
      Warnlog " the area is wrong after undo 9 times "& ZugeordnetZu.gettext & " instead of .$B$2:$F$6"
   end if
   NamenFestlegen.Ok
'/// Call the optionsdialog and uncheck 'expand formatting'
   ToolsOptions
   hToolsOptions( "SPREADSHEET", "GENERAL" )
   Referenzenausdehnen.UnCheck
   Kontext "OptionenDlg"
   OptionenDlg.OK
   Printlog " expand reference on ..."
   Kontext
'/// Go to cell 'IV32000' and attempt to insert a column and a row
'/// There must be appear warnings that it isn't possible to do this
'/// at this position    
    for iwh = 1 to 10
        Kontext "DocumentCalc"
        DocumentCalc.typekeys "<MOD1 Down Right>"
    next iwh
    Kontext "DocumentCalc"
    DocumentCalc.typekeys "Ende<Return LEFT>"
    InsertColumnsCalc
    Kontext
    if Active.Exists(1) then
        printlog " Ok warning: " & Active.GetText
        Active.Ok
    else
        warnlog " no warning by moving filled cells over the edge by columns"
    end if
    for iwh = 1 to 5
        Kontext "DocumentCalc"
        DocumentCalc.typekeys "<MOD1 Down Right>"
    next iwh
    Kontext "DocumentCalc"
    DocumentCalc.typekeys "Ende<Return Up>"
    InsertRowsCalc
    Kontext
    if Active.Exists(1) then
        printlog " Ok warning: " & Active.GetText
        Active.Ok
    else
        warnlog " no warning by moving filled cells over the edge by rows"
    end if
    Call hCloseDocument
    if Dir(sWorkfile) <> "" and gSamePc = true then 
        kill(sWorkfile)
    end if
endcase
    '
'-----------------------------------------------------------
'
testcase tInsertSheet
'/// This test checks if sheets are inserted and if the insert is on the correct position ///
'/// in the document. After that, this modified document is saved and closed. From a new ///
'/// document it is tried to insert a sheet from this saved document in the linked modus ///

    dim tabzahl : dim tabzahl1 : Dim wh : dim gefunden: dim lager as string
    dim Workfile as string, Workfile1 as string
    Workfile = convertpath(gOfficePath & "user/work/teinfuegentabelle.ods")
    Workfile1 = convertpath(gOfficePath & "user/work/teinfuegentabelle1.ods")
    printlog "Insert table"
'/// open a new calc document
    Call hNewDocument
    call fCalcSelectSheet ( 2 )

    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    tabzahl = EinfuegenVor.getitemcount - 1
    TabelleVerschiebenKopieren.Cancel
'/// Insert a new sheet named 'Rigel' and check, if this operation was successfull
   InsertSheetCalc
    Kontext "TabelleEinfuegenCalc"
    Neuerstellen.check
    Tabellenname.settext "Rigel"
    TabelleEinfuegenCalc.Ok
    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    tabzahl1 = EinfuegenVor.getitemcount - 1
    TabelleVerschiebenKopieren.Cancel
    if tabzahl1 - tabzahl = 1 then
      for wh = 1 to tabzahl
            call fCalcSelectSheet ( wh )
            FormatSheetRename
            Kontext "TabelleUmbenennen"
            if TabellenName.gettext = "Rigel" then
               wh = TabZahl + 1
               gefunden = true
            else
               gefunden = false
            end if
            TabelleUmbenennen.Cancel
      next wh
      if gefunden = true then
         Printlog "A table with the correct name new was inserted."
      else
         Warnlog "The table was inserted with the wrong name."
      end if
    else
      Warnlog "It wasn't added a new table."
    end if
'/// Save and close this document
    call hSpeichernUnterMitFilterKill Workfile, gCalcFilter
    call hCloseDocument

    call hNewDocument
    call fCalcSelectSheet ( 2 )
    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    'tabzahl = EinfuegenVor.getitemcount - 1
    TabelleVerschiebenKopieren.Cancel
'/// Open a new document and create a new sheet based on 'Rigel' from the saved document.
    InsertSheetCalc
    Kontext "TabelleEinfuegenCalc"
    AusDateiErstellen.check
    Durchsuchen.Click
    Kontext "OeffnenDlg"
    Dateiname.settext Workfile
    Oeffnen.Click
    sleep 1
    Kontext "TabelleEinfuegenCalc"
    '*************************************
    '*** The filterdialog must be appear
    '*************************************
    try
      Auswahl.select 2
      lager = Auswahl.getseltext
      if lager = "Rigel" then
         Printlog "OK the tablename is appeared at the correct place in the insert menu."
      else
         Warnlog "Tablename isn't shown at the correct place in the Insert dialog"
      end if
      TabelleEinfuegenCalc.Ok
    catch
      TabelleEinfuegenCalc.Cancel
      warnlog "OOPS, no sheet to select available"
    endcatch
'/// Check if the sheet was copied
    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    tabzahl1 = EinfuegenVor.getitemcount - 1
    TabelleVerschiebenKopieren.Cancel
    'Evaluate 2
    if tabzahl1 - tabzahl = 1 then
        for wh = 1 to tabzahl
            call fCalcSelectSheet ( wh )
            FormatSheetRename
            Kontext "TabelleUmbenennen"
            if TabellenName.gettext = lager then
               wh = TabZahl + 1
               gefunden = true
            else
               gefunden = false
            end if
            TabelleUmbenennen.Cancel
        next wh
        if gefunden = true then
         Printlog "OK a table is copied with the correct name from another file"
        else
         Warnlog "A table is copied with the wrong name from another file"
        end if
    else
        Warnlog "There is no table copied from another file"
    end if
    call hCloseDocument
'/// Now do the same with another new document and insert the appropriate sheet as link
    'Insert linked
    call hNewDocument

    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    tabzahl = EinfuegenVor.getitemcount - 1
    TabelleVerschiebenKopieren.Cancel

    InsertSheetCalc
    Kontext "TabelleEinfuegenCalc"
    AusDateiErstellen.check
    verknuepfen.check
    Durchsuchen.Click
    Kontext "OeffnenDlg"
    Dateiname.settext Workfile
    Oeffnen.click
    Kontext "TabelleEinfuegenCalc"
    if TabelleEinfuegenCalc.notexists(2) then sleep 3
    try
      Auswahl.select 2
      lager = Auswahl.getseltext
      if lager = "Rigel" then
      Printlog "OK tablename is shown at the right place in the Insert dialog"
    else
      Warnlog "Tablename isn't shown at the right place in the Insert dialog"
    end if
      TabelleEinfuegenCalc.Ok
    catch
      TabelleEinfuegenCalc.Cancel
      warnlog "OOPS, no sheet to select available"
    endcatch
'/// Then check, if the sheet was inserted as link
    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    tabzahl1 = EinfuegenVor.getitemcount - 1
    TabelleVerschiebenKopieren.Cancel
    'Evaluate2
    if tabzahl1 - tabzahl = 1 then
      for wh = 1 to tabzahl
         call fCalcSelectSheet ( wh )
         FormatSheetRename
         Kontext "TabelleUmbenennen"
         if TabellenName.gettext = lager then
            wh = TabZahl + 1
            gefunden = true
         else
            gefunden = false
         end if
         TabelleUmbenennen.Cancel
      next wh
      if gefunden = true then
         Printlog "OK a table is added linked with the rigth name from another file"
      else
         Warnlog "A table is added linked with a wrong name from another file"
      end if
    else
      Warnlog "There hasn't been added a table"
    end if
'/// Save this document, close it and opened the file 'gOfficePath & "user/work/teinfuegentabelle'
    call hSpeichernUnterMitFilterKill (Workfile1, gCalcFilter)
    Sleep 1
    call hCloseDocument
    call hDateioeffnen (Workfile)
    Sleep 1
'/// Edit go to sheet 'Rigel' and modify it. Then save the file.
    call fCalcSelectSheet ("Rigel")
    Kontext
    DocumentCalc.Typekeys ("13<Return>")

   FileSave
   Kontext "Active"
   if Active.exists then
      printlog Active.GetText
      Active.No
      Kontext "DocumentCalc"
   end if
'/// Load the other file which inherits the linked sheet, and check, if this sheet was updated.
    call hCloseDocument
    call hDateioeffnenmitverknuepfung (Workfile1, 1)
    Kontext
    if cZellwert ("A1") = "13" then
      printlog "Linked table has been updated"
    else
      Warnlog "Linked table hasn't been updated"
    end if

    call hCloseDocument
    sleep(1)
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSheetFromFile
'///Test if Insert->Sheet from file... works
   dim csvFile$
   dim sxcFile$

   csvFile$ = convertpath(gTesttoolpath & "calc/level1/input/tInsertSheetFromFile.csv")
   sxcFile$ = convertpath(gTesttoolpath & "calc/level1/input/tInsertSheetFromFile.sxc")


'   QAErrorLog "PLEASE ACTIVATE TESTCASE AFTER INTEGRATION OF CWS DR21"
'   goto endsub
   
   '///+Open new document
   call hNewDocument
   
     '///+Invoke menu item 'Insert->Sheet form file...'
     InsertSheetFromFile
     '///+Chosse a CSV file
     Kontext "OeffnenDlg"
       Dateiname.settext csvFile$
       '///+Open it
       Oeffnen.Click
       sleep(2)
       '///+Confirm text import without any adjustments 
       Kontext "TextImport"
         TextImport.OK
       Kontext "TabelleEinfuegenCalc"
         TabelleEinfuegenCalc.OK
     '///+Check if '$C$3' contains the string 'Mouse' -> OK
     Kontext "DocumentCalc"
       if cZellwert("C3") = "Mouse" then
          printlog "Insert -> Sheet from file ... with CSV file passed"
       else
          warnlog "Insert -> Sheet from file ... with CSV file failed"
       end if

   call hCloseDocument
   sleep(2)
   '///+Open another document
   call hNewDocument
   
     '///+Invoke menu item 'Insert->Sheet form file...'
     InsertSheetFromFile
     '///+Chosse a SXC file
     Kontext "OeffnenDlg"
       Dateiname.settext sxcFile$
       '///+Open it
       Oeffnen.Click
       sleep(2)
       Kontext "TabelleEinfuegenCalc"
         Auswahl.Select(1)
         TabelleEinfuegenCalc.OK
     '///+Check if '$IV$65536' contains the string 'Check this out' -> OK
     Kontext "DocumentCalc"
       if cZellwert("IV65536") = "Check this out" then
          printlog "Insert -> Sheet from file ... with SXC file passed"
       else
          warnlog "Insert -> Sheet from file ... with SXC file failed"
       end if

   call hCloseDocument

   
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSpecialCharacter
'/// This test inserted special characters and check if these characters are ///
'/// in fact inserted. ///

    dim wh : dim wh2 : dim Lager

    Call  hNewDocument
    sleep(5)

    for wh = 0 to 5
        try 
            InsertSpecialCharacterCalc
        catch
            if wh = 4 then
                qaErrorLog "#123127# - Spellcheck crashes with some character sets, e.g. Greek"
            else
                warnlog "'Insert::Special Characters' failed for unknown reason -> Check this out!"
            endif
            goto endsub
        endcatch
        Kontext "Sonderzeichen"
        SchriftListe.typekeys "<DOWN>", wh
        for wh2 = 1 to 32
            SchriftListe.typekeys " <Right>"
        next wh2
        Sonderzeichen.Ok
        sleep(2)
    next wh
    Kontext
    DocumentCalc.typekeys "<RETURN>"
    for wh = 32 to 255
      DocumentCalc.Typekeys chr(wh)
    next wh
    DocumentCalc.typekeys "<RETURN UP UP>"
    call cCellCompare (1, 0, 0)

    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertDefineName
'/// This test check the function InsertDefineName by inserting several named cell areas ///
'/// in different sheets of the document. After this, the firste sheet is renamed and a ///
'/// new sheet is inserted with the current name of the first sheet. After saving and reloading ///
'/// this file it is tested, if all cell areas have their current settings and if the cellareas ///
'/// on the first sheet (Now Sheet7) are belonged to the correct sheet (Sheet7). ///

   dim xFaktor
   dim yFaktor
   dim istliste(6,3) as string
   dim sollliste(6,3) as string
   dim wh as integer
   dim wh1 as integer
   dim Lager
   dim file$
'/// Open two new calc documents and select in the second one the cells 'A1:B2'
   file$ = convertpath(gOfficePath & "user/work/teinfuegennamenfestlegen.ods"
   if hFileExists (file$) = TRUE then app.kill (file$)
   call hNewDocument
   xFaktor = groessemessen("X")
   printlog "xFaktor:" & xFaktor
   yFaktor = groessemessen("Y")
   printlog "yFaktor:" & yFaktor
   call hCloseDocument
   sleep (3)   
   Call  hNewDocument
   sleep 3
   Call ZellenMarkieren (2,2)
   sleep 3
'/// Define a rangename a add it
   InsertNamesDefine
   Kontext "NamenFestlegen"
   BereichsName.SetText "Test1"
   Hinzufuegen.Click
   NamenFestlegen.Ok
   sleep (1)
'/// Select the cells 'M13:O15' and define a name for this range
   cBereichmarkieren ("M13:O15")
   InsertNamesDefine
   Kontext "NamenFestlegen"
   BereichsName.SetText "Test2"
   Zusaetze.Click
   Druckbereich.check
   Hinzufuegen.Click
   NamenFestlegen.Ok
'/// Go to sheet 2, define a range name for cell 'A1' and check 'filter'
   call fCalcSelectSheet ( 2 )
   InsertNamesDefine
   Kontext "NamenFestlegen"
   BereichsName.SetText "Test3"
   Zusaetze.Click
   Filter.check
   ZugeordnetZuButton.Click
'/// Select a range with the mouse and add this range
   Kontext
   DocumentCalc.Mousedown ((0.5 * xFaktor),(0.5 * yFaktor))
   DocumentCalc.MouseUp ((1.5 * xFaktor),(2.5 * yFaktor))
   Kontext "NamenFestlegen"
   ZugeordnetZuButton.Click
   ZugeordnetZu.Settext "$A$1:$B$3"
   Hinzufuegen.Click
   sleep (1)
'/// Add two other named ranges on this sheet, then go to sheet 3 and add a last range
   BereichsName.SetText "Test4"
   ZugeordnetZu.Settext "A1:A13"
   WiederholungsSpalte.check
   Hinzufuegen.Click
   BereichsName.SetText "Test5"
   ZugeordnetZu.Settext "A1:M1"
   WiederholungsZeile.check
   Hinzufuegen.Click
   NamenFestlegen.Ok

   call fCalcSelectSheet ( 3 )
   EditSelectAll
   InsertNamesDefine
   Kontext "NamenFestlegen"
   BereichsName.SetText "Test6"
   Hinzufuegen.Click
   NamenFestlegen.ok
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
'/// Save Document, close it, reload it and check the ranges again
   printlog "Save Document, close it, reload it and check the ranges again"
   call hSpeichernUnterMitFilterKill file$, gCalcFilter

   sleep 2

   call hCloseDocument
   sleep 2
   call hDateioeffnen file$
   call fCalcSelectSheet ( 1 )
   FormatSheetRename
   Kontext "TabelleUmbenennen"
   Lager = TabellenName.gettext
   TabellenName.Settext left(Lager,len(Lager)-1) & 7
   TabelleUmbenennen.Ok
   InsertSheetCalc
   Kontext "TabelleEinfuegenCalc"
   TabellenName.settext Lager
   TabelleEinfuegenCalc.Ok
   call fCalcSelectSheet ( 4 )
    if cgotocell("C3") <> 0 then
        warnlog "Traveling to C3 failed! Exiting test!"
        goto endsub
    end if
   EditDeleteCells
   Kontext "ZellenLoeschen"
   GanzeZeilen.check
   Zellenloeschen.Ok
   EditDeleteCells
   Kontext "Zellenloeschen"
   GanzeSpalten.check
   Zellenloeschen.Ok
   InsertNamesDefine
   Kontext "NamenFestlegen"
   sleep(5)
   Zusaetze.Click
   for wh = 1 to 6
      BereichsName.select wh
      sleep 2
      istliste(wh,1) = BereichsName.GetSelText
      istliste(wh,2) = (right(Zugeordnetzu.gettext,len(Zugeordnetzu.gettext)-Instr(Zugeordnetzu.gettext,".")+2))
      if Druckbereich.ischecked then istliste(wh,3) = "Druckbereich"
      if Filter.ischecked then istliste(wh,3) = "Filter"
      if Wiederholungsspalte.ischecked then istliste(wh,3) = "Wiederholungsspalte"
      if Wiederholungszeile.ischecked then istliste(wh,3) = "Wiederholungszeile"
   next wh
   for wh = 1 to 6
      if wh = 6 then printlog "If the test crashes at this point this could be the bug:79008"
      Printlog istliste(wh,1) & " " & istliste(wh,2)
   next wh
   NamenFestlegen.Ok
   sollliste(1,1) = "Test1" : sollliste(1,2) = "7.$A$1:$B$2"      : sollliste(1,3) = ""
   sollliste(2,1) = "Test2" : sollliste(2,2) = "7.$M$13:$O$15"    : sollliste(2,3) = "Druckbereich"
   sollliste(3,1) = "Test3" : sollliste(3,2) = "$A$1:$B$3"        : sollliste(3,3) = "Filter"
   sollliste(4,1) = "Test4" : sollliste(4,2) = "A1:A13"           : sollliste(4,3) = "Wiederholungsspalte"
   sollliste(5,1) = "Test5" : sollliste(5,2) = "A1:M1"            : sollliste(5,3) = "Wiederholungszeile"
   sollliste(6,1) = "Test6" : sollliste(6,2) = "3.$A$1:$IU$65535" : sollliste(6,3) = ""
   '** listenvergleichen
   for wh = 1 to 6      ' the maximum is set to 5 instead of 6 to make the test runable
      if istliste(wh,1) = sollliste(wh,1) then
         if istliste(wh,2) = sollliste(wh,2) then
            if istliste(wh,3) = sollliste(wh,3) then
               Printlog "  " & wh & ".Range Name Ok"
            else
               Warnlog  "Range Name: " & wh & " has lost the addon. Desired: " & sollliste(wh,3) & " Current: " & istliste(wh,3)
            end if
         else
            Warnlog "Range Name: " & wh & " the appropriate range isn't correct. Desired: " & Sollliste(wh,2) & " Current: " & istliste(wh,2)
         end if
      else
         Warnlog "The sort of the ranges is wrong"
         for wh1 = 1 to 5  ' the maximum is set to 5 instead of 6 to make the test runable
            if istliste(wh1,1) = sollliste(wh,1) then
               if istliste(wh1,2) = sollliste(wh,2) then
                  if istliste(wh1,3) = sollliste(wh,3) then
                     Printlog "  " & wh1 & ".Range Name Ok"
                  else
                     Warnlog  "Range Name: " & wh1 & " has lost the addon"
                  end if
               else
                  Warnlog "Range Name: " & wh & " the appropriate range is wrong:" & istliste(wh1,2)
               end if
            else
               Warnlog "No agreement found"
            end if
         next wh1
      end if
   next wh

   sleep 3

   Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tInsertChart
    Dim sFormula as string
    Dim x as integer
    Dim y as integer
    Dim Anzahl as integer

    '/// Goals of this test:
    '///+<ol><li>Insert numbers with RAND() function</li>
    '///+<li>Use <i>Paste Special</i> dialog</lI>
    '///+<li>Create from RAND() data a chart</li></ol>
    select case iSprache
        '/// <ul><li>Test sFormula (depending on language
        '///+ <TABLE BORDER=1>
        '///+<TR><TD>Language</TD><TD>sFormula</TD></TR>
        '///+<TR><TD>01</TD><TD>=(RAND()*50)</TD></TR>
        case 01   : sFormula = "=(RAND()*50)"
        '///+<TR><TD>03</TD><TD>=(ALEATÃRIO()*50)</TD></TR>   
        case 03   : sFormula = "=(ALEATÃRIO()*50)"
        '///+<TR><TD>07</TD><TD>=(RAND()*50)</TD></TR>
        case 07   : sFormula = "=(RAND()*50)"
        '///+<TR><TD>31</TD><TD>=(ASELECT()*50)</TD></TR>
        case 31   : sFormula = "=(ASELECT()*50)"
        '///+<TR><TD>33</TD><TD>=(ALEA()*50)</TD></TR>
        case 33   : sFormula = "=(ALEA()*50)"
        '///+<TR><TD>34</TD><TD>=(ALEATORIO()*50)</TD></TR>
        case 34   : sFormula = "=(ALEATORIO()*50)"
        '///+<TR><TD>39</TD><TD>=(CASUALE()*50)</TD></TR>
        case 39   : sFormula = "=(CASUALE()*50)"
        '///+<TR><TD>45</TD><TD>=(SLUMP()*50)</TD></TR>
        case 45   : sFormula = "=(SLUMP()*50)"
        '///+<TR><TD>46</TD><TD>=(SLUMP()*50)</TD></TR>
        case 46   : sFormula = "=(SLUMP()*50)"
        '///+<TR><TD>48</TD><TD>=(SUMA()*50)</TD></TR>
        case 48   : sFormula = "=(SUMA()*50)"
        '///+<TR><TD>49</TD><TD>=(ZUFALLSZAHL()*50)</TD></TR>
        case 49   : sFormula = "=(ZUFALLSZAHL()*50)"
        '///+<TR><TD>55</TD><TD>=(ALEATÓRIO()*50)</TD></TR>
        case 55   : sFormula = "=(ALEATÓRIO()*50)"
        '///+<TR><TD>82</TD><TD>=(RAND()*50)</TD></TR>
        case 82   : sFormula = "=(RAND()*50)"
        '///+<TR><TD>86</TD><TD>=(RAND()*50)</TD></TR>
        case 86   : sFormula = "=(RAND()*50)"
        '///+<TR><TD>88</TD><TD>=(RAND()*50)</TD></TR>
        case 88   : sFormula = "=(RAND()*50)"
        case else : QAErrorlog "Language adjustment is missing!"
                    goto endsub
        '///+</TABLE></ul>
    end select

    '/// File / New / Spreadsheet
    call hNewDocument   
    printlog "create table with random numbers"
    '/// Type in 
    '///+<ul><li>A [RIGHT]</li>
    '///+<li>B [RIGHT]</li>
    '///+<li>C [RIGHT]</li>
    '///+<li>D [RETURN]</li>
    '///+<li>and three times [LEFT]</li></ul>
    DocumentCalc.Typekeys "A<RIGHT>B<RIGHT>C<RIGHT>D<RETURN>"
    DocumentCalc.Typekeys "<LEFT>" , 3   
    for x = 1 to 4
        '/// 4 times
        '///+<ul><li>
        for y = 1 to 12
            '///+12 times 
            '///+<ul><li> Insert the sFormula</li>
            DocumentCalc.Typekeys sFormula
            '///+<li>and press [RETURN]</li></ul></li>
            DocumentCalc.Typekeys "<RETURN>"                   
        next y
        '///+<li>Press [PAGE UP][DOWN][RIGHT]</li></ul>
        DocumentCalc.Typekeys "<PAGEUP><DOWN><RIGHT>"
    next x
    '/// Type [CONTROL+HOME][DOWN]
    DocumentCalc.Typekeys "<MOD1 HOME><DOWN>"
    '/// Type [CONTROL+SHIFT+RIGHT+DOWN]
    DocumentCalc.Typekeys "<MOD1 SHIFT RIGHT DOWN>"
    '/// Format / Cells
    FormatCells
    Kontext
    '/// Select tab page 'Numbers' 
    Active.SetPage TabZahlen
    Kontext "TabZahlen"
    '/// Select the second entry in 'Format'
    ZahlenFormat.Select(2)
    '/// Leave the dialog with OK
    TabZahlen.OK   
    Kontext "DocumentCalc"
    '/// Edit / Copy
    EditCopy
    sleep(2)
    '/// Edit / Paste Special
    EditPasteSpecialCalc
    '/// The 'Paste Special' dialog will occour
    Kontext "InhalteEinfuegenCalc"
    try
        '/// In 'Slection': 
        '/// If 'Paste All' is checked uncheck it
        if AllesEinfuegen.IsChecked then
            AllesEinfuegen.Uncheck
        end if
        '/// If 'Formulas' is checked uncheck it
        if Formeln.isChecked then
            Formeln.Uncheck
            printlog "  sFormulas were checked. Are now unchecked"
        end if
        '/// If 'Numbers' is unchecked check it
        if NOT Zahlen.isChecked then
            Zahlen.Check
            printlog "  values weren't checked. Are now checked"
        end if
        '/// Under 'Options':
        '/// If'Transpose' is checked uncheck it
        if Transponieren.isChecked then
            Transponieren.uncheck
        end if
    catch
        warnlog "It was impossible to check Choose"
    endcatch
    '/// Leave dialog with OK
    InhalteEinfuegenCalc.OK
    Kontext "Active"
    '/// If a message box occours press OK
    if Active.exists then 
        Active.yes
    end if
    Kontext "DocumentCalc"
    '/// Type [RETURN][UP][LEFT]
    DocumentCalc.Typekeys "<RETURN><UP><LEFT>"
    '/// Type [CTRL SHIFT RIGHT DOWN]
    DocumentCalc.Typekeys "<Mod1 SHIFT RIGHT DOWN >"
    '/// Insert / Chart
    InsertChartCalc
        '/// The Chart wizard occours
        Kontext "ChartWizard"
        '/// On the chart wizard press OK button 
        if ChartWizard.Exists(2) then
            printlog "Create chart"
            ChartWizard.OK
            sleep(2)
        else
            warnlog "Chart wizard did not occour! Exiting test case."
            call hCloseDocument
            goto endsub
        end if    
    Kontext "DocumentCalc"
    '/// Type twice [ESCAPE]
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    '/// Press [F5] to get the Navigator
	'/// Select via the Navigator the first Chart in the document
    Call fSelectFirstOLE
    '/// Edit / Object / Edit
    try
        EditObjectEdit
    catch
        warnlog "Chart has not been inserted!"
    endcatch
    '/// After the chart has been again activated
    '///+ close the document with File / Close
    call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertGraphicFromFile
'/// In this test a graphic from a file is inserted. It is tested, if this ///
'/// action was succesfully by calling the dialog 'ContextPositionAndSize'. ///

   dim Workfile : workfile = convertpath(gtesttoolpath + "global\input\graf_inp\baer.tif")

   Call  hNewDocument

   InsertGraphicsFromFile
   Kontext "GrafikEinfuegenDlg"
   Dateiname.settext workfile
   Oeffnen.click
   sleep 1
   try
      ContextPositionAndSize
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      TabPositionAndSize.Ok
      printlog "Insert Graphic OK"
   catch
      warnlog "No Graphic inserted"
   endcatch

   Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tInsertObjectFormula
'/// This test ckecks the insert of a formula with a embedded StarMath Module.///

'    QAErrorLog "This test case is skipped due to BugID: #i29813#"
'    goto skipThisTest
    dim nID as integer
'/// Open a new calc document and insert a formula. Thenchekc if the formula was embedded.
    Call hNewDocument

    PrintLog "Insert Formula"
    InsertObjectFormulaCalc
    Sleep 2
    PrintLog "create a formula"
    Kontext "CommandsMath"
    Commands.typekeys "a sup 2 + b sup 2  = c sup 2"
    Sleep 2
    PrintLog "Leave OLE-Object"
    call gMouseClick ( 50, 50 )
    Sleep 1

    PrintLog "activate OLE-Object"
    call gMouseClick ( 2, 2 )
    Sleep 1
    try
      EditObjectEdit
    catch
      warnlog "The MathFormula wasn't selected"
    endcatch
    Sleep 1
    Kontext "CommandsMath"
    if CommandsMath.NotExists(2) then
    Warnlog "OLE-Math couldn't be activated in the first cell"
    else
    call gMouseClick ( 50, 50 )
    end if
    Sleep 1

    Call hCloseDocument
'skipThisTest:

endcase
'
'-----------------------------------------------------------
'
testcase tInsertObjectOLE
'/// In this test, all available OLE-Objects are inserted by calling the menu item
'/// <i>Insert / Object / OLE Object</i>. The correct count of available object 
'///+ names is being checked depending on the based <i>gPlatform</i>. ///
    dim sLager as string
    dim iAnz as integer
    dim iWh as integer
    dim olezahl as integer 
    dim OLEtype(1 to 10) as string   
'/// File / New / Spreadsheet 
    call hNewDocument
    InsertObjectOLEObject
'/// Call the Insert / Object / OLE Objekt   
    Kontext "OLEObjektEinfuegen"
    iAnz = Objekttyp.getitemcount
'/// Check the count of choosable OLE-objects
'///+ Expected: 5 for UNIX and 6 for Win32
    select case gPlatgroup
        case "w95"  : olezahl = 6
        case "unx"  : olezahl = 5
        case else   : QAErrorLog "Unsupported gPlatgroup. Exiting."
                      Kontext "OLEObjektEinfuegen"
                      OLEObjektEinfuegen.Cancel
                      Call hCloseDocument
                      goto endsub
    end select
    if iAnz = olezahl then
        printlog "  OK "  & iAnz & " Objecttypes choosable"
    else
        warnlog "There seem to be" & iAnz & " OLE object types instead of " & olezahl & "."
    end if
    OLEObjektEinfuegen.Cancel
'/// Insert one object after another and check that the correct type has been inserted.
    for iWh = 1 to iAnz
        InsertObjectOLEObject
        Kontext "OLEObjektEinfuegen"
        Objekttyp.select iWh
        sLager = Objekttyp.GetSelText
        printlog "Objekt: " & sLager
        if instr(sLager , "StarSuite") or instr(sLager , "StarOffice") or instr(sLager , "OpenOffice.org") then
            OLEObjektEinfuegen.Ok
            select case iWh
                case 1  :   Kontext "DocumentChart"
                            if DocumentChart.exists(1) then
                                printlog "OK OLE Object Chart inserted"
                                call deleteObject
                            else
                                warnlog "OLE Objekt Chart not found"
                            end if
                case 2   :  Kontext "DocumentDraw"
                            if DocumentDraw.Exists(1) then
                                printlog "OK OLE Object Draw inserted"
                                call deleteObject
                            else
                                warnlog "OLE Object Draw not found"
                            end if
                case 3   :  Kontext "DocumentImpress"
                            if DocumentImpress.Exists(1) then
                                printlog "OK OLE Object Presentation inserted"
                                Kontext "CommonTaskbar"
                                if CommonTaskbar.exists then 
                                    CommonTaskbar.typekeys "<ESCAPE>"
                                end if
                                call deleteObject
                            else
                                warnlog "OLE Object Presentation not found"
                            end if
                case 4   :  Kontext "DocumentMath"
                            if DocumentMath.Exists(1) then
                                call SchreibenInMathdok("f(x) = x^2")
                                printlog "OK OLE Object Math inserted"
                                call deleteObject
                            else
                                warnlog "OLE Object Math not found"
                            end if
                case 5
                :  Kontext "DocumentWriter"
                            if DocumentWriter.exists(1) then
                                printlog "OK OLE Object Writer inserted"
                                call deleteObject
                            else
                                warnlog "OLE Object Writer not found"
                            end if
                case else   :  printlog "Unknown OLE entry or 'further OLE objects' entry found which is not being testable."
            end select
        else
            OLEObjektEinfuegen.Cancel
            printlog "Unknown OLE entry or 'further OLE objects' entry found which is not being testable."       
        end if
    next iWh
    call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
sub deleteObject
    sleep(5)
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<ESCAPE ESCAPE>"
    sleep(20)
    DocumentCalc.typekeys "<MOD1 HOME>"
    sleep(2)
    call fselectFirstOLE
    Kontext "DocumentCalc"
    EditDeleteContents
    sleep(2)
    Kontext "InhalteLoeschen"
    if InhalteLoeschen.Exists(1) then
        Printlog "Delete dialog has been appeared"
        alles.check
        InhalteLoeschen.Ok
    else
        printlog "No Delete dialog has been appeared"
    end if
    Kontext "DocumentCalc"
    DocumentCalc.MouseDown 2,2
    DocumentCalc.MouseUp 2,2
    sleep(5)
    try
        Obj_Originalgroesse
        sleep(5)
        warnlog "Object wasn't deletable"
    catch
        if fWhereIsTheCellCursor = "A1" then
            printlog "OK Object has been deleted"
        else
            warnlog "Object wasn't deletable " & fWhereIsTheCellCursor
        end if
    endcatch
    call hCloseDocument
    sleep(5)
    call hNewDocument
    sleep(5)
    Kontext "DocumentCalc"
    DocumentCalc.MouseDown 2,2
    DocumentCalc.MouseUp 2,2
    DocumentCalc.MouseMove 2,2
end sub
'
'---------------------------------------------------------------------------
'
testcase tInsertObjectPlugin
'/// This test checks, if it is possible to insert plugins. The plugin only ///
'/// works, if the appropriate plugin is installed in a browser. ///

    call hNewDocument

    InsertObjectPlugIn
    Kontext "PlugInEinfuegen"
    if PlugInEinfuegen.exists then
        printlog "Insert PlugIn Dialog is there"
        DateiUrl.settext convertpath(gtesttoolpath & "input\global\bscfast.wrl")
        Sleep(5)
        PlugInEinfuegen.Ok
        sleep 3
        try
         Kontext "Active"
         if Active.exists then
            Active.OK
            printlog "It seems that no Netscape Browser with this plugin is installed"
         end if
        catch
        endcatch
        'Possibly here must be an kontext "active"
        sleep 10
        Kontext "DocumentCalc"
        DocumentCalc.MouseDown(90,90)
        DocumentCalc.MouseUp(90,90)
        sleep 1
        DocumentCalc.MouseDown 1,1
        DocumentCalc.MouseUp 1,1
        If fWhereIsTheCellCursor = "A1" then
         Warnlog "Insert PlugIn doesn't work"
      else
         Printlog "OK Insert PlugIn work"
      end if
    else
      warnlog "Insert PlugIn Dialog not shown"
    end if

    call hCloseDocument

endcase

