'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_102b_.inc,v $
'*
'*  $Revision: 1.20 $
'*
'*  last change: $Author: jsi $ $Date: 2007/09/15 08:39:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description  :  Detailed test of the functions in the Edit menu - Part 2
'*
'*************************************************************************
'*
' #1 c_102b_ ' Initial routine
' #1 tEditDeleteTables
' #1 tEditDeleteCells
' #1 tEditLinkGraphic
' #1 tEditLinkOLE
' #1 tCalc2DrawCopy
' #1 tEditMoveCopyTable
' #1 tEditDeleteManualRowBreak
' #1 tEditDeleteManualColumnBreak
' #1 tEditModifyMergeDocuments
'*
'\************************************************************************


sub c_102b_

Printlog "--------- C_102b_ ---------"

   call tEditDeleteManualColumnBreak
   call tEditDeleteManualRowBreak   
   call tEditDeleteTables
   call tEditDeleteCells
   call tEditLinkGraphic
   call tEditLinkOLE
   call tCalc2DrawCopy
   gApplication = "CALC"
   call tEditMoveCopyTable
   call tEditModifyMergeDocuments

end sub
'
'-----------------------------------------------------------
'
testcase tEditLinkGraphic
'/// This test insert a graphic as link in a calcdocument and remove it again ///
'/// It is checked, if the graphic was inserted and if it is possible to remove the link. ///

    call  hNewDocument

    InsertGraphicsFromFile
    Kontext "GrafikEinfuegenDLG"
    Dateiname.settext ConvertPath(gtesttoolpath & "global\input\graf_inp\baer.tif")
    Link.Check
    Oeffnen.Click
    sleep (2)
    EditLinksCalc
    Kontext "VerknuepfungenBearbeiten"
    If NOT VerknuepfungenBearbeiten.exists (5) then
      Warnlog "Dialog EditLink doesn't appear"
    end if
    Aendern.click
    Kontext "GrafikEinfuegenDLG"
    If GrafikEinfuegenDLG.exists then
      'Printlog "Ok"
    else
      Warnlog "Modify doesn't call the dialog InsertGraphic"
    end if
    GrafikEinfuegenDLG.Cancel
    Kontext "VerknuepfungenBearbeiten"
    loesen.Click
    Kontext
    If NOT Active.exists then
        Warnlog "No request by deleting the link"
    end if
    Active.Yes
    Kontext "VerknuepfungenBearbeiten"
    VerknuepfungenBearbeiten.Cancel

    try
      EditLinksCalc
      Warnlog "The link still exists"
    catch
      Printlog "OK, the link has been deleted"
    endcatch

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditLinkOLE
'/// A text is inserted in a mathdocument. This document is linked to a calcdocument. ///
'/// + Then a new text is inserted into the mathdocument and the calcdocument is closed without ///
'/// + saving. Now it is checked by compare the textwidth if the link was updated ///
'/// + (this would be an ERROR) or if the content of the link has the old content ("Example"). ///

    dim check_width
    dim sFile as String
    dim SFileMath as String
    sFileMath = gOfficePath & "user/work/verkn.sxm"
    sFile = gOfficePath & "user/work/verkn.ods"

    gApplication = "Math"   
    call  hNewDocument
    setClipboard ("Example")
    Kontext
    EditPaste
    sleep 2
    call hSpeichernUnterMitFilterKill (sFileMath, gMathFilter)
    printlog "saved as " & sFileMath
    call hCloseDocument
    gApplication = "CALC"
    printlog "call new calcdocument"
    call  hNewDocument
    InsertObjectOLEObject
    kontext "OLEObjektEinfuegen"
    AusDateierstellen.check
    OleDatei.settext  ConvertPath (sFileMath)
    OLEObjektEinfuegen.Ok
    Kontext
    call hSpeichernUnterMitFilterKill convertpath (sFile), gCalcFilter
    printlog "saved calcdocument as " & convertpath (sFile)
    sleep 3
    call hCloseDocument
    sleep 3
    printlog "reload the mathdocument " & sFileMath
    call hDateioeffnen sFileMath
    setClipboard ("NextExample")
    Kontext
    EditPaste
    sleep 2
    FileSave
    call hCloseDocument
    sleep 3
    printlog "reload the calcdocument " & sFile
    call hDateioeffnen sFile
    Kontext
    call gMouseClick (1,1)
    FormatPositionAndSize
    Kontext
    active.setpage TabPositionAndSize
    Kontext "TabPositionAndSize"
    check_width = Width.gettext
    printlog "width: " &  width
    TabPositionAndSize.Cancel
    Kontext
    call gMouseClick (1,1)
    Obj_Originalgroesse
    sleep 1
    FormatPositionAndSize
    Kontext
    active.setpage TabPositionAndSize
    Kontext "TabPositionAndSize"
    if val(Width.gettext) > val(check_width) then
      Warnlog "Link has been updated"
    else
      Printlog "Link hasn't been updated"
    end if
    TabPositionAndSize.Cancel

    call hCloseDocument

    try
      app.kill ConvertPath (sFileMath)
      app.kill ConvertPath (sFile)
    catch
      Warnlog "Error while deleting two files"
    endcatch

endcase
'
'-----------------------------------------------------------
'
testcase tCalc2DrawCopy
    Dim iChartVariant as integer
    
    iChartVariant = 0
    SetClipboard = "" 
    
    '/// File / New / Spreadsheet     
    call  hNewDocument    
        Kontext "DocumentCalc"
        '/// Type <RIGHT> three times
        DocumentCalc.Typekeys "<RIGHT>" , 3
        '/// Type <DOWN> twice
        DocumentCalc.Typekeys "<DOWN>" , 2
        '/// Type 12
        DocumentCalc.Typekeys "12<return>"
        '/// Type 25
        DocumentCalc.Typekeys "25<return>"
        '/// Type 42
        DocumentCalc.Typekeys "42<return>"
        '/// Type 15
        DocumentCalc.Typekeys "15<return>"
        '/// Type 14
        DocumentCalc.Typekeys "14<return>"
        '/// Type 10
        DocumentCalc.Typekeys "10<return>"
        '/// Type <UP>
        DocumentCalc.TypeKeys "<UP>"
        '/// Type <STRG SHIFT UP> to select the numbers in the column
        DocumentCalc.Typekeys "<MOD1 SHIFT UP>"
        Kontext
        '/// Insert / Chart
        InsertChartCalc
        Kontext "ChartWizard"
        '/// On the chart wizard press OK button 
        if ChartWizard.Exists(2) then
            printlog "Create chart"
            ChartWizard.OK
            sleep(2)
        else
            warnlog "Chart wizard did not occour! Exiting test case."
            call hCloseDocument
            goto endsub
        end if    
        Kontext "DocumentChart"
        '/// Format / Chart Type
        FormatChartType
        Kontext "ChartType"
        if ChartType.Exists(2) then
            '/// Type <HOME> on the chart type variant
            variant.TypeKeys "<HOME>"
            '/// Select the second chart variant by selecting it with <RIGHT> cursor
            variant.TypeKeys "<RIGHT>", 1
            '/// Leave dialog with OK
            ChartType.OK
            sleep(2)
        else
            warnlog "Chart type dialog did not occour! Exiting test case."
            call hCloseDocument
            goto endsub    
        end if
        Kontext "DocumentChart"
        '/// Type <ESCAPE> to exit the embedded (inplace) mode of the chart
        DocumentChart.TypeKeys "<ESCAPE>"
        sleep(2)
        '/// Edit / Copy
        try
            EditCopy
            printlog "Edit Copy was successfull"
        catch
            warnlog "Edit / Copy wasn't successfull Exiting test case."
            call hCloseDocument
            goto endsub        
        endcatch
        sleep (2)
    '/// Close the spreadsheet document 
    Call hCloseDocument
    sleep(2)
    gApplication = "DRAW"
    printlog "Changing application to DRAW"
    '/// File / New / Drawing
    call hNewDocument
        '/// Paste the chart into it 
        EditPaste
        '/// Edit / Object / Edit should bring the inserted chart
        '///+ into the 'inplace mode' (embedded)
        EditObjectEdit
        sleep(2)
        FormatChartType        
        Kontext "ChartType"
        if ChartType.Exists(2) then
            printlog "Chart has been inserted."
            '/// Check that chart type is the second variant (stacked)     
            iChartVariant = variant.GetSelIndex                
            if iChartVariant = 2 then
                printlog "Chart variant 2 has been used - PASSED."
            else
                warnlog "Instead of chart variant 2 the variant " & iChartVariant & " has been used - FAILED" 
            end if
            '/// Leave the dialog with CANCEL
            ChartType.Cancel
        else
            warnlog "Chart type dialog did not occour! Exiting test case."
            call hCloseDocument
            goto endsub    
        end if         
        sleep (2)
   call hCloseDocument
   gApplication = "CALC"   
endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditMoveCopyTable
'/// This test check, if the move/copy function works ///

   dim content

   call  hNewDocument
'/// Open a new calc document and insert a '13' into cell 'A1', then select the cell
   DocumentCalc.Typekeys "13<Return><Up>"
   DocumentCalc.Typekeys "<SHIFT DOWN UP>"
'/// Call the menuitem 'InsertNamesDefine' and define a name for this cellrange
   InsertNamesDefine
   Kontext "Namenfestlegen"
   BereichsName.settext "range1"
   content = ZugeordnetZu.gettext
   Namenfestlegen.cancel
'/// Copy this sheet and insert it before sheet_2
   EditCopyMoveSheet
   Kontext "TabelleVerschiebenKopieren"
   EinfuegenVor.select 2
   Kopieren.Check
   TabelleVerschiebenKopieren.OK
'/// Check, if the sheet has been really copied
   sleep (2)
   Kontext
   DocumentCalc.Typekeys "<Down>=" + content + "<Return><Up Up>"
   call cCellCompare (1,0,0)

   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditDeleteManualRowBreak
'/// This test inserted a RowBreak, then it is tested, if the RowBreak ///
'/// has been really inserted. At last the RowBreak is deleted. ///
'/// The same procedure is executed in the next test (ColumnBreak) ///

    call  hNewDocument

    DocumentCalc.Typekeys "1<Return>2<Return><Up>"
    InsertManuelBreakRowBreak
    FilePageView
    Kontext "Previewbar"
    try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        OL_SEITENANSICHT_VorherigeSeiteCalc
        Printlog "RowBreak is inserted"
    catch
      Warnlog "No RowBreak is inserted"
    endcatch
    Kontext "Previewbar"
    if Previewbar.Exists(2) then
	    Seitenansicht.Click
	else
	    warnlog "Could not close page preview! Exiting test!"
	    call hCloseDocument
	    goto endsub 
	end if
    'Sometimes the Click seems not work under TT
    'Executing slot
	Kontext "RechenleisteCalc"
    if NOT RechenleisteCalc.Exists(1) then    
		FilePageView
    end if	
    Kontext
    if cgotocell("A2") <> 0 then
        warnlog "Traveling to A2 failed! Exiting test!"
        goto endsub
    end if
    EditRemoveManualBreakRowBreak
    FilePageView
    Kontext "Previewbar"
    try
      OL_SEITENANSICHT_NaechsteSeiteCalc
      OL_SEITENANSICHT_VorherigeSeiteCalc
      Warnlog "RowBreak hasn't been removed"
    catch
      Printlog "OK, the RowBreak has been removed"
    endcatch
    Seitenansicht.Click

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditDeleteManualColumnBreak
'/// For description, please have a look after 'tEditDeleteManualRowBreak'

    call  hNewDocument

    DocumentCalc.Typekeys "1<Right>2<Right><Left>"
    InsertManuelBreakColumnBreak
    FilePageView
    Kontext "Previewbar"
    try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        OL_SEITENANSICHT_VorherigeSeiteCalc
        Printlog "ColumnBreak is inserted"
    catch
      Warnlog "No ColumnBreak has been inserted"
    endcatch
    Kontext "Previewbar"
    Seitenansicht.Click
    'Sometimes the Click seems not work under TT
    'Executing slot
	Kontext "RechenleisteCalc"
    if NOT RechenleisteCalc.Exists(1) then    
		FilePageView
    end if
    Kontext "DocumentCalc"
    if cgotocell("B1") <> 0 then
        warnlog "Traveling to B1 failed! Exiting test!"
        goto endsub
    end if

    EditRemoveManualBreakColumnBreak
    FilePageView
    Kontext "Previewbar"
    try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        OL_SEITENANSICHT_VorherigeSeiteCalc
        Warnlog "ColumnBreak is still present"
    catch
      Printlog "OK, ColumnBreak has been removed"
    endcatch
    Kontext "Previewbar"
    Seitenansicht.Click
    Kontext

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditModifyMergeDocuments
'/// This test checks if it is possible to merge two documents
    Dim sTestFile as string
    Dim iListeAfterFilter as integer
    sTestFile = convertpath (gTesttoolPath & "calc/level1/input/c_102/teditmergedocument.sxc")
    call hNewDocument
'/// First open a new spreadsheet document
        EditChangesMergeDocument
'/// Edit -> Changes -> MergeDocument
        Kontext "OeffnenDlg"
'/// On the file open dialog select upper folder        
        UebergeordneterOrdner.Click
'/// Click on 'standard' button        
        Standard.Click
'/// Set as mergedocument <i>(gTesttoolPath)/calc/level1/input/c_102/teditmergedocument</i>
        Dateiname.setText sTestFile
'/// Click on open        
        Oeffnen.click
'/// Wait a while until the Changes dialog will be visible        
        sleep(30)
        Kontext "Aenderungenanzeigen"
        Kontext "TabControl"
'/// Select tab page filter        
        TabControl.SetPage TabFilter
        Kontext "Aenderungenanzeigen"
'/// Check 'Author'-checkbox        
        if Autor.IsVisible then
                if Autor.IsChecked = FALSE then
                    Autor.Check
                    printlog "On 'filter' tab page the author-checkbox has been checked."
                else
                    warnlog "On 'filter' tab page the author was checked by default!" 
                end if
        else
            warnlog "On 'filter' tab page the author-checkbox was not visible!"
        end if
'/// Select in the list box 'Francine Stecher'        
        AutoListe.Select "Francine Stecher"
        Kontext "TabControl"
'/// Select tab page list        
        TabControl.SetPage TabListe
'/// There should be 1 entry visible in the list after this filter selection.        
        Kontext "Aenderungenanzeigen"        
        iListeAfterFilter = ListenInhalt.GetItemCount()
        if iListeAfterFilter <> 1 then
            warnlog "There should be 1 item but there are " & iListeAfterFilter & " items!"
        else
            printlog "Filter worked fine with author 'Francine Stecher'. PASSED"
        end if
        sleep(3)
'/// Closing the dialog        
        Aenderungenanzeigen.close
        sleep(3)
   Call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditDeleteTables
'/// This test check, if the correct sheet is being deleted.
'///+ For this purpose a cellrange will be created and then the sheet with the range
'///+ will be copied behind the first sheet. Then it will be tested if the sheet has
'///+ really been inserted. At last the sheet will be deleted.
    Dim content
    '/// New Spreadsheet document      
    call  hNewDocument
        Kontext        
        DocumentCalc.Typekeys "<MOD1 HOME>"
        '/// Hold down CTRL/STRG- and press HOME-button
        InsertNamesDefine
        '/// Insert / Names / Define 
        Kontext "Namenfestlegen"
        '/// Enter as 'name' <pre>range1</pre>
        BereichsName.settext "range1"
        '/// Remember/Copy the value of the 'assigned to'-field (e.g. $Sheet1.$A$1) 
        content = ZugeordnetZu.gettext
        '/// CANCEL the dialog (second button from the top)
        Namenfestlegen.cancel
        '/// Edit / Sheet / MoveCopy 
        EditCopyMoveSheet
        Kontext "TabelleVerschiebenKopieren"
        '/// Select second entry in 'Insert before' list
        EinfuegenVor.select(2) 
        '/// Check 'Copy' checkbox on the bottom of the dialog
        Kopieren.Check
        '/// Leave the dialog with OK (first button from the top)
        TabelleVerschiebenKopieren.OK
        sleep (2)
        Kontext
        '/// Type in the cell where the cursor is in '1' and press ENTER
        DocumentCalc.Typekeys "1<RETURN>"
        '/// Type in the cell where the cursor is in '= and the remembered 
        '///+ value of the 'assigned to'-field from the 'Define Names'-dialog
        '///+ and press ENTER 
        DocumentCalc.Typekeys "=" + content + "<RETURN>"
        '/// Type in the cell where the cursor is in UP twice.
        '/// Hold down SHIFT-key and press first DOWN and the UP. 
        DocumentCalc.Typekeys "<UP><UP><SHIFT DOWN UP>"
        '/// Contect Menu on the names tab of the sheet at the bottom and select 'Select all sheets' 
        AlleTabellenAuswaehlen
        '/// Edit / Fill / Sheet
        EditFillSheet
        Kontext "TabellenFuellen"
        '/// Check 'Paste All' in the 'Fill Sheets'-dialog
        AuswahlAllesEinfuegen.check
        '/// leave dialog with OK in the right corner on the top of the dialog 
        TabellenFuellen.Ok
        sleep(4)
        '/// Edit / Sheet / Select
        EditSheetSelect        
        Kontext "SelectSheets"
        '/// Select the 2nd sheet.
        SheetSelectionBox.Select(2)
        '/// Leave the dialog with OK button on the top right corner.
        SelectSheets.OK
        sleep(2)        
        call cCellCompare (1,0,0)
        '/// Window / New Window
        WindowNewWindow        
        'workaround to deselect all sheets
        '/// Insert sheet
        InsertSheetCalc
        Kontext "TabelleEinfuegenCalc"
        '/// Check 'After current sheet'-radio button
        nach.check
        '/// Under 'Sheet'-section, select 'New sheet'
        Neuerstellen.check
        '/// Set 'No. of sheets' to '1'
        Anzahl.settext "1"
        '/// Set the value of the 'Name'-field to 'Warbird'
        Tabellenname.settext "Warbird"
        '/// Leave the dialog with OK button on the top right corner.
        TabelleEinfuegenCalc.Ok
        sleep(2)
        '/// Edit / Sheet / Select
        EditSheetSelect        
        Kontext "SelectSheets"
        '/// Select the 'Warbird' sheet.
        SheetSelectionBox.Select "Warbird"
        '/// Leave the dialog with OK button on the top right corner.
        SelectSheets.OK
        sleep(2)
        '/// Edit / Sheet / Delete
        EditDeleteSheet
        Kontext
        '/// Leave the warning that you will delete the sheet with OK.
        if Active.Exists(10) then
            printlog "PASSED. warning message before delete cell"
            Active.Yes
        else
            warnlog "No warning message is appeared!"
        end if
        '/// Edit / Sheet / Select
        EditSheetSelect        
        Kontext "SelectSheets"
        '/// Select the 'Warbird' sheet.
        try
            SheetSelectionBox.Select "Warbird"
            warnlog "The sheet is being displayed after it should have been deleted!"
        catch
            printlog "PASSED. The sheet 'Warbird' succesfully has been deleted."
        endcatch
        '/// Leave the dialog with CANCEL button which is the second button
        '///+ from the top right corner.        
        SelectSheets.Cancel
        sleep(2)      
    call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditDeleteCells
'/// A short test to check the function delete cells. ///

    call  hNewDocument
'/// Open a new calcdocument and insert in cell 'A3' a '1', then call the manuitem 'EditDeleteCells' ...
    DocumentCalc.TypeKeys "<Down><Down>1<Return><Up>"
    EditDeleteCells
    Kontext "ZellenLoeschen"
    if ZellenLoeschen.exists(10) then
      Printlog "OK,  the dialog 'DeleteCells' appears"
    else
      Warnlog "Dialog not shown"
    end if
    ZellenLoeschen.Ok
'/// ... and confirm this dialog
    sleep 5
    call ZellenMarkieren (1,1)
'/// Check, if the cell 'A3' has been deleted
    DocumentCalc.Typekeys "<Up>"
    call cCellCompare (1,0,0)

    call hCloseDocument

endcase

