'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_datapilot_pagefields.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:28:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Check content.xml for attribute 'table:selected-page'
'*
'*************************************************************************************************
'*
' #1 subPageFields
' #1 tDatapilotPagefields
'*
'\*************************************************************************************************
sub subPageFields
  printLog Chr(13) + "---------  datapilot pagefields  ----------"

     printlog "Testing Page '- all -'"
     call tDatapilotPagefields("- all -")
     printlog "Testing Page 'Audio'"
     call tDatapilotPagefields("Audio")
     printlog "Testing Page 'DVD'"
     call tDatapilotPagefields("DVD")
     printlog "Testing Page 'Video'"
     call tDatapilotPagefields("Video")

end sub

'************************************************************
testcase tDatapilotPagefields ( sCurrentPage as STRING )
'///<u><b>Check existence and value of attribute 'table:selected-page'</b></u>///

dim bTableSelectedPageShouldExist as BOOLEAN
dim iIndex as INTEGER
dim sComfirmAttribute as STRING
dim sWarnAttribute as STRING
    select case sCurrentPage
           case ("- all -") : bTableSelectedPageShouldExist = "false"
                              iIndex = 1
           case ("Audio")   : bTableSelectedPageShouldExist = "true"
                              iIndex = 2
                              sComfirmAttribute = "OK, value for attribute 'table:selected-page' is 'Audio'"
                              sWarnAttribute = "Unexpected value for attibute 'table:selected-page' -> Check this out!" 
           case ("DVD")     : bTableSelectedPageShouldExist = "true"
                              iIndex = 3
                              sComfirmAttribute = "OK, value for attribute 'table:selected-page' is 'DVD'"
                              sWarnAttribute = "Unexpected value for attibute 'table:selected-page' -> Check this out!" 
           case ("Video")   : bTableSelectedPageShouldExist = "true"
                              iIndex = 4
                              sComfirmAttribute = "OK, value for attribute 'table:selected-page' is 'Video'"
                              sWarnAttribute = "Unexpected value for attibute 'table:selected-page' -> Check this out!" 
    end select

dim sInputFile as STRING
    sInputFile = ( gTesttoolPath & ConvertPath( "xml\level1\input\calc\ooo10\pagefields_datapilot" & iIndex & ".sxc" ))
    
dim sExtension
    sExtension = ".ods"

dim sOutputFile as STRING
    sOutputFile = ( gOfficePath & ConvertPath( "user\work\datapilotPagefields" ) & iIndex & sExtension )
    
dim sUnpackedStorageDir as STRING
    sUnpackedStorageDir = ( gOfficePath & ConvertPath( "user\work\datapilotPagefields" ) & iIndex )
    if (dir ( sUnpackedStorageDir ) <> "" ) then
        kill ( sUnpackedStorageDir )
    endif
    
dim sContentXML as STRING
    sContentXML = ( gOfficePath & ConvertPath( "user\work\datapilotPagefields" ) & iIndex & ConvertPath( "\content.xml" ))
    
dim iSaxSeekIndex as INTEGER
    iSaxSeekIndex = 1
    
dim bContinueSeek as BOOLEAN
    bContinueSeek = TRUE
    
dim iAttributeIndex as INTEGER
    
'///<ul>
'///<li>Open test document</li>///
    call hDateiOeffnen ( sInputFile )
    sleep(2)
    
    '///<li>Save in current default format</li>///
    if hSpeichernUnterMitFilterKill ( sOutputFile , sFileFormat ) = FALSE then
       warnlog "Saving " & sOutputFile & " failed! -> Exiting test!"
       call hCloseDocument
    else
       '///<li>... and close</li>///
       call hCloseDocument
       sleep(3)

       '///<li>Unpack storage to obtain the XML files</li>///
       printlog "Unpack storage of test document."
       UnpackStorage( sOutputFile , sUnpackedStorageDir )
       printlog "Read the test documents DOM."
       '///<li>Read DOM of content.xml</li>///
       SAXReadFile( sContentXML )
       sleep(2)

       '///<li>Set the DOM pointer on element 'table:data-pilot-table'</li>///
       printlog "Set the DOM pointer on element 'table:data-pilot-table'"
       printlog "|-/"
       SAXSeekElement( "/" )
       printlog "  |-office:document-content"
       SAXSeekElement( "office:document-content" )
       printlog "    |-office:body"
       SAXSeekElement( "office:body" )
       printlog "      |-office:spreadsheet"
       SAXSeekElement( "office:spreadsheet" )
       printlog "        |-table:data-pilot-tables"
       SAXSeekElement( "table:data-pilot-tables" )
       printlog "          |-table:data-pilot-table"
       SAXSeekElement( "table:data-pilot-table" )
       
       '///<li>Seek in (all) elements 'table:data-pilot-field'</li>///
       while SAXHasElement( "table:data-pilot-field" , iSaxSeekIndex ) AND bContinueSeek
             printlog "            |-table:data-pilot-field"
             SAXSeekElement( "table:data-pilot-field" , iSaxSeekIndex )
             '///<li>... for attribute 'table:selected-page'</li>///
             for iAttributeIndex = 1 to SAXGetAttributeCount
                if SaxGetAttributeName ( iAttributeIndex ) = "table:selected-page" then
                '///<li>When found, check if it should exist (unexpected for page selection '- all -')</li>///
                   bContinueSeek = FALSE
                   if bTableSelectedPageShouldExist then
                      printlog "Bingo, found attribute 'table:selected-page'"
                      '///<li>Check correct index of expected node</li>///
                      if iSaxSeekIndex <> 1 then
                           warnlog "Found 'table:selected-page' on an unexpected Node -> Check this out!"
                           qaErrorLog "TODO: Check if change of file format was announced!"
                           qaErrorLog "TODO: Modify test if change of file format was intended!"
                       endif
                       '///<li>Check correct attribute index</li>///
                       if iAttributeIndex <> 3 then
                           warnlog "Found 'table:selected-page' on unexpected attribute position -> Check this out!"
                           qaErrorLog "TODO: Check if change of file format was announced!"
                           qaErrorLog "TODO: Modify test if change of file format was intended!"
                       endif
                       '///<li>Check correct attribute value</li>///
                       printlog "Now check for expected value of 'table:selected-page'!"
                       if SAXGetAttributeValue( "table:selected-page" ) = sCurrentPage then
                           printlog sComfirmAttribute
                       else
                           warnlog sWarnAttribute
                       endif
                   else
                       warnlog "OOPS, attribute 'table:selected-page' shouldn't exist for '- all -' pages."
                   endif
                endif
             next iAttributeIndex
             iSaxSeekIndex = iSaxSeekIndex + 1
             SAXSeekElement( 0 )
       wend
    endif
    '///<li>Throw warning if testcase didn't succeed at all!</li>///
    if bContinueSeek AND bTableSelectedPageShouldExist then
        warnlog "OOPS, attribute 'table:selected-page' wasn't found though it should exist -> Check this out!"
    endif
   '///<li>Release DOM</li>///
    SAXRelease
'///</ul>
endcase

