'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_tool5.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: hde $ $Date: 2005/11/07 11:07:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*                                                                **
'* owner : helge.delfs@sun.com                                    **
'*                                                                **
'* short description : Description of file                        **
'*                                                                **
'*******************************************************************
'*                                                                **
' #1 hLevelContent () as String
' #1 hLevelChange( aL() as integer,i as integer,x as integer ,y as integer, sublevel as boolean ) as boolean
' #1 hLevelPrint (aL()as integer) as boolean
' #1 hIsNumberingBullets () as Boolean
' #1 hFormatParagraphNumbering (sStyle as string
' #1 hFindInDocument (sTempSearch as string) as boolean
'*                                                                **
'\******************************************************************

function hLevelContent () as String
    ' presupposition: just stay in line with the to check content
    ' easy to enhance; on demand you can add text to the paragraph and only have to chage this function
    ' input : -
    ' output: paragraph content
    dim sTemp as string
    wDokSchreiben "<end><shift home>" 'select line
    editcopy
    sTemp = GetClipboardText()
    'i don't need the first '-', so i start searching at 2. char
    hLevelContent = Right(sTemp, Len(sTemp)-InStr(2,sTemp,"-")
end function

'------------------------------------------------------------------------------

function hLevelChange(aL() as integer,i as integer,x as integer ,y as integer, sublevel as boolean ) as boolean
' ALSO boolean, if it schould be checked, if it got changed! else don't adjust array!!!
' input: level Nr., how many levels +/-
' return: false, if wrong paragraph

  dim itemp as integer
  dim xtemp as integer
  dim ytemp as integer
  dim stemp as integer
  dim j as integer

   if (hLevelOk (i)) then
      if (aL (i,1) + x) > 0 then  ' CHG <-> level 'stufen'
      ' has to work for +/- x
         xTemp = aL (i,1)
         aL (i,1) = aL (i,1) + x
         if (sublevel) then
            iTemp = i+1
            do while (aL (iTemp,1) > xTemp)
               aL (iTemp,1) = aL (iTemp,1) + x
               iTemp=iTemp + 1
            loop
         endif
      else
         'warnlog "This makes no sense; you trie to 'move to the left'; it doesn't go further! Entry: "+i
      endif
      iTemp = 1
      do while (i <> aL(itemp,2))
         inc iTemp
      loop
      printlog "CHG: found i="+i+" at: "+iTemp

      ' move entry without sublevels
      if (y < -1) OR (y > 1) then warnlog "y ! aus (-1,1) is not implemented :-( yet !"
      if (y > 0) then
            xtemp = aL( itemp+y ,1)
            aL( itemp+y ,1) = aL( itemp ,1)
            aL( itemp ,1) = xtemp
            xtemp = aL( itemp+y ,2)
            aL( itemp+y ,2) = aL( itemp ,2)
            aL( itemp ,2) = xtemp
         if (sublevel) then            ' with sublevel
            yTemp = aL( iTemp+y ,1)            ' save hor <-> level in yTemp
            sTemp = 2
            do while (aL (iTemp ,1) > yTemp)
               xtemp = aL( itemp+sTemp ,1)
               aL( itemp+sTemp ,1) = aL( itemp ,1)
               aL( itemp ,1) = xtemp
               xtemp = aL( itemp+sTemp ,2)
               aL( itemp+sTemp ,2) = aL( itemp ,2)
               aL( itemp ,2) = xtemp
               inc sTemp
            loop
         endif
      else
         if (y < 0) then
            for j=-1 to y
               xtemp = aL( itemp+j ,1)              ' hori <-> level copy
               aL( itemp+j ,1) = aL( itemp+j+1 ,1)
               aL( itemp+j+1 ,1) = xtemp            '      ^
               xtemp = aL( itemp+j ,2)              ' vert | level copy
               aL( itemp+j ,2) = aL( itemp+j+1 ,2)  '      v
               aL( itemp+j+1 ,2) = xtemp
            next j
            if (sublevel) then            ' with sublevel
               yTemp = aL( iTemp+y ,1)            ' save hor <-> level in yTemp
               iTemp = itemp+1
               do while (aL (iTemp,1) > yTemp)
                     xtemp = aL( itemp+y ,1)
                     aL( itemp+y ,1) = aL( itemp+y+1 ,1)
                     aL( itemp+y+1 ,1) = xtemp
                     xtemp = aL( itemp+y ,2)
                     aL( itemp+y ,2) = aL( itemp+y+1 ,2)
                     aL( itemp+y+1 ,2) = xtemp
                  iTemp=iTemp + 1
               loop
            endif
         else ' 0
         endif
      endif
   endif
end function

'------------------------------------------------------------------------------

function hLevelPrint (aL()as integer) as boolean
    dim sTemp as string
    dim iTemp as integer
    dim i,j as integer    
    ' how big is this array??!!! pd: it has to be in aL(0,0)
    printlog "---------------------------------------------------------------------"
    for i=1 to aL(0,0)
        sTemp = ""
        for j=1 to aL(i,1)
            sTemp = sTemp + "..."
        next j
        printlog sTemp + i + "  "+aL(i,2)+ "                   +1: "+aL(i,1)
    next i
    printlog "---------------------------------------------------------------------"
end function

'------------------------------------------------------------------------------

function hIsNumberingBullets () as Boolean
    '/// am i in a NumberingBullets area ?? ///'
    '/// Output: True / False (as Boolean)  ///'
    dim NOerror as Boolean

    hIsNumberingBullets = false
    NOerror = false

    sleep (1)
    try
        FormatNumberingBullets
        NOerror = true
    catch
        Warnlog "w_tool5.inc::hIsNumberingBullets::Slot not available"
        NOerror = false
    endcatch

    if NOerror then
        Kontext
        Active.SetPage TabBullet
        Kontext "TabBullet"
        sleep (1)
        if (remove.isEnabled) then
            hIsNumberingBullets = true
        else
            hIsNumberingBullets = false
        endif
        TabBullet.cancel
    endif
    sleep (1)
end function

'------------------------------------------------------------------------------

sub hFormatParagraphNumbering (sStyle as string,bRestart as integer,sStartW as string)

    FormatParagraph
    Kontext
    Active.SetPage TabNumerierungAbsatz
    Kontext "TabNumerierungAbsatz"

    try
        if (sStyle <> "") then
            Vorlage.Select sStyle
        else
            Vorlage.Select 2
        endif
        if (bRestart <> -1) then
            select case bRestart
                case 0: NumerierungNeuBeginnen.UnCheck
                case 1: NumerierungNeuBeginnen.Check
                case 2: NumerierungNeuBeginnen.TriState
            end select
        endif
        if (sStartW <> -1) then
            select case sStartW
                case 0: NumerierungBeginnenBei.UnCheck
                case 1: NumerierungBeginnenBei.Check
            end select
        endif
    catch
        Warnlog "Not possible; wrong style=none??"
    endcatch

   TabNumerierungAbsatz.OK

end sub

'------------------------------------------------------------------------------

function hFindInDocument (sTempSearch as string) as boolean
    dim  sTemp as string

    hFindInDocument = FALSE
    Call hFindeImDokument (sTempSearch, 1)
    EditCopy
    sTemp = right (GetClipboardText(), len(sTempSearch))
    if (sTemp <> sTempSearch) then
        Warnlog "Found: '" & sTemp & "'  and not: " & sTempSearch
        hFindInDocument = FALSE
    else
        hFindInDocument = TRUE
    endif
end function
