'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_tool4.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: hde $ $Date: 2006/03/16 11:10:21 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*                                                                **
'* owner : helge.delfs@sun.com                                    **
'*                                                                **
'* short description : Misc tools for writer tests                **
'*                                                                **
'*******************************************************************
'*                                                                **
' #1 CountItemsInNavigatorGroup(Group as integer) as Integer
' #1 wCheckOutline
' #1 wSetZoom
' #1 wGetSpellcheckDocumentName
' #1 wToolsSpellcheckCheckWriter
' #1 wEnableAutoSpellcheck
' #1 wEnableHyphenation
'*                                                                **
'\******************************************************************


function CountItemsInNavigatorGroup(Group as integer) as Integer
    Dim j as integer,SelectInNavigator as integer
    'First, select the Navigator depending on the application
    Kontext "Navigator"
    If Not Navigator.Exists then EditNavigator
    Kontext "NavigatorWriter"
    
    'In Navigator, close all groups and set focus to first group
    Sleep 2
    if Auswahlliste.GetItemCount<11 then Inhaltsansicht.Click
    Wait 500
    'Close all groups in Navigator
    if Auswahlliste.GetItemCount >11 then
        For j= 1 to 11
            Auswahlliste.Select j
            Auswahlliste.TypeKeys "-"
        next j
    endif
    
    Wait 500
    'Select group given by the function
    Auswahlliste.Select Group
    ' Open group
    Auswahlliste.TypeKeys "+"
    Inhaltsansicht.Click
    CountItemsInNavigatorGroup = Auswahlliste.GetItemCount - 1
    Inhaltsansicht.Click

end function

'*******************************************************************

function wCheckOutline(WhatToFind as string) as boolean
     '/// This function checks the Outline in level 1 test.
     '/// Purpose is to have a little tolerance, because when resolution changes, the
     '/// line breaks are different
     wCheckOutline = False
     Kontext "DocumentImpressOutlineView"
     DocumentImpressOutlineView.TypeKeys "<Home><Down>" ,1
     DocumentImpressOutlineView.TypeKeys "<Home><Shift End>"
     EditCopy
     if GetClipboardText <> WhatToFind then
        DocumentImpressOutlineView.TypeKeys "<Home><Up>" ,2
        DocumentImpressOutlineView.TypeKeys "<Home><Shift End>"
        EditCopy
        if GetClipboardText = WhatToFind then
          wCheckOutline = True
        endif
     else
      wCheckOutline = True
     endif
end function

'*******************************************************************

function wSetZoom (  )
	'/// This function sets the zoom size to 100% in a text document
	
    ViewZoom
    Kontext "Massstab"
    Vergroesserung100.Check
    Massstab.OK
    Sleep 1


end function

'*******************************************************************

function wGetSpellcheckDocumentName(xCategory as integer) as string
    Dim sTemp as string, sReturn as string
    '/// This function is to return the document to load in spellcheck test
    select case xCategory
        case 1:
            select case iSprache
                case 81, 82, 86, 88
                    sReturn = "None"
                case 1
                    sTemp = Convertpath(gTesttoolpath + "writer\level1\input\spellcheck\st1_2_01.odt")
                case 3
                    sTemp = Convertpath(gTesttoolpath + "writer\level1\input\spellcheck\st1_2_03.odt")                    
                case else
                    sTemp = Convertpath(gTesttoolpath + "writer\level1\input\spellcheck\st1_2_" & iSprache & ".odt")
            end select

        case 2:  
            select case iSprache
                case 81, 82, 86, 88
                    sReturn = "None"
                case 1
                    sTemp = Convertpath(gTesttoolpath + "writer\level1\input\linguistik\001.odt")
                case 3
                    sTemp = Convertpath(gTesttoolpath + "writer\level1\input\linguistik\003.odt")
                case else
                    sTemp = Convertpath(gTesttoolpath + "writer\level1\input\linguistik\0" & iSprache & ".odt")
            end select    
    end select

    if sReturn <> "None" then
        if hFileExists(sTemp) then
            sReturn = sTemp
        else
            sReturn = "Empty"
        endif
    endif
    
    wGetSpellcheckDocumentName = sReturn
    
end function

'*******************************************************************

sub wToolsSpellcheckCheckWriter
    '/// This function opens the spellcheck-dialog in all applications    
    Select Case Ucase(gApplication)
        Case "WRITER"		: ToolsSpellcheck
        Case "MASTERDOC"	: ToolsSpellcheck
        Case "HTMLDOKUMENT" : ToolsSpellcheck
        case "DRAW"         : ToolsSpellcheck
        case "IMPRESS"     	: ToolsSpellcheck
    end select
end sub

'*******************************************************************

sub wEnableAutoSpellcheck(sEnable as boolean)
	'/// This function checks option 'AutoCheck' in Options
	'/// requires a bool to indicate state
    '/// from 680m61 on it is checked by default
	ExtrasOptionen
    Kontext "ExtrasOptionenDLG"
    Call hToolsOptions("LanguageSettings","WritingAids")
    Optionen.Select 1
	Select Case sEnable
		Case true
			Optionen.Check
		Case false
			Optionen.UnCheck
	end select		
	Kontext "ExtrasOptionenDLG"
	ExtrasOptionenDLG.Ok

end sub

'*******************************************************************

sub wEnableHyphenation(sEnable as boolean)
    '/// This function enables/disables hyphenation
    '/// through Format / Paragraph / Textflow
    Call hNewDocument
    FormatParagraph
    Kontext
    Active.SetPage TabTextfluss
    kontext "TabTextfluss"    
    Select Case sEnable
        case true        
            Automatisch.Check
        case false
            Automatisch.UnCheck
    end select
    TabTextfluss.OK
    Call hCloseDocument

end sub
