'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_chinesetranslate.bas,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:26:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner :  helge.delfs@sun.com
'*
'* short description : Test Chinese Translation
'*
'\*******************************************************************

sub main

   Dim StartZeit
   Dim bAsianLanguage   as Boolean
   Dim DefaultLanguage  as String
   
   StartZeit = Now()

   use "writer\tools\inc\w_tools.inc"
   use "writer\tools\inc\w_tool3.inc"
   use "writer\level1\inc\tools\tools1.inc"
   use "writer\level1\inc\tools\tools2.inc"
   use "writer\level1\inc\chinesetranslate\w_chinesetranslate1.inc"
   use "writer\level1\inc\chinesetranslate\w_chinesetranslate2.inc"
   
   printlog Chr(13) + "Loading of Include - Files takes: " + Wielange ( StartZeit )
   printlog Chr(13) + "******* Writer - Level 1 - Test *******"

   Call hStatusIn ( "writer", "w_chinesetranslate.bas" , "Chinese Translation" )
 
   printlog Chr(13) + "      - Test Chinese Translation"
      
    'Enable 'Asian Language support' ON
     bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)
   ' Set default language(asian) for document is "Simplified Chinese"
     DefaultLanguage = fSetAsian(fGetLanguageName(86))

     printlog Chr(13) + " -- Default setting -- "  

     'Don't need to run this case - tDefaultSetting_1
     'Call tDefaultSetting_1
     Call tDefaultSetting_2
     Call tDefaultSetting_3
     
     printlog Chr(13) + " -- Standard Function -- "
     Call tChineseTranslate_1
     Call tChineseTranslate_2
     Call tChineseTranslate_3
     Call tChineseTranslate_4
     'Mark this case , since we don't use 'Use Taiwan , Hongkong SAR...'s statue so far
     'Call tChineseTranslate_5

     printlog Chr(13) + " -- Chinese Dictionary -- "
     Call tChineseTranslate_6
     Call tChineseTranslate_7
     Call tChineseTranslate_8
     Call tChineseTranslate_9
     Call tChineseTranslate_10
     Call tChineseTranslate_11

     printlog Chr(13) + " -- Undo/Redo -- "
     Call tUndoRedo
                                               
   'Set default language(asian) to default
     Call fSetAsian(DefaultLanguage)

    'Set the 'Asian Language support' to default
     if bAsianLanguage = FALSE then
         Call ActiveDeactivateAsianSupport(FALSE)
     end if
                          
   Call hStatusOut

   Printlog Chr(13) + "End of Level 1 Test - Chinese Conversion"
   Printlog "Duration: "+ WieLange ( StartZeit )
   Printlog "Date: " +  Date + "    Time: " + Time

end sub

sub LoadIncludeFiles
   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   Call GetUseFiles
   gApplication = "Writer"
end Sub
