'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: wh_o_4.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:27:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub wh_o_4
   'Call tToolsOptionsHTMLSourceText : removed > srx642y
   'Call tToolsOptionsHTMLBackground : removed > srx642y
end sub

'------------------------------------------------------------------------------
testcase tToolsOptionsHTMLSourceText

'/ SourceText                     ///'
'/ ----------                     ///'
'/ tToolsOptionsHTMLSourceText    ///'
'/ normal                         ///'
'/ Function: only manual possible! ///'
'/                                ///'

   dim iListBox(4) as integer         ' ListBox
   dim iTempListBox(4) as integer
   Dim IsViewHTMLSource as Boolean


'iListBox(i) / iTempListBox(i)
'(1) = SGML
'(2) = Kommentar
'(3) = Schluesselwort
'(4) = Unbekannt

   hNewDocument
  printlog "'///- Tools/Options/HTML: SourceText ///"

  printlog ("'/// - save states ///")
    ToolsOptions
    hToolsOptions ("HtmlDocument","SOURCE")

      iListBox(1) = SGML.GetSelIndex
      iListBox(2) = Kommentar.GetSelIndex
      iListBox(3) = Schluesselwort.GetSelIndex
      iListBox(4) = Unbekannt.GetSelIndex

      printlog ("'/// - all states inverting ///")

      If ( SGML.GetItemCount           <> iListBox(1) ) Then SGML.Select           (iListBox(1) + 1) Else SGML.Select           (iListBox(1) - 1)
      If ( 1                           <> iListBox(2) ) Then Kommentar.Select      (iListBox(2) - 1) Else Kommentar.Select      (iListBox(2) + 1)
      If ( Schluesselwort.GetItemCount <> iListBox(3) ) Then Schluesselwort.Select (iListBox(3) + 1) Else Schluesselwort.Select (iListBox(3) - 1)
      If ( 1                           <> iListBox(4) ) Then Unbekannt.Select      (iListBox(4) - 1) Else Unbekannt.Select      (iListBox(4) + 1)
      iTempListBox(1) = SGML.GetSelIndex
      iTempListBox(2) = Kommentar.GetSelIndex
      iTempListBox(3) = Schluesselwort.GetSelIndex
      iTempListBox(4) = Unbekannt.GetSelIndex

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

  printlog ("'/// - SO quit - start ///")

  wOfficeRestart

'--------------------------------------------------------------------------
'/// Function test: Syntax Highlighting ///'
   '///+ uses "input\\writer\\options\\htmltag.html" ///
   hDateiOeffnen ( gTesttoolPath + "writer\level1\input\options\htmltag.html" )

'///+ Check if we are in HTML-Source-View ///'
   try
      FormatObject
   catch
      kontext "Funktionsleiste"
      Bearbeiten.click                   ' maybee theres something missing :-) TBO
   endcatch
   sleep (3)

   try
      ViewZoom
      kontext "massstab"
      massstab.cancel
      IsViewHTMLSource = False
   catch
      IsViewHTMLSource = True
   endcatch

   if True <> IsViewHTMLSource Then
      AnsichtHTMLQuelltext ' THE ONLY ONE THAT WORKS
   end if
' Now we are in HTML-Source-View

'  printlog "Screenshot taken: " + ScreenShot ("h_st_hig")
      AnsichtHTMLQuelltext
   hCloseDocument
'--------------------------------------------------------------------------

  printlog ("'/// - checking states ///")
    ToolsOptions
    hToolsOptions ("HtmlDocument","SOURCE")

      If ( SGML.GetSelIndex           <> iTempListBox(1) ) Then WarnLog "SGML           state changed"
      If ( Kommentar.GetSelIndex      <> iTempListBox(2) ) Then WarnLog "Kommentar      state changed"
      If ( Schluesselwort.GetSelIndex <> iTempListBox(3) ) Then WarnLog "Schluesselwort state changed"
      If ( Unbekannt.GetSelIndex      <> iTempListBox(4) ) Then WarnLog "Unbekannt      state changed"

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

  printlog ("'/// - all UnCheck -> o ///")
    ToolsOptions
    hToolsOptions ( "HtmlDocument" , "SOURCE" )

      SGML.Select           (1)
      Kommentar.Select      (1)
      Schluesselwort.Select (1)
      Unbekannt.Select      (1)

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

  printlog ("'/// - check if all UnChecked ///")
    ToolsOptions
    hToolsOptions ( "HtmlDocument" , "SOURCE" )

      If ( SGML.GetSelIndex           <> 1 ) Then WarnLog "SGML           is not item 1"
      If ( Kommentar.GetSelIndex      <> 1 ) Then WarnLog "Kommentar      is not item 1"
      If ( Schluesselwort.GetSelIndex <> 1 ) Then WarnLog "Schluesselwort is not item 1"
      If ( Unbekannt.GetSelIndex      <> 1 ) Then WarnLog "Unbekannt      is not item 1"

      Printlog ("'/// - all Check -> x ///")

      SGML.Select          (SGML.GetItemCount          )
      Kommentar.Select     (Kommentar.GetItemCount     )
      Schluesselwort.Select(Schluesselwort.GetItemCount)
      Unbekannt.Select     (Unbekannt.GetItemCount     )

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

  printlog ("'/// - check if all Checked ///")
    ToolsOptions
    hToolsOptions ( "HtmlDocument" , "SOURCE" )

      If ( SGML.GetSelIndex           <> SGML.GetItemCount           ) Then WarnLog "SGML           is not item (GetItemCount)"
      If ( Kommentar.GetSelIndex      <> Kommentar.GetItemCount      ) Then WarnLog "Kommentar      is not item (GetItemCount)"
      If ( Schluesselwort.GetSelIndex <> Schluesselwort.GetItemCount ) Then WarnLog "Schluesselwort is not item (GetItemCount)"
      If ( Unbekannt.GetSelIndex      <> Unbekannt.GetItemCount      ) Then WarnLog "Unbekannt      is not item (GetItemCount)"

  printlog ("'/// - restore states ///")

      SGML.Select           (iListBox(1))
      Kommentar.Select      (iListBox(2))
      Schluesselwort.Select (iListBox(3))
      Unbekannt.Select      (iListBox(4))

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

   hCloseDocument
endcase


testcase tToolsOptionsHTMLBackground

'/ Background                       ///'
'/ ----------                       ///'
'/ tToolsOptionsHTMLBackground      ///'
'/ NO TEST AVAIL                    ///'
' Function: not yet!               ///'
'/                                  ///'
'/ No test available (can't be controled :-() ///'
'/     Hintergrundfarbe       HID_BACKGROUND_CTL_BGDCOLORSET    ///'
'/                                  ///'
'/ just calling the TabPage :->     ///'
'/                                  ///'

'----in Format->Page->Backround:
'Durchsuchen            svx:PushButton:RID_SVXPAGE_BACKGROUND:BTN_BROWSE
'Verknuepfen            svx:CheckBox:RID_SVXPAGE_BACKGROUND:BTN_LINK
'Vorschau               svx:CheckBox:RID_SVXPAGE_BACKGROUND:BTN_PREVIEW
'Position               svx:RadioButton:RID_SVXPAGE_BACKGROUND:BTN_POSITION
'Flaeche                svx:RadioButton:RID_SVXPAGE_BACKGROUND:BTN_AREA
'Kachel                 svx:RadioButton:RID_SVXPAGE_BACKGROUND:BTN_TILE
'ArtPosition            HID_BACKGROUND_CTL_POSITION
'Als                    svx:ListBox:RID_SVXPAGE_BACKGROUND:LB_SELECTOR
'Fuer                   svx:ListBox:RID_SVXPAGE_BACKGROUND:LB_TBL_BOX
'FuerAbsatz             svx:ListBox:RID_SVXPAGE_BACKGROUND:LB_PARA_BOX
'------------------------------------------------------------------------------
   hNewDocument
  printlog "'///- Tools/Options/HTML: Content ///"

'/// TBO: not realy a test ;-) ///'

  printlog ("'/// - save states ///")
    ToolsOptions
    hToolsOptions ("HtmlDocument","BACKGROUND")

'   setcontroltype ctbrowsebox
'   try
'      printlog "3"+Hintergrundfarbe.GetItemText
'print "1"
'   catch
'      printlog "2"+Hintergrundfarbe.GetSelText
'print "1"
'      printlog "1"+Hintergrundfarbe.GetText
'print "1"
'   endcatch
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
   hCloseDocument
endcase

