'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_hyphenation.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: hde $ $Date: 2006/03/16 12:36:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : hyphenation functionality test
'*
'************************************************************************
'*
' #1 tHyphenation_1
' #1 tHyphenation_2
' #1 tHyphenation_3
'*
'\***********************************************************************


testcase tHyphenation_1

  Dim testFile, testWord                        as String
  Dim firstPartOfTestWord ,secondPartOfTestWord as String

  testFile             =  "tHyphenation.odt"
  testWord             =  "following"
  firstPartOfTestWord  =  "fol"
  secondPartOfTestWord =  "follow"

  PrintLog "- Test Hyphenation  using ctrl and -"

   '/// Test Hyphenation  using ctrl and -

   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\hyphenation\" + testFile )

    Call wDokSchreiben "<End><Shift Mod1 Left>"

    EditCopy

   '/// add "-" between 'fol' and 'lowing' , then press 3 times 'space bar'
   '/// + check if fol in the end of the line
    if GetClipboardText = testWord then
         Call wDokSchreiben "<Right>" , 3
         Call wDokSchreiben "<Mod1 SUBTRACT>"
         Call wDokSchreiben "<Home>"
         Call wDokSchreiben "<SPACE>" ,3

         Call wDokSchreiben "<End><Left><Shift Mod1 Left>"
         EditCopy

         if  GetClipboardText <> firstPartOfTestWord then
             Warnlog "The hyphenation does NOT work well in first part!"
         end if

        '/// add "-" between 'follow' and 'ing' , then press 3 times 'space bar'
        '/// + check if follow in the end of the line .
         Call wDokSchreiben "<Mod1 z>",2
         Call wDokSchreiben "<End>"
         Call wDokSchreiben "<Left>",3
         Call wDokSchreiben "<Mod1 SUBTRACT>"
         Call wDokSchreiben "<Home>"
         Call wDokSchreiben "<SPACE>",3

         Call wDokSchreiben "<End><Left><Shift Mod1 Left>"
         EditCopy

         if  GetClipboardText = secondPartOfTestWord then
             Call wDokSchreiben "<Home>"

         '/// press 5 times 'space bar'
         '/// check if fol in the end of the line .
             Call wDokSchreiben "<SPACE>" , 5

             Call wDokSchreiben "<End><Shift Mod1 Left>"
             EditCopy

             if  GetClipboardText <> firstPartOfTestWord then
                Warnlog "The hyphenation does NOT work well in first part, but it works fine in second part!"
             end if
         else
             Warnlog "The hyphenation does NOT work well in second part!"
         end if

    else
         Warnlog "The test word is wrong !!"
    end if

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tHyphenation_2

  Dim testFile, testWord                        as String
  Dim firstPartOfTestWord ,secondPartOfTestWord as String
  Dim testWordInHyphenationDlg                  as String

  testFile                 =  "tHyphenation.odt"
  testWord                 =  "following"
  testWordInHyphenationDlg =  "fol=low-ing"
  firstPartOfTestWord      =  "fol"
  secondPartOfTestWord     =  "follow"

  PrintLog "- Test Hyphenation  using Tools/Hyphenation ,test like fol-lowing"

   '/// Test Hyphenation  using Tools/Hyphenation ,test like fol-lowing

   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\hyphenation\" + testFile )

    Call wDokSchreiben "<End><Shift Mod1 Left>"

    EditCopy

    if GetClipboardText <> testWord then
         Warnlog "The test word is wrong !!"
         goto endsub
    end if

   '/// Press 3 times 'space bar'
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<SPACE>" ,3

   '/// Tools/Hyphenation
    ToolsLanguageHyphenate
    Kontext "Silbentrennung"

    if Not Silbentrennung.Exists then
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Active.Ok

                Kontext "Active"
                if Active.Exists then
                    if Active.GetRT = 304 then Active.Ok
                end if
            end if
        end if
        Warnlog "Unable to bring up Dialog 'Hyphenation'!"
        goto endsub
    end if

   '/// check if get 'fol=low-ing'
    if Wort.Gettext <> testWordInHyphenationDlg then
        Warnlog "#i40561# The test can NOT be seperated two times , or something wrong!"
        Silbentrennung.Cancel
        goto NOTest
    end if

    if NOT Vor.IsEnabled then
        Warnlog "the Vor button is Not enabled, or something wrong!"
        Silbentrennung.Cancel
        goto NOTest
    end if

   '/// add "-" between 'fol' and 'lowing' using left arrow key
    Vor.Click
    Silbentrennung.OK

   '/// Close all dialogue, and recover the file to default
    Kontext "Active"
    if NOT Active.Exists then
        Kontext "Silbentrennung"
        Silbentrennung.Cancel
        Warnlog "The first message box is NOT pop up"
        goto NOTest
    end if

    Active.Yes

    Kontext "Active"
    if NOT Active.Exists then
        Warnlog "The second message box is NOT pop up"
        goto endsub
    end if

    Active.OK

   '/// Press 3 times 'space bar' in front of the line
    Call wDokSchreiben "<BACKSPACE>",3
    Call wDokSchreiben "<SPACE>",3

    Call wDokSchreiben "<End><Left><Shift Mod1 Left>"
    EditCopy

   '/// Check if get "fol"
    if GetClipboardText <> firstPartOfTestWord then
        Warnlog "The hyphenation does NOT work well in first part!"
    end if

NOTest:
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tHyphenation_3

  Dim testFile, testWord                        as String
  Dim firstPartOfTestWord ,secondPartOfTestWord as String
  Dim testWordInHyphenationDlg1                 as String
  Dim testWordInHyphenationDlg2                 as String

  testFile                  =  "tHyphenation.odt"
  testWord                  =  "following"
  firstPartOfTestWord       =  "fol"
  secondPartOfTestWord      =  "follow"
  testWordInHyphenationDlg1 =  "fol=low-ing"
  testWordInHyphenationDlg2 =  "fol-low=ing"

  PrintLog "- Test Hyphenation  using Tools/Hyphenation ,test like follow-ing"

   '/// Test Hyphenation  using Tools/Hyphenation ,test like follow-ing

   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\hyphenation\" + testFile )

    Call wDokSchreiben "<End><Shift Mod1 Left>"

    EditCopy

    if GetClipboardText <> testWord then
        Warnlog "The test word is wrong !!"
        goto endsub
    end if

   '/// Press 3 times 'space bar'
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<SPACE>" ,3

   '/// Tools/Hyphenation
    ToolsLanguageHyphenate
    Kontext "Silbentrennung"

    if Not Silbentrennung.Exists then
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Active.Ok

                Kontext "Active"
                if Active.Exists then
                    if Active.GetRT = 304 then Active.Ok
                end if
             end if
        end if
        Warnlog "Unable to bring up Dialog 'Hyphenation'!"
        goto endsub
    end if

   '/// check if get "fol=low-ing"
    if Wort.Gettext <> testWordInHyphenationDlg1 then
        Warnlog "#i40561# The test can NOT be seperated two times , or something wrong!"
        Silbentrennung.Cancel
        goto NOTest
    end if

   '/// click left arrow key
    if NOT Vor.IsEnabled then
        Warnlog "the Vor button is Not enabled, or something wrong!"
        Silbentrennung.Cancel
        goto NOTest
    end if
    Vor.Click

   '/// check if get "fol-low=ing"
    if Wort.Gettext <> testWordInHyphenationDlg2 then
        Warnlog "The test  word should be changed after clicking Vor!"
        goto endsub
    end if

   '/// add "-" between 'follow' and 'ing' pressing right arrow key
    if NOT Zurueck.IsEnabled then
        Warnlog "the Zuruech button is Not enabled, or something wrong!"
        goto endsub
    end if
    Zurueck.Click

   '/// check if get "fol-low=ing"
    if Wort.Gettext <> testWordInHyphenationDlg1 then
         Warnlog "The test  word should be changed after clicking Zurueck!"
         goto endsub
    end if

    Sleep 1

   '/// close all dialogue
    Silbentrennung.OK

    Kontext "Active"
    if NOT Active.Exists then
          Warnlog "The first message box is NOT pop up"
          goto endsub
    end if

    Active.Yes

    Kontext "Active"
    if NOT Active.Exists then
          Warnlog "The second message box is NOT pop up"
          goto endsub
    end if

    Active.OK

   '/// recover to the default file and press 3 sparc bar in front of the line
    Call wDokSchreiben "<BACKSPACE>",3
    Call wDokSchreiben "<SPACE>",3

    Call wDokSchreiben "<End><Left><Shift Mod1 Left>"
    EditCopy

   '/// check if get "follow" in the end of the line
    if GetClipboardText = secondPartOfTestWord then
        Call wDokSchreiben "<Home>"
        Call wDokSchreiben "<SPACE>" , 5

        Call wDokSchreiben "<End><Shift Mod1 Left>"
           EditCopy

           if GetClipboardText <> firstPartOfTestWord then
               Warnlog "The hyphenation does NOT work well in first part, but it works fine in second part!"
           end if
    else
        Warnlog "The hyphenation does NOT work well in second part!"
    end if
NOTest:
   Call hCloseDocument

endcase
