'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_104_.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:26:19 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_104_
   printLog Chr(13) + "---------   Level 1  - Menu / Insert Part 1 -  ----------"

   Call tInsertManualBreak
   Call tInsertFields
   Call tInsertSpecialCharacter1
   Call tInsertSpecialCharacter2

   Call tInsertSection
   Call tInsertHyperlink

   Call tInsertFootnote
   Call tInsertCaption

end sub

'***********************************************************************

testcase tInsertManualBreak
  Dim sRightPage as integer
   '/// Insert / Manual Break ///
  PrintLog "- Insert / Manual Break"
   Select Case iSprache
    Case 01 : sRightPage = 7
    Case 31 : sRightPage = 6
    Case 33 : sRightPage = 4
    Case 34 : sRightPage = 3
    Case 39 : sRightPage = 4
    Case 46 : sRightPage = 4
    Case 49 : sRightPage = 4
    Case 81 : sRightPage = 2
    Case 82 : sRightPage = 4
    Case 86 : sRightPage = 3
    Case 88 : sRightPage = 3
    Case else : Warnlog "Determine the right style entry for this language!"
                goto endsub
   end select

   '/// New Document ///
   Call hNewDocument
   Call wDokSchreiben "Zeilenumbruch"
   printlog "  - Line break"
   '/// Open dialog 'Insert break' with Insert / Manual Break  ///
   InsertManualBreak
   Kontext "UmbruchEinfuegen"
   '/// Check 'line break' . Combobox Style should be disabled ///
   Zeilenumbruch.Check
   if Vorlage.IsEnabled then Warnlog "When selecting line break Combobox Style is active"
   UmbruchEinfuegen.OK
   '/// In document, check if line break has been inserted ///
   Call wDokSchreiben "<Left><Shift Home>"
   EditCopy
   Sleep 1
   if GetClipboardText <> "Zeilenumbruch" then Warnlog "A line break has not been inserted"
   Call wDokSchreiben "<End><Return>"

   printlog "- Page break with 3rd Style and Page number changed to 4"
   '/// Insert a page break with 3rd Style and change pagenumber to '4' ///
   InsertManualBreak
   Kontext "UmbruchEinfuegen"
   '/// Call dialog with 'Insert / Manual Break and in dialog check 'page break' ///
   Seitenumbruch.Check
   '/// Select Style Number 7 (Right Page) ///
   ' Select entry 'right page' depending on the language

   Vorlage.Select sRightPage        ' Right Page
   '/// Check 'Change Page number' and change number to 4 ///
   SeitennummerAendern.Check
   Seitennummer.SetText "4"
   UmbruchEinfuegen.OK
   '/// When closing dialog a messagebox has to appear : Unable to select uneven Page Numbers when selecting 'Right Page' ///
   kontext "Messagebox"
   if Messagebox.Exists then
      Messagebox.OK
      '/// Change Pagenumber to 3 ///
      Kontext "UmbruchEinfuegen"
      Seitennummer.SetText "3"
      UmbruchEinfuegen.OK
      Sleep 1
      '/// Check if break has been inserted ///
      InsertFieldsPageNumbers
      Call wDokSchreiben "+0<Shift Home>"
      ToolsCalculate
      Sleep 1
      if GetClipboardText <> "3" then Warnlog "Maybe no page break has been inserted. Page Number is not 3 but " + GetClipboardText
   else
      Warnlog "Unable to select uneven Page Numbers when selecting 'Right Page'"
      Kontext "UmbruchEinfuegen"
      if UmbruchEinfuegen.Exists then UmbruchEinfuegen.Cancel
   end if

   Call wDokSchreiben "<Backspace>"
   '/// Insert in document a column break ///

   printlog "- Column break"
   Call wDokSchreiben "Hello World"
   Call wDokSchreiben "<Left>",5
   '///+ Call Format / Page / Writer ///
   FormatPageWriter
   Sleep 1
   Kontext
   Active.SetPage TabSpalten
   Kontext "Active"
   if Active.GetRT = 304 then Active.Yes

   Kontext
   Active.SetPage TabSpalten
   '///+ Select Tabpage 'Columns' ///
   Kontext "TabSpalten"
   '///+ Enter as as amount '2' ///
   Anzahl.SetText "2"
   TabSpalten.OK
   '///+  Select Insert / Manual Break ///
   InsertManualBreak
   Kontext "UmbruchEinfuegen"
   Spaltenumbruch.Check
   '///+ Check 'column break' and close dialog with ok ///
   if Vorlage.IsEnabled then Warnlog "On Column break Combobox Style is active"
   UmbruchEinfuegen.OK
   '///+ Check if column break has been inserted ///
   Call wDokSchreiben "<End><Shift Home>"
   EditCopy
   if GetClipboardtext <> "World" then Warnlog "Column break has not been inserted!"
   Sleep 1
   Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertFields
  Dim Gesamtzaehler as Integer
   '/// Insert / Fields ///

  PrintLog "- Insert / Fields"
   '/// Open file ../input/writer/stufe1/st1_14.sxw  ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\st1_14.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\st1_14.sxg" )
   endif
   Kontext "OL_SW"
   Schriftgroesse.Select 1
   Schriftgroesse.TypeKeys "<Return>"
   Kontext
   '/// Select any field on any tabpage and insert into document ///

   InsertFieldsOther
   Gesamtzaehler = uTabDokument
   Gesamtzaehler = Gesamtzaehler + uTabReferenzen
   Gesamtzaehler = Gesamtzaehler + uTabFunktionen
   Gesamtzaehler = Gesamtzaehler + uTabDokumentinfo
   Gesamtzaehler = Gesamtzaehler + uTabVariablen
   Gesamtzaehler = Gesamtzaehler + uTabDatenbank

   Kontext
   Active.SetPage TabDokumentFeldbefehle
   Kontext "TabDokumentFeldbefehle"
   Schliessen.Click
  printlog "  - Number of inserted Fields is: " + Gesamtzaehler

 printlog "  - Load document / save / close / load / close"
   '/// Save document ///
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath + "user\work\InsertFields.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath + "user\work\InsertFields.sxg" )
   endif
   Sleep 2
   Call hCloseDocument
   Sleep 2
   FileOpen
   Kontext "OeffnenDlg"
   '/// Close and reload previous saved document ///
   if gApplication = "WRITER" then
    Dateiname.SetText ( ConvertPath ( gOfficePath + "user\work\InsertFields.sxw" ) )
   else
    Dateiname.SetText ( ConvertPath ( gOfficePath + "user\work\InsertFields.sxg" ) )
   endif
   Sleep 1
   Oeffnen.Click
   Sleep 2
   '///+ a messagebox has to appear, asking to update the fields (if checked in Options) ///
   Kontext "Active"
   if Active.Exists(2) then
      Active.No
   end if
   '/// Close document ///

   Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertSpecialCharacter1
    Dim i : Dim j : Dim Zaehler
    Dim sSchriftArt : Dim Zufall as Integer
    PrintLog "- Insert / Special Character"


    Call hNewDocument
    '/// New writerdocument ///
    SetClipBoard = ""
    printlog "  - Deleting in Special Character Dialog"
    '/// Insert / Special Character ///
    InsertSpecialCharacterWriter
    Kontext "Sonderzeichen"
    for j=1 to 10
        Schrift.Select 5
        Zufall = Int((12 * Rnd) +1)
        SchriftListe.TypeKeys "<Right>", Zufall
        SchriftListe.TypeKeys "<Space>"
    next j
    Sleep 1
    '/// Select any Character and cllick 'delete' ///
    Loeschen.Click
    Sleep 3
    try
        Sonderzeichen.OK
    catch
        Sonderzeichen.Cancel
    endcatch
    '/// Close dialog ///
    Sleep 2
    Call wDokSchreiben "<Shift Home>"
    try
        EditCopy
    catch
    endcatch
    if GetClipboardText <> "" then Warnlog "Remaining data after deleting in special character dialog"

    InsertSpecialCharacterWriter
    Kontext "Sonderzeichen"
    Zaehler = Schrift.GetItemCount
    printlog "- Inserting all Fonttypes with a random of 10 in a document"
    '/// Inserting all Fonttypes with a random of 10 in a document ///
    if gSamePC = 0 then printlog "-  Remote not 'Nil' and 'Fixed' , because Exceed GPF'S hier!"
    for i=1 to Zaehler
        if gSamePC = 0 then
            if Ucase(Left$(Schrift.GetItemText(i),3)) = "FIX" then
                Schrift.Select i + 1
                'if Ucase(Left$(Schrift.GetItemText(i),3)) = "FIX" then Schrift.Select i + 1
            else
                Schrift.Select i
            endif
        else
            Schrift.Select i
        endif
        sSchriftArt = Schrift.GetSelText
        for j=1 to 10
            Zufall = Int((12 * Rnd) +1)
            SchriftListe.TypeKeys "<Right>", Zufall
            SchriftListe.TypeKeys "<Space>"
        next j
        Sonderzeichen.OK
        Call wDokSchreiben "<Tab>"
        Call wDokSchreiben ":vom Schrifttyp " + sSchriftArt + "<Return>"
        InsertSpecialCharacterWriter
        Kontext "Sonderzeichen"
        Sleep 1
    next i
    Sonderzeichen.Cancel
    Sleep 3
    '/// Save document///
    if gApplication = "WRITER" then
        Call hSpeichernUnterKill ( gOfficepath + "user\work\sonderz.sxw" )
    else
        Call hSpeichernUnterKill ( gOfficepath + "user\work\sonderz.sxg" )
    endif
    Call hCloseDocument
    '/// Close document and reopen previous saved document ///
    if gApplication = "WRITER" then
        Call hDateiOeffnen ( gOfficePath + "user\work\sonderz.sxw" )
    else
        Call hDateiOeffnen ( gOfficePath + "user\work\sonderz.sxg" )
    endif
    '/// Close document ///
    Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertSpecialCharacter2
 Dim sSchriftType : Dim Zufall as Integer : Dim sSchriftname as String
 Dim i as integer, j as integer
 if gPlatgroup = "unx" then
    sSchriftname= "Times"
 else
    sSchriftname ="Times New Roman"
 endif

 Call hNewDocument
 PrintLog "- Insert all characters of font Times New Roman"
 '/// Insert all characters of font Times New Roman ///
 Call wDokSchreiben "Insert all characters of font Times New Roman<Return>"

 For j = 1 to 50
    InsertSpecialCharacterWriter
    Kontext "Sonderzeichen"
    Schrift.Select sSchriftname
    Select Case j
       Case 1
          Schriftliste.TypeKeys "<HOME>"
       Case else
          i = (j - 1) * 20
          Schriftliste.TypeKeys "<HOME>"
          Schriftliste.TypeKeys "<RIGHT>", i
    end select

    for i =1 to 20
        Schriftliste.TypeKeys "<RIGHT>",1
        Schriftliste.TypeKeys "<SPACE>"
        Sleep 1
    next i
    Sonderzeichen.OK
    Call wDokSchreiben "<Return>"
    sleep 5
 next j
 if gApplication = "WRITER" then
    Call hSpeichernUnter (gOfficePath + "user\work\specialcharacter.sxw")
 else
    Call hSpeichernUnter (gOfficePath + "user\work\specialcharacter.sxg")
 endif
 Call hCloseDocument

endcase


'***********************************************************************

testcase tInsertSection
  DIM message$
  PrintLog "- Insert / Section"
  '/// Insert /Section ///

   Call hNewDocument
    '/// New document ///
   ToolsOptions
   Call hToolsOptions("TextDocument","FormattingAids")
   '///+ Open options and check 'Direct-Cursor' in options ///
   Zonen_Cursor.Check
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK


   Call wDokSchreiben "Section: protected<Return>Section: protected with password<Return>"
   Call wDokSchreiben "Section: hidden<Return>Section: linked<Home>"
   Call wDokSchreiben "<up>" , 4
   Call wDokSchreiben "<Shift End>"
   '///+ Insert a protected section  ///

  PrintLog "  - protected section"
   InsertSection
   Sleep 3
   Kontext
   Active.Setpage TabBereiche
   Kontext "TabBereiche"
   Bereichsliste.Settext "protected"
   Geschuetzt.Check
   TabBereiche.OK
   EditCopy
   if GetClipBoardtext = "Section: protected" then
     Call wDokSchreiben "<Home>"
     Call wDokSchreiben "<Space>"
     Kontext "Active"
     If Active.Exists then
      Active.ok
     else
      Warnlog "-  No warning when trying to write in protected area!"
     endif
   else
     Warnlog "Testtool couldn't find the protected area!"
   endif

   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Down>"
   Call wDokSchreiben "<Shift End>"

  PrintLog "  - protected section with password"
   '///+ Insert a protected section with password ///
   InsertSection
   Sleep 3
   Kontext
   Active.Setpage TabBereiche
   Kontext "TabBereiche"
   Bereichsliste.Settext "with password"
   if Passwort.IsEnabled then Warnlog "'With Password' is enabled, though 'Protect' is not checked! (#87559#)"
   Geschuetzt.Check
   if Passwort.IsEnabled then
    Passwort.Check
    Kontext "BereicheSchuetzen"
    if BereicheSchuetzen.NotExists then
     Kontext "TabBereiche"
      EnterPasswort.Click
       Kontext "BereicheSchuetzen"
        if BereicheSchuetzen.NotExists then
          Warnlog "Unable to enter passwort for section, because dialog is not up!"
        else
          PasswortName.Settext "protectedarea"
          PasswortBestaetigen.Settext "protectedarea"
          BereicheSchuetzen.Ok
        endif
    else
     PasswortName.Settext "protectedarea"
     PasswortBestaetigen.Settext "protectedarea"
     BereicheSchuetzen.Ok
    endif
   else
    Warnlog "'With Password' is disabled, though 'Protect' is checked!"
   endif

   Kontext "TabBereiche"
   TabBereiche.OK
   EditCopy
   if GetClipBoardtext = "Section: protected with password" then
     Call wDokSchreiben "<Home>"
     Call wDokSchreiben "<Space>"
     Kontext "Active"
     If Active.Exists then
      Active.ok
     else
      Warnlog "-  No warning when trying to write in protected area!"
     endif
   else
     Warnlog "Testtool couldn't find the protected area!"
   endif

   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Down>"
   Call wDokSchreiben "<Shift End>"

  PrintLog "  - hidden section"
   '///+ Insert a hidden section ///
   InsertSection
   Kontext
   Active.Setpage TabBereiche
   Kontext "TabBereiche"
   Bereichsliste.Settext "hidden Section"
   Ausblenden.Check
   TabBereiche.OK
   Call wDokSchreiben "<Home><Shift End>"
   EditCopy
   if GetClipboardText = "Section: hidden" then
    Warnlog "- hidden section without function, section is visible!"
    Call wDokSchreiben "<Home><Down>"
   endif

  PrintLog "  - linked section"
   '///+ Insert a linked section ///
   InsertSection
   Kontext
   Active.Setpage TabBereiche
   Kontext "TabBereiche"
   Bereichsliste.Settext "linked Section"
   Verknuepfung.Check

   Kontext "MessageBox"
   if Messagebox.Exists then
     Messagebox.No
     wait 500
    Kontext "TabBereiche"
    if Verknuepfung.IsChecked then
     Warnlog "Checkbox Link should be unchecked after denying the messagebox!"
    else
       Verknuepfung.Check
       Kontext "MessageBox"
        if Messagebox.Exists then Messagebox.Yes
    endif
   else
     Warnlog "No warning that the content of the current section will be overwritten!"
   endif

   Kontext "TabBereiche"
   Auswaehlen.Click
   Kontext "OeffnenDlg"
   Dateiname.SetText ConvertPath ( gTesttoolPath +"writer\level1\input\senden.sxw" )

   Sleep 2
   Oeffnen.Click
   Kontext "TabBereiche"
   Geschuetzt.Uncheck
   TabBereiche.OK
   Sleep 10

   Call wDokSchreiben "<Up>",3
   Call wDokSchreiben "<Home><Shift End>"
   EditCopy
   if GetClipboardText = "Hallo" then Warnlog "Linked section without function"
   Sleep 5
   Call wDokSchreiben "<PageUp>"

  printlog "  - Document save/close/load/close"
   '/// Save document / close and reload previous saved document ///
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath + "user\work\section.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath + "user\work\section.sxg" )
   endif
   Sleep 2
   Call hCloseDocument
   Sleep 5
   if gApplication = "WRITER" then
    Call hDateiOeffnen (gOfficePath + "user\work\section.sxw",true)
   else
    Call hDateiOeffnen (gOfficePath + "user\work\section.sxg",true)
   endif
   Sleep 5
   '///+ check properties of previous entered sections ///
   Call wDokSchreiben "<Up>",10
   wait 500
   Call wDokSchreiben "<Mod1 Home>"
   Call wDokSchreiben "z"
   Kontext
   if Active.NotExists then
                warnlog "No warning when trying to write in protected section!"
        else
                Active.OK
   endif
   Call wDokSchreiben "<Down><Home><Shift End>"
   Call wDokSchreiben "z"
   Kontext
   if Active.NotExists then
                warnlog "No warning when trying to write in password protected section!"
        else
                Active.OK
   endif
   Call wDokSchreiben "<Down><Home><Shift End>"
   EditCopy
   if GetClipboardText = "Section: hidden" then Warnlog "Hidden Section is visible after reload without function"
   Call wDokSchreiben "<Down><Home><Shift End>"
   EditCopy
   if GetClipboardText = "Section: linked" then Warnlog "Linked Section without function"
   Sleep 1
   '/// Close document ///
   Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertHyperlink
  PrintLog "- Insert / Hyperlink"
  Dim Hyperform as string
  Select case iSprache
   case 01 : Hyperform = "Text"
   case 03 : Hyperform = "Texto"
   case 31 : Hyperform = "Tekst"
   case 33 : Hyperform = "Texte"
   case 34 : Hyperform = "Texto"
   case 39 : Hyperform = "Testo"
   case 45 : Hyperform = "Tekst"
   case 46 : Hyperform = "Text"
   case 48 : Hyperform = "Tekst"
   case 49 : Hyperform = "Text"
   case else : if bAsianLan = False then Warnlog "Languagesupport is missing !"
  end select

  Call  hNewDocument
   '/// New document ///

  printlog "  - inserting a hyperlink"
   InsertHyperlink
   '/// Insert / Hyperlink ///
   Sleep 5
   wEinfuegenHyperlink(1)
   Kontext "TabHyperlinkInternet"
   '///+ Check 'Internet' and enter some data ///
   Internet.Check
   ZielURL.SetText "www.mikeportnoy.com"
   Hinweis.SetText "Hier bitte klicken !!!"
   NameText.SetText "Ein Link mit dem Testtool"
   Frame.Select "_top"
   if Hyperform > "" then
    Form.Select Hyperform
   else
    printlog Form.GetSelText
   endif
   Kontext "Hyperlink"
   '/// Click 'Apply' and close dialog ///
   Uebernehmen.Click
   Hyperlink.Close

   Call wDokSchreiben "<Left>"

   '///+ Change fontsize to '80' ///
   FormatCharacter
   Kontext
   Active.SetPage TabFont
   Kontext "TabFont"
   try
    SizeWest.Select "80"
   catch
    Size.Select "80"
   endcatch
   '///+ Change font and background color ///
   Kontext
   Active.SetPage TabFontEffects
   Kontext "TabFontEffects"
   FontColor.Select 8

   Kontext
   Active.SetPage TabHintergrund
   Sleep 1
   Kontext "TabHintergrund"
   Hintergrundfarbe.Typekeys "<Down><Left>", 4
   TabHintergrund.OK

   ViewZoom
   Kontext "Massstab"
   Optimal.Check
   Massstab.OK


  printlog "  - checking properties"
   '///+ checking previous entered properties ///
   Call wDokSchreiben "<Mod1 A>"
   EditCopy
   if GetClipboardText <> "Hier bitte klicken !!!" then Warnlog "Wrong text in Document"
   Call wDokSchreiben "<Home><Up>",3
   Call wDokSchreiben "<Right>"

   EditHyperlink
   Kontext "TabHyperlinkInternet"

   if ZielURL.GetSeltext <> "http://www.mikeportnoy.com/" then Warnlog "URL is wrong : "+ ZielURL.GetSelText
   SetClipboard ZielURL.Getitemtext
   if Hinweis.GetText <> "Hier bitte klicken !!!" then Warnlog "The Text is wrong"
   if NameText.GetText <> "Ein Link mit dem Testtool" then Warnlog "Name is wrong"
   if Frame.GetSelText <> "_top" then Warnlog "Frame -Properties are wrong"
   ' Not for Asian languages
   if Hyperform > "" then
    if Form.GetSelText <> Hyperform then Warnlog "Form is wrong"
   endif
   Kontext "Hyperlink"
   Hyperlink.Close

   FormatCharacter

   Kontext
   Active.SetPage TabFont
   Kontext "TabFont"
   try
    if SizeWest.GetSelText <> "80" then Warnlog "Font height is not 80 Pixel but " + SizeWest.GetSelText
   catch
    if Size.GetSelText <> "80" then Warnlog "Font height is not 80 Pixel but " + Size.GetSelText
   endcatch
   TabFont.Cancel
   '///+ Execute Link ///

   if GetClipboardText="http://www.mikeportnoy.com" then
     printlog "  - execute link"
     Call wDokSchreiben "<End>"
     Sleep 1
     Call gMouseMove (35,50)
     Sleep 1
     gMouseClick 35, 50
   Sleep 2
   Kontext "Active"
   if Active.Exists then
      Active.Click ( 200 )
      Sleep 20
   else
      Warnlog "Link has not been executed"
   end if
  endif

  Sleep 2
   '/// Close document ///
  Call hCloseDocument     ' das Dokument schliessen
endcase

' ***********************************************************************

testcase tInsertFootnote
  PrintLog "- Insert / Footnote"

   Call hNewDocument
   '/// New document ///
  printlog "  - insert 2 footnotes"
   Call wDokSchreiben "Hallo hier die 1. Funote"
   '/// Insert a footnote with Insert / Footnote ///
   InsertFootnote
   Kontext "FussnoteEinfuegen"
   '///+ check automatic ///
   Automatisch.Check
   FussnoteEinfuegen.OK

   Call wDokSchreiben "Nummer1"
   Call wDokSchreiben "<PageUp>"
   Call wDokSchreiben "<Return>Hallo hier die 2. Funote"

   InsertFootnote
   '///+ Insert a second footnote with some special characters  ///
   Kontext "FussnoteEinfuegen"
   Zeichen.Check
   '///+ check if number of characters is limited to 10 ///
   try
      ZeichenText.SetText "?=)!)!$/&%(%&"
      Printlog "Unlimit number of characters of 10"
   catch
      ZeichenText.SetText "?=)!)!$/"
      Printlog "Limit number of characters to 10"
   endcatch
   FussnoteEinfuegen.OK

  printlog "  - Checking footnotes and the text belongs to the fotnote"
   '///+ Checking footnotes and the text belongs to the fotnote ///
   Call wDokSchreiben "Nummer2"
   Call wDokSchreiben "<Up><Home><Shift End>"
   EditCopy
   if GetClipboardText <> "Nummer1" then warnlog "1. Footnote text is wrong"
   Call wDokSchreiben "<Down>"
   Sleep 1
   Call wDokSchreiben "<Home><Shift End>"
   EditCopy
   if GetClipboardText <> "Nummer2" then warnlog "2. Footnote text is wrong   " + GetClipboardText
   Call wDokSchreiben "<Up><PageUp><Shift Home>"
   EditCopy
   if Instr ( GetClipBoardText, "1. Funote" ) = 0 then Warnlog "1. Footnote has not been selected"

   Call wDokSchreiben "<Down><End><Shift Home>"
   EditCopy
   if Instr ( GetClipBoardText, "2. Funote" ) = 0 then Warnlog "2. Footnote is wrong"
  '/// Close document ///
   Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertCaption
  PrintLog "- Insert / Caption"

   Call hNewDocument
   '/// Open a new document ///
  PrintLog "  - Insert Caption of a table"
   '/// Insert a table ///
   Call hTabelleEinfuegen
   '///+ Insert / Caption and change text ///
   InsertCaption
   Kontext "Beschriftung"
   BeschriftungsText.SetText "Hollahupp"
   Beschriftung.OK
   Call wDokSchreiben "<Down>",2
   Call wDokSchreiben "<End><Mod1 Shift Home>"
   '///+ Check if caption has been inserted in document ///
   try
    EditCopy
   catch
   endcatch
   if GetClipBoardText = "Hollahupp" then Warnlog "There has been no or a wrong caption inserted to the table"

   Call wDokSchreiben "<Home><Down>"
  PrintLog "  - Caption of a graphic"
   '/// Insert a graphic ///
   Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
   '///+ Insert / Caption and change text ///
   InsertCaption
   Kontext "Beschriftung"
   BeschriftungsText.SetText "Holterdipolter"
   Beschriftung.OK
   '///+ Close dialog and document ///

   Call hCloseDocument
endcase
