'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_format_character2.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/16 13:24:19 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Standard character formatting 
'*
'\***********************************************************************

sub w_format_character2

   Call tFormatCharacter1	'-> Format/Default
   Call tFormatCharacter2	'-> Format/Character
   Call tFormatHyperlink		'-> Autocorrection of hyperlinks
   
end sub


testcase tFormatCharacter1
	'/// Format / Default ///
	Call hNewDocument
	'/// New document ///
	Printlog "  - adjust Font- and Paragraph-Format"
	Call wDokSchreiben "Format<Shift Mod1 Left>"
	'/// Insert a word and select it ///
	FormatCharacter
	'/// Select Format / Character and adjust Font- and Paragraph-Formats ///
	Sleep 5
	Kontext
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	Outline.Check
	Shadow.Check
	Underline.Select 2
	StrikeThrough.Select 2
	TabFontEffects.OK
	FormatParagraph
	Kontext
	active.SetPage TabEinzuegeUndAbstaende
	kontext "TabEinzuegeUndAbstaende"
	Automatisch.Check
	TabEinzuegeUndAbstaende.OK
	'/// Close dialog ///
	Wait 500
	
	Printlog "  - Format / Default"
	'/// Select Format / Default ///
	FormatDefaultWriter
	Wait 500
	
	Printlog "  - check Font- and Paragraph-Formats"
	'/// Check if Font- and Paragraph-Formats have benn set to default ///
	FormatCharacter
	Kontext
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	if Outline.IsChecked then Warnlog "Outline is checked"
	if Shadow.IsChecked then Warnlog "Shadow is checked"
	if Underline.GetSelIndex = 2 then Warnlog "Wrong entry in 'Underline' is selected"
	if StrikeThrough.GetSelIndex = 2 then Warnlog "Wrong entry in 'StrikeThrough' is selected"
	TabFontEffects.OK
	FormatParagraph
	Kontext
	active.SetPage TabEinzuegeUndAbstaende
	kontext "TabEinzuegeUndAbstaende"
	if Automatisch.IsChecked then Warnlog "Automatic is checked"
	TabEinzuegeUndAbstaende.OK
	
	'/// Close document ///
	Call hCloseDocument
endcase


testcase tFormatCharacter2
	Dim Vergleich1%, Vergleich2$, Vergleich3$, Vergleich4$
    Dim vLink as integer
	'/// Format / Character ///
	PrintLog "- Format / Character"
	
	'/// New document ///
	Call hNewDocument
	printlog "  - adjust character"
	'/// Select Format / Character ///
	FormatCharacter
	Sleep 5
	Kontext
	'/// On Tabpage 'Font' adjust settings ///
	active.SetPage TabFont
	kontext "TabFont"
	try
		FontWest.Select 1
		Vergleich2$ = FontWest.GetSelText
		Vergleich1% = StyleWest.GetItemCount
		StyleWest.Select Vergleich1%
		Vergleich3$ = StyleWest.GetSelText
		SizeWest.Select 24
	catch
		Font.Select 1
		Vergleich2$ = Font.GetSelText
		Vergleich1% = Style.GetItemCount
		Style.Select Vergleich1%
		Vergleich3$ = Style.GetSelText
		Size.Select 24
	endcatch
	wait 100
	Kontext
	'/// On Tabpage 'Font Effects' adjust settings ///
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	Blinking.Check
	Kontext
	Active.Setpage TabFontPosition
	'/// On Tabpage 'Font Position ' adjust settings ///
	Kontext "TabFontPosition"
	Spacing.Select 2
	SpacingBy.More 3
	Vergleich4$ = SpacingBy.GetText
	if Right ( Vergleich4$, 2 ) <> "pt" then Warnlog "Wrong Unit at Spacing by"
	Kontext
	'/// On Tabpage 'Hyperlink' adjust settings ///
	active.SetPage TabHyperlinkZeichen
	kontext "TabHyperlinkZeichen"
	URLName.SetText "www.mikeportnoy.com"
	NameText.SetText "A hyperlink with testtool"
	TargetFrame.Select 2
	Select Case iSprache
        Case 36
            vLink = 2
        Case else
            vLink = 6
    end select
    UnbesuchterLink.Select vLink
            
	Kontext
	active.SetPage TabHintergrund
	kontext "TabHintergrund"
	Sleep 1
	Hintergrundfarbe.Typekeys "<Down><Left>", 4
	TabHintergrund.OK
	'/// Close dialog and reopen with Format / Character ///
	
	Call wDokSchreiben "This is formatted text <Home><Right>"
	
	printlog "  - check character"
	
	'/// Check settings made ///
	Call wDokSchreiben "<Home><Right>"
	FormatCharacter
	Kontext
	active.SetPage TabFont
	kontext "TabFont"
	try
		if FontWest.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ FontWest.GetSelText
		if StyleWest.GetSelText <> Vergleich3$ then Warnlog "FontStyle should " +Vergleich3$+" is "+ StyleWest.GetSelText
		if SizeWest.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + SizeWest.GetSelText
	catch
		if Font.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ Font.GetSelText
		if Style.GetSelText <> Vergleich3$ then Warnlog "FontStyle should " +Vergleich3$+" is "+ Style.GetSelText
		if Size.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + Size.GetSelText
	endcatch
	Kontext
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	if NOT Blinking.IsChecked then Warnlog "Blinking is not checked"
	Kontext
	Active.Setpage TabFontPosition
	Kontext "TabFontPosition"
	if Spacing.GetSelIndex <> 2 then Warnlog "Wrong Spacing activated, is not the 2. but " + Spacing.GetSelText
	if SpacingBy.GetText <> Vergleich4$ then Warnlog "Wrong Value selected. Not: " + Vergleich4$ +" but " + SpacingBy.GetText
	
	Kontext
	active.SetPage TabHyperlinkZeichen
	kontext "TabHyperlinkZeichen"
	if URLName.GetText <> "http://www.mikeportnoy.com/" then Warnlog "#i41171#Wrong URL : " + URLName.GetText
	SetClipboard UrlName.Gettext
	if NameText.GetText <> "A hyperlink with testtool" then Warnlog "Wrong Linkname : " + NameText.GetText
	if TargetFrame.GetSelIndex <> 2 then Warnlog "Wrong Target selected : " + TargetFrame.GetSelText
	if UnbesuchterLink.GetSelIndex <> vLink then Warnlog "Wrong Style for unused Link :" + UnbesuchterLink.GetSelIndex
	TabHyperlinkZeichen.OK
	
	if gApplication = "WRITER" then
		Call hSpeichernUnterKill ( gOfficePath + "user\work\format1.sxw" )
	else
		Call hSpeichernUnterKill ( gOfficePath + "user\work\format1.sxg" )
	endif
	'/// Save document as '../user/work/format1.sxw' and close it ///
	
	if getclipboardtext="http://www.mikeportnoy.com/" then
		printlog "  - activate Link"
	endif
	Sleep 20
	
	printlog "  - check saved character format"
	Sleep 1
	Call hCloseDocument
	Sleep 2
	if gApplication = "WRITER" then
		Call hDateiOeffnen ( gOfficePath + "user\work\format1.sxw" )
	else
		Call hDateiOeffnen ( gOfficePath + "user\work\format1.sxg" )
	endif
	Call wDokSchreiben "<Home><Right>"
	Wait 500
	'/// Reopen previous saved documentand check settings made under Format / Character ///
	
	FormatCharacter
	
	Sleep 3
	Kontext
	active.SetPage TabFont
	kontext "TabFont"
	try
		if FontWest.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ FontWest.GetSelText
		if StyleWest.GetSelText <> Vergleich3$ then Warnlog "FontStyle should " +Vergleich3$+" is "+ StyleWest.GetSelText
		if SizeWest.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + SizeWest.GetSelText
	catch
		if Font.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ Font.GetSelText
		if Style.GetSelText <> Vergleich3$ then Warnlog "FontStyle should " +Vergleich3$+" is "+ Style.GetSelText
		if Size.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + Size.GetSelText
	endcatch
	Kontext
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	if NOT Blinking.IsChecked then Warnlog "Blinking is not checked"
	Kontext
	Active.Setpage TabFontPosition
	Kontext "TabFontPosition"
	if Spacing.GetSelIndex <> 2 then Warnlog "Wrong Spacing selected. Not 2. but " + Spacing.GetSelText
	if SpacingBy.GetText <> Vergleich4$ then Warnlog "Wrong value selectzed. Not " + Vergleich4$ +" but " + SpacingBy.GetText
	Kontext
	active.SetPage TabHyperlinkZeichen
	kontext "TabHyperlinkZeichen"
	if URLName.GetText <> "http://www.mikeportnoy.com/" then Warnlog "#i41171#Wrong URL : " + URLName.GetText
	if NameText.GetText <> "A hyperlink with testtool" then Warnlog "Wrong Linkname : " + NameText.GetText
	if TargetFrame.GetSelIndex <> 2 then Warnlog "Wrong Target selected : " + TargetFrame.GetSelText
	TabHyperlinkZeichen.OK
	'/// Close document ///
	Call hCloseDocument
endcase



testcase tFormatHyperlink
	' /// This testcase has been written due to bug #109488
	'/// Open a new writerdocument
	Call hNewDocument
	'/// Enter a URL (www.sun.com) in document	
	Call wDokSchreiben "Autocorrect my URL www.sun.com"
	'/// Enter a space after URL
	Call wDokSchreiben " "
	'/// URL should have been autocompleted to http://www.sun.com
	Call wDokSchreiben "<Left>",7
	FormatCharacter
	Kontext
	Active.Setpage TabHyperlinkZeichen
	Kontext "TabHyperlinkZeichen"
	if URLName.GetText <> "http://www.sun.com/" then
		Warnlog "Autocorrection for hyperlink does not work!"
	else
		printlog "Hyperlink has been auto-corrected"			
	endif
	TabHyperlinkZeichen.Cancel

	'/// Change URL to www.sauna.com	
	Call wDokSchreiben "a"
	Call wDokSchreiben "<Left>" ,2
	Call wDokSchreiben "a"
	
	'/// Check whether URL has been changed
	FormatCharacter
	Kontext
	Active.Setpage TabHyperlinkZeichen
	Kontext "TabHyperlinkZeichen"
	if URLName.GetText <> "http://www.sun.com/" then
		Warnlog "Autocorrection for hyperlink should not have been affected to URL!"
	else
		printlog "Hyperlink has not been auto-corrected"			
	endif
	TabHyperlinkZeichen.Cancel
	'/// Close document
	Call hCloseDocument
endcase

