'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_218_.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/16 08:43:53 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_218_

    Call HTMLToDRAWText
    Call HTMLToDRAWField
    Call HTMLToDRAWTable
    Call HTMLToDRAWGraphicLinked
    Call HTMLToDRAWControl
    Call HTMLToDRAWFloatingFrame

end sub

' ---------------------------------------------------------------------------------

testcase HTMLToDRAWText
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Shift Down><Shift End>"
  EditCopy

  gApplication = "DRAW"
  '///+ Open new document ///
  Call hNewDocument
  '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
   Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
   '///+ Write Clipboard format under pasted content ///
   Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_draw_text.sxd")
   '///+ Save document as "..\user\work\html_to_draw_text.sxd" ///
   Wait 500
   Call hCloseDocument
   '///+ Close saved document ///
   wait 500
   Call hDateiOeffnen (gOfficepath + "user\work\html_to_draw_text.sxd",true)
   '///+ Reopen saved document ///
   Wait 500
   Call hCloseDocument
   '///+ Close saved document ///
  else
   Warnlog "Dialog 'Paste Special' is not up!"
   Call hCloseDocument
   goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToDRAWField
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select paragraph with 'Date Field' ///
    '///+ Copy selected text ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben "<Down>",2
    Call wDokSchreiben "<Home><Shift End>"
    try
        EditCopy
    catch
        Call wDokSchreiben "<Down>",1
        Call wDokSchreiben "<Home><Shift End>"
        EditCopy
    endcatch
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_draw_field.sxd")
        '///+ Save document as "..\user\work\html_to_draw_field.sxd" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_draw_field.sxd",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToDRAWTable
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Down>",5
  Call wDokSchreiben "<Mod1 A>",2
  EditCopy

  gApplication = "DRAW"
  '///+ Open new document ///
  Call hNewDocument
  '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
  Wait 500
  '/// Paste 'Table' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
   if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_draw_table.sxd")
     '///+ Save document as "..\user\work\html_to_draw_table.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\html_to_draw_table.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
   else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
   endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToDRAWGraphicLinked
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Linked Graphic' ///
    '///+ Copy selected Linked Graphic ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    EditCopy
    
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Linked Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_draw_graphic1.sxd")
        '///+ Save document as "..\user\work\html_to_draw_graphic1.sxd" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_draw_graphic1.sxd",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToDRAWControl
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Control' ///
    '///+ Copy selected Control ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    Call wDokSchreiben "<Tab>"
    EditCopy
    
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_draw_control.sxd")
        '///+ Save document as "..\user\work\html_to_draw_control.sxd" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_draw_control.sxd",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToDRAWFloatingFrame
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Floating Frame' ///
    '///+ Copy selected Floating Frame ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    Call wDokSchreiben "<Tab>",2
    try
        EditCopy
    catch
        Warnlog "Edit / Copy is disabled ! Maybe object not selected!"
        Call hCloseDocument
        goto endsub
    endcatch
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Floating Frame' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_draw_float.sxd")
        '///+ Save document as "..\user\work\html_to_draw_float.sxd" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_draw_float.sxd",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase
