'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_217_.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/16 08:43:54 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_217_

    Call HTMLToCALCText
    Call HTMLToCALCField
    Call HTMLToCALCTable
    Call HTMLToCALCGraphicLinked
    Call HTMLToCALCControl
    Call HTMLToCALCFloatingFrame

end sub

' ---------------------------------------------------------------------------------

testcase HTMLToCALCText
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Shift Down><Shift End>"
  EditCopy

  gApplication = "CALC"
  '///+ Open new document ///
  Call hNewDocument
  '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
   Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
   '///+ Write Clipboard format under pasted content ///
   Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_calc_text.sxc")
   '///+ Save document as "..\user\work\html_to_calc_text.sxc" ///
   Wait 500
   Call hCloseDocument
   '///+ Close saved document ///
   wait 500
   Call hDateiOeffnen (gOfficepath + "user\work\html_to_calc_text.sxc",true)
   '///+ Reopen saved document ///
   Wait 500
   Call hCloseDocument
   '///+ Close saved document ///
  else
   Warnlog "Dialog 'Paste Special' is not up!"
   Call hCloseDocument
   goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToCALCField
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select paragraph with 'Date Field' ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Down>",2
  Call wDokSchreiben "<Home><Shift End>"
  EditCopy

    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_calc_field.sxc")
     '///+ Save document as "..\user\work\html_to_calc_field.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\html_to_calc_field.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  '/// Close active document ///
  Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToCALCTable
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Down>",5
  Call wDokSchreiben "<Mod1 A>",2
  EditCopy

  gApplication = "CALC"
  '///+ Open new document ///
  Call hNewDocument
  '///+ Edit / Paste Special ///
  Sleep 2
  try
      EditPasteSpecialCalc
  catch
      Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
      Call hCloseDocument
      Call hCloseDocument
      goto endsub
  endcatch
  Wait 500
  '/// Paste 'Table' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
   if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_calc_table.sxc")
     '///+ Save document as "..\user\work\html_to_calc_table.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\html_to_calc_table.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
   else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
   endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToCALCGraphicLinked
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Linked Graphic' ///
    '///+ Copy selected Linked Graphic ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    EditCopy
    
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        QAErrorlog "Unable to execute 'Edit / Paste Special'! Test failed! Manually not reproducable"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Linked Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_calc_graphic1.sxc")
        '///+ Save document as "..\user\work\html_to_calc_graphic1.sxc" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_calc_graphic1.sxc",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToCALCControl
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Control' ///
    '///+ Copy selected Control ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    Call wDokSchreiben "<Tab>"
    EditCopy
    
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_calc_control.sxc")
        '///+ Save document as "..\user\work\html_to_calc_control.sxc" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_calc_control.sxc",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToCALCFloatingFrame
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Floating Frame' ///
    '///+ Copy selected Floating Frame ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    Call wDokSchreiben "<Tab>",2
    try
        EditCopy
    catch
        Warnlog "Edit / Copy is disabled ! Maybe object not selected!"
        Call hCloseDocument
        goto endsub
    endcatch
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Floating Frame' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterKill (gOfficepath + "user\work\html_to_calc_float.sxc")
        '///+ Save document as "..\user\work\html_to_calc_float.sxc" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_calc_float.sxc",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase
