'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_german_spell_check3.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:20:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Spellcheck for some new German words III
'*
'************************************************************************
'*
' #1 tGermanSpellCheck_21
' #1 tGermanSpellCheck_22
' #1 tGermanSpellCheck_23
' #1 tGermanSpellCheck_24
' #1 tGermanSpellCheck_25
' #1 tGermanSpellCheck_26
' #1 tGermanSpellCheck_27
' #1 tGermanSpellCheck_28
' #1 tGermanSpellCheck_29
' #1 tGermanSpellCheck_30
'*
'\***********************************************************************

sub w_german_spell_check_3

'///   This case is based on -- "
'///   http://staroffice-doc.germany.sun.com:8080/Teams/QA/Test_Plans/Writer/tools
'///      --- new_german_spelling.vor
   printLog Chr(13) + "- Tools/Spellcheck/check for some new German words"
      Call tGermanSpellCheck_21        'Tools/Spellcheck/check  for some new German words Page 21
      Call tGermanSpellCheck_22        'Tools/Spellcheck/check  for some new German words Page 22
      Call tGermanSpellCheck_23        'Tools/Spellcheck/check  for some new German words Page 23
      Call tGermanSpellCheck_24        'Tools/Spellcheck/check  for some new German words Page 24
      Call tGermanSpellCheck_25        'Tools/Spellcheck/check  for some new German words Page 25
      Call tGermanSpellCheck_26        'Tools/Spellcheck/check  for some new German words Page 26
      Call tGermanSpellCheck_27        'Tools/Spellcheck/check  for some new German words Page 27
      Call tGermanSpellCheck_28        'Tools/Spellcheck/check  for some new German words Page 28
      Call tGermanSpellCheck_29        'Tools/Spellcheck/check  for some new German words Page 29
      Call tGermanSpellCheck_30        'Tools/Spellcheck/check  for some new German words Page 30
end sub

' *******************************************************************

testcase tGermanSpellCheck_21

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling21.stw"
  
  aCheckedWord = Array( _
                        "Runderlaß" , "Rußland" , "Säbelraßler" , "Saisonnier" , _
                        "Saisonschluß" , "Salutschuß" , "Salzfaß" , "Samenerguß" , _
                        "Sammelanschluß" , "Sankt Gallener" , "sanktgallisch" , "Sanmarinese" , _
                        "sanmarinesisch" , "sauberhalten" , "saubermachen" , "sausenlassen" , _
                        "Saxophon" , "trockene" , "Schalenguß" , "Schallehre" , _
                        "Schallehre" , "Schalloch" , "Schalloch" , "Schalterschluß" , _
                        "schärfste" , "schaßte" , "schattenspendender" , "schätzenlernen" , _
                        "Schauprozeß" , "Scheidungsprozeß" , "schießenlassen" , "Schiffahrt" , _
                        "Schiffahrt" , "Schippenas" , "Schiß" , "Schlachtroß" , _
                        "Schlagfluß" , "Schlammasse" , "Schlammasse" , "schlechtgehen" , _
                        "schlechtgelaunt" , "schlimmste" , "schlimmste" , "schliß" , _
                        "Schlitzverschluß" , "Schloß" , "Schlößchen" , "Schloßherr" , _
                        "Schloßpark" , "Schluß" , "Schlußbemerkung" , "schlußendlich" , _
                        "schlußfolgern" , "Schlußfolgerung" , "Schlußlicht" , "Schlußpfiff" , _
                        "Schlußpunkt" , "Schlußsatz" , "Schlußsatz" , "Schlußspurt" , _
                        "Schlußspurt" , _
                        )

  aCorrectWord = Array( _
                        "Runderlass" , "Russland" , "Säbelrassler" , "Saisonier" , _
                        "Saisonschluss" , "Salutschuss" , "Salzfass" , "Samenerguss" , _
                        "Sammelanschluss" , "Sankt-Gallener" , "sankt-gallisch" , "San-Marinese" , _
                        "san-marinesisch" , "sauber halten" , "sauber machen" , "sausen lassen" , _
                        "Saxofon" , "Trockene" , "Schalenguss" , "Schalllehre" , _
                        "Schall-Lehre" , "Schallloch" , "Schall-Loch" , "Schalterschluss" , _
                        "Schärfste" , "schasste" , "Schatten spendender" , "schätzen lernen" , _
                        "Schauprozess" , "Scheidungsprozess" , "schießen lassen" , "Schifffahrt" , _
                        "Schiff-Fahrt" , "Schippenass" , "Schiss" , "Schlachtross" , _
                        "Schlagfluss" , "Schlammmasse" , "Schlamm-Masse" , "schlecht gehen" , _
                        "schlecht gelaunt" , "Schlimmste" , "Schlimmste" , "schliss" , _
                        "Schlitzverschluss" , "Schloss" , "Schlösschen" , "Schlossherr" , _
                        "Schlosspark" , "Schluss" , "Schlussbemerkung" , "schlussendlich" , _
                        "schlussfolgern" , "Schlussfolgerung" , "Schlusslicht" , "Schlusspfiff" , _
                        "Schlusspunkt" , "Schlusssatz" , "Schluss-Satz" , "Schlussspurt" , _
                        "Schluss-Spurt" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words -- page 21"
  '/// Tools/Spellcheck/check  for some new German words -- page 21
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_22

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling2.stw"
  
  aCheckedWord = Array( _
                       "Schlußstrich" , "Schlußstrich" , "Schlußverkauf" , "Schlußwort" , _
                       "Schmerfluß" , "schmiß" , "Schmiß" , "Schmuckblattelegramm" , _
                       "Schmuckblattelegramm" , "schmutziggrau" , "Schnappschloß" , "Schnappschuß" , _
                       "Schnee-Eifel" , "Schnee-Eule" , "Schneewächte" , "Schnellimbiß" , _
                       "Schnelläufer" , "Schnelläufer" , "schnellebig" , "Schnellebigkeit" , _
                       "Schnellschuß" , "Schnepper" , "schneppern" , "schneuzen" , _
                       "Schokoladenguß" , "schönste" , "schoß" , "Schoß" , _
                       "schräglaufend" , "Schraubverschluß" , "schreckensblaß" , "Schreckschußpistole" , _
                       "Schrittempo" , "Schrittempo" , "Schrotschuß" , "Schulabschluß" , _
                       "schuld" , "zuschulden" , "schuldbewußt" , "Schuldenerlaß" , _
                       "Schulschluß" , "Schulstreß" , "Schulterschluß" , "Schuß" , _
                       "schußbereit" , "schußfest" , "schußlig" , "Schußlinie" , _
                       "Schußschwäche" , "Schußschwäche" , "Schußwaffe" , "Schußwechsel" , _
                       "schwachbetont" , "schwachbevölkert" , "schwarz" , "weiß" , _
                       "Schwarze" , "schwarzgefärbt" , "schwarzrotgolden" , "schwerfallen" , _
                       "schwernehmen" , "schwertun" , "schwerverständlich" , "Schwimmeister" , _
                       "Schwimmeister" , _
                       )
                        
  aCorrectWord = Array( _
                       "Schlussstrich" , "Schluss-Strich" , "Schlussverkauf" , "Schlusswort" , _
                       "Schmerfluss" , "schmiss" , "Schmiss" , "Schmuckblatttelegramm" , _
                       "Schmuckblatt-Telegramm" , "schmutzig grau" , "Schnappschloss" , "Schnappschuss" , _
                       "Schneeeifel" , "Schneeeule" , "Schneewechte" , "Schnellimbiss" , _
                       "Schnellläufer" , "Schnell-Läufer" , "schnelllebig" , "Schnelllebigkeit" , _
                       "Schnellschuss" , "Schnäpper" , "schnäppern" , "schnäuzen" , _
                       "Schokoladenguss" , "Schönste" , "schoss" , "Schoss" , _
                       "schräg laufend" , "Schraubverschluss" , "schreckensblass" , "Schreckschusspistole" , _
                       "Schritttempo" , "Schritt-Tempo" , "Schrotschuss" , "Schulabschluss" , _
                       "Schuld" , "zu Schulden" , "schuldbewusst" , "Schuldenerlass" , _
                       "Schulschluss" , "Schulstress" , "Schulterschluss" , "Schuss" , _
                       "schussbereit" , "schussfest" , "schusslig" , "Schusslinie" , _
                       "Schussschwäche" , "auch: Schuss-Schwäche" , "Schusswaffe" , "Schusswechsel" , _
                       "schwach betont" , "schwach bevölkert" , "Schwarz" , "Weiß" , _
                       "schwarze" , "schwarz gefärbt" , "schwarz-rot-golden" , "schwer fallen" , _
                       "schwer nehmen" , "schwer tun" , "schwer verständlich" , "Schwimmmeister" , _
                       "Schwimm-Meister" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 22"
  '/// Tools/Spellcheck/check  for some new German words - page 22
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_23

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
    
  sFileName = "new_german_spelling23.stw"

  aCheckedWord = Array( _
                       "Science-fiction" , "Science-fiction" , "Sechspaß" , "See-Elefant" , _
                       "jedem das Seine" , "Seine" , "Seinen" , "Seinigen" , _
                       "seinlassen" , "Seismograph" , "auf seiten" , "seiten" , _
                       "von seiten" , "seiten" , "selbständig" , "Selbständigkeit" , _
                       "selbstbewußt" , "Selbstbewußtsein" , "selbsternannt" , "selbstgebacken" , _
                       "selbstgemacht" , "selbstgestrickt" , "Selbstschuß" , "selbstverdient" , _
                       "seligpreisen" , "seligsprechen" , "Senatsbeschluß" , "Sendeschluß" , _
                       "Sendungsbewußtsein" , "Sensationsprozeß" , "Séparée" , "sequentiell" , _
                       "seßhaft" , "Seßhaftigkeit" , "S-förmig" , "Shakespeareschen" , _
                       "Shakespeareschen" , "Short story" , "Short story" , "Showbusineß" , _
                       "Showdown" , "Shrimp" , "Sicher" , "sicherste" , _
                       "Sicherheitsschloß" , "Sicherheitsverschluß" , "siedendheiß" , "siegesbewußt" , _
                       "siegesgewiß" , "Simplonpaß" , "Singende" , "Siphonverschluß" , _
                       "sitzenbleiben" , "sitzenlassen" , "Skipaß" , "Small talk" , _
                       "Small talk" , "so daß" , "Sommerschlußverkauf" , "sonstige" , _
                       "Soufflé" , _
                       )
                        
  aCorrectWord = Array( _
                       "Sciencefiction" , "Science-Fiction" , "Sechspass" , "Seeelefant" , _
                       "jedem das seine" , "seine" , "seinen" , "seinigen" , _
                       "sein lassen" , "Seismograf" , "aufseiten" , "Seiten" , _
                       "vonseiten" , "Seiten" , "selbstständig" , "Selbstständigkeit" , _
                       "selbstbewusst" , "Selbstbewusstsein" , "selbst ernannt" , "selbst gebacken" , _
                       "selbst gemacht" , "selbst gestrickt" , "Selbstschuss" , "selbst verdient" , _
                       "selig preisen" , "selig sprechen" , "Senatsbeschluss" , "Sendeschluss" , _
                       "Sendungsbewusstsein" , "Sensationsprozess" , "Separee" , "sequenziell" , _
                       "sesshaft" , "Sesshaftigkeit" , "s-förmig" , "shakespeareschen" , _
                       "Shakespeare'schen" , "Shortstory" , "Short Story" , "Showbusiness" , _
                       "Show-down" , "Schrimp" , "sicher" , "Sicherste" , _
                       "Sicherheitsschloss" , "Sicherheitsverschluss" , "siedend heiß" , "siegesbewusst" , _
                       "siegesgewiss" , "Simplonpass" , "singende" , "Siphonverschluss" , _
                       "sitzen bleiben" , "sitzen lassen" , "Skipass" , "Smalltalk" , _
                       "Small Talk" , "sodass" , "Sommerschlussverkauf" , "Sonstige" , _
                       "Soufflee" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 23"
  '/// Tools/Spellcheck/check  for some new German words - page 23
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_24

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling24.stw"
  
  aCheckedWord = Array( _
                        "soviel" , "soviel" , "soviel" , "soweit" , _
                        "soweit" , "sowenig" , "Sowjetrußland" , "Als" , _
                        "Spaghetti" , "Spantenriß" , "spazierenfahren" , "spazierengehen" , _
                        "Speichelfluß" , "Sperrad" , "Sperrad" , "Sperriegel" , _
                        "Sperriegel" , "Spliß" , "splißt" , "sporenbildende" , _
                        "Sportdreß" , "Sprenggeschoß" , "Spritzguß" , "sproß" , _
                        "Sproß" , "Sproßachse" , "Sprößchen" , "Sprößling" , _
                        "staatenbildende" , "Stahlroß" , "Stallaterne" , "Stallaterne" , _
                        "Stammutter" , "Stammutter" , "standesbewußt" , "Standesbewußtsein" , _
                        "Startschuß" , "steckenbleiben" , "steckenlassen" , "Steckschloß" , _
                        "Steckschuß" , "stehenbleiben" , "stehenlassen" , "Stehimbiß" , _
                        "Steilpaß" , "Stemmeißel" , "Stemmeißel" , "Stendelwurz" , _
                        "Stengel" , "Step" , "Steptanz" , "Stereophonie" , _
                        "Steuererlaß" , "Steuermeßbetrag" , "Stewardeß" , "stiftengehen" , _
                        "stillen" , "Stilleben" , "Stilleben" , "stillegen" , _
                        "Stillegung" , "Stoffarbe" , "Stoffarbe" , "Stoffetzen" , _
                        "Stoffetzen" , _
                        )
                       
  aCorrectWord = Array( _
                        "so viel" , "so viel" , "so viel" , "so weit" , _
                        "so weit" , "so wenig" , "Sowjetrussland" , "als" , _
                        "Spagetti" , "Spantenriss" , "spazieren fahren" , "spazieren gehen" , _
                        "Speichelfluss" , "Sperrrad" , "Sperr-Rad" , "Sperrriegel" , _
                        "Sperr-Riegel" , "Spliss" , "splisst" , "Sporen bildende" , _
                        "Sportdress" , "Sprenggeschoss" , "Spritzguss" , "spross" , _
                        "Spross" , "Sprossachse" , "Sprösschen" , "Sprössling" , _
                        "Staaten bildende" , "Stahlross" , "Stalllaterne" , "Stall-Laterne" , _
                        "Stammmutter" , "Stamm-Mutter" , "standesbewusst" , "Standesbewusstsein" , _
                        "Startschuss" , "stecken bleiben" , "stecken lassen" , "Steckschloss" , _
                        "Steckschuss" , "stehen bleiben" , "stehen lassen" , "Stehimbiss" , _
                        "Steilpass" , "Stemmmeißel" , "Stemm-Meißel" , "Ständelwurz" , _
                        "Stängel" , "Stepp" , "Stepptanz" , "Stereofonie" , _
                        "Steuererlass" , "Steuermessbetrag" , "Stewardess" , "stiften gehen" , _
                        "Stillen" , "Stillleben" , "Still-Leben" , "stilllegen" , _
                        "Stilllegung" , "Stofffarbe" , "Stoff-Farbe" , "Stofffetzen" , _
                        "Stoff-Fetzen" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 24" 
  '/// Tools/Spellcheck/check  for some new German words - page 24
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_25

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling25.stw"
  
  aCheckedWord = Array( _
                        "Stoffülle" , "Stoffülle" , "Stop" , "Straferlaß" , _
                        "Strafprozeß" , "Strafprozeßordnung" , "Straß" , "Streifschuß" , _
                        "Streitroß" , "strenggenommen" , "strengnehmen" , "strengste" , _
                        "Streß" , "streßt" , "Streßsituation" , "Streßsituation" , _
                        "2stündig" , "2stündlich" , "Stuß" , "substantiell" , _
                        "Sustenpaß" , "Tablettenmißbrauch" , "tabula" , "zutage" , _
                        "2tägig" , "Tankschloß" , "Tarifabschluß" , "Täßchen" , _
                        "tausend" , "Tausende" , "T-bone-Steak" , "Tee-Ei" , _
                        "Tee-Ernte" , "Teerfaß" , "Telephon" , "Telephonanschluß" , _
                        "Thunfisch" , "Tie-Break" , "tiefste" , "tiefbewegt" , _
                        "tiefempfunden" , "tiefverschneit" , "Tintenfaß" , "Tip" , _
                        "todblaß" , "Todesschuß" , "Tolpatsch" , "tolpatschig" , _
                        "Tomatenketchup" , "Topographie" , "Torschlußpanik" , "Torschuß" , _
                        "totenblaß" , "totgeboren" , "traditionsbewußt" , "Tränenfluß" , _
                        "tränennaß" , "Traß" , "Trekking" , "treuergeben" , _
                        "triefnaß" , "trockenen" , _
                        )
                        
  aCorrectWord = Array( _
                        "Stofffülle" , "Stoff-Fülle" , "Stopp" , "Straferlass" , _
                        "Strafprozess" , "Strafprozessordnung" , "Strass" , "Streifschuss" , _
                        "Streitross" , "streng genommen" , "streng nehmen" , "Strengste" , _
                        "Stress" , "stresst" , "Stresssituation" , "Stress-Situation" , _
                        "2-stündig" , "2-stündlich" , "Stuss" , "substanziell" , _
                        "Sustenpass" , "Tablettenmissbrauch" , "Tabula" , "zu Tage" , _
                        "2-tägig" , "Tankschloss" , "Tarifabschluss" , "Tässchen" , _
                        "Tausend" , "tausende" , "T-Bone-Steak" , "Teeei" , _
                        "Teeernte" , "Teerfass" , "Telefon" , "Telefonanschluss" , _
                        "Tunfisch" , "Tiebreak" , "Tiefste" , "tief bewegt" , _
                        "tief empfunden" , "tief verschneit" , "Tintenfass" , "Tipp" , _
                        "todblass" , "Todesschuss" , "Tollpatsch" , "tollpatschig" , _
                        "Tomatenketschup" , "Topografie" , "Torschlusspanik" , "Torschuss" , _
                        "totenblass" , "tot geboren" , "traditionsbewusst" , "Tränenfluss" , _
                        "tränennass" , "Trass" , "Trecking" , "treu ergeben" , _
                        "triefnass" , "Trockenen" , _
                       )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 25" 
  '/// Tools/Spellcheck/check  for some new German words - page 25
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_26

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling26.stw"
  
  aCheckedWord = Array( _
                        "treuergeben" , "triefnaß" , "trockenen" , "trockene" , _
                        "tropfnaß" , "Troß" , "trüben" , "Truchseß" , _
                        "Trugschluß" , "Trumpfas" , "Tuffelsen" , "Tuffelsen" , _
                        "Türschloß" , "übelgelaunt" , "übelnehmen" , "übelriechend" , _
                        "Überbiß" , "Überdruß" , "übereinanderlegen" , "übereinanderliegen" , _
                        "übereinanderwerfen" , "Überfluß" , "Überflußgesellschaft" , "Überguß" , _
                        "überhandnehmen" , "abend" , "nachmittag" , "Überschuß" , _
                        "überschwenglich" , "überwächtet" , "übriges" , "übrigen" , _
                        "übrige" , "übrigen" , "übrigbehalten" , "übrigbleiben" , _
                        "übriglassen" , "U-förmig" , "ratio" , "Umdenkprozeß" , _
                        "umfaßt" , "Umriß" , "Umrißzeichnung" , "Umschichtungsprozeß" , _
                        "Umschluß" , "umsein" , "um so" , "Umstellungsprozeß" , _
                        "Umwandlungsprozeß" , "Umwelteinfluß" , "unabsehbare" , "unangepaßt" , _
                        "Unangepaßtheit" , "unbeeinflußbar" , "unbeeinflußt" , "Unbekannt" , _
                        "unbewußt" , "ähnliches" , "unendlichemal" , "unerläßlich" , _
                        "unermeßlich" , "Unfairneß" , "unfaßbar" , "unfaßlich" , _
                       )

  aCorrectWord = Array( _
                        "treu ergeben" , "triefnass" , "Trockenen" , "Trockene" , _
                        "tropfnass" , "Tross" , "Trüben" , "Truchsess" , _
                        "Trugschluss" , "Trumpfass" , "Tufffelsen" , "Tuff-Felsen" , _
                        "Türschloss" , "übel gelaunt" , "übel nehmen" , "übel riechend" , _
                        "Überbiss" , "Überdruss" , "übereinander legen" , "übereinander liegen" , _
                        "übereinander werfen" , "Überfluss" , "Überflussgesellschaft" , "Überguss" , _
                        "überhand nehmen" , "Abend" , "Nachmittag" , "Überschuss" , _
                        "überschwänglich" , "überwechtet" , "Übriges" , "Übrigen" , _
                        "Übrige" , "Übrigen" , "übrig behalten" , "übrig bleiben" , _
                        "übrig lassen" , "u-förmig" , "Ratio" , "Umdenkprozess" , _
                        "umfasst" , "Umriss" , "Umrisszeichnung" , "Umschichtungsprozess" , _
                        "Umschluss" , "um sein" , "umso" , "Umstellungsprozess" , _
                        "Umwandlungsprozess" , "Umwelteinfluss" , "Unabsehbare" , "unangepasst" , _
                        "Unangepasstheit" , "unbeeinflussbar" , "unbeeinflusst" , "unbekannt" , _
                        "unbewusst" , "Ähnliches" , "unendliche Mal" , "unerlässlich" , _
                        "unermesslich" , "Unfairness" , "unfassbar" , "unfasslich" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words -- page 26"
  '/// Tools/Spellcheck/check  for some new German words -- page 26
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_27

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling27.stw"
  
  aCheckedWord = Array( _
                        "unklaren" , "unklaren" , "unmißverständlich" , "unpäßlich" , _
                        "Unpäßlichkeit" , "unplaziert" , "unrecht" , "unrecht" , _
                        "unrecht" , "Unrechtsbewußtsein" , "unselbständig" , "Unselbständigkeit" , _
                        "Unseren" , "Unsrigen" , "untenerwähnt" , "untenstehend" , _
                        "unterbewußt" , "Unterbewußtsein" , "unterderhand" , "untereinanderstehen" , _
                        "Untergeschoß" , "Unterlaß" , "Untersuchungsausschuß" , "unvergeßlich" , _
                        "unerläßlich" , "unzähligemal" , "va banque" , "Varieté" , _
                        "veranlaßt" , "verantwortungsbewußt" , "Verantwortungsbewußtsein" , "Verbiß" , _
                        "verblaßt" , "verbleuen" , "verborgenen" , "verdroß" , _
                        "Verdruß" , "verfaßt" , "vergeßlich" , "Vergeßlichkeit" , _
                        "Vergißmeinnicht" , "vergißt" , "verhaßt" , "Verlaß" , _
                        "verläßlich" , "Verläßlichkeit" , "verlorengehen" , "vermißt" , _
                        "Vermißtenanzeige" , "verpaßt" , "verpraßt" , "Verriß" , _
                        "verschiedenes" , "verschiedenemal" , "Verschiß" , "Verschluß" , _
                        "Verschlußkappe" , "Verschlußsache" , "Verschlußsache" , "verselbständigen" , _
                        "Versorgungsengpaß" , "Vertragsabschluß" , "Vertragsschluß" , "V-förmig" , _
                        )
                        
  aCorrectWord = Array( _
                        "Unklaren" , "Unklaren" , "unmissverständlich" , "unpässlich" , _
                        "Unpässlichkeit" , "unplatziert" , "Unrecht" , "Unrecht" , _
                        "Unrecht" , "Unrechtsbewusstsein" , "unselbstständig" , "Unselbstständigkeit" , _
                        "unseren" , "unsrigen" , "unten erwähnt" , "unten stehend" , _
                        "unterbewusst" , "Unterbewusstsein" , "unter der Hand" , "untereinander stehen" , _
                        "Untergeschoss" , "Unterlass" , "Untersuchungsausschuss" , "unvergesslich" , _
                        "unerlässlich" , "unzählige Mal" , "Vabanque spielen" , "Varietee" , _
                        "veranlasst" , "verantwortungsbewusst" , "Verantwortungsbewusstsein" , "Verbiss" , _
                        "verblasst" , "verbläuen" , "Verborgenen" , "verdross" , _
                        "Verdruss" , "verfasst" , "vergesslich" , "Vergesslichkeit" , _
                        "Vergissmeinnicht" , "vergisst" , "verhasst" , "Verlass" , _
                        "verlässlich" , "Verlässlichkeit" , "verloren gehen" , "vermisst" , _
                        "Vermisstenanzeige" , "verpasst" , "verprasst" , "Verriss" , _
                        "Verschiedenes" , "verschiedene Mal" , "Verschiss" , "Verschluss" , _
                        "Verschlusskappe" , "Verschlusssache" , "Verschluss-Sache" , "verselbstständigen" , _
                        "Versorgungsengpass" , "Vertragsabschluss" , "Vertragsschluss" , "v-förmig" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 27"
  '/// Tools/Spellcheck/check  for some new German words - page 27
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_28

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
    
  sFileName = "new_german_spelling28.stw"

  aCheckedWord = Array( _
                         "Vibraphon" , "zuviel" , "zuwenig" , "vielbefahren" , _
                         "vielgelesen" , "Vierpaß" , "vollen" , "voneinandergehen" , _
                         "von seiten" , "seiten" , "vorangehendes" , "vorangehenden" , _
                         "voraus" , "vorgefaßt" , "abend" , "mittag" , _
                         "morgen" , "Vorhängeschloß" , "vorhergehendes" , "vorhergehenden" , _
                         "vorhinein" , "vorige" , "vorigen" , "Vorlegeschloß" , _
                         "vorliebnehmen" , "vormittag" , "Vorschlußrunde" , "Vorschuß" , _
                         "Vorschußlorbeeren" , "vorstehendes" , "vorstehenden" , "vorwärtsgehen" , _
                         "vorwärtskommen" , "wachestehender" , "Wachsabguß" , "Wächte" , _
                         "Waggon" , "Wahlausschuß" , "talkie" , "Walnuß" , _
                         "Walroß" , "Wandlungsprozeß" , "Warnschuß" , "Wasserschloß" , _
                         "wäßrig" , "Wehrpaß" , "weichgekocht" , "Weinfaß" , _
                         "schwarz" , "weiß" , "weißgekleidet" , "Weißrußland" , _
                         "weiteren" , "weitgereist" , "weitreichend" , "weitverbreitet" , _
                         "Werkstattage" , "Werkstattage" , "Werkstofforschung" , "Werkstofforschung" , _
                         "wesentlichen" , "Wetteufel" , "Wetteufel" , "Wetturnen" , _
                         "Wetturnen" , "widereinanderstoßen" , "wieviel" , _
                      )
                        
  aCorrectWord = Array( _
                        "Vibrafon" , "zu viel" , "zu wenig" , "viel befahren" , _
                        "viel gelesen" , "Vierpass" , "Vollen" , "voneinander gehen" , _
                        "vonseiten" , "Seiten" , "Vorangehendes" , "Vorangehenden" , _
                        "Voraus" , "vorgefasst" , "Abend" , "Mittag" , _
                        "Morgen" , "Vorhängeschloss" , "Vorhergehendes" , "Vorhergehenden" , _
                        "Vorhinein" , "Vorige" , "Vorigen" , "Vorlegeschloss" , _
                        "vorlieb nehmen" , "Vormittag" , "Vorschlussrunde" , "Vorschuss" , _
                        "Vorschusslorbeeren" , "Vorstehendes" , "Vorstehenden" , "vorwärts gehen" , _
                        "vorwärts kommen" , "Wache stehender" , "Wachsabguss" , "Wechte" , _
                        "Wagon" , "Wahlausschuss" , "Talkie" , "Walnuss" , _
                        "Walross" , "Wandlungsprozess" , "Warnschuss" , "Wasserschloss" , _
                        "wässrig" , "Wehrpass" , "weich gekocht" , "Weinfass" , _
                        "Schwarz" , "Weiß" , "weiß gekleidet" , "Weißrussland" , _
                        "Weiteren" , "weit gereist" , "weit reichend" , "weit verbreitet" , _
                        "Werkstatttage" , "Werkstatt-Tage" , "Werkstoffforschung" , "Werkstoff-Forschung" , _
                        "Wesentlichen" , "Wettteufel" , "Wett-Teufel" , "Wettturnen" , _
                        "Wett-Turnen" , "widereinander stoßen" , "wie viel" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 28"
  '/// Tools/Spellcheck/check  for some new German words - page 28
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument

endcase

' *******************************************************************

testcase tGermanSpellCheck_29

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling29.stw"
  
  aCheckedWord = Array( _
                        "Winterschlußverkauf" , "Wißbegierde" , "wißbegierig" , "wißt" , _
                        "wußtest" , "wüßten" , "Witterungseinfluß" , "Wollappen" , _
                        "Wollappen" , "Wollaus" , "Wollaus" , "wunder" , _
                        "wundliegen" , "Wurfgeschoß" , "X-beinig" , "X-förmig" , _
                        "tenmal" , "Zäheit" , "Zahlenschloß" , "Zäpfchen-R" , _
                        "Zaubernuß" , "Zechenstillegung" , "Zeilengußmaschine" , "2zeilig" , _
                        "Zeitlang" , "zur Zeit" , "Zellehre" , "Zellehre" , _
                        "Zellstoffabrik" , "Zellstoffabrik" , "Zersetzungsprozeß" , "zielbewußt" , _
                        "Zierat" , "zigtausend" , "Zigtausende" , "Zippverschluß" , _
                        "Zirkelschluß" , "Zivilprozeß" , "Zivilprozeßordnung" , "Zoo-Orchester" , _
                        "eigen" , "zueinanderfinden" , "Zufluß" , "zufriedengeben" , _
                        "zufriedenlassen" , "zufriedenstellen" , "zugrunde gehen" , "zugrunde legen" , _
                        "zugrunde liegen" , "zugrundeliegend" , "zugrundeliegend" , "zugrunde" , _
                        "zugunsten" , "zu Hause" , "zulande" , "zulasten" , _
                        "zuleide" , "zumute" , "Zündschloß" , "Zungenkuß" , _
                        "Zungen-R" , "zunutze" , "zupaß" , "zugepreßt" , _
                        )
                       
  aCorrectWord = Array( _
                        "Winterschlussverkauf" , "Wissbegierde" , "wissbegierig" , "wisst" , _
                        "wusstest" , "wüssten" , "Witterungseinfluss" , "Wolllappen" , _
                        "Woll-Lappen" , "Wolllaus" , "Woll-Laus" , "Wunder" , _
                        "wund liegen" , "Wurfgeschoss" , "x-beinig" , "x-förmig" , _
                        "ten Mal" , "Zähheit" , "Zahlenschloss" , "Zäpfchen-r" , _
                        "Zaubernuss" , "Zechenstilllegung" , "Zeilengussmaschine" , "2-zeilig" , _
                        "Zeit lang" , "zurzeit" , "Zelllehre" , "Zell-Lehre" , _
                        "Zellstofffabrik" , "Zellstoff-Fabrik" , "Zersetzungsprozess" , "zielbewusst" , _
                        "Zierrat" , "Zigtausend" , "zigtausende" , "Zippverschluss" , _
                        "Zirkelschluss" , "Zivilprozess" , "Zivilprozessordnung" , "Zooorchester" , _
                        "Eigen" , "zueinander finden" , "Zufluss" , "zufrieden geben" , _
                        "zufrieden lassen" , "zufrieden stellen" , "zu Grunde" , "zu Grunde" , _
                        "zu Grunde" , "zugrunde liegend" , "zu Grunde liegend" , "zu Grunde" , _
                        "zu Gunsten" , "zuhause" , "zu Lande" , "zu Lasten" , _
                        "zu Leide" , "zu Mute" , "Zündschloss" , "Zungenkuss" , _
                        "Zungen-r" , "zu Nutze" , "zupass" , "zugepresst" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 29" 
  '/// Tools/Spellcheck/check  for some new German words - page 29
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_30

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling30.stw"
  
  aCheckedWord = Array( _
                        "zu Rande" , "zu Rate" , "zurückgemußt" , "zur Zeit" , _
                        "Zusammenfluß" , "zusammengefaßt" , "zusammengepaßt" , "zusammengepreßt" , _
                        "Zusammenschluß" , "zusammensein" , "zuschanden" , "zuschulden" , _
                        "Zuschuß" , "Zuschußbetrieb" , "zusein" , "zustande" , _
                        "zustande" , "zutage" , "zutage treten" , "zuungunsten" , _
                        "zuviel" , "zuwege" , "zuwenig" , "zwanziger Jahre" , _
                        "Zwanzigerjahre" , "Zweite" , "zweiter" , "zweite" , _
                        "Zweitkläßler" , "Zwischengeschoß" , _
                        )
                        
  aCorrectWord = Array( _
                        "zurande" , "zurate" , "zurückgemusst" , "zurzeit" , _
                        "Zusammenfluss" , "zusammengefasst" , "zusammengepasst" , "zusammengepresst" , _
                        "Zusammenschluss" , "zusammen sein" , "zu Schanden" , "zu Schulden" , _
                        "Zuschuss" , "Zuschussbetrieb" , "zu sein" , "zu Stande" , _
                        "zu Stande" , "zu Tage" , "zu Tage" , "zu Ungunsten" , _
                        "zu viel" , "zu Wege" , "zu wenig" , "Zwanzigerjahre" , _
                        "zwanziger Jahre" , "zweite" , "Zweiter" , "Zweite" , _
                        "Zweitklässler" , "Zwischengeschoss" , _
                       )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 30" 
  '/// Tools/Spellcheck/check  for some new German words - page 30
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************
