'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_drawing_tools2.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:26:55 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test of the drawing tools - group
'*
'************************************************************************
'*
' #1 tGroup_1
' #1 tGroup_2
' #1 tGroup_3
' #1 tGroup_4
' #1 tGroup_5
' #1 tGroup_6
' #1 tGroup_7
' #1 tGroup_8
' #1 tGroup_9
' #1 tGroup_10
' #1 tGroup_11
' #1 tGroup_12
' #1 tEncapsulatedGroup_1
'*
'\***********************************************************************

sub w_drawing_tools_2

   printLog Chr(13) + "- Test of the drawing tools 2 -- Group"

      'Group objects
       Call tGroup_1                'Generate a objects group via menu Format/Group/Group
       Call tGroup_2                'Generate a objects group via contextmenu Format/Group/Group
       Call tGroup_3                'Menu entries may not be enabled if less then two objects are selected
       Call tGroup_4                'Name a selected object group  via Menu Format/Name object
       Call tGroup_5                'Name a selected object group via context menu Name object
       Call tGroup_6                'Edit object group via Menu Format/Group/Edit Group
       Call tGroup_7                'Edit object group via context menu Group/Edit Group
       Call tGroup_8                'Leave object group  via Menu Format/Group/Exit Group
       Call tGroup_9                'Leave object group via context menu Group/Exit Group
       Call tGroup_10               'Create new objects inside the group ,Undo new created objects before leaving the group
       Call tGroup_11               'Create new objects inside the group ,Undo new created objects after leaving the group
       Call tGroup_12               'Save and reload document while editing a group
       Call tEncapsulatedGroup_1    'Group objects inside the group
end sub

'-------------------------------------------------------------------------

testcase  tGroup_1

  PrintLog "- Generate a objects group via menu Format/Group/Group"
  '/// Generate a objects group via menu Format/Group/Group

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
     Sleep 1
     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 1

   '/// via menu Format/Group/Group objects
     try
        FormatGroupGroup
     catch
        Warnlog "Something wrong when creating group via menu - Format/Group/Group."
     endcatch

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_2

  PrintLog "- Generate a objects group via contextmenu Format/Group/Group"
  '/// Generate a objects group via menu Format/Group/Group

   Call hNewDocument

  '/// Insert 2 drawing objects (rectangle and ellipse) ///
    Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
    Sleep 1
    Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
    Sleep 1
    wObjektSelektieren ( 8, 18, 55, 65 )
    Sleep 1

   '/// via contextmenu Group/Group objects
    try
        Call wOpenContextMenu
        hMenuSelectNr(10)
        hMenuSelectNr(1)
    catch
        Warnlog "Something wrong when creating group via contextmenu Group/Group"
    endcatch

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_3

  PrintLog "- Menu entries may not be enabled if less then two objects are selected"
  '/// Menu entries may not be enabled if less then two objects are selected

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
     Sleep 1

   '/// Only select 1 object
     Call gMouseClick(15,25)
     Sleep 1

   '/// via menu Format/Group/Group objects
     try
        FormatGroupGroup
        Warnlog "Should NOT generate the group when less then two objects are selected!"
     catch
     endcatch

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_4

  Dim sGroupName as String

  sGroupName = "myTestGroup"

  PrintLog "- Name a selected object group  via Menu Format/Name object"
  '/// Name a selected object group  via Menu Format/Name object

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
     Sleep 1
     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 1

   '/// via menu Format/Group/Group objects
     FormatGroupGroup
     Sleep 1

     try
       FormatNameObject
       Kontext
       Kontext "NameDlgGroup"
          NameField.SetText sGroupName
       NameDlgGroup.OK

     catch
       Warnlog "Something wrong when Naming the group"
     endcatch

   '/// let the focus out of the group
     Call gMouseClick(5,5)

     fStartupNavigator( "DrawObjects" , 1 )
     Auswahlliste.TypeKeys "<down><return>"  'after this step, the focus should be on the group
     Sleep 1

     try
       FormatNameObject
       Sleep 1
       Kontext
       Kontext "NameDlgGroup"
         if  NameField.GetText <> sGroupName then Warnlog "The group name is wrong !"
       NameDlgGroup.Cancel
     catch
       Warnlog "Something wrong when checking the group name"
     endcatch

     fCloseNavigator

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_5

  Dim sGroupName as String

  sGroupName = "myTestGroup"

  PrintLog "- Name a selected object group via context menu Name object "
  '/// Name a selected object group via context menu Name object

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
     Sleep 1
     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 1

   '/// via menu Format/Group/Group objects
     FormatGroupGroup
     Sleep 1

     try
       Call wOpenContextMenu
       hMenuSelectNr(5)
       Kontext
       Kontext "NameDlgGroup"
         NameField.SetText sGroupName
       NameDlgGroup.OK
     catch
       Warnlog "Something wrong when Naming the group"
     endcatch

   '/// let the focus out of the group
     Call gMouseClick(5,5)

     fStartupNavigator( "DrawObjects" , 1 )
     Auswahlliste.TypeKeys "<down><return>"  'after this step, the focus should be on the group
     Sleep 1

     try
       Call wOpenContextMenu
       hMenuSelectNr(5)
       Kontext
       Kontext "NameDlgGroup"
         if  NameField.GetText <> sGroupName then Warnlog "The group name is wrong !"
       NameDlgGroup.Cancel
     catch
       Warnlog "Something wrong when checking the group name"
     endcatch

     fCloseNavigator

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_6

  Dim sPositionX1  , sPositionY1  as String
  Dim sPositionX2  , sPositionY2  as String

  PrintLog "- Edit object group  via Menu Format/Group/Enter Group"
  '/// Edit object group  via Menu Format/Group/Enter Group

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 30, 25 , false)
     Sleep 1
     Call gMouseClick(12,22)
     Sleep 1
      fPositionAndSize("TabPositionAndSizeWriter")
         sPositionX1  =  Horizontalby.Gettext
         sPositionY1  =  Verticalby.Gettext
      TabPositionAndSizeWriter.Cancel
      Sleep 2
     Call gMouseClick(80,80)
     Sleep 1

     Call wZeichenobjektEinfuegen("ELLIPSE",  15, 27, 40, 35, false)
     Sleep 2
     Call gMouseClick(28,30)
     Sleep 1
      fPositionAndSize("TabPositionAndSizeWriter")
         sPositionX2  =  Horizontalby.Gettext
         sPositionY2  =  Verticalby.Gettext
      TabPositionAndSizeWriter.Cancel
      Sleep 2
     Call gMouseClick(80,80)

     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 2
     FormatGroupGroup
     Sleep 1

   '/// Format/Group/Enter Group
     FormatGroupEditGroup
     Sleep 1

   '/// Set the focus to ellipse , and move it
     Call gMouseClick(27,30)
     Sleep 1
     Call wDokSchreiben "<Right>",2

   '/// Set the focus to rectangle , check if it is moved (Should NOT)
     Call gMouseClick(15,23)
     fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext <> sPositionX1 then Warnlog "Rectangle should NOT be moved: X Not -> "+sPositionX1+"  but -> "+ Horizontalby.Gettext
      if Verticalby.Gettext   <> sPositionY1 then Warnlog "Rectangle should NOT be moved: Y Not -> "+sPositionY1+"  but -> "+ Verticalby.Gettext
     TabPositionAndSizeWriter.Cancel

   '/// Set the focus to ellipse , check if it is moved (Should)
     Call wDokSchreiben "<TAB>"
     fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext = sPositionX2 then Warnlog "ellipse should be moved"
      if Verticalby.Gettext   = sPositionY2 then Warnlog "ellipse should be moved"
     TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_7

  Dim sPositionX1  , sPositionY1  as String
  Dim sPositionX2  , sPositionY2  as String

  PrintLog "- Edit object group via context menu Group/Enter Group"
  '/// Edit object group via context menu Group/Enter Group

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 30, 25 , false)
     Sleep 1
     Call gMouseClick(12,22)
     Sleep 1
      fPositionAndSize("TabPositionAndSizeWriter")
         sPositionX1  =  Horizontalby.Gettext
         sPositionY1  =  Verticalby.Gettext
      TabPositionAndSizeWriter.Cancel
      Sleep 2
     Call gMouseClick(80,80)
     Sleep 1

     Call wZeichenobjektEinfuegen("ELLIPSE",  15, 27, 40, 35, false)
     Sleep 2
     Call gMouseClick(28,30)
      fPositionAndSize("TabPositionAndSizeWriter")
         sPositionX2  =  Horizontalby.Gettext
         sPositionY2  =  Verticalby.Gettext
      TabPositionAndSizeWriter.Cancel
      Sleep 2
     Call gMouseClick(80,80)

     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 2
     FormatGroupGroup
     Sleep 1

   '/// Context menu Group/Enter Group
     Call wOpenContextMenu
     hMenuSelectNr(11)
     Sleep 1
     hMenuSelectNr(2)
     Sleep 1

   '/// Set the focus to ellipse , and move it
     Call gMouseClick(27,30)
     Sleep 1
     Call wDokSchreiben "<Right>",2

   '/// Set the focus to rectangle , check if it is moved (Should NOT)
     Call gMouseClick(15,23)
     fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext <> sPositionX1 then Warnlog "Rectangle should NOT be moved: X Not -> "+sPositionX1+"  but -> "+ Horizontalby.Gettext
      if Verticalby.Gettext   <> sPositionY1 then Warnlog "Rectangle should NOT be moved: Y Not -> "+sPositionY1+"  but -> "+ Verticalby.Gettext
     TabPositionAndSizeWriter.Cancel

   '/// Set the focus to ellipse , check if it is moved (Should)
     Call wDokSchreiben "<TAB>"
     fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext = sPositionX2 then Warnlog "ellipse should be moved"
      if Verticalby.Gettext   = sPositionY2 then Warnlog "ellipse should be moved"
     TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_8

  Dim sPositionX  , sPositionY  as String

  PrintLog "- Leave object group  via Menu Format/Group/Exit Group"
  '/// Leave object group  via Menu Format/Group/Exit Group

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call gMouseClick(10,20)
     Sleep 1
      fPositionAndSize("TabPositionAndSizeWriter")
        sPositionX = Horizontalby.Gettext
        sPositionY = Verticalby.Gettext
      TabPositionAndSizeWriter.Cancel

     Call gMouseClick(80,80)
     Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 1

     FormatGroupGroup
     Sleep 1

   '/// Format/Group/Edit Group
     FormatGroupEditGroup
     Sleep 1

   '/// Leave group via Format/Group/Exit Group
     FormatGroupExitGroup   'after this group , the focus should be on the group
     Sleep 1

   '/// Set the focus to ellipse(in fact, the focus is on the group)  , and move it
     Call gMouseClick(35,50)
     Sleep 1
     Kontext "DocumentWriter"
     Call wDokSchreiben "<Right>",2
     Call wDokSchreiben "<Down>"

   '/// Set the focus to rectangle (in fact, the focus is still on the group) ,
   '/// check if it is moved . Group is moved , Rectangle is moved ...
     Call gMouseClick(40,35)
     fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext = sPositionX then Warnlog "Rectangle X should be moved!"
      if Verticalby.Gettext   = sPositionY then Warnlog "Rectangle Y should be moved!"
     TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_9

  Dim sPositionX  , sPositionY  as String

  PrintLog "- Leave object group  via context Menu Format/Group/Exit Group"
  '/// Leave object group  via context Menu Format/Group/Exit Group

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call gMouseClick(10,20)
     Sleep 1
      fPositionAndSize("TabPositionAndSizeWriter")
        sPositionX = Horizontalby.Gettext
        sPositionY = Verticalby.Gettext
      TabPositionAndSizeWriter.Cancel

     Call gMouseClick(80,80)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
     Sleep 1
     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 1
     FormatGroupGroup
     Sleep 1

   '/// Format/Group/Edit Group
     FormatGroupEditGroup
     Sleep 1

   '/// Leave group via context menu Group/Exit Group
     Call gMouseClick(35,50)
     Sleep 1
     Call wOpenContextMenu
     Sleep 2
     hMenuSelectNr(10)
     Sleep 2
     hMenuSelectNr(1)       'after this group , the focus should be on the group
     Sleep 2

   '/// Set the focus to ellipse(in fact, the focus is on the group)  , and move it
     Call gMouseClick(35,50)
     Kontext "DocumentWriter"
     Call wDokSchreiben "<Right>",2
     Call wDokSchreiben "<Down>"

   '/// Set the focus to rectangle (in fact, the focus is still on the group) ,
   '/// check if it is moved . Group is moved , Rectangle is moved ...
     Call gMouseClick(40,35)
     fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext = sPositionX then Warnlog "Rectangle X should be moved!"
      if Verticalby.Gettext   = sPositionY then Warnlog "Rectangle Y should be moved!"
     TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_10

  PrintLog "- create new objects inside the group ,"
  PrintLog "  Undo new created objects before leaving the group"
  '/// create new objects inside the group
  '/// Undo new created objects before leaving the group
   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 30, 30, 50, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  30, 60, 50, 80, false)
     Sleep 1
     wObjektSelektieren ( 25, 25, 55, 85 )
     Sleep 1

     FormatGroupGroup
     Sleep 1

   '/// insert another object (rectangle) in the group
     Call wZeichenobjektEinfuegen("RECHTECK", 35, 40, 45, 55)
     Sleep 1

   '/// Format/Group/Edit Group
     Call gMouseClick(30,32)
     Sleep 1
     FormatGroupEditGroup
     Sleep 1

   '/// Undo new created object( rectangle) before leaving the group
     EditUndo
     Sleep 1

     Call gMouseClick(35,40)    'set focus in the rectangle , in fact, the rectangle should be undone now.
     Sleep 1
     try
        fPositionAndSize("TabPositionAndSizeWriter")
        TabPositionAndSizeWriter.Cancel
        Warnlog "Undo before leaving the group is FAILED!"
     catch
     endcatch

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_11

  PrintLog "- create new objects inside the group ,"
  PrintLog "  Undo new created objects after leaving the group"
  '/// create new objects inside the group
  '/// Undo new created objects after leaving the group
   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 30, 30, 50, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  30, 60, 50, 80, false)
     Sleep 1
     wObjektSelektieren ( 25, 20, 55, 85 )
     Sleep 1

     FormatGroupGroup
     Sleep 1

   '/// insert another object (rectangle) in the group
     Call wZeichenobjektEinfuegen("RECHTECK", 35, 40, 45, 55, false)
     Sleep 2
   '/// Format/Group/Edit Group
     Call gMouseClick(30,32)
     Sleep 3
     FormatGroupEditGroup
     Sleep 1

   '/// Leave the group , Format/Group/Exit Group
     FormatGroupExitGroup
     Sleep 1

   '/// Undo new created object( rectangle) after leaving the group
     EditUndo
     Sleep 1

     Call gMouseClick(37,42)    'set focus in the rectangle , in fact, the rectangle should be undone now.
     Sleep 1
     try
        fPositionAndSize("TabPositionAndSizeWriter")
        TabPositionAndSizeWriter.Cancel
        Warnlog "Undo before leaving the group is FAILED!"
     catch
     endcatch

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tGroup_12

  Dim sDocument as String

  PrintLog "- Edit object group  via Menu Format/Group/Edit Group"
  '/// Edit object group  via Menu Format/Group/Edit Group

  sDocument = ConvertPath ( gOfficePath +"user\work\tGroup_12.sxw")
  if hFileExists ( sDocument ) then app.kill ( sDocument )

  Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  20, 40, 50, 60, false)
     Sleep 1
     wObjektSelektieren ( 8, 18, 55, 65 )
     Sleep 1

     FormatGroupGroup
     Sleep 1

   '/// Format/Group/Edit Group
     FormatGroupEditGroup
     Sleep 1

   '/// Save document
     Call hSpeichernUnterKill(sDocument)

   '/// close document
     Call hCloseDocument

   '/// Open previous saved document ///
     Call hDateiOeffnen(sDocument)
     Kontext "DocumentWriter"
     Call gMouseClick(20,30)    'set focus in the group

   '/// try formatGroupEditGroup
     try
        FormatGroupEditGroup
     catch
        Warnlog "It should be in the group mode!"
     endcatch

   '/// close document
     Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tEncapsulatedGroup_1

  PrintLog "- Group objects inside the group ,Encapsulated Group"
  '/// Group objects inside the group ,Encapsulated Group

   Call hNewDocument

   '/// Insert 2 drawing objects (rectangle and ellipse) , generate a group ///
     Call wZeichenobjektEinfuegen("RECHTECK", 10, 20, 40, 35, false)
     Sleep 1
     Call wZeichenobjektEinfuegen("ELLIPSE",  50, 50, 80, 80, false)
     Sleep 1
     wObjektSelektieren ( 8, 18, 85, 85 )
     Sleep 1

     FormatGroupGroup
     Sleep 1

   '/// insert 2 drawing objects (rectangle and ellipse) in the group
     Call wZeichenobjektEinfuegen("RECHTECK", 12, 40, 38, 45, false)
     Call wZeichenobjektEinfuegen("ELLIPSE",  52, 40, 78, 45, false)
     wObjektSelektieren ( 11, 38, 79, 48 )

   try
   '/// generate a new group
     FormatGroupGroup
   '/// edit the new group
     FormatGroupEditGroup
   '/// leave the new group
     FormatGroupExitGroup
   '/// Undo the new group
     FormatGroupUnGroup
   catch
     Warnlog "Something wrong where operating the Encapsulated group!"
   endcatch

   Call hCloseDocument

endcase
