'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_so7_pp1_iz.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: pj $ $Date: 2005/11/22 13:50:40 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'**
'** owner : peter.junge@Sun.COM
'**
'** short description :  Test fixes for Issuezilla Bugs
'**
'************************************************************************
' **
' #1 issuezillaPP1        ' Initial routine
' #1 tIZ19381             ' I/O error when OLE object is thrown out of undo/redo buffer  
' #1 tIZ21036             ' Crash after shifting cells with paste special
' **
'\***********************************************************************

sub issuezillaPP1

Printlog Chr(13) + "--------- Izzuezilla Bugs fixed? ---------"

        call tIZ19381
        call tIZ21036

end sub

'**************************************************************************************************

testcase tIZ19381

dim sOutputFile 
dim iIndex

sOutputFile = convertpath(gOfficepath & "user/work/i19381") 

printlog "IssueZilla Task 19381"

'/// call new document
call hNewDocument
sleep(2)

'/// enter some numbers as content
Kontext "DocumentCalc"
  DocumentCalc.typekeys "1<RETURN>2<RETURN><UP>"
  sleep(2)

'/// create a chart from the content
InsertChartCalc
Kontext "AutoFormatDiagrammBeginn"
  Fertigstellen.Click
  sleep(2)
Kontext "DocumentCalc"
  DocumentCalc.typekeys "<Escape>"
  sleep(2)
'/// save document
  if NOT hSpeichernUnterMitFilterKill (sOutputFile, gsFileFormat) then
      warnlog "Saving test document localy failed -> Aborting"
      call hCloseDocument
      goto endsub
  endif
sleep(2)
  
'/// reload document again
call hCloseDocument
sleep(2)
FileOpen
Kontext "OeffnenDlg"
  Dateiname.Settext sOutputFile
  Oeffnen.Click
  sleep(2)
  call gMouseClick(95,95)

'/// cut the chart
Kontext "DocumentCalc"
  call fNavigatorSelectObject ( "ole objects" , 1 )
  sleep(2)
  EditCut
  sleep(2)
'/// paste the chart again
Kontext "DocumentCalc"
  DocumentCalc.TypeKeys "<ESCAPE>"
  EditPaste
  sleep(2)
'/// save document
Kontext "DocumentCalc"
  DocumentCalc.typekeys "<MOD1 S>"
  sleep(2)
kontext
  if active.exists(2) then
      warnlog "OOPS, found unexpected MsgBox -> Check this out!"
      active.OK
  endif

'/// enter 21 numbers as changes to get chart cut/paste out of the undo buffer
Kontext "DocumentCalc"
  DocumentCalc.TypeKeys "<ESCAPE>"
  call fCalcSelectCell("E42")
  for iIndex = 1 to 21
      DocumentCalc.typekeys "1<Return>"
  next iIndex

'/// Try to save another time
Kontext "DocumentCalc"
  DocumentCalc.typekeys "<MOD1 S>"

'/// check for error message
Kontext "Active"
  if Active.Exists(2) then
     if Active.GetRT = 304 then
        printlog Active.GetText
        WarnLog "Issue 19381 seems to occur again!"
        Active.OK
     end if
  else
     printlog "No message box is in the way!"
  end if    
'/// clean up dialogs and leave the testcase
call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tIZ21036

printlog "IssueZilla Task 21036"

'/// open new document
call hNewDocument
sleep(2)

'/// select a whole row (e.g. A1:IV1)
Kontext "DocumentCalc"
DocumentCalc.typekeys "<SHIFT MOD1 RIGHT>"
sleep(2)

'/// cut selection
try
  EditCut
catch
  QAErrorLog "Is this a crash?? Please check it out!"
  goto endsub
endcatch
sleep(2)

'/// go to A2
call fCalcSelectCell("A2")
sleep(2)

'/// call edit->paste special
EditPasteSpecialCalc
sleep(2)

'/// check shift cells->right
Kontext "InhalteEinfuegenCalc"
NachRechts.Check

'/// OK
InhalteEinfuegenCalc.OK

'/// confirm MsgBox
Kontext "Active"
  if Active.Exists(2) then
     if Active.GetRT = 304 then
        printlog Active.GetText
        Active.OK
        sleep(2)
     end if
  else
     warnlog "No message box came up!"
     goto endsub
  end if

'/// check for crash
try
   printlog "OK, there are still " & hWindowGetCount & " documents open"
catch 
   warnlog "Probably the office did crash -> Check this out!"
   goto endsub
endcatch
  
call hCloseDocument
endcase

