'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_spellcheck.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/05/15 14:45:15 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description :
'*
'*******************************************************************
'*
' #1 tiToolsSpellcheckCorrect
' #1 tiToolsSpellcheckError
' #1 tiToolsSpellcheckCheck
' #1 tToolsSpellcheckAutoSpellcheck
'*
'\*******************************************************************

testcase tiToolsSpellcheckCorrect
    Dim DieDatei as String
    dim lFiles(100) as string
    dim i as integer
    dim iFiles as integer

    lFiles(0)=0
    Printlog "- Checking Dictionary-Files" ' borrowed from w_106.inc
    '/// check if dictionary exists for this EUROPEAN language as file  ///'
    '///+  share/dict/$iSprache-hyph.dat ///'
    '///+ print all dictionaries from share/dict/*.dat ///'
    select case iSprache
        case 01 : DieDatei = "01-44-hyph.dat"
        case else : DieDatei =  "" & iSprache & "-hyph.dat"
    end select
    DieDatei = Convertpath(gNetzOfficePath + "share\dict\" + DieDatei)
    if gPlatGroup <> "unx" then
        if (Dir(DieDatei) = "") then
            if bAsianLan then
                printlog "Dictionary not found : " + DieDatei + ", but is AsianLan, so OK :-)"
            else
                if gNetzInst then
                    printlog "Dictionary not found : " + DieDatei
                 else
                    warnlog "Dictionary not found : " + DieDatei
                 endif
            endif
        else
            Printlog "    Dictionary has been installed : " + DieDatei
        end if
    end if
    iFiles = GetFileList (Convertpath (gNetzOfficePath + "share\dict\"), "*.dat" ,lFiles())
    for i = 1 to iFiles
        printlog " " + i + ": " + DateiExtract(lFiles(i))
    next i

    PrintLog "'/// Spellcheck without text ///'"
    '///+ Open new document ///'
    Call hNewDocument
    sleep 2
    '///+ call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    Kontext "Active"
    '///+ There has to come up only one active: 'Spellcehck of entire document has been completed [OK]' ///'
    if Active.Exists(5) then
        try
            printlog "Message: Finished: Want to continue at the beginning? '" + active.gettext + "'"
            Active.No
        catch
            Warnlog "The Active-dialoge didn't have a No-button, tries with OK instead."
            Active.Ok
        endcatch
    else
        Warnlog "No 'Spellcheck finished, do you wish to continue?' message appeared"
    end if
    sleep 2

    PrintLog "- Spellcheck with correct text"
    '/// create textbox without a spelling error ///'
    select case iSprache
        case 01   : hTextrahmenErstellen ("This is a text without any error.<Return>",10,10,50,20)
        case 33   : hTextrahmenErstellen ("Il nous faut donc un de temps pour examiner avec soin tous les dossiers.<Return>",10,10,70,20)
        case 34   : hTextrahmenErstellen ("Este es un chico muy importante.",10,10,50,20)
        case 39   : hTextrahmenErstellen ("La ringraziamo per l'interesse mostrato a collaborare con la firma.<Return>",10,10,70,20)
        case 46   : hTextrahmenErstellen ("Det varierar vad som behandlas och ur vilket perspektiv.<Return>",10,10,50,20)
        case 49   : hTextrahmenErstellen ("Dies ist ein Text ohne Fehler.<Return>",10,10,50,20)
        case 55   : hTextrahmenErstellen ("Esta poderia ser a resposta para suas preces?<Return>",10,10,50,20)
        case else :
            if bAsianLan then
                printlog "For the language  " + iSprache +" nothing is prepared yet, but is AsianLan, so OK :-) will use english instaed"
                ' there was smth wrong, try to find out :
                kontext
                if active.exists then
                    printlog "ERROR: active: '"+active.gettext+"'"
                    active.ok
                endif
                hTextrahmenErstellen ("This is a text without any error.<Return>",10,10,50,20)
            else
                Warnlog "For the language  " + iSprache +" nothing is prepared yet: insert text here"
                hTextrahmenErstellen ("This is a text without any error.<Return>",10,10,50,20)
            endif
    end select
    '///+ call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    sleep 2
    '///+ There has to come up only one active: 'Spellcheck of entire document has been completed [OK]' ///'
    Kontext "Active"
    if active.exists(5) then
        printlog "Message: spellchecking has finished?: '" + active.gettext + "'"
        Active.OK
    else
        errorLog "Spellcheck started :"
        Kontext "Spellcheck"
        if Spellcheck.exists then
            errorlog " - spellcheck came up and will be closed now"
            Spellcheck.Close
        else
            printlog "spellcheck didn't come up"
        endif
    endif
    sleep 2
    '/// close document ///'
    Call hCloseDocument
endcase

testcase tiToolsSpellcheckError
    Dim Fehler$
    Dim Sprachenname$
    Dim Dummy$
    Dim FehlerText$
    Dim i as integer

    '/// New document ///'
    Call hNewDocument
    select case iSprache
        case 01 : FehlerText$ = "Thatt is a failure test."                      : Fehler$ = "Thatt" : Sprachenname$ = "English (US)"
        case 34 : FehlerText$ = "Ezte es un chico muy importante."              : Fehler$ = "Ezte"  : Sprachenname$ = "Niederlaendisch"
        case 33 : FehlerText$ = "Ler nous faut donc un de temps pour examiner." : Fehler$ = "Ler"   : Sprachenname$ = "Franzoesisch"
        case 39 : FehlerText$ = "Ringrarziamo per l'interessa mostrato a collaborare con la firma." : Fehler$ = "Ringrarziamo" : Sprachenname$ = "Italienisch"
        case 46 : FehlerText$ = "Detd varierar vad som behandlas och ur vilket perspektiv."         : Fehler$ = "Detd"         : Sprachenname$ = "Schwedisch"
        case 49 : FehlerText$ = "Diees ist ein Fehler."                         : Fehler$ = "Diees" : Sprachenname$ = "Deutsch"
        case 55 : FehlerText$ = "Eesta poderia ser a resposta para suas preces?": Fehler$ = "Eesta" : Sprachenname$ = "Portugiesisch"
        case else :
            if bAsianLan then
                printlog "For the language  " + iSprache +" nothing is prepared yet, but is AsianLan, so OK :-) using english"
                FehlerText$ = "Thatt is a failure test."
                Fehler$ = "Thatt"
                Sprachenname$ = "English (US)"
                call hSetSpellHypLanguage
            else
                Warnlog "For the language  " + iSprache +" nothing is prepared yet: insert text here"
            endif
    end select
    sleep 2

    '/// delete ignore word list ///'
    if (not wIgnorierenlisteLoeschen) then
        qaErrorLog "Can't get into Dictionary lists"
        goto endsub
    endif

    '/// create 1 textbox with 1 spelling error (test replace always) ///'
    hTextrahmenErstellen (FehlerText$,30,30,90,40)
    sleep 1
    hTypeKeys "<HOME>"
    '/// call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    '/// Spellcheck dialog has to come up, wrong word is selected ///'
    Kontext "Spellcheck"
    if Spellcheck.Exists then
        '/// there has to be at least ONE suggestion ///'
        if (Suggestions.GetItemCount < 1) then
            '/// if no suggestion avilable: ///'
            warnlog "   - no suggestion for the language: "+DictionaryLanguage.GetSelIndex+" '"+DictionaryLanguage.GetSelText+"' , press check button..."
            '///+ press button 'Check word'  ///'
            Pruefen.click
            if (Suggestions.GetItemCount < 1) then
                warnlog " STILL no suggestions :-( errors will follow "
            else
                printlog "   - now suggestion for the language: "+DictionaryLanguage.GetSelIndex+" '"+DictionaryLanguage.GetSelText+"'" + Suggestions.GetItemCount
            endif
        endif
        Dummy$=Suggestions.GetItemText (1)
        '/// select first spellcheck suggestion (click it!) ///'
        Suggestions.Select (1)
        '/// check if textfield 'word' has changed to selected word ///'
        if (Suggestions.GetSelText <> Dummy$) Then
            Warnlog "  - Suggestion not used"
        else
            Printlog "  Suggestion is used"
        end if
        sleep 1
        kontext "Spellcheck"
        '/// click button 'Always replace' ///'
        ChangeAll.Click
        '/// spellcheck dialog has to disappear and ///'
        '///+ There has to come up only one active: 'Spellcheck of entire document has been completed [OK]' ///'
        Kontext "Active"
        if Active.Exists(5) then
            Printlog "Message: Spellchecking has finished?: '" + active.gettext + "'"
            Active.OK
        else
            Printlog "'Change All' seems to have worked correctly."
            Kontext "Spellcheck"
            Spellcheck.Close
            Kontext "Active"
            if active.exists(5) then
               Printlog " Spellcheck dialog closed'" + active.gettext + "'"
               Active.OK
            else
               Printlog " Spellcheck dialog closed'"
            endif
        end if
    else
        Warnlog "  Error not recognized by the Spellchecker"
        if active.exists(5) then
           Kontext "Active"
           printlog "Message: spellchecking has finished?: '" + active.gettext + "'"
           Active.OK
        endif
    end if

    '/// delete textbox ///'
    EditSelectAll
    hTypeKeys "<DELETE>"
    sleep 1

    '/// create same textbox again (test IGNORE function) ///'
    Printlog "  check function Ignore"
    hTextrahmenErstellen (FehlerText$,30,30,80,40)
    '/// call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    Kontext "Spellcheck"
    '/// press button 'Ignore' ///'
    IgnoreOnce.Click
    '/// spellcheck dialog has to disappear and ///'
    '///+ There has to come up only one active: 'Spellcheck of entire document has been completed [OK]' ///'
    Kontext "Active"
    if Active.Exists(5) Then
        Printlog " Spellcheck ended because of only 1 defined error. And Ignore worked.'" + active.gettext + "'"
        Active.OK
    else
        Printlog " 'Ignore Once' seems to work correctly."
        Kontext "Spellcheck"
        Spellcheck.Close
        Kontext "Active"
        if active.exists(5) then
           Printlog " Spellcheck dialog closed'" + active.gettext + "'"
           Active.OK
        else
           Printlog " Spellcheck dialog closed'"
        endif
    end if

    '/// call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    Kontext "Spellcheck"
    if Spellcheck.Exists Then
        Printlog "  Ignore worked"
        Spellcheck.Close
        Kontext "Active"
        if active.exists(5) then
           Printlog " " + active.gettext + "'"
           Active.OK
        else
           Printlog " Spellcheck dialog closed'"
        endif
    else
        Warnlog "  Spellcheck ended even we only ignored the error"
    '    Kontext "Active"
    '    Printlog " '" + active.gettext + "'"
     '   Active.OK
    end if

    '/// delete textbox ///'
    EditSelectAll
    hTypeKeys "<DELETE>"
    sleep 1

    '/// create same textbox again (test ALWAYS IGNORE function) ///'
    hTextrahmenErstellen (FehlerText$,30,30,60,40)
    '/// call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    Kontext "Spellcheck"
    '/// click button 'Always Ignore' ///'
    IgnoreAll.Click
    '/// spellcheck dialog has to disappear and ///'
    '///+ There has to come up only one active: 'Spellcheck of entire document has been completed [OK]' ///'
    Kontext "Active"
    if active.exists(5) then
        Printlog " Spellcheck ended because of only 1 defined error. And Ignore worked.'" + active.gettext + "'"
        Active.OK
    else
        Printlog " 'Ignore All' seems to work."
        Kontext "Spellcheck"
        Spellcheck.Close
        Kontext "Active"
        if active.exists(5) then
           Printlog " Spellcheck dialog closed'" + active.gettext + "'"
           Active.OK
        else
           Printlog " Spellcheck dialog closed'"
        endif
    endif
    '/// call 'Tools->Spellcheck->Check' ///'
'    ToolsSpellcheck
'    Kontext "Active"
'    if Active.Exists(5) Then
'        Warnlog " Spellcheck dialog wasnt closed directly'" + active.gettext + "'"
'        Active.OK
'    end if

    Printlog "- Delete ignore list"
    sleep 1
    '/// delete ignore word list ///'
    if (not wIgnorierenlisteLoeschen) then
        qaErrorLog "Can't get into Dictionary lists"
        goto endsub
    endif
    Call hCloseDocument
endcase

testcase tiToolsSpellcheckCheck
    Dim Datei$
    Dim sWord(2) as string
    Dim i as integer
    Dim j as integer
    Dim s as integer
    Dim AlleBuecher as integer
    dim sExt as string
    Dim sWordOne as string
    Dim sWordTwo as string
    Dim iBooks as integer
    dim bWordFound(2) as boolean
    dim iSuggestions as integer
    dim iWord(2) as integer
    dim bFound as boolean

    Select Case Ucase(gApplication)
        case "DRAW"         : sExt = ".sxd"
        case "IMPRESS"      : sExt = ".sxi"
    end select

    '/// load prepared document containing 4 errors : "graphics\\level1\\input\\recht_ "///'
    if (not bAsianLan) then
       Call hDateiOeffnen (gTesttoolpath + "graphics\level1\input\recht_"+iSprache+sExt)
       ' check if the document is writable
    else
       Call hDateiOeffnen (gTesttoolpath + "graphics\level1\input\recht_1"+sExt)
    endif
    if fIsDocumentWritable = false then
       ' make the document writable and check if it's succesfull
       if fMakeDocumentWritable = false then
          warnlog "The document can't be make writeable. Test stopped."
          goto endsub
       endif
    endif
    select case iSprache  ' sWord(1)=red     : sWord(2)=turquoise
        case 01 : sWord(1) = "documente"     : sWord(2) = "expriss"
        case 33 : sWord(1) = "intercu"       : sWord(2) = "Lees"
        case 34 : sWord(1) = "afekto"        : sWord(2) = "fratternal"
        case 39 : sWord(1) = "Millano"       : sWord(2) = "target"
        case 46 : sWord(1) = "desa"          : sWord(2) = "occh"
        case 49 : sWord(1) = "Texxt"         : sWord(2) = "reichtt"
        case 55 : sWord(1) = "esktava"         : sWord(2) = "noitee"
    case else :
        if bAsianLan then
            sWord(1) = "documente"     : sWord(2) = "expriss"
        else
            Warnlog "For the language  " + iSprache +" nothing is prepared yet: insert text here and create the file"
        endif
    end select
    sleep 2

    Printlog "'/// Delete all added words from dictionaries ///'"
    '///+ call Tools->Options ///'
    ToolsOptions
    '///+ select in category 'Languagesettings' entry 'Writing Aids' ///'
    hToolsOptions ("LANGUAGESETTINGS","WRITINGAIDS")
    sleep 1
    Kontext "WRITINGAIDS"
    sleep 1
    '///+ click on button 'edit' in section 'User-defined dictionaries' ///'
    if (fGetIntoDictionary) then
        qaErrorLog "wTSC"
        goto endsub
    endif
    Kontext "BenutzerwoerterbuchBearbeiten"
    sleep 1
    '///+ check every book, if it contains the words that will be added in this test ///'
    iBooks = Buch.getItemCount
    bWordFound(1) = false
    bWordFound(2) = false
    for i = 1 to iBooks
        Buch.select(i)
        printlog WordList.getItemCount
        for j = 1 to 2
            Wort.setText sWord(j)
            sleep 1
            if ((not neu.isEnabled) and Loeschen.isEnabled) then
                '///+ if it contains the word, press button 'delete'  ///'
                Loeschen.click
                bWordFound(j) = true
                printlog " added word WAS in dictionary: '" + Buch.getSelText + "' - '" + sWord(j) + "'"
            endif
        next j
    next i
    if (bWordFound(1) OR bWordFound(2))then
        qaErrorLog "Word was found in dictionary - check why it was there. '" + sWord(1) + "': " + bWordFound(1) + "  '" + sWord(2) + "': " + bWordFound(2)
    endif
    '///+ close dialog 'Edit Custom Dictionary'  ///'
    BenutzerwoerterbuchBearbeiten.Close
    sleep 1
    Kontext "ExtrasOptionenDlg"
    '///+ press button 'OK' on dialog 'Writing Aids'///'
    ExtrasOptionenDlg.OK
    '///+ call dialog again and delete all remaining words from dictionary 'IgnoreAllList' ///'
    if (not wIgnorierenlisteLoeschen) then
        qaErrorLog "Can't get into Dictionary lists"
        goto endsub
    endif

    '/// test if spellcheck dialog comes up and check/set direction of spellcheck ///'
    '///+ call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    Kontext "Spellcheck"
    sleep 1
    '///+ if no dictionary for the language is available, a messagebox comes up: ///'
    '///+ . . . 'Error executing the spellcheck.: $Language is not supported by spellchecker funtion.'  ///'
    kontext "active"
    if active.exists(5) then
        warnLog "$Language is not supported by spellchecker funtion: '" + active.gettext + "'"
        Active.OK
        '///+ . . . . . . exiting testcase  ///'
        goto endsub
    endif
    Kontext "Spellcheck"
    '/// Save the current Dictionary Language ///'
    s = DictionaryLanguage.GetSelIndex
    for i= 1 to DictionaryLanguage.GetItemCount
        DictionaryLanguage.Select i
        sleep 1
        printlog " # "+i+": "+DictionaryLanguage.GetSelText
    next i

    iWord(1) = 1
    iWord(2) = 2

    DictionaryLanguage.Select s
    '/// Close dialog 'Spellcheck' ///'
    Spellcheck.Close
    Kontext "Active"
    if active.exists(5) then
       Warnlog " Should not be any message here: " + active.gettext + "'"
       Active.OK
    else
       printlog "Spellcheck ended, dialog closed"
    endif

    '/// check presupposiotion: 12 Words have to be complained about ///'
    '///+ call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    Sleep 2
    Kontext "Spellcheck"
    printlog "   - check if switch is still available :-)"
    for i = 1 to 11
        Kontext "Spellcheck"
        '///+ click button 'Ignore' 12 times///'
        IgnoreOnce.Click
        Kontext "Active"
        if active.exists(5) then
            warnlog "Presupposition not met: there are less than 12 errors in the document! " + i
            Active.OK
            '///+ if errors < 12 -> exiting testcase  ///'
            goto endsub
        endif
    next i
    Kontext "Spellcheck"
    IgnoreOnce.Click
    '///+ Spellcheck dialog has to disapear and messagebox with OK has to come up  ///'
    Kontext "Active"
    if active.exists(5) then
       printlog "Active said: " + active.gettext + "'"
       Active.NO
    endif
    Kontext "Spellcheck"
    if Spellcheck.Exists(5) then
       warnlog "Presupposition not met: there are more than 12 errors in the document!"
       Spellcheck.Close
       kontext "Active"
       if active.exists(5) then
          Active.OK
       else
          printlog "bug fixed #111972# "
       endif
       '///+ if errors > 12 -> exiting testcase  ///'
       goto endsub
    else
       Kontext "Active"
       if active.exists(5) then
          warnlog "There was a Message where none was supposed to be: '" + active.gettext + "'"
          Active.NO
       endif
       printlog "Presupposition met: there are 12 errors in the document!"
    endif

    '/// perform the test now ///'
    '///+ call 'Tools->Spellcheck->Check' ///'
    ToolsSpellcheck
    Sleep 2
    Kontext "Spellcheck"
    Printlog "----------------------------------------------------------------------------"
    Printlog "   - Ignore now"
    '/// 1st error: ignore : 1st pink word in 1st Paragraph ///'
    '///+ backwards: 1st green word in 3rd Paragraph ///'
    sWordOne = Suggestions.GetSelText
    printlog "********* word found: '" + sWordOne + "'"
    printlog "##### suggestions: "+Suggestions.GetItemCount+"; Language: "+DictionaryLanguage.getSelText '+" ; dictionary: "+woerterbuch.getSelText
    if (Suggestions.GetItemCount > 0) then
        printlog "----- "+i+": "+Suggestions.GetSelText (1)
    endif
    '///+ click button 'Ignore' ///'
    IgnoreOnce.Click
    Sleep 2

    Printlog "----------------------------------------------------------------------------"
    Printlog "   - Add"
    '/// 2nd error: add : 1st red word in 1st Paragraph -> hasn't to show up anymore from now on ///'
    '///+ backwards: 1st turquoise word in 3rd Paragraph -> hasn't to show up anymore from now on ///'
    '///+ check if word in textfield 'Word' changed  ///'
    '///+ (check if it is the expected next error - you have to look into the source code for the right word!) ///'
    sWordTwo = Suggestions.GetSelText
    if (sWordOne = sWordTwo) then
        warnlog "Ignore didn't work? Spellcheck didn't go on"
    endif
    if (sWord(iWord(1)) <> sWordTwo) then
       Printlog "The errornous word '" + sWord(iWord(1)) + "' would be replaced with: '" + sWordTwo + "'"
      ' warnlog "This is not the expected 2nd Word; expected: '" + sWord(iWord(1)) + "' is: '" + sWordTwo + "'"
    endif
    printlog "********* word found: '" + sWordTwo + "'"
    printlog "##### suggestions: "+Suggestions.GetItemCount+"; Language: "+DictionaryLanguage.getSelText ' +" ; dictionary: "+woerterbuch.getSelText
    if (Suggestions.GetItemCount > 0) then
        printlog "----- "+i+": "+Suggestions.GetSelText (1)
    endif
    Sleep 1
    '///+ click button 'Add' on dialog '' ///'
    AddToDictionary.Click
     Sleep 2
    printlog "The menu has: " + MenuGetItemCount + " entries."
     hMenuSelectNr(1) 'Default
    Kontext "Active"
    if Active.Exists(5) Then
        Warnlog " - Word could not be added to dictionary: '" + active.getText + "'"
        Active.OK
        Sleep 1
    end if
    'check in options, if word exists in word list
    '///+ click button 'Options' on dialog 'Spellcheck'///'
    Kontext "Spellcheck"
    SpellcheckOptions.Click
    Kontext "TabLinguistik"
    '///+ click button 'Edit ...' on dialog 'Writing Aids' in section 'User-defined dictionaries'///'
    if TabLinguistik.exists(5) then
        sleep 5
    if (fGetIntoDictionary) then
        qaErrorLog "wTSC"
        goto endsub
    endif
    else
        qaerrorlog "baeh"
    endif
    Kontext "BenutzerwoerterbuchBearbeiten"
    '///+ check every book, if it contains the added word ///'
    if not BenutzerwoerterbuchBearbeiten.exists(5) then
        sleep 5
        qaerrorlog "baeh"
    endif
    iBooks = Buch.getItemCount
    bWordFound(1) = false
    for i = 1 to iBooks
        Buch.select(i)
        Wort.setText sWord(iWord(1))
        sleep 1
        if ((not neu.isEnabled) and Loeschen.isEnabled) then
            bWordFound(1) = true
            printlog " added word is in dictionary: '" + Buch.getSelText + "'"
        endif
    next i
    if (not bWordFound(1)) then
        warnlog "Word was not added to dictionary"
    endif
    '///+ cancel dialog 'Edit Custom Dictionary' ///'
    BenutzerwoerterbuchBearbeiten.Close
    Kontext "TabLinguistik"
    '///+ cancel dialog 'Writing Aids' ///'
    TabLinguistik.Close
    Kontext "Spellcheck"

    Printlog "----------------------------------------------------------------------------"
    Printlog "   - Always Ignore"
    '/// 3rd error: always ignore : 1st turquoise word in 1st Paragraph -> hasn't to show up anymore from now on ///'
    '///+ check if word in textfield 'Word' changed  ///'
    '///+ (check if it is the expected next error - you have to look into the source code for the right word!) ///'
    sWordOne = sWordTwo
    sWordTwo = Suggestions.GetSelText 'wort.getText
    if (sWordOne = sWordTwo) then
        warnlog "Add didn't work? Spellcheck didn't go on."
    endif
    if (sWord(iWord(2)) <> sWordTwo) then
       Printlog "The errornous word '" + sWord(iWord(2)) + "' would be replaced with: '" + sWordTwo + "'"
    else
       Warnlog "ERROR: SAME WORD in the dictionary as in the text??? Must be wrong."
    endif
    printlog "********* word found: '" + sWordTwo + "'"
    printlog "##### suggestions: "+Suggestions.GetItemCount+"; Language: "+DictionaryLanguage.getSelText  ' +" ; dictionary: "+DictionaryLanguage.getSelText   'Wort.GetItemCount  'Woerterbuch.GetSelText
    if (Suggestions.GetItemCount > 0) then  'Wort.GetItemCount > 0) then
        printlog "----- "+i+": "+Suggestions.GetItemText (1)  'Wort.GetItemText (1)
    endif
    Sleep 1
    '///+ click button 'Always ignore' on dialog ///'
    IgnoreAll.Click
    Sleep 2
    'check in options, if word exists in word list
    '///+ click button 'Options' on dialog 'Spellcheck'///'
    SpellcheckOptions.Click
    Kontext "TabLinguistik"
    '///+ click button 'Edit ...' on dialog 'Writing Aids' in section 'User-defined dictionaries'///'
    if TabLinguistik.exists(5) then
        sleep 5 'culprint swedish windows; wait until butrton exists?
    if (fGetIntoDictionary) then
        qaErrorLog "wTSC"
        goto endsub
    endif
    else
        qaerrorlog "baeh"
    endif
    Kontext "BenutzerwoerterbuchBearbeiten"
    if not BenutzerwoerterbuchBearbeiten.exists(5) then
        sleep 5
        qaerrorlog "baeh"
    endif
    '///+ check every book, if it contains the added word ///'
    iBooks = Buch.getItemCount
    bWordFound(2) = false
    for i = 1 to iBooks
        Kontext "BenutzerwoerterbuchBearbeiten"
        Buch.select(i)
        Inhalt.setText sWord(iWord(2)) 'Wort.setText sWord(iWord(2))
        sleep 1
        if ((not neu.isEnabled) and Loeschen.isEnabled) then
            bWordFound(2) = true
            printlog " added word is in dictionary: '" + Buch.getSelText + "'"
        endif
    next i
    if (not bWordFound(2)) then
        warnlog "Word was not added to dictionary"
    endif
    '///+ cancel dialog 'Edit Custom Dictionary' ///'
    BenutzerwoerterbuchBearbeiten.Close
    Kontext "TabLinguistik"
    '///+ cancel dialog 'Writing Aids' ///'
    TabLinguistik.Close 'Cancel
    Kontext "Spellcheck"

    Printlog "----------------------------------------------------------------------------"
    Printlog "   - Replace"
    '/// 4th error: replace : 1st green word in 1st Paragraph ///'
    '///+ check if word in textfield 'Word' changed  ///'
    '///+ (check if it is the expected next error - you have to look into the source code for the right word!) ///'
    sWordOne = sWordTwo
    sWordTwo = Suggestions.GetSelText
    if (sWordOne = sWordTwo) then
       warnlog "Always ignore didn't work? Spellcheck didn't go on."
    endif
    printlog "********* word found: '" + sWordTwo + "'"
    iSuggestions = Suggestions.GetItemCount
    printlog "##### suggestions: " + iSuggestions + "; Language: "+DictionaryLanguage.getSelText  '+"; dictionary: "+woerterbuch.getSelText
    if (Suggestions.GetItemCount > 0) then
        printlog "----- "+i+": "+Suggestions.GetItemText (1)
    endif
    Sleep 1
    '///+ click button 'Replace' ///'
    if (iSuggestions > 0) then
        Change.click
    else
        qaErrorLog "Please change the text in the file, so the spellchecker can make a suggestion for the word: '" + sWordTwo + "'"
        IgnoreOnce.Click
    endif
    ' remember the replaced word and search after it ?

    Printlog "----------------------------------------------------------------------------"
    Printlog "   - Always Replace"
    '/// 5th error: always replace : 1st pink word in 2nd Paragraph -> hasn't to show up anymore from now on ///'
    '///+ backwards: 1st green word in 2nd Paragraph -> hasn't to show up anymore from now on ///'
    '///+ check if word in textfield 'Word' changed  ///'
    '///+ (check if it is the expected next error - you have to look into the source code for the right word!) ///'
    sWordOne = sWordTwo
    sWordTwo = Suggestions.GetSelText
    if (sWordOne = sWordTwo) then
        warnlog "Replace didn't work? Spellcheck didn't go on"
    endif
    printlog "********* word found: '" + sWordTwo + "'"
    iSuggestions = Suggestions.GetItemCount
    printlog "##### suggestions: " + iSuggestions + "; Language: "+DictionaryLanguage.getSelText  ' +"   ; dictionary: "+woerterbuch.getSelText
    if (Suggestions.GetItemCount > 0) then
        printlog "----- "+i+": "+Suggestions.GetItemText (1)
    endif
    Sleep 1
    '///+ click button 'Always Replace' ///'
    if (iSuggestions > 0) then
        ChangeAll.click
    else
        qaErrorLog "Please change the text in the file, so the spellchecker can make a suggestion for the word: '" + sWordTwo + "'"
        IgnoreOnce.Click
    endif
    ' remember the replaced word and search after it ?

    '/// 2 errors are left: 4th word (green) in 2nd and 3rd paragraph ///'
    '///+ backwards: 1st word (pink) in 2nd and 1st paragraph ///'
        Kontext "Spellcheck"
        sWordOne = sWordTwo
        sWordTwo = Suggestions.GetSelText
        if (sWordOne <> sWordTwo) then
            printlog sWordTwo
        else
            warnlog "there is anopther word left, that wasn't expected!. '" + sWordTwo +"'"
        endif
        '///+ click button 'Ignore' 2 times///'
        IgnoreOnce.Click

        Kontext "Spellcheck"
        sWordOne = sWordTwo
        sWordTwo = Suggestions.GetSelText
        if (sWordOne <> sWordTwo) then
            warnlog "there is anopther word left, that wasn't expected!. '" + sWordTwo +"'"
        else
            printlog sWordTwo
        endif
        '///+ click button 'Ignore' 2 times///'
        IgnoreOnce.Click
        Kontext "Active"
        if active.exists(5) then
           printlog "Spellcheck works :-) '" + active.gettext + "'"
           Active.No
        else
           warnlog "Spellcheck didn't work :-(! there are still errors in the document."
           Kontext "Spellcheck"
           Spellcheck.Close
Kontext "Active"
if active.exists(5) then
    qaErrorLog "    Spellcheck dialog closed'" + active.gettext + "'"
    Active.No
endif
    endif
    sleep 2

    Printlog "'/// Delete all added words from dictionaries ///'"
    '///+ call Tools->Options ///'
    ToolsOptions
    '///+ select in category 'Languagesettings' entry 'Writing Aids' ///'
    hToolsOptions ("LANGUAGESETTINGS","WRITINGAIDS")
    sleep 1
    Kontext "WRITINGAIDS"
    sleep 1
    '///+ click on button 'edit' in section 'User-defined dictionaries' ///'
    if (fGetIntoDictionary) then
        qaErrorLog "wTSC"
        goto endsub
    endif
    Kontext "BenutzerwoerterbuchBearbeiten"
    sleep 1
    '///+ check every book, if it contains the added word ///'
    iBooks = Buch.getItemCount
    bWordFound(1) = false
    bWordFound(2) = false
    for i = 1 to iBooks
        Buch.select(i)
        for j = 1 to 2
            Wort.setText sWord(j)
            sleep 1
            if ((not neu.isEnabled) and Loeschen.isEnabled) then
                '///+ if it contains the word, press button 'delete'  ///'
                Loeschen.click
                bWordFound(j) = true
                printlog " added word is in dictionary: '" + Buch.getSelText + "' - '" + sWord(j) + "'"
            endif
        next j
    next i
    if ((not bWordFound(1)) AND (not bWordFound(2)))then
        warnlog "Word was not found in dictionary. '" + sWord(1) + "': " + bWordFound(1) + "  '" + sWord(2) + "': " + bWordFound(2)
    endif
    '///+ close dialog 'Edit Custom Dictionary'  ///'
    BenutzerwoerterbuchBearbeiten.Close
    sleep 1
    Kontext "ExtrasOptionenDlg"
    '///+ press button 'OK' on dialog 'Writing Aids'///'
    ExtrasOptionenDlg.OK
    '///+ call dialog again and delete all remaining words from dictionary 'IgnoreAllList' ///'
    if (not wIgnorierenlisteLoeschen) then
        qaErrorLog "Can't get into Dictionary lists"
        goto endsub
    endif
    sleep 2

    '/// close document ///'
    Call hCloseDocument
endcase

function wIgnorierenlisteLoeschen as boolean
    Dim i as integer
    Dim j as integer
    dim iBooks as integer

    ToolsOptions
    Call hToolsOptions("LANGUAGESETTINGS","WRITINGAIDS")
    Sleep 3
    if (fGetIntoDictionary) then
        qaErrorLog "wIgLi"
        wIgnorierenlisteLoeschen = FALSE
        exit function
    endif
    Kontext "BenutzerwoerterbuchBearbeiten"
    sleep 1
    iBooks = Buch.GetItemCount
    for i = 1 to iBooks
        Buch.Select i
        if Left$(Buch.GetSelText,13)="IgnoreAllList" then
            sleep 2
            while (Loeschen.IsEnabled)
                    Loeschen.Click
                    sleep 1
            wend
        endif
    next i
    Kontext "BenutzerwoerterbuchBearbeiten"
    BenutzerwoerterbuchBearbeiten.Cancel
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    wIgnorierenlisteLoeschen = TRUE
end function

testcase tToolsSpellcheckAutoSpellcheck
    '/// Bugs need to get fixed before this is usable: i22192 112919 106815 i23568 ///'
'    112919: Stacktrace ID: 17030 / testtool: hMenuSelect(0)
'    106815: Autospellcheck: underlining of words doesn't change when I change old/new german
    dim i,x,y,z as integer
    dim iResult as long
    dim iTemp as long
    dim iTemp2 as long
    dim sTemp as string
    dim sCompare as string
    dim iCompare as long
    dim iError as long
    dim sError as string

    '/// open new document ///'
    call hNewDocument  '()
    '/// insert text 'Ein Tipp: Schiffahrt schreibt man nun mit 3f' ///'
    call hTextrahmenErstellen ("Ein Tipp: Schiffahrt schreibt man nun mit 3f Tunfisch Amboss a", 10, 10, 90, 50)

    '/// select the whole text ///'
    EditSelectAll
    '/// on dialog 'format-character' set language to english ///'
    setCharacterLanguage(glLocale(4))
    sleep 10
    printlog "## check ENGLISH auto spellchecking"
    iError = 0
    ' Get underlined words / wrong recognized words by spellchecker
    iResult = sAnalyseContextMenu(11, iError)
    sTemp = sLongToBinary(iResult, 11)
    sError = sLongToBinary(iError, 11)
    ' reference of words, which should be underlined
    sCompare = "11011001011"
    iCompare = sBinaryToLong(sCompare)
    ' compare result with reference -> get the difference
    iTemp = not (iResult EQV iCompare)
    ' eliminate errors from open bugs -> get the real errors
    iTemp2 = iTemp AND NOT iError
    if (iTemp2 > 0) then
        warnlog "wrong words are not underlined? Should be: " + sCompare
        warnlog "Is:                                        " + sTemp
        warnlog "Differences:                               " + sLongToBinary(iTemp, 11)
        warnlog "Wrong after merging errors from bugs       " + sLongToBinary(iTemp2, 11)
    endif

    sleep 1
'    call hTypeKeys "<F2>"
    call hTypeKeys "<mod1 end> <Shift mod1 home>"
    setCharacterLanguage(glLocale(6))
    sleep 10
    printlog "## check GERMAN auto spellchecking"
    iError = 0
    iResult = sAnalyseContextMenu(11, iError)
    sTemp = sLongToBinary(iResult, 11)
    sError = sLongToBinary(iError, 11)
    sCompare = "00010000000"
    iCompare = sBinaryToLong(sCompare)
    ' compare result with reference -> get the difference
    iTemp = not (iResult EQV iCompare)
    ' eliminate errors from open bugs -> get the real errors
    iTemp2 = iTemp AND NOT iError
    if (iTemp2 > 0) then
        warnlog "wrong words are not underlined? Should be: " + sCompare
        warnlog "Is:                                        " + sTemp
        warnlog "Differences:                               " + sLongToBinary(iTemp, 11)
        warnlog "Wrong after merging errors from bugs       " + sLongToBinary(iTemp2, 11)
    endif
    printlog "-----------------------------------"
'    '/// activate german spelling OLD ///'
'    toggleGermanSpellchecking
'
'    '/// TODO: BUG??? to activate the changes - FOR WHAT RESON EVER - i have to deactiovate/activate teh edit mode :-( ///'
'    '///+ type key [escape] to leave edit mode for textbox ///'
'    call hTypeKeys "<escape>"
'    sleep 1
'    '///+ type key [F2] to activate edit mode ///'
'    call hTypeKeys "<F2>"
'    printlog "## check GERMAN OLD auto spellchecking"
'
'    iError = 0
'    iResult = sAnalyseContextMenu(11, iError)
'    sTemp = sLongToBinary(iResult, 11)
'    sError = sLongToBinary(iError, 11)
'    sCompare = "00000000011"
'    iCompare = sBinaryToLong(sCompare)
'    ' compare result with reference -> get the difference
'    iTemp = not (iResult EQV iCompare)
'    ' eliminate errors from open bugs -> get the real errors
'    iTemp2 = iTemp AND NOT iError
'    if (iTemp2 > 0) then
'        warnlog "wrong words are not underlined? Should be: " + sCompare
'        warnlog "Is:                                        " + sTemp
'        warnlog "Differences:                               " + sLongToBinary(iTemp, 11)
'        warnlog "Wrong after merging errors from bugs       " + sLongToBinary(iTemp2, 11)
'    endif
'    printlog "-----------------------------------"
'
'    '/// set to default value:  german spelling OLD disabled ///'
'    toggleGermanSpellchecking
    '/// close application ///'
    hCloseDocument()
endcase

function setCharacterLanguage(sLanguage as string) as boolean
    setCharacterLanguage = FALSE
    FormatCharacter
    sleep 1
    Kontext
    Messagebox.SetPage TabFont
    kontext "TabFont"
    sleep 1
    try
        LanguageWest.select (sLanguage)
        setCharacterLanguage = TRUE
    catch
        Language.select (sLanguage)
        setCharacterLanguage = TRUE
    endcatch
    TabFont.Ok
    sleep 1
end function

function toggleGermanSpellchecking as string
    '/// activate old german spellchecking ///'
    '///+ Tools->Options ///'
    ToolsOptions
    '///+ select tabpage 'writing aids' in category 'Languagesettings' ///'
    hToolsOptions("LANGUAGESETTINGS","WRITINGAIDS")
    kontext "TabLinguistik"
    '///+ hopefully it never changes for any reason between the languages!: select the 8th entry 'German spelling - old' ///'
    printlog " - 'German Spelling - old' ?= " + Optionen.getItemText(8)
    Optionen.select(8)
    '///+ default is 'unselected' - i can't check it automatically - so i depend on it! ///'
    '///+ press [space] to select it///'
    Optionen.typeKeys "<space>"
    Kontext "ExtrasOptionenDlg"
    '///+ close options with OK button ///'
    ExtrasOptionenDlg.OK
end function

function sAnalyseContextMenu(iItems as integer, optional iError as long) as integer
    dim i,y,x,z as integer
    dim iSlot as integer
    dim iSpecialCharacterEntry as integer
    dim bNoContextMenu as boolean
    dim iTemp as long
    dim sCandidates(5) as string
    dim bDifferent as boolean
    dim iInternError as long
    dim iError1 as long  ' misplaced
'    i22192: context menu opens not on cursor position
    dim iError2 as long  ' no context menu

    '/// goto start of textbox ///'
    call hTypeKeys "<mod1 home>"
    '/// for every word, check the context menu to get suggestions for correction ///'
    for i = 0 to (iItems-1)
        '/// copy current word to clipboard ///'
        call hTypeKeys "<Shift mod1 right>"
        EditCopy
        sCandidates(1) = getClipboardText()
        if (" " = right(sCandidates(1),1)) then
            sCandidates(1) = left(sCandidates(1),len(sCandidates(1))-1)
        endif
        call hTypeKeys "<mod1 left>"
        '/// open context menu ///'
        call hOpenContextMenu()
        sleep 3
        ' collecting criteria for underlining:
        ' 1st one: is word selected? yes: underlined;
        try          ' WorkAround ##
            editcopy
            sCandidates(2) = getClipboardText()
'            printlog "******************* " + getclipboardtext()
        catch
            sCandidates(2) = ""
'            printlog "###################################################"
        endcatch
        ' if (1) is different from nonempty (2) then the wrong word is selected
        if (sCandidates(1) <> sCandidates(2)) then
            if ("" <> sCandidates(2)) then
'               printlog "############ " + sCandidates(1) + " ################## " + sCandidates(2) + " #####################"
                bDifferent = TRUE
                iError1 = iError1 + (2^i)
            else
                bDifferent = false
             ' no word is selected... a) not underlined b) no context menu open
            endif
        else
'            printlog "******************* " + sCandidates(1)
            bDifferent = FALSE
        endif
        ' check if context menu opened
        try
            x = hMenuItemGetCount
            ' successfully opened context menu
            bNoContextMenu = false
        catch
            ' context menu not open
            bNoContextMenu = true
            iError2 = iError2 + (2^i)
            ' in writer it would work... :-( #i23568#
'            warnlog ""+i+" C: " + x + ";------ " + getClipboardText + " -------- "
        endcatch
        ' if context menu open do....
        if (not bNoContextMenu) then
'            printlog ""+i+" C: " + x + ";------ " + getClipboardText + " -------- " + hMenuItemGetText(1)
            '/// analyze context menu entries ///'
            for y = 1 to x
                z = hMenuGetItemId(y)
                if (1 = y) then iSlot = z  ' criteria for WorkAround
                if (z = 27019) then iSpecialCharacterEntry = y    ' entry to select for WorkAround
    '            Printlog ("---i: "+ y +"; " + z + "  ; " +hMenuItemGetText(y) + " ; " + hMenuGetItemCommand(y))
            next y
            '/// if first slot not a spelling suggestion -> WorkAround 112919 ///'
            '/// close Context Menu ///'
            if (iSlot <> 10456) then
                if (not bDifferent) then  ' WorkAround ##
'                qaerrorlog "" + iSlot + " UNDERLINED"
                    iTemp = iTemp + (2^i)
                endif
                call hMenuClose()
            else
'                printlog "" + iSlot + " not underlined"
                'InsertSpecialCharacterDraw
                hMenuSelectNr(iSpecialCharacterEntry)  ' because of bug #112919#
                kontext "Sonderzeichen"
                Sonderzeichen.Cancel '
            endif
        endif
        sleep 1
        '/// goto next word with keys [strg]+[right] ///'
        call hTypeKeys "<mod1 right>"
    next i
    '/// leave textbox edit mode ///'
'    call hTypeKeys "<escape>"
    iInternError = iError1 OR iError2
    if (iError1 > 0) then
        qaErrorLog "#i22192#: context menu opens not on cursor position"
        printlog "" + sLongToBinary(iError1, 11)
    endif
    if (iError2 > 0) then
        qaErrorLog "#i23568# context menu doesn't open in redlining mode before a punctuation mark"
        printlog "" + sLongToBinary(iError2, 11)
    endif
    if (not isMissing(iError)) then
        iError = iInternError
    endif
    sAnalyseContextMenu = iTemp
end function

function sLongToBinary(iTempIn as long, iCount as integer) as string
    ' lsb left !
    dim sTemp as string
    dim i as integer
    dim iMask as long
    dim itemp as long

    itemp = itempin

    for i = 1 to iCount
        iMask = iMask + (2^(i-1))
    next i

    sTemp = ""
    iTemp = Itemp AND iMask
    for i = 1 to iCount
        if ((iTemp MOD 2) = 1) then
            sTemp = sTemp + "1"
        else
            sTemp = sTemp + "0"
        endif
        iTemp = INT (iTemp / 2)
    next i
    sLongToBinary = sTemp
end function

function sBinaryToLong(sTempIn as String) as long
    ' lsb left !
    dim iTemp as long
    dim i as integer
    dim sTemp as string

    sTemp = sTempin

    for i = 1 to len(sTemp)
        if (mid(sTemp, i, 1) = "1") then
            iTemp = itemp + (2^(i-1))
        endif
    next i
    sBinaryToLong = iTemp
end function

function fGetIntoDictionary as boolean
    dim bFound as boolean
    dim iBooks as integer
    dim i as integer

    iBooks = Benutzerwoerterbuch.GetItemCount
    i=0
    bFound=TRUE
    while (bFound AND (i < iBooks))
        inc i
        Benutzerwoerterbuch.select i
        printlog Benutzerwoerterbuch.getSelText + i
        try
            Bearbeiten.Click
            bFound = FALSE
        catch
            printLog "wIgLi" + i
        endcatch
    wend
    fGetIntoDictionary = bFound
end function


