'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_autocorrection.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/07/27 09:59:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description :
'*
'*******************************************************************
'*
' #1 tToolsAutocorrectReplace
' #1 tToolsAutocorrectExceptions
' #1 tToolsAutocorrectCustomQuotes
' #1 tToolsAutocorrectOption
'*
'\*******************************************************************

' Tools->Autocorrect...
' Replace; Exceptions; Options; Custom Quotes
' these are Language
' dependant in the
' listbox above!!
' box only enabled, if the both tabpages are selected ...

testcase tToolsAutocorrectReplace
    dim i,x as integer
    dim iTemp as integer

    '/// open new application ///'
    Call hNewDocument

    '/// Tools->Autocorrect... ///'
    ToolsAutocorrect
        Kontext
        '/// select tabpage 'Replace' ///'
        active.SetPage TabErsetzung
        Kontext "TabErsetzung"
        iTemp = WelcheSprache.GetItemCount
        for i = 1 to iTemp
            WelcheSprache.select i
            sleep 1
            x = Liste.getItemCount
'         results from an english version:
'         - 28: English (UK): 807
'         - 29: English (USA): 807
'         - 38: French (France): 304
'         - 43: German (Germany): 100
'         - 102: Spanish (Spain): 353
            if (x <> 0) then
                printlog " - " + i + ": " + WelcheSprache.getSelText + ": " + x
 '               printlog "    " + Liste.getItemText (5,1) + " - " + Liste.getItemText (5,2)
            endif
        next i
    TabErsetzung.OK

    '/// close application ///'
    hCloseDocument
'NurText                offmgr:CheckBox:RID_OFAPAGE_AUTOCORR_REPLACE:CB_TEXT_ONLY
'Kuerzel                offmgr:Edit:RID_OFAPAGE_AUTOCORR_REPLACE:ED_SHORT
'ErsetzenDurch          offmgr:Edit:RID_OFAPAGE_AUTOCORR_REPLACE:ED_REPLACE
'Liste                  HID_OFACTL_AUTOCORR_REPLACE
'Neu                    offmgr:PushButton:RID_OFAPAGE_AUTOCORR_REPLACE:PB_NEW_REPLACE
'Loeschen               offmgr:PushButton:RID_OFAPAGE_AUTOCORR_REPLACE:PB_DELETE_REPLACE
endcase

testcase tToolsAutocorrectExceptions
    dim i,x,y as integer
    dim iTemp as integer

    '/// open new application ///'
    Call hNewDocument

    '/// Tools->Autocorrect... ///'
    ToolsAutocorrect
        Kontext
        '/// select tabpage 'Replace' ///'
        active.SetPage TabAusnahmen
        Kontext "TabAusnahmen"
        iTemp = WelcheSprache.GetItemCount
        for i = 1 to iTemp
            WelcheSprache.select i
            sleep 1
            x = AbkuerzungenListe.getItemCount
'         results from an english version:
'             - 28: English (UK): 120
'             - 28: English (UK): 7
'             - 29: English (USA): 120
'             - 29: English (USA): 7
'             - 38: French (France): 50
'             - 38: French (France): 1
'             - 43: German (Germany): 123
'             - 43: German (Germany): 20
'             - 102: Spanish (Spain): 115
'             - 102: Spanish (Spain): 1
            if (x <> 0) then
                printlog " - " + i + ": " + WelcheSprache.getSelText + ": " + x
'                printlog "    " + AbkuerzungenListe.getItemText (5)
            endif
            y = WoerterListe.getItemCount
            if (y <> 0) then
                printlog " - " + i + ": " + WelcheSprache.getSelText + ": " + y
'                printlog "    " + WoerterListe.getItemText (5)
            endif
        next i
    TabAusnahmen.OK

    '/// close application ///'
    hCloseDocument
'Abkuerzungen           offmgr:Edit:RID_OFAPAGE_AUTOCORR_EXCEPT:ED_ABBREV
'AbkuerzungenNeu        offmgr:PushButton:RID_OFAPAGE_AUTOCORR_EXCEPT:PB_NEWABBREV
'AbkuerzungenLoeschen   offmgr:PushButton:RID_OFAPAGE_AUTOCORR_EXCEPT:PB_DELABBREV
'AbkuerzungenAutomatisch   offmgr:CheckBox:RID_OFAPAGE_AUTOCORR_EXCEPT:CB_AUTOABBREV
'Woerter                offmgr:Edit:RID_OFAPAGE_AUTOCORR_EXCEPT:ED_DOUBLE_CAPS
'WoerterNeu             offmgr:PushButton:RID_OFAPAGE_AUTOCORR_EXCEPT:PB_NEWDOUBLECAPS
'WoerterLoeschen        offmgr:PushButton:RID_OFAPAGE_AUTOCORR_EXCEPT:PB_DELDOUBLECAPS
'WoerterAutomatisch     offmgr:CheckBox:RID_OFAPAGE_AUTOCORR_EXCEPT:CB_AUTOCAPS
endcase

testcase tToolsAutocorrectCustomQuotes(bSimple as boolean)
    ' bSinple = true: use simple quotes ;; else Double Quotes
    Dim Vorn$
    Dim Hinten$
    Dim Normal$
    dim sTemp as string
    dim sFileName as string

    '/// No matter the applikation and platform: open a file which has the same font selected. ///'
    if (lCase(gApplication) = "impress") then
       sFileName = (ConvertPath ( gTesttoolPath + "graphics\level1\input\rightfont" + ".odp"))
    else
       sFileName = (ConvertPath ( gTesttoolPath + "graphics\level1\input\rightfont" + ".odg"))
    endif

    'HDE has same problems in w_106a.inc ;-) !!! migrate ?!?! ///'
    '/// open new application ///'
    Call hNewDocument

    '///  open file where the right font already is defined. ///'
    hDateiOeffnen sFileName
    printlog "File opened: " + sFileName
    Sleep 3

    '/// TBO TODO: put quotes in locale list !!!! (i love UTF8 :-)))///'
    if bSimple then
        Printlog "- Tools/Autocorrect -single quotes"
        Normal$ = Chr(39)
        select case iSprache
            case 01 : Vorn$ = Chr(8218) : Hinten$ = Chr(8216)
            case 03 : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
            case 07 : qaerrorlog "Test impossible. No quotes in russian!"
                      hCloseDocument
                      goto endsub
            case 31 : Vorn$ = Chr(8218) : Hinten$ = Chr(8216)
            case 33 : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
            case 34 : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
            case 36 : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
            case 39 : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
            case 45 : Vorn$ = Chr(8217) : Hinten$ = Chr(8217)
            case 46 : Vorn$ = Chr(8217) : Hinten$ = Chr(8217)
            case 48 : Vorn$ = Chr(130)  : Hinten$ = Chr(8216)
            case 49 : Vorn$ = Chr(8218) : Hinten$ = Chr(8216)
            case 55 : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
            case 81, 82, 86, 88 : Vorn$ = Chr(8216) : Hinten$ = Chr(8217) ' Asian
        case else : Warnlog "- Nothing prepared for this language, but I run: take the warnlogs an insert the numbers here.: "+iSprache
                      Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
        end select
    else
        Printlog "- Tools/Autocorrect -double quotes"
        Normal$ = Chr(34)
        select case iSprache
            case 01 : Vorn$ = Chr(8222) : Hinten$ = Chr(8220)
            case 03 : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
            case 07 : qaerrorlog "Test not possible. No quotes in russian !"
                      Call hCloseDocument
                      goto endsub
            case 31 : Vorn$ = Chr(8222) : Hinten$ = Chr(8220)
            case 33 : Vorn$ = Chr(171) : Hinten$ = Chr(187)
            case 34 : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
            case 36 : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
            case 39 : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
            case 45 : Vorn$ = Chr(8221) : Hinten$ = Chr(8221)
            case 46 : Vorn$ = Chr(8221) : Hinten$ = Chr(8221)
            case 48 : Vorn$ = Chr(8222) : Hinten$ = Chr(8220)
            case 49 : Vorn$ = Chr(8222) : Hinten$ = Chr(8220)
            case 55 : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
            case 81, 82, 86, 88 : Vorn$ = Chr(8220) : Hinten$ = Chr(8221) ' Asian
        case else : Warnlog "- Nothing prepared for this language: "+iSprache
                  goto endsub
        end select
    endif
    Printlog "   - replace quotes" '------------------------------------------------------------------------------------------
    '/// check default item for beginn and end. type them as normal and look how it get's replaced ///'
    '/// Tools->Autocorrect... ///'
    ToolsAutocorrect
        Kontext
        '/// select tabpage 'Custom Quotes' ///'
        active.SetPage TabTypografisch
        Kontext "TabTypografisch"
        '/// check checkbox 'Replace'; Simple: ; Double: click button 'Default'; ///'
        if bSimple then
            EinfacheErsetzen.Check
        else
           DoppelteErsetzen.Check
           DoppeltStandard.Click
        endif
    '/// close dialog 'AutoCorrect' with OK ///'
    TabTypografisch.OK
    sleep 5
    gMouseClick 50,50
    sleep 5
    '/// create textframe with quotes; Simple: 39; Double: 34; ///'
    hTextrahmenErstellen ( Normal$ + "Hallo" + Normal$ + " ",20,20,60,30)
    sleep 5
    '/// press keys [Home][Shift + Right] to select the start quote ///'
    hTypeKeys ("<Home><Shift Right>")
    sleep 5
    '/// Edit->Copy ///'
    EditCopy
    sTemp = GetClipboardText
    '/// compare quote to reference start quote ///'
    if (sTemp <> Vorn$) then
        Warnlog "The beginning quote seems wrong. Should be :'" + Vorn$ +"':"+ASC(vorn$)+ ":  but it is = :'" + sTemp +"':"+ASC(sTemp)+":"
    endif
    sleep 1
    '/// press keys [End][Left][Shift + Left] to select the end quote ///'
    hTypeKeys "<End><Left><Shift Left>"
    Sleep 1
    EditCopy
    sTemp = GetClipboardText
    '/// compare quote to reference end quote ///'
    if (sTemp <> Hinten$) then
        Warnlog "The end quote seems wrong. Should be :" + Hinten$ +":"+ASC(Hinten$) +":  but it is :" + sTemp + ":"+ASC(sTemp)+":"
    endif

    '/// type keys [Home][Shift + End][Delete] to remove text
    hTypeKeys "<Home><Shift End><Delete>"

    Printlog "   - dont replace quotes" '------------------------------------------------------------------------------------------
    '/// Tools->Autocorrect... ///'
    ToolsAutocorrect
    Kontext
        '/// select tabpage 'Custom Quotes' ///'
        Active.SetPage TabTypografisch
        Kontext "TabTypografisch"
        '/// UNcheck checkbox 'Replace' ///'
        if bSimple then
            EinfacheErsetzen.Uncheck
        else
            DoppelteErsetzen.Uncheck
        endif
    '/// close dialog 'AutoCorrect' with OK ///'
    TabTypografisch.OK
    sleep 1
    gMouseClick 50,50
    sleep 1
    '/// create textframe with quotes; Simple: 39; Double: 34; ///'
    hTextrahmenErstellen ( Normal$ + "Hello" + Normal$ + " ",20,20,60,30)
    sleep 1
    '/// press keys [Home][Shift + Right] to select the start quote ///'
    hTypeKeys "<Home><Shift Right>"
    Sleep 1
    '/// Edit->Copy ///'
    EditCopy
    sTemp = GetClipboardText
    '/// check if quote got modified; it hasn't got. ///'
    if (sTemp <> Normal$) then
        Warnlog "The beginning quote seems wrong. Should be :'" + Vorn$ +"':"+ASC(vorn$)+ ":  but it is = :'" + sTemp +"':"+ASC(sTemp)+":"
    endif

    '/// press keys [End][Left][Shift + Left] to select the end quote ///'
    hTypeKeys "<End><Left><Shift Left>"
    Sleep 1
    '/// Edit->Copy ///'
    EditCopy
    sTemp = GetClipboardText
    '/// check if quote got modified; it hasn't got. ///'
    if (sTemp <> Normal$) then
        Warnlog "The end quote seems wrong. Should be :" + Hinten$ +":"+ASC(Hinten$) +":  but it is :" + sTemp + ":"+ASC(sTemp)+":"
    endif
    '/// type keys [Home][Shift + End][Delete] to remove text
    hTypeKeys "<Home><Shift End><Delete>"

    Printlog "   - replace quotes" '------------------------------------------------------------------------------------------
    '/// set to a value, and check if that value is used///'
    '/// Tools->Autocorrect... ///'
    ToolsAutocorrect
    Kontext
        '/// select tabpage 'Custom Quotes' ///'
        active.SetPage TabTypografisch
        Kontext "TabTypografisch"
        '/// check checkbox 'Replace'; click button Start quote: '"/'' ///'
        if bSimple then
            EinfacheErsetzen.Check
            EinfachWortAnfang.Click
        else
            DoppelteErsetzen.Check
            DoppeltWortAnfang.Click
        endif
                Kontext "Sonderzeichen"
                sleep 1
                '/// on dialog 'Start Quote' in character list press [Home] 91*[Right] ///'
                Schriftliste.TypeKeys "<Home>"
                Schriftliste.TypeKeys "<Right>", 91 '123
                sleep 1
            '/// close dialog 'Start Quote' with OK ///'
            Sonderzeichen.OK

        Kontext "TabTypografisch"
        '/// click button End Quote: '"/'' ///'
        if bSimple then
            EinfachWortEnde.Click
        else
            DoppeltWortEnde.Click
        endif
               Kontext "Sonderzeichen"
               sleep 1
                '/// on dialog 'End Quote' in character list press [Home] 93*[Right] ///'
               Schriftliste.TypeKeys "<Home>"
               Schriftliste.TypeKeys "<Right>", 93 '125
               sleep 1
            '/// close dialog 'End Quote' with OK ///'
            Sonderzeichen.OK

        Kontext "TabTypografisch"
    '/// close dialog 'AutoCorrect' with OK ///'
    TabTypografisch.OK
    sleep 5
    gMouseClick 50,50
    sleep 5
    '/// create textframe with quotes; Simple: 39; Double: 34; ///'
    hTextrahmenErstellen ( Normal$ + "Hello" + Normal$ + " ",20,20,60,30)
    sleep 2
    '/// press keys [Home][Shift + Right] to select the start quote ///'
    hTypeKeys "<Home><Shift Right>"
    Sleep 5
    '/// Edit->Copy ///'
    EditCopy
    sTemp = GetClipboardText
    '/// compare quote to selected start quote ///'
    if (sTemp <> Chr(123)) then
        Warnlog "Beginning quote is wrong. It should be :" + Chr (123) + ":123:  but it is = " + sTemp +":"+ASC(sTemp)+":"
    endif

    '/// press keys [End][Left][Shift + Left] to select the end quote ///'
    hTypeKeys "<End><Left><Shift Left>"
    Sleep 1
    '/// Edit->Copy ///'
    EditCopy
    sTemp = GetClipboardText
    '/// compare quote to selected end quote ///'
    if (sTemp <> Chr(125)) then
        Warnlog "The end quote is wrong, it should be :" + Chr (125) + ":125:  but it is = " + sTemp +":"+ASC(sTemp)+":"
    endif
    '/// type keys [Home][Shift + End][Delete] to remove text
    hTypeKeys "<Home><Shift End><Delete>"

    Printlog "   - back to standard" '------------------------------------------------------------------------------------------
    '/// Tools->Autocorrect... ///'
    ToolsAutocorrect
    Kontext
        '/// select tabpage 'Custom Quotes' ///'
        active.SetPage TabTypografisch
        Kontext "TabTypografisch"
        '/// check checkbox 'Replace'; click button 'Default'; ///'
        if bSimple then
            EinfacheErsetzen.Check
            EinfachStandard.Click
        else
            DoppelteErsetzen.Check
            DoppeltStandard.Click
        endif
        wait 100
    '/// close dialog 'AutoCorrect' with OK ///'
    TabTypografisch.OK
    sleep 1
    '/// create textframe with quotes; Simple: 39; Double: 34; ///'
    hTextrahmenErstellen ( Normal$ + "Hello" + Normal$ + " ",20,20,60,30)
    sleep 2
    '/// press keys [Home][Shift + Right] to select the start quote ///'
    hTypeKeys "<Home><Shift Right>"
    Sleep 1
    '/// Edit->Copy ///'
    EditCopy
    sTemp = GetClipboardText
    '/// compare quote to reference start quote ///'
    if (sTemp <> Vorn$) then
        Warnlog "The beginning quote seems wrong. Should be :" + Vorn$ +":"+ASC(vorn$)+ ":  but it is = :" + sTemp +":"+ASC(sTemp)+":"
    endif

    '/// press keys [End][Left][Shift + Left] to select the end quote ///'
    hTypeKeys "<End><Left><Shift Left>"
    Sleep 1
    '/// Edit->Copy ///'
    EditCopy
    sTemp = GetClipboardText
    '/// compare quote to reference end quote ///'
    if (sTemp <> Hinten$) then
        Warnlog "The end quote seems wrong. Should be :" + Hinten$ +":"+ASC(Hinten$) +":  but it is :" + sTemp + ":"+ASC(sTemp)+":"
    endif
    '/// type keys [Home][Shift + End][Delete] to remove text
    hTypeKeys "<Home><Shift End><Delete>"

    '/// Tools->Autocorrect... ///'
    ToolsAutocorrect
    Kontext
        '/// select tabpage 'Custom Quotes' ///'
        active.SetPage TabTypografisch
        Kontext "TabTypografisch"
        '/// UNcheck checkbox 'Replace' ///'
        if bSimple then
            EinfacheErsetzen.UnCheck
        else
            DoppelteErsetzen.UnCheck
        endif
    '/// close dialog 'AutoCorrect' with OK ///'
    TabTypografisch.OK
    sleep 1

    '/// close application ///'
    hCloseDocument
endcase

testcase tToolsAutocorrectOption
    const cEntryCount = 9
    dim i as integer
    dim iEntryCount as integer
    dim sEntries (20, 2) as string
    dim bState as boolean

    ' this test relies on the following order of entries!!:
    sEntries (1,1) = "Use replacement table"
    sEntries (1,2) = "(C) "
    sEntries (2,1) = "Correct TWo INitial CApitals"
    sEntries (2,2) = "ABer "
    sEntries (3,1) = "Capitalize first letter of every sentence"
    sEntries (3,2) = "Hello. this is a sentence. "
    sEntries (4,1) = "Automatic *bold* and _underline_"
    sEntries (4,2) = "*Hello* " '"_Hello_ "
    sEntries (5,1) = "URL Recognition"
    sEntries (5,2) = "It is www.ksta.de "
    sEntries (6,1) = "Replace 1st... with 1^st..."
    sEntries (6,2) = "1st "
    sEntries (7,1) = "Replace 1/2 ... with ÃÂ» ..."
    sEntries (7,2) = "1/2 "
    sEntries (8,1) = "Replace dashes"
    sEntries (8,2) = "Hello - Hrbert "
    sEntries (9,1) = "Ignore double spaces"
    sEntries (9,2) = "Hello  this is 2  blanks "

    Printlog "- Tools / Autocorrect -options"
    Call hNewDocument()
    callAutocorrectOptions

    iEntryCount = Einstellungen.getItemCount
    if (iEntryCount <> cEntryCount) then
        warnLog "Unexpected count of entries in Listbox: expected: '" + cEntryCount + "' actual: '" + iEntryCount + "'"
        for i = 1 to iEntryCount
            Printlog " " + i + " - '" + sEntries (i,1) + "' ?= '" + Einstellungen.getItemText(1) + "'"
        next i
    endif
    TabOptionen.OK

    for i = 1 to cEntryCount
        callAutocorrectOptions
        Printlog " " + i + " - '" + sEntries (i,1) + "' ?= '" + Einstellungen.getItemText(i) + "'"
        bState = (i <> cEntryCount)
        Einstellungen.select(i)
        if (bState <> Einstellungen.isChecked) then
            Warnlog "        Entry is '" + bState + "' per default - will be '" + bState + "' now!"
        end if
        ' first test the opposite default value
        if bState then
            Einstellungen.UnCheck
        else
            Einstellungen.Check
        endif
        TabOptionen.OK
        sCheckCheck (i, sEntries(i,2), not bState)
        ' now test and set the default value
        callAutocorrectOptions
        Einstellungen.select(i)
        if bState then
            Einstellungen.Check
        else
            Einstellungen.UnCheck
        endif
        TabOptionen.OK
        sCheckCheck (i, sEntries(i,2), bState)
    next i

    hCloseDocument
    sleep 1
endcase

sub callAutocorrectOptions
    ToolsAutocorrect
    Kontext
    active.SetPage TabOptionen
    Kontext "TabOptionen"
end sub

sub sCheckCheck (i, Pruefung$, bEnabled)
    hTextrahmenErstellen  (Pruefung$,20,20,60,40)
    wait 100
    select case i
' Disabled sCheckUnderlined due to start of external program (web-browser) - FHA
        case 5: bEnabled 'sCheckUnderlined (bEnabled)
        case 6: sCheckSupperscript (bEnabled)
        case 8: sCheckDash (bEnabled)
        case else:
            hTypeKeys "<Home><Shift End>"
            EditCopy
            if (GetClipboardText = Pruefung$) then ' not replaced
                if bEnabled then  ' not as expected
                    warnlog "-    replacement failed"
                endif
            else     ' replaced
                if not bEnabled then  ' not as expected
                    warnlog "-    replacement failed : '" + Pruefung$ + "' - '" + GetClipboardText + "'"
                endif
            endif
    end select

    hTypeKeys "<Home><Shift End><Delete>"
end sub

sub sCheckUnderlined (bEnabled)
    dim btemp as boolean
    hTypeKeys "<End><Left><Shift Left>"
    try
        ContextOpenHyperlink
        btemp = true
    catch
        btemp = false
    endcatch
    if (bEnabled <> btemp) then
        warnlog "-    replacement failed"
    endif
    kontext
    if active.exists(5) then
        active.ok
    endif
end sub

sub sCheckSupperscript (bEnabled)
    hTypeKeys "<Home><Right><Right>"
    FormatCharacter
    Kontext
    Active.SetPage TabFontPosition
    Kontext "TabFontPosition"
    if (bEnabled <> Superscript.IsChecked) then
        warnlog "-    replacement failed"
    endif
    TabFontPosition.OK
end sub

sub sCheckDash (bEnabled)
    ' inserted is 45
    ' en dash is 8211 / alt + 0150
    ' em dash is 8212 / alt + 0151 ' which doen't work atm
    dim sTemp as string
    hTypeKeys "<End><Left><Left><Left><Left><Left><Left><Left><Left><Shift Left>"
    EditCopy
    sTemp = GetClipboard
    if ((asc(sTemp) <> 45) <> bEnabled) then
        warnlog "-    replacement failed : " + bEnabled + " : " + asc(sTemp)
    endif
end sub

