'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_optionitems.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2006/08/02 11:38:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Verify that the applications appear in tools/options
'*
'*******************************************************************************
'**
' #1 tUpdtOptionItems ' Verify that the applications appear in tools/option
'**
'\******************************************************************************

testcase tUpdtOptionItems

    '///<h3>Verify that the applications appear in tools/option</h3>
    '///<ul>
    
    const DOCTYPES = 7
    dim iDocType as integer
    dim cDocType as string
    dim iAppItems as integer
    dim iNodes as integer
    
    dim iAppCount( DOCTYPES ) as integer
        iAppCount( 1 ) = 8 ' writer
        iAppCount( 2 ) = 7 ' calc
        iAppCount( 3 ) = 7 ' impress
        iAppCount( 4 ) = 7 ' draw
        iAppCount( 5 ) = 7 ' math
        iAppCount( 6 ) = 8 ' masterdoc
        iAppCount( 7 ) = 8 ' html
        
    '///+<li>Step through all main applications and do</li>
    '///<ul>
    for iDocType = 1 to DOCTYPES
    
        '///<li>Create a new document</li>
        printlog( "" )
        printlog( hNumericDocType( iDocType ) )
        hCreateDocument()
        
        '///+<li>Open Tools/Options</li>
        ToolsOptions
        
        '///+<li>Retrieve the number of listed applications from the applications list</li>
        kontext "ExtrasOptionenDlg"
        
        '///+<li>Collapse all nodes</li>      
        iAppItems = Optionsliste.getItemCount()
        Optionsliste.typeKeys( "<HOME>" )
        for iNodes = 1 to iAppItems
            Optionsliste.typeKeys( "-" )
            Optionsliste.typeKeys( "<DOWN>" )
        next iNodes
        
        
        '///+<li>Verify that the number is correct</li>
        iAppItems = Optionsliste.getItemCount()
        if ( iAppItems <> iAppCount( iDocType ) ) then
            warnlog( "#i68068# The number of top nodes in Tools/Options is incorrect." )
            printlog( "Found...: " & iAppItems )
            printlog( "Expected: " & iAppCount( iDocType ) )
        else
            printlog( "The number of top nodes is correct." )
        endif
        
        '///+<li>Close Tools/Options</li>
        ExtrasOptionenDlg.cancel()
        
        '///+<li>Close the document</li>
        hDestroyDocument()
        
    next iDocType
    '///</ul>
    '///</ul>

endcase

