'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: scriptorganizer_tools.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2006/03/08 08:15:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Test scripting-organizers / document-attached scripts
'*
'*******************************************************************************
'**
' #1 hCreateScriptingObject ' creates a new library or script
' #1 hRenameScriptingObject ' renames a library or script
' #1 hDeleteScript   ' deletes a script or library
' #1 hOpenScriptOrganizer ' Open the scriptorganizers (Beanshell or Javascript)
' #1 hCloseScriptOrganizer ' close the scriptorganizer (Beanshell or JavaScript)
'**
'\******************************************************************************

function hCreateScriptingObject( cName as string ) as boolean

    '///<h3>Create a new scripting object for the current module</h3>
    '///<i>Starting point: Script organizer is open, module selected</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the module (string)</li>
    '///<ul>
    '///+<li>Any name the organizer can accept</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition</li>
    '///<ul>
    '///+<li>TRUE on success</li>
    '///+<li>FALSE on failure or invalid user input</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    const CFN = "hNewScriptingObject::"
    dim brc as boolean

    '///+<li>Verify the function parameter</li>
    if ( cName = "" ) then
        warnlog( CFN & "Empty Name for scripting object passed to function" )
        hCreateScriptingObject() = false
        exit function
    endif
    
    '///+<li>Verify that the &quot;Create...&quot; button exists</li>
    Kontext "ScriptOrganizer"
    if ( not PBCreate.exists() ) then
        warnlog( CFN & "Create-button does not exist" )
        hCreateScriptingObject() = false
        exit function        
    endif    
    
    '///+<li>Verify that the &quot;Create...&quot; button is enabled</li>
    if ( PBCreate.isEnabled() ) then
             
        '///+<li>Click &quot;Create...&quot; to open the naming dialog</li> 
        PBCreate.click()
        
        '///+<li>Name the new script</li>
        Kontext "ScriptNameDlg"
        if ( ScriptNameDlg.exists() ) then        
            
            EFObjectName.setText( cName )
            ScriptNameDlg.OK()  
            brc = true
            
        endif

    else
        printlog( CFN & "Button is disabled" )
        brc = false
    endif
    
    '///+<li>Verify that we are back on the script organizer</li>
    kontext "ScriptOrganizer"
    if ( not ScriptOrganizer.exists() ) then
        warnlog( CFN & "Could not return to ScriptOrganizer" )
        brc = false
    endif    
    
   hCreateScriptingObject() = brc
   '///</ul>

end function

'*******************************************************************************

function hRenameScriptingObject( cName as string ) as boolean

    '///<h3>Rename the selected script</h3>
    '///<i>Starting point: Script organizer is open, a script is selected</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>New name of the script</li>
    '///<ul>
    '///+<li>Any name the script organizer does accept</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition</li>
    '///<ul>
    '///+<li>TRUE on success</li>
    '///+<li>FALSE on failure or invalid user input</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    const CFN = "hRenameScriptingObject::"
    dim cMessage as string
    dim brc as boolean
    
    brc = true
    
    '///+<li>Verify the function parameter</li>
    if ( cName = "" ) then
        warnlog( CFN & "Empty Name for scripting object passed to function" )
        hRenameScriptingObject() = false
        exit function
    endif    
    
    '///+<li>Verify that the &quot;Rename...&quot; button exists</li>
    Kontext "ScriptOrganizer"
    if ( not PBRename.exists() ) then
        warnlog( CFN & "Rename button does not exist, aborting" )
        hRenameScriptingObject() = false
        exit function
    endif
    
    '///+<li>Verify that the &quot;Rename...&quot; button is enabled</li>
    if ( PBRename.isEnabled ) then
    
        '///+<li>Click &quot;Rename...&quot; to open the renaming dialog</li>
        PBRename.click()
        
        '///+<li>Name the new script</li>
        Kontext "ScriptNameDlg"
        if ( ScriptNameDlg.exists() ) then
        
            EFObjectName.setText( cName )
            ScriptNameDlg.OK()
            
            '///+<li>Test for any messagebox, try to close it with OK</li>
            kontext "active"
            if ( active.exists() ) then
                cMessage = hRemoveLineBreaks( active.getText )
                printlog( CFN & cMessage )
                brc = false
                active.OK()
            endif
            
        endif
        
    endif
    
    '///+<li>Verify that we are back on the script organizer</li>
    kontext "ScriptOrganizer"
    if ( not ScriptOrganizer.exists() ) then
        warnlog( CFN & "Could not return to ScriptOrganizer" )
        brc = false
    endif
    
    hRenameScriptingObject() = brc
    '///</ul>
    
end function

'*******************************************************************************

function hDeleteScript( cName as string , bSuccess as boolean ) as boolean

    '///<h3>Delete the selected script</h3>
    '///<i>Starting point: Script organizer is open, a script is selected</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the script (string)</li>
    '///<ul>
    '///+<li>For debugging purpose only, the name will be used for warnlogs</li>
    '///+<li>May be an empty string (not recommended)</li>
    '///</ul>
    '///+<li>Expected result (boolean)</li>
    '///<ul>
    '///+<li>TRUE: The script is expected to be deleted without warnings/errors</li>
    '///+<li>FALSE: The script should not be deletable</li>
    '///</ul>    
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean) - see description</li>
    '///<ul>
    '///+<li>TRUE on success (expected outcome)</li>
    '///+<li>FALSE on failure</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hDeleteScript::"
    dim iPos as integer
    dim cMessage as string
    
    '///+<li>Test for the possible conditions:</li>
    '///<ol>
    '///+<li>Delete is correctly enabled (success)</li>
    kontext "ScriptOrganizer"
    if ( PBDelete.isEnabled() and bSuccess ) then
    
        PBDelete.click()
        kontext "active"
        cMessage = active.getText()
        cMessage = hRemoveLineBreaks( cMessage )
        printlog( CFN & cMessage ) 
        active.yes()

        kontext "active"
        if ( active.exists() ) then
            cMessage = active.getText()
            cMessage = hRemoveLineBreaks( cMessage )
            qaerrorlog( CFN & "Message: Failed to delete object: " & cName )
            printlog( CFN & cMessage )
            active.ok()
        endif
        hDeleteScript() = true
        
    '///+<li>Delete is disabled correctly (success)</li>
    elseif ( ( not PBDelete.isEnabled() ) and ( not bSuccess ) ) then
    
        printlog( CFN & "Delete-Button disabled for non-deletable object: " & cName )
        hDeleteScript() = true
        
    '///+<li>Delete is enabled but should not be (failure)</li>
    elseif ( PBDelete.isEnabled() and ( not bSuccess ) ) then
    
        PBDelete.click()
        sleep( 1 )
        
        kontext "active"
        if ( active.exists() ) then
            cMessage = active.getText()
            cMessage = hRemoveLineBreaks( cMessage )
            printlog( CFN & "Delete-Button enabled for non deletable object" )
            printlog( CFN & cMessage )
            active.yes()
            sleep( 2 )
        endif
        
        kontext "active"
        if ( active.exists() ) then
            cMessage = active.getText()
            cMessage = hRemoveLineBreaks( cMessage )
            printlog( CFN & "Message: Failed to delete object" )
            printlog( CFN & cMessage )
            active.ok()
        endif
        hDeleteScript() = false
        
    '///+<li>Delete is incorrectly disabled (failure)</li>        
    elseif ( ( not PBDelete.isEnabled() ) and bSuccess ) then
    
        printlog( CFN & "Delete-Button disabled for deletable object" )
        hDeleteScript() = false
        
    else
    
        warnlog( CFN & "Unknown condition in if-statement" )
        hDeleteScript() = false
        
    endif
    '///</ol>
    '///</ul>
   
end function                
            
'*******************************************************************************

function hOpenScriptOrganizer( iDialog as integer ) as boolean

    '///<h3>Open the ScriptOrganizers and verify that they are open</h3>
    '///<i>Starting point: Any document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Dialog-ID (integer)</li>
    '///<ul>
    '///+<li>1 = BeanShell organizer</li>
    '///+<li>2 = JavaScript organizer</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition</li>
    '///<ul>
    '///+<li>TRUE if the expected organizer is open</li>
    '///+<li>FALSE if the expected organizer is not open</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hOpenScriptOrganizer::"

    '///<li>Verify function parameter (must be 1 or 2) </li>
    if ( ( iDialog < 1 ) or ( iDialog > 2 ) ) then
        warnlog( CFN & "Invalid parameter passed to function:" & iDialog )
        hOpenScriptOrganizer() = false
        exit function
    endif

    '///<li>Call the associated slot</li>
    select case iDialog
    case 1 : ToolsMacrosOrganizeMacrosBeanShell
    case 2 : ToolsMacrosOrganizeMacrosJavaScript
    end select

    '///<li>Verify that the dialog is open, return TRUE if yes</li>
    kontext "ScriptOrganizer"
    if ( ScriptOrganizer.exists() ) then
        hOpenScriptOrganizer() = true
        printlog( CFN & "Dialog is open" )
    else
        hopenScriptOrganizer() = false
        warnlog( CFN & "Slot failed, dialog not open" )
    endif

    '///</ul>

end function
    
'*******************************************************************************

function hCloseScriptOrganizer() as boolean

    '///<h3>Close a Script Organizer (Cancel)</h3>
    '///<i>Starting point: Any open Script Organizer</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE if the Script Organizer was closed</li>
    '///+<li>FALSE if the Script Organizer is still open</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    const CFN = "hCloseScriptOrganizer::" 
    dim iTry as integer
    
    hCloseScriptOrganizer() = false
    
    '///+<li>Try ten times to cancel the Script Organizer, break on success</li>
    kontext "ScriptOrganizer"
    for iTry = 1 to 10 
    
        if ( ScriptOrganizer.exists() ) then
        
            ScriptOrganizer.cancel()
            wait( 100 )
            
        else
        
            exit for
            hCloseScriptOrganizer() = true
            
        endif
        
    next iTry
    '///</ul>
    
end function

'*******************************************************************************

function hOpenRunMacroDialog() as boolean

    '///<h3>Open the &quot;Run Macro&quot; dialog</h3>
    '///<i>Starting point: Any document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition</li>
    '///<ul>
    '///+<li>TRUE if dialog is open</li>
    '///+<li>FALSE if the Script Selector does not exist</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    '///+<li>Execute the ToolsMacrosRunMacro slot</li>
    ToolsMacrosRunMacro

    '///+<li>Verify that the dialog is present</li>
    kontext "ScriptSelector"
    if ( ScriptSelector.exists() ) then
        hOpenRunMacroDialog() = true
    else
        hOpenRunMacroDialog() = false
    endif
    '///</ul>

end function
